/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MessageReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.QueuedMessage;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class MessageItemReference
extends ItemReference
implements SIMPMessage,
TransactionCallback {
    private boolean requiresNewId = false;
    private static TraceComponent tc = SibTr.register((Class)MessageItemReference.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessorSearchResults searchResults;
    private ControlAdapter controlAdapter = null;
    private MessageEventListener PRE_COMMIT_ADD;
    private MessageEventListener PRE_COMMIT_REMOVE;
    private MessageEventListener POST_COMMIT_ADD_1;
    private MessageEventListener POST_COMMIT_ADD_2;
    private MessageEventListener POST_COMMIT_REMOVE_1;
    private MessageEventListener POST_COMMIT_REMOVE_2;
    private MessageEventListener POST_COMMIT_REMOVE_3;
    private MessageEventListener POST_ROLLBACK_ADD_1;
    private MessageEventListener POST_ROLLBACK_ADD_2;
    private MessageEventListener POST_ROLLBACK_REMOVE_1;
    private MessageEventListener POST_ROLLBACK_REMOVE_2;
    private MessageEventListener POST_ROLLBACK_REMOVE_3;
    private MessageEventListener UNLOCKED;
    private MessageEventListener REFERENCES_DROPPED_TO_ZERO;
    private boolean downgradePersistence = false;
    private boolean streamIsGuess = false;
    private boolean reavailable = false;

    public MessageItemReference() {
    }

    public MessageItemReference(MessageItem messageItem) {
        this(messageItem, false);
    }

    public MessageItemReference(MessageItem messageItem, boolean bl) {
        super(messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageItemReference", (Object)new Object[]{messageItem, new Boolean(bl)});
        }
        this.downgradePersistence = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageItemReference", (Object)this);
        }
    }

    public boolean getRequiresNewId() {
        return this.requiresNewId;
    }

    public void setRequiresNewId(boolean bl) {
        this.requiresNewId = bl;
    }

    public JsMessage getMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessage");
        }
        JsMessage jsMessage = ((MessageItem)this.getReferredItem()).getMessage();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessage", (Object)jsMessage);
        }
        return jsMessage;
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        int n = ((MessageItem)this.getReferredItem()).getStorageStrategy();
        if (this.downgradePersistence && n > 2) {
            n = 2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(n));
        }
        return n;
    }

    public Reliability getReliability() {
        return ((MessageItem)this.getReferredItem()).getReliability();
    }

    public long getMaximumTimeInStore() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaximumTimeInStore");
        }
        long l = ((MessageItem)this.getReferredItem()).getMaximumTimeInStore();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)new Long(l));
        }
        return l;
    }

    public void eventPostCommitAdd(Transaction transaction) {
        super.eventPostCommitAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)new Object[]{transaction});
        }
        if (!transaction.isAutoCommit()) {
            try {
                if (this.POST_COMMIT_ADD_1 != null) {
                    this.POST_COMMIT_ADD_1.messageEventOccurred(2, this, transaction);
                }
                if (this.POST_COMMIT_ADD_2 != null) {
                    this.POST_COMMIT_ADD_2.messageEventOccurred(2, this, transaction);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostCommitAdd", (String)"1:362:1.106", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostCommitRemove(Transaction transaction) {
        super.eventPostCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
        this.dereferenceControlAdapter();
        try {
            if (this.POST_COMMIT_REMOVE_1 != null) {
                this.POST_COMMIT_REMOVE_1.messageEventOccurred(3, this, transaction);
            }
            if (this.POST_COMMIT_REMOVE_2 != null) {
                this.POST_COMMIT_REMOVE_2.messageEventOccurred(3, this, transaction);
            }
            if (this.POST_COMMIT_REMOVE_3 != null) {
                this.POST_COMMIT_REMOVE_3.messageEventOccurred(3, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostCommitRemove", (String)"1:408:1.106", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) {
        super.eventPostRollbackRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)new Object[]{transaction});
        }
        try {
            if (this.POST_ROLLBACK_REMOVE_1 != null) {
                this.POST_ROLLBACK_REMOVE_1.messageEventOccurred(5, this, transaction);
            }
            if (this.POST_ROLLBACK_REMOVE_2 != null) {
                this.POST_ROLLBACK_REMOVE_2.messageEventOccurred(5, this, transaction);
            }
            if (this.POST_ROLLBACK_REMOVE_3 != null) {
                this.POST_ROLLBACK_REMOVE_3.messageEventOccurred(5, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostRollbackRemove", (String)"1:465:1.106", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    private void resetEvents() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetEvents");
        }
        this.PRE_COMMIT_ADD = null;
        this.PRE_COMMIT_REMOVE = null;
        this.POST_COMMIT_ADD_1 = null;
        this.POST_COMMIT_ADD_2 = null;
        this.POST_COMMIT_REMOVE_1 = null;
        this.POST_COMMIT_REMOVE_2 = null;
        this.POST_COMMIT_REMOVE_3 = null;
        this.POST_ROLLBACK_ADD_1 = null;
        this.POST_ROLLBACK_ADD_2 = null;
        this.POST_ROLLBACK_REMOVE_1 = null;
        this.POST_ROLLBACK_REMOVE_2 = null;
        this.POST_ROLLBACK_REMOVE_3 = null;
        this.UNLOCKED = null;
        this.REFERENCES_DROPPED_TO_ZERO = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetEvents");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        super.eventPostRollbackAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        try {
            if (this.POST_ROLLBACK_ADD_1 != null) {
                this.POST_ROLLBACK_ADD_1.messageEventOccurred(4, this, transaction);
            }
            if (this.POST_ROLLBACK_ADD_2 != null) {
                this.POST_ROLLBACK_ADD_2.messageEventOccurred(4, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventPostRollbackAdd", (String)"1:534:1.106", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        this.resetEvents();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventUnlocked() {
        super.eventUnlocked();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked");
        }
        this.reavailable = true;
        if (this.UNLOCKED != null) {
            try {
                this.UNLOCKED.messageEventOccurred(6, this, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.eventUnlocked", (String)"1:574:1.106", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventUnlocked", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        this.reavailable = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    public void eventLocked() {
    }

    public SIBUuid12 getProducerConnectionUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProducerConnectionUuid");
            SibTr.exit((TraceComponent)tc, (String)"getProducerConnectionUuid");
        }
        return ((SIMPMessage)((Object)this.getReferredItem())).getProducerConnectionUuid();
    }

    public String toString() {
        return "Reference " + ((MessageItem)this.getReferredItem()).toString();
    }

    private MessageItem getMessageItem() {
        return (MessageItem)this.getReferredItem();
    }

    public boolean isTransacted() {
        return this.getMessageItem().isTransacted();
    }

    public int getProducerSeed() {
        return this.getMessageItem().getProducerSeed();
    }

    public void restore(byte[] byArray) {
        MessageReferenceStream messageReferenceStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)byArray);
        }
        if (!(messageReferenceStream = (MessageReferenceStream)this.getReferenceStream()).hasInDoubtItems()) {
            messageReferenceStream.registerListeners(this);
        } else {
            messageReferenceStream.addUnrestoredMsgId(this.getID());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void unspill(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unspill", (Object)byArray);
        }
        this.restore(byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unspill");
        }
    }

    public void registerMessageEventListener(int n, MessageEventListener messageEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerMessageEventListener", (Object)new Object[]{new Integer(n), messageEventListener});
        }
        boolean bl = false;
        switch (n) {
            case 2: {
                if (this.POST_COMMIT_ADD_1 == null) {
                    this.POST_COMMIT_ADD_1 = messageEventListener;
                    break;
                }
                if (this.POST_COMMIT_ADD_2 == null) {
                    this.POST_COMMIT_ADD_2 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                if (this.POST_COMMIT_REMOVE_1 == null) {
                    this.POST_COMMIT_REMOVE_1 = messageEventListener;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_2 == null) {
                    this.POST_COMMIT_REMOVE_2 = messageEventListener;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_3 == null) {
                    this.POST_COMMIT_REMOVE_3 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 4: {
                if (this.POST_ROLLBACK_ADD_1 == null) {
                    this.POST_ROLLBACK_ADD_1 = messageEventListener;
                    break;
                }
                if (this.POST_ROLLBACK_ADD_2 == null) {
                    this.POST_ROLLBACK_ADD_2 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 5: {
                if (this.POST_ROLLBACK_REMOVE_1 == null) {
                    this.POST_ROLLBACK_REMOVE_1 = messageEventListener;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_2 == null) {
                    this.POST_ROLLBACK_REMOVE_2 = messageEventListener;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_3 == null) {
                    this.POST_ROLLBACK_REMOVE_3 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD == null) {
                    this.PRE_COMMIT_ADD = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE == null) {
                    this.PRE_COMMIT_REMOVE = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO == null) {
                    this.REFERENCES_DROPPED_TO_ZERO = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 6: {
                if (this.UNLOCKED == null) {
                    this.UNLOCKED = messageEventListener;
                    break;
                }
                bl = true;
            }
        }
        if (bl) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.registerMessageEventListener", "1:755:1.106", new Integer(n)}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.registerMessageEventListener", (String)"1:761:1.106", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItemReference.registerMessageEventListener", "1:768:1.106", new Integer(n)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerMessageEventListener", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerMessageEventListener");
        }
    }

    public void deregisterMessageEventListener(int n, MessageEventListener messageEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterMessageEventListener", (Object)new Object[]{new Integer(n), messageEventListener});
        }
        switch (n) {
            case 2: {
                if (this.POST_COMMIT_ADD_1 == messageEventListener) {
                    this.POST_COMMIT_ADD_1 = null;
                    break;
                }
                if (this.POST_COMMIT_ADD_2 != messageEventListener) break;
                this.POST_COMMIT_ADD_2 = null;
                break;
            }
            case 3: {
                if (this.POST_COMMIT_REMOVE_1 == messageEventListener) {
                    this.POST_COMMIT_REMOVE_1 = null;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_2 == messageEventListener) {
                    this.POST_COMMIT_REMOVE_2 = null;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_3 != messageEventListener) break;
                this.POST_COMMIT_REMOVE_3 = null;
                break;
            }
            case 4: {
                if (this.POST_ROLLBACK_ADD_1 == messageEventListener) {
                    this.POST_ROLLBACK_ADD_1 = null;
                    break;
                }
                if (this.POST_ROLLBACK_ADD_2 != messageEventListener) break;
                this.POST_ROLLBACK_ADD_2 = null;
                break;
            }
            case 5: {
                if (this.POST_ROLLBACK_REMOVE_1 == messageEventListener) {
                    this.POST_ROLLBACK_REMOVE_1 = null;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_2 == messageEventListener) {
                    this.POST_ROLLBACK_REMOVE_2 = null;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_3 != messageEventListener) break;
                this.POST_ROLLBACK_REMOVE_3 = null;
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD != messageEventListener) break;
                this.PRE_COMMIT_ADD = null;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE != messageEventListener) break;
                this.PRE_COMMIT_REMOVE = null;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO != messageEventListener) break;
                this.REFERENCES_DROPPED_TO_ZERO = null;
                break;
            }
            case 6: {
                if (this.UNLOCKED != messageEventListener) break;
                this.UNLOCKED = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterMessageEventListener");
        }
    }

    public MessageProcessorSearchResults getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(MessageProcessorSearchResults messageProcessorSearchResults) {
        this.searchResults = messageProcessorSearchResults;
    }

    public long calculateWaitTimeUpdate(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"calculateWaitTimeUpdate");
        }
        long l2 = ((MessageItem)this.getReferredItem()).calculateWaitTimeUpdate(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"calculateWaitTimeUpdate", (Object)new Long(l2));
        }
        return l2;
    }

    public long getAggregateWaitTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAggregateWaitTime");
        }
        long l = this.getLatestWaitTimeUpdate() + ((MessageItem)this.getReferredItem()).getAggregateWaitTime();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAggregateWaitTime", (Object)new Long(l));
        }
        return l;
    }

    public long getLatestWaitTimeUpdate() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLatestWaitTimeUpdate");
        }
        long l = System.currentTimeMillis();
        long l2 = l - ((MessageItem)this.getReferredItem()).getCurrentMEArrivalTimestamp();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLatestWaitTimeUpdate", (Object)new Long(l2));
        }
        return l2;
    }

    public boolean isToBeStoredAtSendTime() {
        return false;
    }

    public void setStoreAtSendTime(boolean bl) {
    }

    public void setStreamIsGuess(boolean bl) {
        this.streamIsGuess = bl;
    }

    public boolean getStreamIsGuess() {
        return this.streamIsGuess;
    }

    public JsDestinationAddress getDestinationAddress() {
        return null;
    }

    public ControlAdapter getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    public void createControlAdapter() {
        ItemStream itemStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        BaseDestinationHandler baseDestinationHandler = null;
        ReferenceStream referenceStream = this.getReferenceStream();
        if (referenceStream instanceof MessageReferenceStream && (itemStream = referenceStream.getItemStream()) instanceof PubSubMessageItemStream) {
            baseDestinationHandler = ((PubSubMessageItemStream)itemStream).getDestinationHandler();
            this.controlAdapter = new QueuedMessage((SIMPMessage)this, (DestinationHandler)baseDestinationHandler, referenceStream);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void dereferenceControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        if (this.controlAdapter != null) {
            this.controlAdapter.dereferenceControllable();
            this.controlAdapter = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    public SIBUuid12 getGuaranteedStreamUuid() {
        return ((MessageItem)this.getReferredItem()).getGuaranteedStreamUuid();
    }

    public void setGuaranteedStreamUuid(SIBUuid12 sIBUuid12) {
        ((MessageItem)this.getReferredItem()).setGuaranteedStreamUuid(sIBUuid12);
    }

    public Byte getReportCOD() {
        return ((MessageItem)this.getReferredItem()).getReportCOD();
    }

    public boolean isFromRemoteME() {
        return ((MessageItem)this.getReferredItem()).isFromRemoteME();
    }

    public long updateStatisticsMessageWaitTime() {
        return 0L;
    }

    public MessageStore getMessageStore() {
        return this.getOwningMessageStore();
    }

    public void beforeCompletion(Transaction transaction) {
    }

    public void afterCompletion(Transaction transaction, boolean bl) {
    }

    public boolean isReavailable() {
        return this.reavailable;
    }

    public int guessRedeliveredCount() {
        return super.guessUnlockCount();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/items/MessageItemReference.java, SIB.processor, WAS602.SIB, o0610.11 1.106");
        }
    }
}

