/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.RemoteConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public class AIMessageItem
extends MessageItem {
    private static final TraceComponent tc = SibTr.register((Class)AIMessageItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private RemoteConsumerDispatcher rcd;
    private int cachedRedeliveredCount;
    private AIStreamKey key;
    private boolean informedConsumerKeyThatLocked;
    private PersistentTranId rejectTransactionID = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIMessageItem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIMessageItem");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.informedConsumerKeyThatLocked = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIMessageItem", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIMessageItem(JsMessage jsMessage) {
        super(jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIMessageItem", (Object)jsMessage);
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.informedConsumerKeyThatLocked = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIMessageItem", (Object)this);
        }
    }

    public synchronized void setRejectTransactionID(PersistentTranId persistentTranId) {
        this.rejectTransactionID = persistentTranId;
    }

    private synchronized boolean isRejectTransactionID(PersistentTranId persistentTranId) {
        if (this.rejectTransactionID != null) {
            return persistentTranId.equals(this.rejectTransactionID);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPersistentData() throws PersistentDataEncodingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            if (!this.informedConsumerKeyThatLocked) {
                RemoteDispatchableKey remoteDispatchableKey = this.key.getRemoteDispatchableKey();
                RemoteConsumerKey remoteConsumerKey = null;
                if (remoteDispatchableKey instanceof RemoteConsumerKey) {
                    remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
                }
                if (remoteConsumerKey != null) {
                    remoteConsumerKey.messageLocked(this.key);
                    this.informedConsumerKeyThatLocked = true;
                }
            }
            this.key.clearRemoteDispatchableKey();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
        return super.getPersistentData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)byArray);
        }
        super.restore(byArray);
        this.key = new AIStreamKey(this.getMessage().getGuaranteedRemoteGetValueTick());
        ItemStream itemStream = this.getItemStream();
        BaseDestinationHandler baseDestinationHandler = null;
        PtoPMessageItemStream ptoPMessageItemStream = (PtoPMessageItemStream)itemStream;
        baseDestinationHandler = ptoPMessageItemStream.getDestinationHandler();
        SIBUuid8 sIBUuid8 = this.getMessage().getGuaranteedSourceMessagingEngineUUID();
        this.rcd = baseDestinationHandler.getRemoteConsumerDispatcher(sIBUuid8);
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.cachedRedeliveredCount = this.rcd.getRedeliveredCount(this.msg.getGuaranteedRemoteGetValueTick());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInfo(RemoteConsumerDispatcher remoteConsumerDispatcher, AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setInfo", (Object)new Object[]{remoteConsumerDispatcher, aIStreamKey});
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            this.rcd = remoteConsumerDispatcher;
            this.key = aIStreamKey;
            this.cachedRedeliveredCount = remoteConsumerDispatcher.getRedeliveredCount(this.msg.getGuaranteedRemoteGetValueTick());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setInfo");
        }
    }

    public final AIStreamKey getAIStreamKey() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIStreamKey");
            SibTr.exit((TraceComponent)tc, (String)"getAIStreamKey", (Object)this.key);
        }
        return this.key;
    }

    public final int getStorageStrategy() {
        return 2;
    }

    public long getMaximumTimeInStore() {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaximumTimeInStore");
        }
        long l2 = super.getMaximumTimeInStore();
        long l3 = this.rcd.getRejectTimeout();
        if (l2 == -2L) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)new Long(l3));
            }
            return l3;
        }
        if (l3 == -2L) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)new Long(l2));
            }
            return l2;
        }
        long l4 = l = l2 < l3 ? l2 : l3;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)new Long(l));
        }
        return l;
    }

    public boolean canExpireSilently() {
        super.canExpireSilently();
        return false;
    }

    public void eventExpiryNotification(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventExpiryNotification", (Object)transaction);
        }
        super.eventExpiryNotification(transaction);
        this.setRejectTransactionID(transaction.getPersistentTranId());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventExpiryNotification");
        }
    }

    public void eventPrecommitRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPrecommitRemove", (Object)transaction);
        }
        super.eventPrecommitRemove(transaction);
        if (!this.isRejectTransactionID(transaction.getPersistentTranId())) {
            this.rcd.accept(this.key, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPrecommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventPostCommitRemove(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)transaction);
        }
        super.eventPostCommitRemove(transaction);
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            if (!this.informedConsumerKeyThatLocked) {
                RemoteDispatchableKey remoteDispatchableKey = this.key.getRemoteDispatchableKey();
                RemoteConsumerKey remoteConsumerKey = null;
                if (remoteDispatchableKey instanceof RemoteConsumerKey) {
                    remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
                }
                if (remoteConsumerKey != null) {
                    remoteConsumerKey.messageLocked(this.key);
                    this.informedConsumerKeyThatLocked = true;
                }
            }
        }
        if (this.isRejectTransactionID(transaction.getPersistentTranId())) {
            this.rcd.expiryCallback(this);
        } else {
            this.rcd.acceptCommitted(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventLocked() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventLocked");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            RemoteDispatchableKey remoteDispatchableKey = this.key.getRemoteDispatchableKey();
            RemoteConsumerKey remoteConsumerKey = null;
            if (remoteDispatchableKey instanceof RemoteConsumerKey) {
                remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
            }
            if (remoteConsumerKey != null) {
                remoteConsumerKey.messageLocked(this.key);
                this.informedConsumerKeyThatLocked = true;
            }
        }
        super.eventLocked();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventUnlocked() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            RemoteDispatchableKey remoteDispatchableKey = this.key.getRemoteDispatchableKey();
            RemoteConsumerKey remoteConsumerKey = null;
            if (remoteDispatchableKey instanceof RemoteConsumerKey) {
                remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
            }
            if (remoteConsumerKey != null) {
                remoteConsumerKey.messageUnlocked(this.key);
                this.informedConsumerKeyThatLocked = false;
            }
        }
        super.eventUnlocked();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int guessRedeliveredCount() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"guessRedeliveredCount");
        }
        AIMessageItem aIMessageItem = this;
        synchronized (aIMessageItem) {
            n = this.cachedRedeliveredCount < 0 ? 1 : this.cachedRedeliveredCount;
        }
        int n2 = super.guessRedeliveredCount() + n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"guessRedeliveredCount", (Object)new Integer(n2));
        }
        return n2;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/items/AIMessageItem.java, SIB.processor, WAS602.SIB, o0610.11 1.33");
        }
    }
}

