/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.filters;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public final class MessageSelectorFilter
implements Filter {
    private static final TraceComponent tc = SibTr.register((Class)MessageSelectorFilter.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private String _selectorString;
    private SelectorDomain _domain;
    private String _discriminator;
    private Selector _selectorTree;
    private Selector _discriminatorTree;

    public MessageSelectorFilter(MessageProcessor messageProcessor, SelectionCriteria selectionCriteria) throws SISelectorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageSelectorFilter", (Object)new Object[]{messageProcessor, selectionCriteria});
        }
        this._messageProcessor = messageProcessor;
        this._selectorString = selectionCriteria.getSelectorString();
        this._domain = selectionCriteria.getSelectorDomain();
        this._discriminator = selectionCriteria.getDiscriminator();
        if (this._selectorString != null) {
            this._selectorTree = messageProcessor.getMessageProcessorMatching().parseSelector(this._selectorString, this._domain);
        }
        try {
            if (this._discriminator != null) {
                this._discriminatorTree = messageProcessor.getMessageProcessorMatching().parseDiscriminator(this._discriminator);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter.MessageSelectorFilter", (String)"1:129:1.32", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageSelectorFilter", (Object)this);
        }
    }

    public boolean filterMatches(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)abstractItem);
        }
        boolean bl = true;
        if (this._selectorTree != null || this._discriminatorTree != null) {
            SIMPMessage sIMPMessage = (SIMPMessage)((Object)abstractItem);
            bl = this._messageProcessor.getMessageProcessorMatching().evaluateMessage(this._selectorTree, this._discriminatorTree, (SIBusMessage)sIMPMessage.getMessage());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getSelectorString() {
        return this._selectorString;
    }

    public String getDiscriminator() {
        return this._discriminator;
    }

    public SelectorDomain getDomain() {
        return this._domain;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/filters/MessageSelectorFilter.java, SIB.processor, WAS602.SIB, o0610.11 1.32");
        }
    }
}

