/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;
import java.util.Iterator;

public class BatchHandler
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register((Class)BatchHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ExternalLocalTransaction _currentTran = null;
    private int _currentBatchSize = 0;
    private int _batchSize;
    private long _batchTimeout;
    private boolean _timerStarted = false;
    private HashSet _listeners;
    private LockManager _readWriteLock;
    private SIMPTransactionManager _txManager;
    private MPAlarmManager _am;
    private Alarm _alarm;

    public BatchHandler(int n, long l, SIMPTransactionManager sIMPTransactionManager, MPAlarmManager mPAlarmManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BatchHandler", (Object)new Object[]{new Integer(n), new Long(l), sIMPTransactionManager, mPAlarmManager});
        }
        this._batchSize = n;
        this._batchTimeout = l;
        this._txManager = sIMPTransactionManager;
        this._am = mPAlarmManager;
        this._readWriteLock = new LockManager();
        this._listeners = new HashSet();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BatchHandler", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction registerInBatch() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerInBatch", (Object)this);
        }
        this._readWriteLock.lock();
        BatchHandler batchHandler = this;
        synchronized (batchHandler) {
            if (this._currentTran == null) {
                this._currentTran = this._txManager.createLocalTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerInBatch", (Object)this._currentTran);
        }
        return this._currentTran;
    }

    public void messagesAdded(int n) throws SIResourceException {
        this.messagesAdded(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagesAdded(int n, BatchListener batchListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messagesAdded", (Object)new Object[]{this, new Integer(n), batchListener});
        }
        boolean bl = false;
        try {
            BatchHandler batchHandler = this;
            synchronized (batchHandler) {
                this._currentBatchSize += n;
                if (batchListener != null && !this._listeners.contains(batchListener)) {
                    this._listeners.add(batchListener);
                }
                if (this._currentBatchSize >= this._batchSize) {
                    bl = true;
                } else if (this._currentBatchSize - n == 0 && !this._timerStarted) {
                    this.startTimer();
                }
            }
        }
        finally {
            this._readWriteLock.unlock();
        }
        if (bl) {
            this.completeBatch(false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messagesAdded");
        }
    }

    public void completeBatch(boolean bl) throws SIResourceException {
        this.completeBatch(bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeBatch(boolean bl, BatchListener batchListener) throws SIResourceException {
        block20: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"completeBatch", (Object)new Object[]{this, new Boolean(bl)});
            }
            this._readWriteLock.lockExclusive();
            try {
                if (bl && this._currentBatchSize > 0 || this._currentBatchSize >= this._batchSize) {
                    Iterator iterator = this._listeners.iterator();
                    while (iterator.hasNext()) {
                        BatchListener batchListener2 = (BatchListener)iterator.next();
                        batchListener2.batchPrecommit(this._currentTran);
                    }
                    if (batchListener != null) {
                        batchListener.batchPrecommit(this._currentTran);
                    }
                    boolean bl2 = false;
                    Exception exception = null;
                    try {
                        this._currentTran.commit();
                        bl2 = true;
                    }
                    catch (Exception exception2) {
                        FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.sib.processor.impl.store.BatchHandler.completeBatch", (String)"1:269:1.24", (Object)this);
                        bl2 = false;
                        SibTr.exception((TraceComponent)tc, (Exception)exception2);
                        exception = exception2;
                    }
                    this._currentBatchSize = 0;
                    this._currentTran = null;
                    iterator = this._listeners.iterator();
                    while (iterator.hasNext()) {
                        BatchListener batchListener3 = (BatchListener)iterator.next();
                        if (bl2) {
                            batchListener3.batchCommitted();
                        } else {
                            batchListener3.batchRolledBack();
                        }
                        iterator.remove();
                    }
                    if (batchListener != null) {
                        if (bl2) {
                            batchListener.batchCommitted();
                        } else {
                            batchListener.batchRolledBack();
                        }
                    }
                    if (exception != null) {
                        this._readWriteLock.unlockExclusive();
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"completeBatch", (Object)exception);
                        }
                        throw new SIResourceException((Throwable)exception);
                    }
                    if (this._timerStarted) {
                        this.cancelTimer();
                    }
                    break block20;
                }
                if (batchListener != null) {
                    batchListener.batchCommitted();
                }
            }
            finally {
                this._readWriteLock.unlockExclusive();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"completeBatch");
        }
    }

    private void startTimer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startTimer", (Object)this);
        }
        if (this._alarm == null) {
            this._alarm = this._am.create(this._batchTimeout, this);
            this._timerStarted = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startTimer");
        }
    }

    private void cancelTimer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelTimer", (Object)this);
        }
        if (this._alarm != null) {
            this._alarm.cancel();
            this._alarm = null;
            this._timerStarted = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelTimer");
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{this, object});
        }
        this._alarm = null;
        this._timerStarted = false;
        try {
            this.completeBatch(true);
        }
        catch (SIException sIException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/BatchHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.24");
        }
    }
}

