/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class AsyncUpdateThread
implements AlarmListener {
    private static final TraceComponent tc = SibTr.register((Class)AsyncUpdateThread.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final SIMPTransactionManager tranManager;
    private final MessageProcessor mp;
    private ArrayList enqueuedUnits;
    private boolean executing;
    private ArrayList executingUnits;
    private final int batchThreshold;
    private final long maxCommitInterval;
    private boolean executeSinceExpiry;
    private boolean closed;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public AsyncUpdateThread(MessageProcessor messageProcessor, SIMPTransactionManager sIMPTransactionManager, int n, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AsyncUpdateThread", (Object)new Object[]{messageProcessor, sIMPTransactionManager, new Integer(n), new Long(l)});
        }
        this.mp = messageProcessor;
        this.tranManager = sIMPTransactionManager;
        this.batchThreshold = n;
        this.maxCommitInterval = l;
        this.closed = false;
        this.enqueuedUnits = new ArrayList(10);
        this.executingUnits = new ArrayList(10);
        this.executing = false;
        this.executeSinceExpiry = false;
        if (l > 0L) {
            messageProcessor.getAlarmManager().create(l, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AsyncUpdateThread", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(AsyncUpdate asyncUpdate) throws ClosedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"enqueueWork", (Object)asyncUpdate);
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            if (this.closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"enqueueWork", (Object)"ClosedException");
                }
                throw new ClosedException();
            }
            this.enqueuedUnits.add(asyncUpdate);
            if (this.executing) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"enqueueWork");
                }
                return;
            }
            if (this.enqueuedUnits.size() > this.batchThreshold) {
                this.executeSinceExpiry = true;
                try {
                    this.startExecutingUpdates();
                }
                catch (ClosedException closedException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"enqueueWork", (Object)closedException);
                    }
                    throw closedException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"enqueueWork");
        }
    }

    private void startExecutingUpdates() throws ClosedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startExecutingUpdates");
        }
        ArrayList arrayList = this.executingUnits;
        this.executingUnits = this.enqueuedUnits;
        this.enqueuedUnits = arrayList;
        this.enqueuedUnits.clear();
        this.executing = true;
        try {
            ExternalLocalTransaction externalLocalTransaction = this.tranManager.createLocalTransaction();
            ExecutionThread executionThread = new ExecutionThread(this.executingUnits, externalLocalTransaction);
            this.mp.startNewSystemThread(executionThread);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.startExecutingUpdates", (String)"1:224:1.21", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startExecutingUpdates", (Object)interruptedException);
            }
            this.closed = true;
            throw new ClosedException(interruptedException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startExecutingUpdates");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm");
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            if (!this.closed) {
                if (this.executeSinceExpiry || this.executing) {
                    this.executeSinceExpiry = false;
                } else {
                    try {
                        if (this.enqueuedUnits.size() > 0) {
                            this.startExecutingUpdates();
                        }
                    }
                    catch (ClosedException closedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.maxCommitInterval > 0L) {
            this.mp.getAlarmManager().create(this.maxCommitInterval, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            this.closed = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillAllUpdatesExecuted() throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitTillAllUpdatesExecuted");
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            while (this.enqueuedUnits.size() > 0 || this.executing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"waitTillAllUpdatesExecuted", (Object)interruptedException);
                    }
                    throw interruptedException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitTillAllUpdatesExecuted");
        }
    }

    class ExecutionThread
    implements Runnable {
        private final List _list;
        private final ExternalLocalTransaction _tran;

        ExecutionThread(List list, ExternalLocalTransaction externalLocalTransaction) {
            this._list = list;
            this._tran = externalLocalTransaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run");
            }
            try {
                AsyncUpdate asyncUpdate;
                Throwable throwable = null;
                int n = this._list.size();
                for (int i = 0; i < n; ++i) {
                    asyncUpdate = (AsyncUpdate)this._list.get(i);
                    try {
                        asyncUpdate.execute(this._tran);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        break;
                    }
                }
                if (throwable == null) {
                    try {
                        this._tran.commit();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:289:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        throwable = sIException;
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:301:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                        throwable = sIErrorException;
                    }
                    catch (Throwable throwable3) {
                        FFDCFilter.processException((Throwable)throwable3, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:313:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Throwable)throwable3);
                        throwable = throwable3;
                    }
                } else {
                    try {
                        this._tran.rollback();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:334:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:344:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    }
                    catch (Throwable throwable4) {
                        FFDCFilter.processException((Throwable)throwable4, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:354:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Throwable)throwable4);
                    }
                }
                for (int i = 0; i < n; ++i) {
                    asyncUpdate = (AsyncUpdate)this._list.get(i);
                    if (throwable == null) {
                        try {
                            asyncUpdate.committed();
                        }
                        catch (SIException sIException) {
                            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:375:1.21", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        }
                        continue;
                    }
                    asyncUpdate.rolledback(throwable);
                }
                AsyncUpdateThread asyncUpdateThread = AsyncUpdateThread.this;
                synchronized (asyncUpdateThread) {
                    if (!AsyncUpdateThread.this.closed) {
                        AsyncUpdateThread.this.executing = false;
                        if (AsyncUpdateThread.this.enqueuedUnits.size() > AsyncUpdateThread.this.batchThreshold) {
                            AsyncUpdateThread.this.executeSinceExpiry = true;
                            try {
                                AsyncUpdateThread.this.startExecutingUpdates();
                            }
                            catch (ClosedException closedException) {
                                // empty catch block
                            }
                        }
                    }
                    AsyncUpdateThread.this.notify();
                }
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", (String)"1:413:1.21", (Object)this);
                SibTr.error((TraceComponent)tc, (String)nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread.ExecutionThread.run", "1:419:1.21", runtimeException}, null));
                if (tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                    SibTr.exit((TraceComponent)tc, (String)"run", (Object)runtimeException);
                }
                throw runtimeException;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

