/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.mediation;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.impl.mediation.MessagePump;
import com.ibm.ws.sib.processor.impl.mediation.MessagePumpException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.sib.core.ConsumerSession;

public class RegisteredConsumer {
    private static final TraceComponent tc = SibTr.register((Class)RegisteredConsumer.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerSession _consumer;
    private MessagePump _messagePump;
    private boolean _isStarted = false;
    private boolean _concurrency;
    private ThreadPool _mediationThreadPool;

    public RegisteredConsumer(JsDestinationAddress jsDestinationAddress, MessagePump messagePump, MPCoreConnection mPCoreConnection, DestinationDefinition destinationDefinition, MessageProcessor messageProcessor) throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RegisteredConsumer", (Object)new Object[]{jsDestinationAddress, messagePump, mPCoreConnection, destinationDefinition, messageProcessor});
        }
        this._consumer = this.createConsumer(jsDestinationAddress, mPCoreConnection);
        this._messagePump = messagePump;
        this._isStarted = false;
        this._concurrency = destinationDefinition.getMediationDefinition().isConcurrentMediationAllowed();
        this._mediationThreadPool = messageProcessor.getMessagingEngine().getMediationThreadPool();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RegisteredConsumer", (Object)this);
        }
    }

    public synchronized void start() throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (!this._isStarted) {
            Object object;
            try {
                object = this._messagePump.getPumpBusyLock();
                int n = 1;
                if (this._concurrency) {
                    n = this._mediationThreadPool.getMaximumPoolSize();
                    this._messagePump.setConcurencyEnabled(this._concurrency, this._mediationThreadPool, n);
                }
                long l = 0L;
                ORB oRB = EJSORB.getORBInstance();
                String string = oRB.getProperty("was.wlmTimeout");
                if (string != null && string.length() != 0) {
                    try {
                        l = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer.start", (String)"1:169:1.15", (Object)this);
                    }
                }
                ((ConsumerSessionImpl)this._consumer).registerAsynchMediationConsumerCallback(this._messagePump, n, l, 1, null, false, null, (ExternalConsumerLock)object);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer.start", (String)"1:191:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                MessagePumpException messagePumpException = new MessagePumpException((Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"start", (Object)messagePumpException);
                }
                throw messagePumpException;
            }
            try {
                this._consumer.start(false);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer.start", (String)"1:215:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                try {
                    this._consumer.deregisterAsynchConsumerCallback();
                }
                catch (SIException sIException2) {
                    FFDCFilter.processException((Throwable)sIException2, (String)"com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer.start", (String)"1:233:1.15", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException2));
                }
                sIException.printStackTrace();
                MessagePumpException messagePumpException = new MessagePumpException((Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"start", (Object)messagePumpException);
                }
                throw messagePumpException;
            }
            object = this._messagePump.getMediationConsumerDispatcher();
            ((ConsumerDispatcher)object).setReadyForUse();
            this._isStarted = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public synchronized void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this._isStarted) {
            try {
                this._consumer.stop();
                this._consumer.deregisterAsynchConsumerCallback();
                this._isStarted = false;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer.stop", (String)"1:283:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
    }

    public void free() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"free");
        }
        this.stop();
        this._consumer = null;
        this._messagePump = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"free");
        }
    }

    private ConsumerSession createConsumer(JsDestinationAddress jsDestinationAddress, MPCoreConnection mPCoreConnection) throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumer", (Object)new Object[]{jsDestinationAddress, mPCoreConnection});
        }
        ConsumerSession consumerSession = null;
        try {
            consumerSession = mPCoreConnection.createConsumerSession((SIDestinationAddress)jsDestinationAddress, null, null, null, false, false, Reliability.NONE, true, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer.createConsumer", (String)"1:351:1.15", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            MessagePumpException messagePumpException = new MessagePumpException((Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createConsumer", (Object)messagePumpException);
            }
            throw messagePumpException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumer", (Object)consumerSession);
        }
        return consumerSession;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/mediation/RegisteredConsumer.java, SIB.processor, WAS602.SIB, o0610.11 1.15");
        }
    }
}

