/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.mediation;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.impl.interfaces.MPCallsToUnitTestHandler;
import com.ibm.ws.sib.processor.impl.mediation.ActiveMediation;
import com.ibm.ws.sib.processor.impl.mediation.MediationMessageSelectionCriteria;
import com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine;
import com.ibm.ws.sib.processor.impl.mediation.MessagePumpException;
import com.ibm.ws.sib.processor.impl.mediation.RegisteredConsumer;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediation;
import com.ibm.wsspi.sib.mediation.runtime.SIMediationInvalidException;
import com.ibm.wsspi.sib.mediation.runtime.StopReason;
import com.ibm.wsspi.sib.mediation.runtime.StopReasonFactory;

public class MessagePump
implements AsynchConsumerCallback {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)MessagePump.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private RegisteredConsumer _consumer = null;
    private DestinationMediation _mediation;
    private volatile boolean _isStarted = false;
    private MessageProcessor _messageProcessor;
    private ActiveMediation _owningActiveMediation;
    private MPCoreConnection _connection = null;
    private volatile ProducerSession _producer;
    private MediationMessageSelectionCriteria _selectionFilter = null;
    private String _nameToTrace = null;
    private JsDestinationAddress _destAddress;
    private boolean _concurencyEnabled = false;
    private int _msgCount = 0;
    private int _maxActiveMessages;
    private ThreadPool _mediationThreadPool;

    public MessagePump(DestinationMediation destinationMediation, MessageProcessor messageProcessor, ActiveMediation activeMediation, MediationMessageSelectionCriteria mediationMessageSelectionCriteria) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessagePump", (Object)new Object[]{destinationMediation, messageProcessor, activeMediation, mediationMessageSelectionCriteria});
        }
        this._selectionFilter = mediationMessageSelectionCriteria;
        this._mediation = destinationMediation;
        this._isStarted = false;
        this._messageProcessor = messageProcessor;
        this._owningActiveMediation = activeMediation;
        this._nameToTrace = activeMediation.getDestinationDefinition().getName();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Message pump created. name=" + this._nameToTrace));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessagePump", (Object)this);
        }
    }

    public ConsumerDispatcher getMediationConsumerDispatcher() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationConsumerDispatcher");
        }
        ConsumerDispatcher consumerDispatcher = this._owningActiveMediation.getMediationConsumerDispatcher();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationConsumerDispatcher");
        }
        return consumerDispatcher;
    }

    void setConcurencyEnabled(boolean bl, ThreadPool threadPool, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConcurencyEnabled", (Object)new Object[]{new Boolean(bl), threadPool, new Integer(n)});
        }
        this._concurencyEnabled = bl;
        this._mediationThreadPool = threadPool;
        this._maxActiveMessages = n;
        if (this._concurencyEnabled && this._maxActiveMessages < 20) {
            this._maxActiveMessages = 20;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConcurencyEnabled");
        }
    }

    private void incrementAndCheckActiveMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incrementAndCheckActiveMessages", (Object)lockedMessageEnumeration);
        }
        if (this._concurencyEnabled) {
            ++this._msgCount;
            if (this._msgCount == this._maxActiveMessages) {
                if (this._maxActiveMessages != this._mediationThreadPool.getMaximumPoolSize()) {
                    this._maxActiveMessages = this._mediationThreadPool.getMaximumPoolSize();
                    try {
                        ((ConsumerSessionImpl)lockedMessageEnumeration.getConsumerSession()).getLocalConsumerPoint().setMaxActiveMessages(this._maxActiveMessages);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.incrementAndCheckActiveMessages", (String)"1:250:1.30", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"incrementAndCheckActiveMessages", (Object)"SIErrorException - no active consumer ?!");
                        }
                        throw new SIErrorException();
                    }
                }
                this._msgCount = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incrementAndCheckActiveMessages");
        }
    }

    public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeMessages", (Object)new Object[]{this._nameToTrace, lockedMessageEnumeration});
        }
        try {
            boolean bl = this.isMessagesPassingFilter(lockedMessageEnumeration);
            if (bl) {
                this.incrementAndCheckActiveMessages(lockedMessageEnumeration);
                this._mediation.mediate(lockedMessageEnumeration);
            } else {
                this.putMessagesToPostMediatedDestination(lockedMessageEnumeration);
            }
        }
        catch (SIMediationInvalidException sIMediationInvalidException) {
            FFDCFilter.processException((Throwable)((Object)sIMediationInvalidException), (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.consumeMessages", (String)"1:303:1.30", (Object)this);
            if (this._isStarted) {
                this.stop();
                MPCallsToUnitTestHandler mPCallsToUnitTestHandler = MessageProcessor.getMPCallsToUnitTestHandler();
                mPCallsToUnitTestHandler.unitTestFailure("Mediation failed. It's not in the state we expected.", (Exception)((Object)sIMediationInvalidException));
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.consumeMessages", (String)"1:348:1.30", (Object)this);
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)sIException));
            StopReason stopReason = this.createFailedToMoveStopReason();
            this.stop();
            this.stopMediation(stopReason);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeMessages");
        }
    }

    private StopReason createFailedToMoveStopReason() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createFailedToMoveStopReason");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_STOPPED_BY_FAILURE_TO_MOVE_UNMEDIATED_MESSAGE_SIMP0662", new Object[]{this._owningActiveMediation.getDestinationDefinition().getName()}, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createFailedToMoveStopReason", (Object)stopReason);
        }
        return stopReason;
    }

    private boolean isMessagesPassingFilter(LockedMessageEnumeration lockedMessageEnumeration) throws SIErrorException, SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SIResourceException, SIIncorrectCallException {
        SIBusMessage sIBusMessage;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMessagesPassingFilter", (Object)lockedMessageEnumeration);
        }
        boolean bl = true;
        while ((sIBusMessage = lockedMessageEnumeration.nextLocked()) != null) {
            boolean bl2 = this._selectionFilter.isMatchingCriteria(sIBusMessage);
            if (bl2) continue;
            bl = false;
        }
        lockedMessageEnumeration.resetCursor();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMessagesPassingFilter", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void stopMediation(StopReason stopReason) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMediation", (Object)stopReason);
        }
        MediationStateMachine mediationStateMachine = this._owningActiveMediation.getStateMachine();
        mediationStateMachine.stopEvent(false, stopReason, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopMediation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMessagesToPostMediatedDestination(LockedMessageEnumeration lockedMessageEnumeration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putMessagesToPostMediatedDestination", (Object)lockedMessageEnumeration);
        }
        try {
            SIUncoordinatedTransaction sIUncoordinatedTransaction = this._connection.createUncoordinatedTransaction();
            boolean bl = false;
            try {
                while (lockedMessageEnumeration.getRemainingMessageCount() > 0) {
                    SIBusMessage sIBusMessage = lockedMessageEnumeration.nextLocked();
                    if (sIBusMessage == null) continue;
                    lockedMessageEnumeration.deleteCurrent((SITransaction)sIUncoordinatedTransaction);
                    if (this._producer == null) {
                        this._producer = this.createProducer(this._messageProcessor, this._destAddress, this._connection);
                    }
                    this._producer.send(sIBusMessage, (SITransaction)sIUncoordinatedTransaction);
                }
                bl = true;
            }
            finally {
                if (bl) {
                    sIUncoordinatedTransaction.commit();
                } else {
                    sIUncoordinatedTransaction.rollback();
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.putMessagesToPostMediatedDestination", (String)"1:500:1.30", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            StopReason stopReason = this.createFailedToMoveStopReason();
            this.stopMediation(stopReason);
        }
    }

    private MPCoreConnection createConnection(DestinationDefinition destinationDefinition, BaseDestinationHandler baseDestinationHandler) throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection", (Object)new Object[]{destinationDefinition, baseDestinationHandler});
        }
        String string = baseDestinationHandler.getName();
        String string2 = destinationDefinition.getMediationDefinition().getMediationName();
        MPCoreConnection mPCoreConnection = this._messageProcessor.createMediationConnection(string2, string);
        if (mPCoreConnection == null) {
            MessagePumpException messagePumpException = new MessagePumpException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:553:1.30", this}, null));
            SibTr.exception((TraceComponent)tc, (Exception)messagePumpException);
            FFDCFilter.processException((Throwable)messagePumpException, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.createConnection", (String)"1:562:1.30", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createConnection", (Object)messagePumpException);
            }
            throw messagePumpException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection", (Object)mPCoreConnection);
        }
        return mPCoreConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(DestinationDefinition destinationDefinition, BaseDestinationHandler baseDestinationHandler) throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)this._nameToTrace);
        }
        if (!this._isStarted) {
            boolean bl = false;
            try {
                MPCoreConnection mPCoreConnection = this.createConnection(destinationDefinition, baseDestinationHandler);
                String string = destinationDefinition.getName();
                JsDestinationAddress jsDestinationAddress = SIMPUtils.createMediationDestinationAddress(string);
                RegisteredConsumer registeredConsumer = new RegisteredConsumer(jsDestinationAddress, this, mPCoreConnection, destinationDefinition, this._messageProcessor);
                this._destAddress = jsDestinationAddress;
                this._connection = mPCoreConnection;
                this._consumer = registeredConsumer;
                this._isStarted = true;
                registeredConsumer.start();
                bl = true;
                Object var9_8 = null;
                if (!bl) {
                    this._selectionFilter = null;
                    this._connection = null;
                    this._producer = null;
                    this._consumer = null;
                    this._isStarted = false;
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!bl) {
                    this._selectionFilter = null;
                    this._connection = null;
                    this._producer = null;
                    this._consumer = null;
                    this._isStarted = false;
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public synchronized void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this._nameToTrace);
        }
        if (this._isStarted) {
            this._consumer.stop();
            this._isStarted = false;
            this._consumer.free();
            this._consumer = null;
            try {
                if (null != this._producer) {
                    this._producer.close();
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.stop", (String)"1:663:1.30", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
            this._producer = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void free() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"free");
        }
        this.stop();
        this._mediation = null;
        try {
            if (this._producer != null) {
                this._producer.close();
                this._producer = null;
            }
            if (this._connection != null) {
                this._connection.close();
                this._connection = null;
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.free", (String)"1:707:1.30", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
        }
        this._messageProcessor = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"free");
        }
    }

    public ExternalConsumerLock getPumpBusyLock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPumpBusyLock");
        }
        ExternalConsumerLock externalConsumerLock = this._owningActiveMediation.getMediationBusyLock();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPumpBusyLock", (Object)externalConsumerLock);
        }
        return externalConsumerLock;
    }

    private ProducerSession createProducer(MessageProcessor messageProcessor, JsDestinationAddress jsDestinationAddress, MPCoreConnection mPCoreConnection) throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProducer", (Object)new Object[]{messageProcessor, jsDestinationAddress});
        }
        ProducerSessionImpl producerSessionImpl = null;
        try {
            producerSessionImpl = (ProducerSessionImpl)mPCoreConnection.createProducerSession((SIDestinationAddress)jsDestinationAddress, null, null, null);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.mediation.MessagePump.createProducer", (String)"1:769:1.30", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            SibTr.warning((TraceComponent)tc, (String)"MEDIATION_MESSAGE_PUMP_START_PRODUCER_FAILED_SIMP0666", (Object)new Object[]{jsDestinationAddress.getDestinationName(), jsDestinationAddress.getBusName(), sIException.toString()});
            MessagePumpException messagePumpException = new MessagePumpException((Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createProducer", (Object)messagePumpException);
            }
            throw messagePumpException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProducer", (Object)producerSessionImpl);
        }
        return producerSessionImpl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/mediation/MessagePump.java, SIB.processor, WAS602.SIB, o0610.11 1.30");
        }
    }
}

