/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.mediation;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsConfigConstants;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.MediationLocalizationDefinition;
import com.ibm.ws.sib.processor.MediationState;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.impl.mediation.ActiveMediation;
import com.ibm.ws.sib.processor.impl.mediation.InternalMediationState;
import com.ibm.ws.sib.processor.impl.mediation.MediationControlAdapter;
import com.ibm.ws.sib.processor.impl.mediation.MediationMessageSelectionCriteria;
import com.ibm.ws.sib.processor.impl.mediation.MediationStateMachineLock;
import com.ibm.ws.sib.processor.impl.mediation.MessagePumpException;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MediationInputItemStream;
import com.ibm.ws.sib.processor.runtime.MPRuntimeEvent;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.mediation.runtime.SIMediationInvalidException;
import com.ibm.wsspi.sib.mediation.runtime.SIMediationNotFoundException;
import com.ibm.wsspi.sib.mediation.runtime.StopReason;
import com.ibm.wsspi.sib.mediation.runtime.StopReasonFactory;
import java.util.Map;
import java.util.Properties;

public class MediationStateMachine {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)MediationStateMachine.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static final boolean RESUME_PREVENTED = true;
    public static final boolean RESUME_ALLOWED = false;
    public static final boolean IMMEDIATE = true;
    public static final boolean NOT_IMMEDIATE = false;
    public static final boolean NOT_RESUME_TYPE_START = false;
    public static final boolean RESUME_TYPE_START = true;
    private BaseDestinationHandler _owningDestinationHandler;
    private StopReason _stopReason = null;
    private boolean _isMediationResumePrevented = false;
    private State _preferredStateWhenConfigChangeComplete;
    private volatile MediationDefinition _mediationDefinition = null;
    private volatile DestinationDefinition _destinationDefinition;
    private volatile MediationInputItemStream _owner;
    private volatile ActiveMediation _activeMediation = null;
    private MessageProcessor _messageProcessor = null;
    private volatile MediationStateMachineLock _stateEngineLock = new MediationStateMachineLock();
    private volatile MediationControlAdapter _mediationControlAdapter = null;
    private final Inactive _inactiveState = new Inactive();
    private final WaitingForWAS _waitingForWasState = new WaitingForWAS();
    private final WaitingForMP _waitingForMPState = new WaitingForMP();
    private final WaitingForPreviousDelete _waitingForPreviousDelete = new WaitingForPreviousDelete();
    private final Started _startedState = new Started();
    private final StoppingForStop _stoppingForStopState = new StoppingForStop();
    private final StoppingForDelete _stoppingForDeleteState = new StoppingForDelete();
    private final StoppingForChange _stoppingForChangeState = new StoppingForChange();
    private final Stopped _stoppedState = new Stopped();
    private final Closed _closedState = new Closed();
    private final Deleting _deletingState = new Deleting();
    private volatile State _mediationState = this._inactiveState;

    public MediationStateMachine(MediationInputItemStream mediationInputItemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MediationStateMachine", (Object)mediationInputItemStream);
        }
        this._owner = mediationInputItemStream;
        this._mediationState = this._inactiveState;
        this._mediationControlAdapter = new MediationControlAdapter(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MediationStateMachine", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateEvent(MediationLocalizationDefinition mediationLocalizationDefinition, BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activateEvent", (Object)new Object[]{this, mediationLocalizationDefinition, baseDestinationHandler});
        }
        this._messageProcessor = messageProcessor;
        this._owningDestinationHandler = baseDestinationHandler;
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.activate(mediationLocalizationDefinition);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activateEvent");
        }
    }

    private void prepareForStartStopOrWaitingState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepareForStartStopOrWaitingState");
        }
        ConsumerDispatcherState consumerDispatcherState = new ConsumerDispatcherState();
        ConsumerDispatcher consumerDispatcher = new ConsumerDispatcher(this._owningDestinationHandler, this._owner, consumerDispatcherState);
        this._owner.setOutputHandler(consumerDispatcher);
        this.snapShotConfig();
        this.runtimeControlStart();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepareForStartStopOrWaitingState");
        }
    }

    public DestinationDefinition getDestinationDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationDefinition", (Object)this);
        }
        DestinationDefinition destinationDefinition = this._destinationDefinition;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationDefinition", (Object)destinationDefinition);
        }
        return destinationDefinition;
    }

    private void snapShotConfig() {
        DestinationDefinition destinationDefinition;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"snapShotConfig");
        }
        if ((destinationDefinition = (DestinationDefinition)this._owningDestinationHandler.getDefinition()) == null) {
            this._destinationDefinition = null;
        } else {
            this._destinationDefinition = (DestinationDefinition)destinationDefinition.clone();
            MediationDefinition mediationDefinition = destinationDefinition.getMediationDefinition();
            this._mediationDefinition = mediationDefinition != null ? (MediationDefinition)mediationDefinition.clone() : null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"snapShotConfig");
        }
    }

    private boolean isInitialStateStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isInitialStateStarted");
        }
        boolean bl = true;
        DestinationDefinition destinationDefinition = this.getDestinationDefinition();
        if (destinationDefinition != null) {
            MediationLocalizationDefinition mediationLocalizationDefinition;
            bl = !destinationDefinition.isMediationEnabled() ? false : JsConfigConstants.MEDIATION_INITIAL_STATE_STARTED.equalsIgnoreCase((mediationLocalizationDefinition = (MediationLocalizationDefinition)this._owner.getLocalizationDefinition()).getInitialState());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isInitialStateStarted", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void runtimeControlStart() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeControlStart");
        }
        this._owner.registerControlAdapterAsMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeControlStart");
        }
    }

    private void runtimeControlStop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeControlStop");
        }
        this._owner.deregisterControlAdapterMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeControlStop");
        }
    }

    private void setMediationState(State state) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMediationState");
        }
        State state2 = this._mediationState;
        this._mediationState = state;
        if (state.getExternalMediationState() != state2.getExternalMediationState()) {
            this.emitStateChangedEvent(state.getExternalMediationState());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMediationState");
        }
    }

    private void setStopReason(StopReason stopReason) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopReason", (Object)stopReason);
        }
        this._stopReason = stopReason;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStopReason");
        }
    }

    private StopReason createStopReasonMPStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStopReasonMPStopping");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_STOPPED_BY_SHUTDOWN_SIMP0652", new Object[]{this._owner.getDestinationHandler().getName()}, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStopReasonMPStopping");
        }
        return stopReason;
    }

    private StopReason createStopReasonWasClosing() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStopReasonWasClosing");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_STOPPED_BY_SHUTDOWN_SIMP0652", new Object[]{this._owner.getDestinationHandler().getName()}, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStopReasonWasClosing");
        }
        return stopReason;
    }

    private void emitStateChangedEvent(MediationState mediationState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"emitStateChangedEvent", (Object)mediationState);
        }
        if (this._messageProcessor != null && this._messageProcessor.getMessagingEngine() != null && this._messageProcessor.getMessagingEngine().isEventNotificationEnabled()) {
            if (this._owner.getControlAdapter() != null) {
                String string = this._owningDestinationHandler.getName();
                String string2 = "";
                if (this._mediationDefinition != null) {
                    string2 = this._mediationDefinition.getMediationName();
                }
                String string3 = this._owningDestinationHandler.getUuid().toString();
                String string4 = nls.getFormattedMessage("NOTIFY_MEDIATION_STATE_CHANGE_CWSIP0657", new Object[]{string, string2, mediationState.toString()}, null);
                Properties properties = new Properties();
                properties.put("destination.name", string);
                properties.put("destination.UUID", string3);
                properties.put("mediation.name", string2);
                if (mediationState.equals(MediationState.DELETING)) {
                    properties.put("mediation.state", "mediation.state.deleting");
                } else if (mediationState.equals(MediationState.STARTED)) {
                    properties.put("mediation.state", "mediation.state.started");
                } else if (mediationState.equals(MediationState.STOPPED)) {
                    properties.put("mediation.state", "mediation.state.stopped");
                } else if (mediationState.equals(MediationState.STOPPING)) {
                    properties.put("mediation.state", "mediation.state.stopping");
                } else if (mediationState.equals(MediationState.WAITING)) {
                    properties.put("mediation.state", "mediation.state.waiting");
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unknown state: " + mediationState));
                }
                if (this._stopReason != null) {
                    properties.put("mediation.state.reason", this._stopReason.getReason(null));
                }
                MPRuntimeEvent mPRuntimeEvent = new MPRuntimeEvent("SIB.mediation.new.state", string4, properties);
                this._owner.getControlAdapter().runtimeEventOccurred(mPRuntimeEvent);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Unable to fire event, control adapter is null");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"fireSendAllowedStateChangeEvent", (Object)"Event notification is disabled");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"emitStateChangedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deactivateEvent", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._owner.setOutputHandler(null);
            this._owner = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deactivateEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mpStartedEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mpStartedEvent", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.mpStarted();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mpStartedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previousMediationPointDeletedEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"previousMediationPointDeletedEvent", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.previousInstanceDeleted();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"previousMediationPointDeletedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openForEBusinessEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"openForEBusinessEvent", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.openForEBusiness();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"openForEBusinessEvent");
        }
    }

    public ConsumerDispatcher getMediationConsumerDispatcher() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationConsumerDispatcher", (Object)this);
        }
        ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)this._owner.getOutputHandler();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationConsumerDispatcher", (Object)consumerDispatcher);
        }
        return consumerDispatcher;
    }

    public MediationInputItemStream getMediationInputItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationInputItemStream", (Object)this);
        }
        MediationInputItemStream mediationInputItemStream = this._owner;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationInputItemStream", (Object)mediationInputItemStream);
        }
        return mediationInputItemStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closingForEBusinessEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closingForEBusinessEvent", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.closingForEBusiness();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closingForEBusinessEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEvent(boolean bl, StopReason stopReason, MediationControlAdapter mediationControlAdapter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopEvent", (Object)new Object[]{this, new Boolean(bl)});
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            boolean bl2 = true;
            if (mediationControlAdapter != null && mediationControlAdapter != this._mediationControlAdapter) {
                bl2 = false;
            }
            if (bl2) {
                this._mediationState.stop(false, bl, stopReason);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mpStoppingEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mpStoppingEvent", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.mpStopping();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mpStoppingEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEvent(boolean bl, MediationControlAdapter mediationControlAdapter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startEvent", (Object)new Object[]{this, new Boolean(bl)});
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            StopReason stopReason = null;
            if (!bl) {
                this._isMediationResumePrevented = false;
                stopReason = this.createStopReasonAdministratorAction();
            } else {
                stopReason = this.createStopReasonMediationAction();
            }
            boolean bl2 = true;
            if (mediationControlAdapter != null && mediationControlAdapter != this._mediationControlAdapter) {
                bl2 = false;
            }
            if (bl2) {
                this._mediationState.start(bl, stopReason);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stoppedEvent(ActiveMediation activeMediation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stoppedEvent", (Object)new Object[]{this, activeMediation});
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            if (activeMediation == this._activeMediation) {
                this._mediationState.stopped();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stoppedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLaterEvent(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteLaterEvent", (Object)new Object[]{baseDestinationHandler, messageProcessor, this});
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this._mediationState.deleteLater(baseDestinationHandler, messageProcessor);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteLaterEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNowEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteNowEvent", (Object)this);
        }
        boolean bl = false;
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            bl = this._mediationState.deleteNow();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteNowEvent", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean immediateCleanupPreMediatedItemStream() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"immediateCleanupPreMediatedItemStream");
        }
        bl = this._owner.reallocateMsgs();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"immediateCleanupPreMediatedItemStream", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void changeConfig(DestinationDefinition destinationDefinition) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"changeConfig", (Object)new Object[]{destinationDefinition, this});
        }
        boolean bl = false;
        if (this._destinationDefinition == null) {
            bl = false;
        } else if (this._destinationDefinition.isMediationEnabled() != destinationDefinition.isMediationEnabled()) {
            bl = true;
        } else {
            String string = this._destinationDefinition.getExceptionDestination();
            String string2 = destinationDefinition.getExceptionDestination();
            if (string == null) {
                if (string2 != null) {
                    bl = true;
                }
            } else if (string2 == null) {
                bl = true;
            } else if (!string2.equals(string)) {
                bl = true;
            }
            if (!bl) {
                if (this._destinationDefinition.getMediationDefinition() != null && destinationDefinition.getMediationDefinition() == null) {
                    bl = true;
                } else {
                    MediationDefinition mediationDefinition = destinationDefinition.getMediationDefinition();
                    if (!this.isMediationDefinitionSame(mediationDefinition, this._mediationDefinition)) {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            this.changeEvent();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"changeConfig");
        }
    }

    private boolean isMediationDefinitionSame(MediationDefinition mediationDefinition, MediationDefinition mediationDefinition2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMediationDefinitionSame", (Object)new Object[]{mediationDefinition, mediationDefinition2});
        }
        boolean bl = true;
        if (mediationDefinition.getDiscriminator() != mediationDefinition2.getDiscriminator()) {
            bl = false;
        } else if (mediationDefinition.getHandlerListName() != mediationDefinition2.getHandlerListName()) {
            bl = false;
        } else if (mediationDefinition.getMediationName() != mediationDefinition2.getMediationName()) {
            bl = false;
        } else if (mediationDefinition.getSelector() != mediationDefinition2.getSelector()) {
            bl = false;
        } else if (mediationDefinition.isConcurrentMediationAllowed() != mediationDefinition2.isConcurrentMediationAllowed()) {
            bl = false;
        } else {
            Map map = mediationDefinition.getMediationContext();
            Map map2 = mediationDefinition2.getMediationContext();
            if (map == null && map2 != null || map != null && map2 == null) {
                bl = false;
            } else if (map != null && !((Object)map).equals(map2)) {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMediationDefinitionSame", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"changeEvent");
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            this.setStopReasonConfigChange();
            this._mediationState.change();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"changeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediationState getMediationState() {
        MediationState mediationState;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationState", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            mediationState = this._mediationState.getExternalMediationState();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationState", (Object)mediationState);
        }
        return mediationState;
    }

    InternalMediationState getInternalMediationState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInternalMediationState");
        }
        InternalMediationState internalMediationState = this._mediationState.getInternalState();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInternalMediationState", (Object)internalMediationState);
        }
        return internalMediationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StopReason getMediationStopReason() {
        StopReason stopReason;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationStopReason", (Object)this);
        }
        this._stateEngineLock.getLockSoon();
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        synchronized (mediationStateMachineLock) {
            this._stateEngineLock.freeingLockSoon();
            stopReason = this._stopReason;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationStopReason", (Object)stopReason);
        }
        return stopReason;
    }

    private StopReason createActiveMediation(MediationMessageSelectionCriteria mediationMessageSelectionCriteria) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createActiveMediation");
        }
        StopReason stopReason = null;
        try {
            this._activeMediation = new ActiveMediation(this, (DestinationDefinition)this._owningDestinationHandler.getDefinition(), this._mediationControlAdapter, this._messageProcessor, this._owningDestinationHandler, mediationMessageSelectionCriteria);
        }
        catch (SIMediationNotFoundException sIMediationNotFoundException) {
            FFDCFilter.processException((Throwable)((Object)sIMediationNotFoundException), (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.createActiveMediation", (String)"1:2962:1.56", (Object)this);
            Object object = sIMediationNotFoundException.hasStopReason() ? sIMediationNotFoundException.getStopReason() : sIMediationNotFoundException;
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMediationNotFoundException));
            stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_FAILED_TO_START_SIMP0655", new Object[]{this._destinationDefinition.getName(), this._destinationDefinition.getMediationDefinition().getMediationName(), object}, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createActiveMediation", stopReason);
        }
        return stopReason;
    }

    private void tellMediationToStart() throws SIMediationInvalidException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tellMediationToStart");
        }
        this._activeMediation.start();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tellMediationToStart");
        }
    }

    private void tellMediationToStop(boolean bl) throws SIMediationInvalidException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tellMediationToStop");
        }
        this._activeMediation.stop(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tellMediationToStop");
        }
    }

    private void destroyActiveMediation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroyActiveMediation");
        }
        if (this._activeMediation != null) {
            this._activeMediation.free();
            this._activeMediation = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroyActiveMediation");
        }
    }

    private boolean isConfigChangesMediationIdentity(MediationDefinition mediationDefinition, MediationDefinition mediationDefinition2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isConfigChangesMediationIdentity", (Object)new Object[]{mediationDefinition, mediationDefinition2});
        }
        boolean bl = false;
        if (mediationDefinition2 == null) {
            bl = true;
        } else if (!mediationDefinition.getMediationName().equals(mediationDefinition2.getMediationName())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isConfigChangesMediationIdentity", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void destroySequence() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroySequence");
        }
        this.runtimeControlStop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroySequence");
        }
    }

    private StopReason createInitialStateStoppedReason() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInitialStateStoppedReason");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_CHANGE_REASON_CONFIG_ACTION_SIMP0773", null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInitialStateStoppedReason", (Object)stopReason);
        }
        return stopReason;
    }

    private void moveToStartOrStoppedState(boolean bl, StopReason stopReason, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveToStartOrStoppedState");
        }
        boolean bl3 = true;
        if (bl && !(bl3 = this._startedState.enterState(bl2, stopReason))) {
            bl = false;
        }
        if (!bl) {
            if (bl3) {
                this.setStopReason(stopReason);
            }
            this._preferredStateWhenConfigChangeComplete = this._stoppedState;
            this._stoppedState.enterState();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveToStartOrStoppedState");
        }
    }

    private void enqueueDestinationForDeletion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"enqueueDestinationForDeletion");
        }
        BaseDestinationHandler baseDestinationHandler = this._owner.getDestinationHandler();
        DestinationManager destinationManager = baseDestinationHandler.getDestinationManager();
        destinationManager.markDestinationAsCleanUpPending(baseDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"enqueueDestinationForDeletion");
        }
    }

    public synchronized void setMessageFlowEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)new Object[]{new Boolean(bl), this});
        }
        this._mediationState.setMessageFlowEvent(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent");
        }
    }

    private boolean setMessageFlow(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageFlow", (Object)new Boolean(bl));
        }
        boolean bl2 = false;
        if (bl) {
            try {
                this.messageFlowOn();
                bl2 = true;
            }
            catch (MessagePumpException messagePumpException) {
                SibTr.warning((TraceComponent)tc, (String)"MESSAGE_PUMP_START_WARNING_CWSIP0656W", (Object)new Object[]{this._destinationDefinition.getName(), messagePumpException.toString()});
            }
        } else {
            this.messageFlowOff();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageFlow", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    private void messageFlowOff() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageFlowOff");
        }
        Object var1_1 = null;
        this._activeMediation.setMessageFlowOff();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageFlowOff", var1_1);
        }
    }

    private void messageFlowOn() throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageFlowOn");
        }
        this._activeMediation.setMessageFlowOn();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageFlowOn");
        }
    }

    private boolean isMediationEnabled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMediationEnabled");
        }
        boolean bl = this._destinationDefinition.isMediationEnabled();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMediationEnabled", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void setStopReasonCantStartBecauseMediationDisabled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopReasonCantStartBecauseMediationDisabled");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_START_PREVENTED_DISABLED_SIMP0665", new Object[]{this._destinationDefinition.getName()}, false);
        this.setStopReason(stopReason);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStopReasonCantStartBecauseMediationDisabled");
        }
    }

    private void setStopReasonWaitingForWasToStart() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopReasonWaitingForWasToStart");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_CHANGE_REASON_WAIT_WAS_SIMP0774", null, false);
        this.setStopReason(stopReason);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStopReasonWaitingForWasToStart");
        }
    }

    private void setStopReasonInitialState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopReasonInitialState");
        }
        StopReason stopReason = this.createInitialStateStoppedReason();
        this.setStopReason(stopReason);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStopReasonInitialState");
        }
    }

    private void setStopReasonConfigChange() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopReasonConfigChange");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_CHANGE_REASON_CONFIG_CHANGE_SIMP0776", null, false);
        this.setStopReason(stopReason);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStopReasonConfigChange");
        }
    }

    private StopReason createStopReasonAdministratorAction() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStopReasonAdministratorAction");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_CHANGE_REASON_ADMIN_ACTION_SIMP0771", null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStopReasonAdministratorAction", (Object)stopReason);
        }
        return stopReason;
    }

    private void setStopReasonWaitingForOtherInstanceDeletion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopReasonWaitingForOtherInstanceDeletion");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_CHANGE_REASON_WAIT_DELETE_SIMP0775", null, false);
        this.setStopReason(stopReason);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStopReasonWaitingForOtherInstanceDeletion");
        }
    }

    private StopReason createStopReasonMediationAction() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStopReasonMediationAction");
        }
        StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_CHANGE_REASON_MEDIATION_ACTION_SIMP0772", null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStopReasonMediationAction", (Object)stopReason);
        }
        return stopReason;
    }

    public ExternalConsumerLock getStateMachineLock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateMachineLock");
        }
        MediationStateMachineLock mediationStateMachineLock = this._stateEngineLock;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStateMachineLock", (Object)mediationStateMachineLock);
        }
        return mediationStateMachineLock;
    }

    public void mbeanEventStop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mbeanEventStop");
        }
        StopReason stopReason = this.createStopReasonAdministratorAction();
        this.stopEvent(true, stopReason, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mbeanEventStop");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Mediation State Machine: hash=");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append(" desinationName=");
        if (this._destinationDefinition == null) {
            stringBuffer.append("unknown");
        } else {
            stringBuffer.append(this._destinationDefinition.getName());
        }
        stringBuffer.append(" state=");
        if (this._mediationState == null) {
            stringBuffer.append("unknown");
        } else {
            stringBuffer.append(this._mediationState);
        }
        return stringBuffer.toString();
    }

    public void replaceControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"replaceControlAdapter");
        }
        this.freeControlAdapter();
        this._mediationControlAdapter = new MediationControlAdapter(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replaceControlAdapter");
        }
    }

    public void freeControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"freeControlAdapter");
        }
        if (this._mediationControlAdapter != null) {
            this._mediationControlAdapter.free();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"freeControlAdapter");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/mediation/MediationStateMachine.java, SIB.processor, WAS602.SIB, o0610.11 1.56");
        }
    }

    private class Deleting
    extends State {
        private Deleting() {
        }

        public void setMessageFlowEvent(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.DELETING);
            }
            return InternalMediationState.DELETING;
        }

        public boolean deleteNow() {
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteNow", (Object)this);
            }
            if (bl = MediationStateMachine.this.immediateCleanupPreMediatedItemStream()) {
                MediationStateMachine.this.destroySequence();
                MediationStateMachine.this._closedState.enterState();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteNow", (Object)this);
            }
            return bl;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            MediationStateMachine.this.setStopReasonConfigChange();
            MediationStateMachine.this.enqueueDestinationForDeletion();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }
    }

    private class Closed
    extends State {
        private Closed() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.CLOSED);
            }
            return InternalMediationState.CLOSED;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }
    }

    private class StoppingForChange
    extends State {
        private StoppingForChange() {
        }

        public void setMessageFlowEvent(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
            MediationStateMachine.this.messageFlowOff();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.STOPPING_TO_CHANGE);
            }
            return InternalMediationState.STOPPING_TO_CHANGE;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._stoppingForDeleteState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void change() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"change", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"change", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._stoppingForStopState.enterState();
            MediationStateMachine.this._stoppingForStopState.stopped();
            MediationStateMachine.this._stoppedState.mpStopping();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void start(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"start", (Object)this);
            }
            if (!bl) {
                MediationStateMachine.this._isMediationResumePrevented = false;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start", (Object)this);
            }
        }

        public void stopped() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stopped", (Object)this);
            }
            MediationStateMachine.this._stoppedState.enterState();
            MediationStateMachine.this._stoppedState.change();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stopped", (Object)this);
            }
        }

        public void stop(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stopWhileStoppingForChange", (Object)this);
            }
            if (bl) {
                MediationStateMachine.this._isMediationResumePrevented = true;
            }
            MediationStateMachine.this._preferredStateWhenConfigChangeComplete = MediationStateMachine.this._stoppedState;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stopWhileStoppingForChange");
            }
        }
    }

    private class StoppingForDelete
    extends State {
        private StoppingForDelete() {
        }

        public void setMessageFlowEvent(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
            MediationStateMachine.this.messageFlowOff();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.STOPPING_TO_DELETE);
            }
            return InternalMediationState.STOPPING_TO_DELETE;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            MediationStateMachine.this.setStopReasonConfigChange();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._stoppingForStopState.enterState();
            MediationStateMachine.this._stoppingForStopState.stopped();
            MediationStateMachine.this._stoppedState.mpStopping();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void stopped() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stopped", (Object)this);
            }
            MediationStateMachine.this._stoppedState.enterState();
            MediationStateMachine.this._stoppedState.deleteLater(MediationStateMachine.this._owningDestinationHandler, MediationStateMachine.this._messageProcessor);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stopped", (Object)this);
            }
        }
    }

    private class StoppingForStop
    extends State {
        private StoppingForStop() {
        }

        public void setMessageFlowEvent(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
            MediationStateMachine.this.messageFlowOff();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.STOPPING_TO_STOP);
            }
            return InternalMediationState.STOPPING_TO_STOP;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._stoppingForDeleteState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void change() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"change", (Object)this);
            }
            MediationStateMachine.this._stoppingForChangeState.enterState();
            MediationStateMachine.this._preferredStateWhenConfigChangeComplete = MediationStateMachine.this._stoppedState;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"change", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._stoppingForStopState.enterState();
            MediationStateMachine.this._stoppingForStopState.stopped();
            MediationStateMachine.this._stoppedState.mpStopping();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void start(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"start", (Object)this);
            }
            if (!bl || !MediationStateMachine.this._isMediationResumePrevented) {
                MediationStateMachine.this._isMediationResumePrevented = false;
                if (!MediationStateMachine.this.isMediationEnabled()) {
                    MediationStateMachine.this.setStopReasonCantStartBecauseMediationDisabled();
                } else {
                    MediationStateMachine.this.moveToStartOrStoppedState(true, stopReason, true);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start", (Object)this);
            }
        }

        public void stopped() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stopped", (Object)this);
            }
            MediationStateMachine.this._stoppedState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stopped", (Object)this);
            }
        }

        public void stop(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this);
            }
            if (bl) {
                MediationStateMachine.this._isMediationResumePrevented = true;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stop", (Object)this);
            }
        }
    }

    private class Stopped
    extends State {
        private Stopped() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.STOPPED);
            }
            return InternalMediationState.STOPPED;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            MediationStateMachine.this.destroyActiveMediation();
            if (!MediationStateMachine.this._messageProcessor.isWASOpenForEBusiness() || !MediationStateMachine.this._messageProcessor.isStarted()) {
                MediationStateMachine.this._closedState.enterState();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._deletingState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            MediationStateMachine.this.runtimeControlStop();
            MediationStateMachine.this.freeControlAdapter();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void closingForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            MediationStateMachine.this.runtimeControlStop();
            MediationStateMachine.this.freeControlAdapter();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
        }

        public void change() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"change", (Object)this);
            }
            DestinationDefinition destinationDefinition = (DestinationDefinition)MediationStateMachine.this._owningDestinationHandler.getDefinition();
            boolean bl = MediationStateMachine.this.isConfigChangesMediationIdentity(MediationStateMachine.this._destinationDefinition.getMediationDefinition(), destinationDefinition.getMediationDefinition());
            MediationStateMachine.this.snapShotConfig();
            if (bl) {
                MediationStateMachine.this.replaceControlAdapter();
                boolean bl2 = MediationStateMachine.this.isInitialStateStarted();
                StopReason stopReason = MediationStateMachine.this.createInitialStateStoppedReason();
                MediationStateMachine.this.moveToStartOrStoppedState(bl2, stopReason, false);
            } else if (MediationStateMachine.this._preferredStateWhenConfigChangeComplete == MediationStateMachine.this._startedState) {
                MediationStateMachine.this.moveToStartOrStoppedState(true, null, false);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"changeWhileStopped");
            }
        }

        public void start(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"start", (Object)this);
            }
            if (!bl || !MediationStateMachine.this._isMediationResumePrevented) {
                MediationStateMachine.this._isMediationResumePrevented = false;
                MediationStateMachine.this.moveToStartOrStoppedState(true, stopReason, false);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start", (Object)this);
            }
        }

        public void stop(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this);
            }
            if (bl) {
                MediationStateMachine.this._isMediationResumePrevented = true;
            }
            MediationStateMachine.this._preferredStateWhenConfigChangeComplete = MediationStateMachine.this._stoppedState;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stop", (Object)this);
            }
        }
    }

    private class Started
    extends State {
        private Started() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.STARTED);
            }
            return InternalMediationState.STARTED;
        }

        public boolean enterState(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            boolean bl2 = true;
            if (MediationStateMachine.this._mediationDefinition == null) {
                StopReason stopReason2 = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_START_ERROR_SIMP0651", new Object[]{MediationStateMachine.this._destinationDefinition.getName()}, false);
                MediationStateMachine.this.setStopReason(stopReason2);
                bl2 = false;
            } else {
                MediationMessageSelectionCriteria mediationMessageSelectionCriteria = this.createMessageSelectionFilter();
                if (mediationMessageSelectionCriteria == null) {
                    bl2 = false;
                }
                MediationStateMachine.this._preferredStateWhenConfigChangeComplete = MediationStateMachine.this._startedState;
                MediationStateMachine.this.runtimeControlStart();
                if (!MediationStateMachine.this.isMediationEnabled()) {
                    MediationStateMachine.this.setStopReasonCantStartBecauseMediationDisabled();
                    bl2 = false;
                } else {
                    StopReason stopReason3;
                    if (!bl && (stopReason3 = MediationStateMachine.this.createActiveMediation(mediationMessageSelectionCriteria)) != null) {
                        bl2 = false;
                        MediationStateMachine.this.setStopReason(stopReason3);
                    }
                    if (bl2) {
                        try {
                            MediationStateMachine.this.tellMediationToStart();
                            MediationStateMachine.this.setStopReason(stopReason);
                        }
                        catch (SIMediationInvalidException sIMediationInvalidException) {
                            FFDCFilter.processException((Throwable)((Object)sIMediationInvalidException), (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.Started.enterState", (String)"1:872:1.56", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMediationInvalidException));
                            Object object = sIMediationInvalidException.hasStopReason() ? sIMediationInvalidException.getStopReason() : sIMediationInvalidException;
                            StopReason stopReason4 = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_FAILED_TO_START_SIMP0654", new Object[]{MediationStateMachine.this._destinationDefinition.getName(), object}, false);
                            MediationStateMachine.this.setStopReason(stopReason4);
                            bl2 = false;
                        }
                        MediationStateMachine.this.setMediationState(this);
                        MediationStateMachine.this.setMessageFlow(true);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            return bl2;
        }

        private MediationMessageSelectionCriteria createMessageSelectionFilter() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"createMessageSelectionFilter", (Object)this);
            }
            String string = MediationStateMachine.this._mediationDefinition.getSelector();
            String string2 = MediationStateMachine.this._mediationDefinition.getDiscriminator();
            MediationMessageSelectionCriteria mediationMessageSelectionCriteria = null;
            try {
                mediationMessageSelectionCriteria = new MediationMessageSelectionCriteria(MediationStateMachine.this._messageProcessor, string, string2);
            }
            catch (SISelectorSyntaxException sISelectorSyntaxException) {
                FFDCFilter.processException((Throwable)sISelectorSyntaxException, (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.Started.createMessageSelectionFilter", (String)"1:942:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sISelectorSyntaxException));
                StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_START_FAILURE_INVALID_SELECTOR_SIMP0663", new Object[]{MediationStateMachine.this._destinationDefinition.getName(), string, sISelectorSyntaxException}, false);
                MediationStateMachine.this.setStopReason(stopReason);
            }
            catch (SIDiscriminatorSyntaxException sIDiscriminatorSyntaxException) {
                FFDCFilter.processException((Throwable)sIDiscriminatorSyntaxException, (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.Started.createMessageSelectionFilter", (String)"1:965:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDiscriminatorSyntaxException));
                StopReason stopReason = StopReasonFactory.create("com.ibm.ws.sib.processor.CWSIPMessages", "MEDIATION_START_FAILURE_INVALID_DISCRIMINATOR_SIMP0664", new Object[]{MediationStateMachine.this._destinationDefinition.getName(), string2, sIDiscriminatorSyntaxException}, false);
                MediationStateMachine.this.setStopReason(stopReason);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createMessageSelectionFilter", (Object)this);
            }
            return mediationMessageSelectionCriteria;
        }

        public void setMessageFlowEvent(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
            MediationStateMachine.this.setMessageFlow(bl);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._stoppingForDeleteState.enterState();
            try {
                MediationStateMachine.this.messageFlowOff();
                MediationStateMachine.this.tellMediationToStop(false);
            }
            catch (SIMediationInvalidException sIMediationInvalidException) {
                FFDCFilter.processException((Throwable)((Object)sIMediationInvalidException), (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.Started.deleteLater", (String)"1:1025:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMediationInvalidException));
                MediationStateMachine.this._stoppingForDeleteState.stopped();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            StopReason stopReason = MediationStateMachine.this.createStopReasonMPStopping();
            this.stop(true, true, stopReason);
            MediationStateMachine.this._stoppingForStopState.stopped();
            MediationStateMachine.this._stoppedState.mpStopping();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping");
            }
        }

        public void closingForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
            StopReason stopReason = MediationStateMachine.this.createStopReasonWasClosing();
            this.stop(true, true, stopReason);
            MediationStateMachine.this._stoppingForStopState.stopped();
            MediationStateMachine.this._stoppedState.closingForEBusiness();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
        }

        public void stop(boolean bl, boolean bl2, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this);
            }
            MediationStateMachine.this._stopReason = stopReason;
            if (bl2) {
                MediationStateMachine.this._isMediationResumePrevented = true;
            }
            MediationStateMachine.this._stoppingForStopState.enterState();
            MediationStateMachine.this._preferredStateWhenConfigChangeComplete = MediationStateMachine.this._stoppedState;
            try {
                MediationStateMachine.this.messageFlowOff();
                MediationStateMachine.this.tellMediationToStop(bl);
            }
            catch (SIMediationInvalidException sIMediationInvalidException) {
                FFDCFilter.processException((Throwable)((Object)sIMediationInvalidException), (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.Started.stop", (String)"1:1125:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMediationInvalidException));
                MediationStateMachine.this._stoppingForStopState.stopped();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stop", (Object)this);
            }
        }

        public void change() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"change", (Object)this);
            }
            MediationStateMachine.this._stoppingForChangeState.enterState();
            try {
                MediationStateMachine.this.messageFlowOff();
                MediationStateMachine.this.tellMediationToStop(false);
            }
            catch (SIMediationInvalidException sIMediationInvalidException) {
                FFDCFilter.processException((Throwable)((Object)sIMediationInvalidException), (String)"com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine.Started.change", (String)"1:1163:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMediationInvalidException));
                MediationStateMachine.this._stoppingForChangeState.stopped();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"change", (Object)this);
            }
        }
    }

    private class WaitingForPreviousDelete
    extends State {
        private WaitingForPreviousDelete() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.WAITING_FOR_OTHER_INSTANCE_DELETE);
            }
            return InternalMediationState.WAITING_FOR_OTHER_INSTANCE_DELETE;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setStopReasonWaitingForOtherInstanceDeletion();
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void closingForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._deletingState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            MediationStateMachine.this.runtimeControlStop();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void previousInstanceDeleted() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"previousInstanceDeleted", (Object)this);
            }
            if (!MediationStateMachine.this._messageProcessor.isWASOpenForEBusiness()) {
                MediationStateMachine.this._waitingForWasState.enterState();
            } else {
                boolean bl = MediationStateMachine.this.isInitialStateStarted();
                MediationStateMachine.this.setStopReasonInitialState();
                StopReason stopReason = MediationStateMachine.this.createInitialStateStoppedReason();
                MediationStateMachine.this.moveToStartOrStoppedState(bl, stopReason, false);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"previousInstanceDeleted", (Object)this);
            }
        }
    }

    private class WaitingForWAS
    extends State {
        private WaitingForWAS() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.WAITING_FOR_WAS);
            }
            return InternalMediationState.WAITING_FOR_WAS;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setStopReasonWaitingForWasToStart();
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._deletingState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            MediationStateMachine.this.runtimeControlStop();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void openForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"openForEBusiness", (Object)this);
            }
            MediationStateMachine.this.setStopReasonInitialState();
            boolean bl = MediationStateMachine.this.isInitialStateStarted();
            if (bl) {
                StopReason stopReason = MediationStateMachine.this.createInitialStateStoppedReason();
                boolean bl2 = MediationStateMachine.this._startedState.enterState(false, stopReason);
                if (!bl2) {
                    bl = false;
                }
            }
            if (!bl) {
                MediationStateMachine.this._preferredStateWhenConfigChangeComplete = MediationStateMachine.this._stoppedState;
                MediationStateMachine.this._stoppedState.enterState();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"openForEBusiness", (Object)this);
            }
        }
    }

    private class WaitingForMP
    extends State {
        private WaitingForMP() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.WAITING_FOR_MP);
            }
            return InternalMediationState.WAITING_FOR_MP;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setStopReasonWaitingForWasToStart();
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void closingForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._deletingState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            MediationStateMachine.this._closedState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void mpStarted() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStarted", (Object)this);
            }
            MediationStateMachine.this.runtimeControlStart();
            if (MediationStateMachine.this._owningDestinationHandler.hasDeletingMediation()) {
                MediationStateMachine.this._waitingForPreviousDelete.enterState();
            } else if (MediationStateMachine.this._messageProcessor.isWASOpenForEBusiness()) {
                boolean bl = MediationStateMachine.this.isInitialStateStarted();
                StopReason stopReason = MediationStateMachine.this.createInitialStateStoppedReason();
                MediationStateMachine.this.setStopReasonInitialState();
                MediationStateMachine.this.moveToStartOrStoppedState(bl, stopReason, false);
            } else {
                MediationStateMachine.this._waitingForWasState.enterState();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStarted", (Object)this);
            }
        }
    }

    private class Inactive
    extends State {
        private Inactive() {
        }

        public InternalMediationState getInternalState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalState", (Object)InternalMediationState.INACTIVE);
            }
            return InternalMediationState.INACTIVE;
        }

        public void enterState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"enterState", (Object)this);
            }
            MediationStateMachine.this.setMediationState(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"enterState", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            StopReason stopReason = MediationStateMachine.this.createStopReasonMPStopping();
            MediationStateMachine.this.setStopReason(stopReason);
            MediationStateMachine.this._closedState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            MediationStateMachine.this._messageProcessor = messageProcessor;
            MediationStateMachine.this._owningDestinationHandler = baseDestinationHandler;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            MediationStateMachine.this._deletingState.enterState();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public void activate(MediationLocalizationDefinition mediationLocalizationDefinition) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"activate", (Object)this);
            }
            MediationStateMachine.this.prepareForStartStopOrWaitingState();
            MediationStateMachine.this._owner.updateLocalizationDefinition((LocalizationDefinition)mediationLocalizationDefinition);
            if (MediationStateMachine.this._owner.getOutputHandler() != null) {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)MediationStateMachine.this._owner.getOutputHandler();
                consumerDispatcher.setReadyForUse();
            }
            if (MediationStateMachine.this._messageProcessor.isStarted()) {
                if (MediationStateMachine.this._owningDestinationHandler.hasDeletingMediation()) {
                    MediationStateMachine.this._waitingForPreviousDelete.enterState();
                } else if (MediationStateMachine.this._messageProcessor.isWASOpenForEBusiness()) {
                    boolean bl = MediationStateMachine.this.isInitialStateStarted();
                    MediationStateMachine.this.setStopReasonInitialState();
                    StopReason stopReason = MediationStateMachine.this.createInitialStateStoppedReason();
                    MediationStateMachine.this.moveToStartOrStoppedState(bl, stopReason, false);
                } else {
                    MediationStateMachine.this._waitingForWasState.enterState();
                }
            } else {
                MediationStateMachine.this._waitingForMPState.enterState();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"activate", (Object)this);
            }
        }
    }

    private abstract class State {
        private State() {
        }

        public void stopped() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stopped", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stopped", (Object)this);
            }
        }

        public void activate(MediationLocalizationDefinition mediationLocalizationDefinition) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"activate", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"activate", (Object)this);
            }
        }

        public void openForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"openForEBusiness", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"openForEBusiness", (Object)this);
            }
        }

        public void closingForEBusiness() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"closingForEBusiness", (Object)this);
            }
        }

        public void change() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"change", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"change", (Object)this);
            }
        }

        public void mpStarted() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStarted", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStarted", (Object)this);
            }
        }

        public void mpStopping() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"mpStopping", (Object)this);
            }
        }

        public void previousInstanceDeleted() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"previousInstanceDeleted", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"previousInstanceDeleted", (Object)this);
            }
        }

        public void deleteLater(BaseDestinationHandler baseDestinationHandler, MessageProcessor messageProcessor) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLater", (Object)this);
            }
        }

        public boolean deleteNow() {
            boolean bl = false;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteNow", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteNow", (Object)this);
            }
            return bl;
        }

        public void start(boolean bl, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"start", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start", (Object)this);
            }
        }

        public void setMessageFlowEvent(boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMessageFlowEvent", (Object)this);
            }
        }

        public void stop(boolean bl, boolean bl2, StopReason stopReason) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this);
            }
            if (bl2) {
                MediationStateMachine.this._isMediationResumePrevented = true;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"stop", (Object)this);
            }
        }

        public final MediationState getExternalMediationState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getExternalMediationState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getExternalMediationState");
            }
            return this.getInternalState().getMediationState();
        }

        public final InternalMediationState getInternalMediationState() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getInternalMediationState", (Object)this);
                SibTr.exit((TraceComponent)tc, (String)"getInternalMediationState");
            }
            return this.getInternalState();
        }

        abstract InternalMediationState getInternalState();
    }
}

