/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.mediation;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.impl.mediation.MediationControlAdapter;
import com.ibm.ws.sib.processor.impl.mediation.MediationMessageSelectionCriteria;
import com.ibm.ws.sib.processor.impl.mediation.MediationStateMachine;
import com.ibm.ws.sib.processor.impl.mediation.MessagePump;
import com.ibm.ws.sib.processor.impl.mediation.MessagePumpException;
import com.ibm.ws.sib.processor.impl.mediation.StoppedEventListener;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediation;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediationFactory;
import com.ibm.wsspi.sib.mediation.runtime.SIMediationInvalidException;
import com.ibm.wsspi.sib.mediation.runtime.SIMediationNotFoundException;
import java.util.List;

public class ActiveMediation {
    private static final TraceComponent tc = SibTr.register((Class)ActiveMediation.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private volatile MessagePump _messagePump = null;
    private volatile MediationStateMachine _stateMachine = null;
    private DestinationDefinition _destinationDefClone = null;
    private volatile StoppedEventListener _stoppedEventListener = null;
    private DestinationMediation _mediation = null;
    private BaseDestinationHandler _owningDestinationHandler = null;
    private DestinationMediationFactory _mediationFactory = null;
    private MediationControlAdapter _controlAdapter = null;
    private String _nameToTrace = null;

    public ActiveMediation(MediationStateMachine mediationStateMachine, DestinationDefinition destinationDefinition, MediationControlAdapter mediationControlAdapter, MessageProcessor messageProcessor, BaseDestinationHandler baseDestinationHandler, MediationMessageSelectionCriteria mediationMessageSelectionCriteria) throws SIMediationNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ActiveMediation", (Object)new Object[]{mediationStateMachine, destinationDefinition, mediationControlAdapter, messageProcessor, baseDestinationHandler, mediationMessageSelectionCriteria});
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Constructing active mediation for destination " + destinationDefinition.getName()));
            }
        }
        this._nameToTrace = destinationDefinition.getName();
        this._owningDestinationHandler = baseDestinationHandler;
        this._stateMachine = mediationStateMachine;
        this._destinationDefClone = (DestinationDefinition)destinationDefinition.clone();
        this._controlAdapter = mediationControlAdapter;
        this._mediationFactory = (DestinationMediationFactory)messageProcessor.getMEInstance("MediationFactory");
        this._mediation = this._mediationFactory.getDestinationMediation(this._destinationDefClone, (SIDestinationAddress)SIMPUtils.createMediationDestinationAddress(destinationDefinition.getName()));
        this._messagePump = this.createMessagePump(mediationMessageSelectionCriteria, this._mediation, this._owningDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ActiveMediation", (Object)this);
        }
    }

    private MessagePump createMessagePump(MediationMessageSelectionCriteria mediationMessageSelectionCriteria, DestinationMediation destinationMediation, BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMessagePump", (Object)new Object[]{mediationMessageSelectionCriteria, destinationMediation, baseDestinationHandler});
        }
        MessagePump messagePump = new MessagePump(destinationMediation, baseDestinationHandler.getMessageProcessor(), this, mediationMessageSelectionCriteria);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMessagePump", (Object)messagePump);
        }
        return messagePump;
    }

    public void free() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"free", (Object)this._nameToTrace);
        }
        this._stateMachine = null;
        if (null != this._stoppedEventListener) {
            this._stoppedEventListener.free();
        }
        this._stoppedEventListener = null;
        this._messagePump.free();
        this._messagePump = null;
        this._mediationFactory.returnDestinationMediation(this._mediation);
        this._mediationFactory = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"free");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SIMediationInvalidException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)this._nameToTrace);
        }
        ActiveMediation activeMediation = this;
        synchronized (activeMediation) {
            if (this._stoppedEventListener != null) {
                this._stoppedEventListener.free();
            }
            this._stoppedEventListener = null;
        }
        this._mediation.start(this._controlAdapter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public ConsumerDispatcher getMediationConsumerDispatcher() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationConsumerDispatcher");
        }
        ConsumerDispatcher consumerDispatcher = this._stateMachine.getMediationConsumerDispatcher();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationConsumerDispatcher");
        }
        return consumerDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stoppedEvent(StoppedEventListener stoppedEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stoppedEvent", (Object)new Object[]{stoppedEventListener, this._nameToTrace});
        }
        ActiveMediation activeMediation = this;
        synchronized (activeMediation) {
            if (stoppedEventListener == this._stoppedEventListener) {
                this._stateMachine.stoppedEvent(this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stoppedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) throws SIMediationInvalidException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)new Object[]{new Boolean(bl), this._nameToTrace});
        }
        this._messagePump.stop();
        Object object = this;
        synchronized (object) {
            this._stoppedEventListener = new StoppedEventListener(this);
        }
        if (bl) {
            this._mediation.stop();
        } else if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            object = this.getMediationConsumerDispatcher();
            List list = ((ConsumerDispatcher)object).getConsumerPoints();
            for (int i = 0; i < list.size(); ++i) {
                ConsumerKey consumerKey = (ConsumerKey)list.get(i);
                ConsumerPoint consumerPoint = consumerKey.getConsumerPoint();
                if (!consumerPoint.isConsumerAMediation()) continue;
                consumerPoint.registerMediationStoppedEventListener(this._stoppedEventListener);
            }
        } else {
            this._mediation.initiateStop(this._stoppedEventListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void setMessageFlowOff() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageFlowOff", (Object)this._nameToTrace);
        }
        this._messagePump.stop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageFlowOff");
        }
    }

    public void setMessageFlowOn() throws MessagePumpException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageFlowOn", (Object)this._nameToTrace);
        }
        this._messagePump.start(this._destinationDefClone, this._owningDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageFlowOn");
        }
    }

    public MediationStateMachine getStateMachine() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateMachine");
        }
        MediationStateMachine mediationStateMachine = this._stateMachine;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStateMachine", (Object)mediationStateMachine);
        }
        return mediationStateMachine;
    }

    public DestinationDefinition getDestinationDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationDefinition");
        }
        DestinationDefinition destinationDefinition = this._destinationDefClone;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationDefinition", (Object)destinationDefinition);
        }
        return destinationDefinition;
    }

    public ExternalConsumerLock getMediationBusyLock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMediationBusyLock");
        }
        ExternalConsumerLock externalConsumerLock = this._stateMachine.getStateMachineLock();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMediationBusyLock", (Object)externalConsumerLock);
        }
        return externalConsumerLock;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/mediation/ActiveMediation.java, SIB.processor, WAS602.SIB, o0610.11 1.26");
        }
    }
}

