/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.Iterator;
import java.util.List;

public class ReportHandler {
    private static final TraceComponent tc = SibTr.register((Class)ReportHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DestinationHandler _destination;
    private MessageProcessor _messageProcessor;
    private InputHandler _inputHandler = null;
    private JsDestinationAddress _destinationAddress;

    public ReportHandler(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ReportHandler", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ReportHandler", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SIMPMessage sIMPMessage, Transaction transaction, Integer n) throws SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{sIMPMessage, transaction, n});
        }
        JsMessage jsMessage = null;
        try {
            jsMessage = sIMPMessage.getMessage().getReceived();
        }
        catch (MessageCopyFailedException messageCopyFailedException) {
            FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.ReportHandler.handleMessage", (String)"1:171:1.34", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)messageCopyFailedException);
        }
        Byte by = null;
        if (n == SIApiConstants.REPORT_COA) {
            by = jsMessage.getReportCOA();
        } else if (n == SIApiConstants.REPORT_COD) {
            by = sIMPMessage.getReportCOD();
        } else if (n == SIApiConstants.REPORT_EXCEPTION) {
            by = jsMessage.getReportException();
        } else if (n == SIApiConstants.REPORT_EXPIRY) {
            by = jsMessage.getReportExpiry();
        }
        if (by.equals(SIApiConstants.REPORT_NO_DATA)) {
            jsMessage.clearMessagePayload();
            jsMessage.clearMessageProperties();
        }
        jsMessage.setReportFeedback(n);
        jsMessage.setReportCOA(null);
        jsMessage.setReportCOD(null);
        jsMessage.setReportException(null);
        jsMessage.setReportExpiry(null);
        jsMessage.setReportNAN(null);
        jsMessage.setReportPAN(null);
        jsMessage.setReportDiscardMsg(Boolean.FALSE);
        jsMessage.setTimeToLive(0L);
        jsMessage.setRemainingTimeToLive(-1L);
        jsMessage.setMessageWaitTime(0L);
        jsMessage.setTimestamp(System.currentTimeMillis());
        jsMessage.setRedeliveredCount(0);
        if (sIMPMessage.getMessage().getReplyPriority() != null) {
            jsMessage.setPriority(sIMPMessage.getMessage().getReplyPriority().intValue());
        }
        if (sIMPMessage.getMessage().getReplyReliability() != null) {
            jsMessage.setReliability(sIMPMessage.getMessage().getReplyReliability());
        }
        if (sIMPMessage.getMessage().getReplyTimeToLive() != null) {
            jsMessage.setTimeToLive(sIMPMessage.getMessage().getReplyTimeToLive().longValue());
        } else {
            jsMessage.setTimeToLive(0L);
        }
        if (sIMPMessage.getMessage().getReplyDiscriminator() != null) {
            jsMessage.setDiscriminator(sIMPMessage.getMessage().getReplyDiscriminator());
        } else {
            jsMessage.setDiscriminator(null);
        }
        if (Boolean.FALSE.equals(sIMPMessage.getMessage().getReportPassCorrelId())) {
            jsMessage.setCorrelationIdAsBytes(jsMessage.getApiMessageIdAsBytes());
        }
        if (Boolean.FALSE.equals(sIMPMessage.getMessage().getReportPassMsgId())) {
            object2 = jsMessage.getApiMessageIdAsBytes();
            if (object2 != null) {
                object = new byte[((byte[])object2).length + 1];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object[i] = (byte)object2[i];
                }
                object[((Object)object2).length] = n.byteValue();
            } else {
                object = new byte[]{n.byteValue()};
            }
            jsMessage.setApiMessageIdAsBytes(object);
        }
        if (!sIMPMessage.getMessage().isReverseRoutingPathEmpty()) {
            object2 = sIMPMessage.getMessage().getReverseRoutingPath();
            object = null;
            Iterator iterator = object2.iterator();
            object = (JsDestinationAddress)iterator.next();
            object2.remove(object);
            jsMessage.setForwardRoutingPath((List)object2);
            if (this._destinationAddress == null) {
                this._destinationAddress = (JsDestinationAddress)object;
            }
            JsDestinationAddress jsDestinationAddress = this._destinationAddress;
            synchronized (jsDestinationAddress) {
                if (this._inputHandler == null || !this._destinationAddress.equals(object)) {
                    this._destinationAddress = (JsDestinationAddress)object;
                    this._destination = this._messageProcessor.getDestinationManager().getDestination(this._destinationAddress, true);
                    this._inputHandler = this._destination.getInputHandler();
                }
                try {
                    this._inputHandler.handleMessage(new MessageItem(jsMessage), transaction, this._destinationAddress, this._messageProcessor.getMECellule());
                }
                catch (SIMPNoLocalisationsException sIMPNoLocalisationsException) {
                    this._destination.handleUndeliverableMessage(sIMPMessage, 26, new String[]{this._destination.getName()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ReportHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.34");
        }
    }
}

