/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionLostException;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPLimitExceededException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPResourceException;
import com.ibm.ws.sib.processor.exceptions.SIMPRollbackException;
import com.ibm.ws.sib.processor.gd.ExpressTargetStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.GuaranteedTargetStream;
import com.ibm.ws.sib.processor.gd.InternalInputStreamManager;
import com.ibm.ws.sib.processor.gd.SourceStreamManager;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AbstractInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.exceptions.FlushAlreadyInProgressException;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.Browsable;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProxyReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.matching.MatchingConsumerDispatcher;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.stats.TopicspaceInstrumentation;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.SearchResultsObjectPool;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.CellulePair;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PubSubInputHandler
extends AbstractInputHandler
implements DownstreamControl,
Browsable,
InputHandlerStore {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)PubSubInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private SourceStreamManager _sourceStreamManager;
    private BatchHandler _sourceBatchHandler;
    private TopicspaceInstrumentation _stats;
    private InternalInputStreamManager _internalInputStreamManager;
    private Cellule _localCellule;
    private SIMPReferenceStream _proxyReferenceStream;
    private SearchResultsObjectPool _searchResultsObjectPool;
    private MessageProcessorMatching _matchspace;
    private String _linkInboundUserid = null;
    private PubSubMessageItemStream _itemStream;
    private HashMap _originStreamMap;
    private boolean _flushedForDeleteSource = false;
    private FlushComplete _deleteFlushSource = null;
    private boolean _flushedForDeleteTarget = false;
    private AlarmListener _deleteFlushTarget = null;

    PubSubInputHandler(DestinationHandler destinationHandler, TargetProtocolItemStream targetProtocolItemStream, PubSubMessageItemStream pubSubMessageItemStream, ProxyReferenceStream proxyReferenceStream, ProtocolItemStream protocolItemStream, SearchResultsObjectPool searchResultsObjectPool) {
        super(destinationHandler, targetProtocolItemStream);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubInputHandler", (Object)new Object[]{destinationHandler, targetProtocolItemStream, pubSubMessageItemStream, proxyReferenceStream, protocolItemStream, searchResultsObjectPool});
        }
        this._proxyReferenceStream = proxyReferenceStream;
        proxyReferenceStream.setPubSubInputHandler(this);
        this._sourceStreamManager = new SourceStreamManager(this._messageProcessor, this, destinationHandler, protocolItemStream, destinationHandler.getMessageProcessor().getMECellule(), null);
        this._internalInputStreamManager = new InternalInputStreamManager(this._messageProcessor, this);
        this._localCellule = this._messageProcessor.getMECellule();
        this._searchResultsObjectPool = searchResultsObjectPool;
        this._itemStream = pubSubMessageItemStream;
        this._matchspace = this._messageProcessor.getMessageProcessorMatching();
        this._sourceBatchHandler = this._messageProcessor.getSourceBatchHandler();
        this._originStreamMap = new HashMap();
        if (destinationHandler.isLink() && !destinationHandler.isMQLink()) {
            this._linkInboundUserid = ((LinkHandler)destinationHandler).getInboundUserid();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Link handler, set link inbound userid: " + this._linkInboundUserid));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubInputHandler", (Object)this);
        }
    }

    public void messageEventOccurred(int n, SIMPMessage sIMPMessage, Transaction transaction) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(n), sIMPMessage, transaction});
        }
        if (n == 8) {
            this.eventPrecommitAdd(sIMPMessage, transaction);
        } else if (n == 2) {
            this.eventPostAdd(sIMPMessage, transaction, false);
        } else if (n == 4) {
            this.eventPostAdd(sIMPMessage, transaction, true);
        } else if (n == 9) {
            this.eventPostCommit(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    protected final void eventPrecommitAdd(SIMPMessage sIMPMessage, Transaction transaction) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPrecommitAdd", (Object)new Object[]{sIMPMessage, transaction});
        }
        if (sIMPMessage.isTransacted()) {
            this.localFanOut((MessageItem)sIMPMessage, transaction, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPrecommitAdd");
        }
    }

    private void eventPostAdd(SIMPMessage sIMPMessage, Transaction transaction, boolean bl) throws SIResourceException {
        PubSubOutputHandler pubSubOutputHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostAdd", (Object)new Object[]{sIMPMessage, transaction, new Boolean(bl)});
        }
        MessageItemReference messageItemReference = (MessageItemReference)sIMPMessage;
        MessageItem messageItem = (MessageItem)messageItemReference.getReferredItem();
        JsMessage jsMessage = messageItem.getMessage();
        if (bl) {
            this._sourceStreamManager.updateSourceStream(messageItem, bl);
        } else {
            this._sourceStreamManager.updateSourceStream(messageItemReference, bl);
        }
        jsMessage.setBus(this._messageProcessor.getMessagingEngineBus());
        MessageProcessorSearchResults messageProcessorSearchResults = messageItemReference.getSearchResults();
        List list = messageProcessorSearchResults.getPubSubOutputHandlers(null);
        MessagingEngine messagingEngine = this._messageProcessor.getMECellule();
        CellulePair[] cellulePairArray = new CellulePair[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pubSubOutputHandler = (PubSubOutputHandler)iterator.next();
            if (!pubSubOutputHandler.okToForward(messageItem)) continue;
            if (bl) {
                pubSubOutputHandler.rollbackInsert(messageItem);
            } else {
                pubSubOutputHandler.commitInsert(messageItem);
                if (UserTrace.tc_mt.isDebugEnabled()) {
                    UserTrace.traceOutboundSend(jsMessage, pubSubOutputHandler.getTargetMEUuid(), this._destination.getName());
                }
            }
            if (pubSubOutputHandler.isLink()) {
                pubSubOutputHandler.sendLinkMessage(messageItem, bl);
                continue;
            }
            MessagingEngine messagingEngine2 = new MessagingEngine(pubSubOutputHandler.getTargetMEUuid());
            cellulePairArray[n++] = new CellulePair(messagingEngine, messagingEngine2);
        }
        if (n > 0) {
            if (bl) {
                pubSubOutputHandler = this.createSilenceMessage(jsMessage.getGuaranteedValueValueTick(), jsMessage.getGuaranteedValueCompletedPrefix(), messageItem.getPriority(), messageItem.getReliability(), jsMessage.getGuaranteedStreamUUID());
                this._mpio.sendDownTree(cellulePairArray, 1, messageItem.getPriority(), (ControlMessage)pubSubOutputHandler);
            } else {
                this._mpio.sendDownTree(cellulePairArray, 1, messageItem.getPriority(), jsMessage);
            }
        }
        messageItemReference.setSearchResults(null);
        this._searchResultsObjectPool.add(messageProcessorSearchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostAdd");
        }
    }

    public void sendNackMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, long l2, int n, Reliability reliability, SIBUuid12 sIBUuid122) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNackMessage", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        ControlNack controlNack = this.createControlNackMessage(n, reliability, sIBUuid122);
        controlNack.setStartTick(l);
        controlNack.setEndTick(l2);
        if (cellule == null) {
            cellule = (Cellule)this._originStreamMap.get(sIBUuid122);
        }
        this._mpio.sendUpTree(this._localCellule, cellule, null, n + 2, (ControlMessage)controlNack);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNackMessage ");
        }
    }

    public void sendAckMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, int n, Reliability reliability, SIBUuid12 sIBUuid122, boolean bl) throws SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckMessage", (Object)new Long(l));
        }
        if (cellule == null) {
            cellule = (Cellule)this._originStreamMap.get(sIBUuid122);
        }
        ControlAck controlAck = this.createControlAckMessage(n, reliability, sIBUuid122);
        controlAck.setAckPrefix(l);
        if (bl && this._internalInputStreamManager.hasStream(sIBUuid122, n, reliability)) {
            try {
                this.processAck(controlAck);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.sendAckMessage", (String)"1:739:1.273.1.1", (Object)this);
            }
        } else {
            this._mpio.sendUpTree(this._localCellule, cellule, null, n + 1, (ControlMessage)controlAck);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckMessage");
        }
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{controlMessage});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) != ControlMessageType.REQUESTFLUSH) {
            if (controlMessageType == ControlMessageType.ACK) {
                this.processAck((ControlAck)controlMessage);
            } else if (controlMessageType == ControlMessageType.NACK) {
                this.processNack((ControlNack)controlMessage);
            } else if (controlMessageType == ControlMessageType.ACKEXPECTED) {
                this.processAckExpected((ControlAckExpected)controlMessage);
            } else {
                super.handleControlMessage(cellule, controlMessage);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    private void processAckExpected(ControlAckExpected controlAckExpected) throws SIResourceException {
        Reliability reliability;
        int n;
        SIBUuid12 sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)controlAckExpected);
        }
        if (this._internalInputStreamManager.hasStream(sIBUuid12 = controlAckExpected.getGuaranteedStreamUUID(), n = controlAckExpected.getPriority().intValue(), reliability = controlAckExpected.getReliability())) {
            this._internalInputStreamManager.processAckExpected(controlAckExpected);
        } else {
            this._targetStreamManager.handleAckExpectedMessage(controlAckExpected);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    private void processNack(ControlNack controlNack) throws SIResourceException {
        SIBUuid12 sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)controlNack);
        }
        if (this._sourceStreamManager.hasStream(sIBUuid12 = controlNack.getGuaranteedStreamUUID())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignoring processNack on sourceStream at PubSubInputHandler");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processNack");
            }
        } else {
            this._internalInputStreamManager.processNack(controlNack);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processAck(ControlAck var1_1) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (PubSubInputHandler.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)PubSubInputHandler.tc, (String)"processAck");
        }
        var2_2 = var1_1.getGuaranteedStreamUUID();
        var3_3 = null;
        var4_4 = 0L;
        var6_5 = null;
        var7_6 = 0x7FFFFFFFFFFFFFFFL;
        var9_7 = this._destination.getAllPubSubOutputHandlers().values().iterator();
        var10_8 = null;
        while (var9_7.hasNext()) {
            var10_8 = (PubSubOutputHandler)var9_7.next();
            var7_6 = var10_8.checkAck(var1_1, var7_6);
        }
        if (!this._sourceStreamManager.hasStream(var2_2)) {
            var7_6 = this._targetStreamManager.checkAck(var1_1, var7_6);
        }
        try {
            var11_9 = this;
            synchronized (var11_9) {
                var3_3 = this._sourceStreamManager.hasStream(var2_2) != false ? this._sourceStreamManager.processAck(var1_1, var7_6) : this._internalInputStreamManager.processAck(var1_1, var7_6);
            }
            if (var3_3 != null) {
                var11_9 = this._sourceBatchHandler.registerInBatch();
                var12_11 = false;
                try {
                    var13_12 = this._sourceStreamManager.getBatchListener(var1_1);
                    var14_13 = null;
                    for (var15_14 = 0; var15_14 < var3_3.size(); ++var15_14) {
                        var14_13 = (TickRange)var3_3.get(var15_14);
                        var13_12.addToBatchList(var14_13);
                        var4_4 = var14_13.itemStreamIndex;
                        try {
                            var6_5 = (MessageItemReference)this._proxyReferenceStream.findById(var4_4);
                            if (var6_5 == null) continue;
                            var6_5.remove((Transaction)var11_9, var6_5.getLockID());
                            continue;
                        }
                        catch (MessageStoreException var16_15) {
                            FFDCFilter.processException((Throwable)var16_15, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.processAck", (String)"1:1031:1.273.1.1", (Object)this);
                            SibTr.exception((TraceComponent)PubSubInputHandler.tc, (Exception)var16_15);
                            if (PubSubInputHandler.tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)PubSubInputHandler.tc, (String)"processAck", (Object)var16_15);
                            }
                            SibTr.error((TraceComponent)PubSubInputHandler.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:1042:1.273.1.1", var16_15});
                            throw new SIResourceException(PubSubInputHandler.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:1050:1.273.1.1", var16_15}, null), (Throwable)var16_15);
                        }
                    }
                    var12_11 = true;
                    this._sourceBatchHandler.messagesAdded(var3_3.size(), var13_12);
                    var18_16 = null;
                    ** if (var12_11) goto lbl-1000
                }
                catch (Throwable var17_20) {
                    block23: {
                        var18_17 = null;
                        if (!var12_11) {
                            try {
                                this._sourceBatchHandler.messagesAdded(0);
                            }
                            catch (SIResourceException var19_19) {
                                if (!PubSubInputHandler.tc.isEventEnabled()) break block23;
                                SibTr.exception((TraceComponent)PubSubInputHandler.tc, (Exception)var19_19);
                            }
                        }
                    }
                    throw var17_20;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this._sourceBatchHandler.messagesAdded(0);
                    }
                    catch (SIResourceException var19_18) {
                        if (PubSubInputHandler.tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)PubSubInputHandler.tc, (Exception)var19_18);
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                }
            }
            var21_21 = null;
            this._destination.unlockPubsubOutputHandlers();
        }
        catch (Throwable var20_23) {
            var21_22 = null;
            this._destination.unlockPubsubOutputHandlers();
            this._sourceStreamManager.attemptFlushIfNecessary();
            if (PubSubInputHandler.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)PubSubInputHandler.tc, (String)"processAck");
            }
            throw var20_23;
        }
        this._sourceStreamManager.attemptFlushIfNecessary();
        if (PubSubInputHandler.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)PubSubInputHandler.tc, (String)"processAck");
        }
    }

    public void handleMessage(MessageItem messageItem, Transaction transaction, JsDestinationAddress jsDestinationAddress, Cellule cellule) throws SINotAuthorizedException, SILimitExceededException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{messageItem, transaction, jsDestinationAddress, cellule});
        }
        if (UserTrace.tc_mt.isDebugEnabled()) {
            this.traceSend(messageItem);
        }
        super.handleMessage(messageItem, transaction, jsDestinationAddress, cellule);
        if (!messageItem.isFromRemoteME() && !messageItem.getMessage().isMediated() && this._destination.getMediationDefinition() != null) {
            this._destination.getTopicSpacePtoPMediationInputHandler().handleMessage(messageItem, transaction, jsDestinationAddress, cellule);
        } else if (!this._destination.isToBeDeleted()) {
            if (UserTrace.tc_mt.isDebugEnabled()) {
                messageItem.setDebugName(this._destination.getName());
            }
            if (cellule.equals(this._localCellule)) {
                this.localPut(messageItem, transaction);
            } else {
                try {
                    this.remotePut(messageItem, cellule);
                }
                catch (SIResourceException sIResourceException) {
                    SIMPResourceException sIMPResourceException = new SIMPResourceException(sIResourceException);
                    sIMPResourceException.setExceptionReason(901);
                    sIMPResourceException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler.handleMessage", "1:1150:1.273.1.1", SIMPUtils.getStackTrace(sIResourceException)});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)((Object)sIMPResourceException));
                    }
                    throw sIMPResourceException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    private void localPut(MessageItem messageItem, Transaction transaction) throws SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException, SINotAuthorizedException, SILimitExceededException {
        boolean bl;
        boolean bl2;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"localPut", (Object)new Object[]{messageItem, transaction});
        }
        boolean bl3 = false;
        if (!messageItem.getMessage().isForwardRoutingPathEmpty()) {
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls.getFormattedMessage("FORWARD_ROUTING_PATH_ERROR_CWSIP0249", new Object[]{this._destination.getName()}, null));
            sIMPIncorrectCallException.setExceptionReason(37);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName(), "unknown", SIMPUtils.getStackTrace((Throwable)((Object)sIMPIncorrectCallException))});
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIMPIncorrectCallException));
            }
            throw sIMPIncorrectCallException;
        }
        if (messageItem.isFromRemoteBus() && this._messageProcessor.isBusSecure()) {
            JsMessage jsMessage = messageItem.getMessage();
            if (!this._messageProcessor.getAuthorisationUtils().sentBySIBServer(jsMessage)) {
                SecurityContext securityContext;
                String string = this._linkInboundUserid != null ? this._linkInboundUserid : jsMessage.getSecurityUserid();
                if (string == null) {
                    string = "";
                }
                if (!this._destination.checkDestinationAccess(securityContext = new SecurityContext(string, (String)(object = messageItem.getMessage().getDiscriminator())), OperationType.SEND)) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"not authorized to produce to this destination");
                    }
                    String string2 = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{this._destination.getName(), string}, null);
                    this._messageProcessor.getAccessChecker().fireDestinationAccessNotAuthorizedEvent(this._destination.getName(), string, OperationType.SEND, string2);
                    SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(string2);
                    sIMPNotAuthorizedException.setExceptionReason(18);
                    sIMPNotAuthorizedException.setExceptionInserts(new String[]{this._destination.getName(), string});
                    throw sIMPNotAuthorizedException;
                }
                if (!this._destination.checkDiscriminatorAccess(securityContext, OperationType.SEND)) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"not authorized to produce to this destination's discriminator");
                    }
                    SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), securityContext.getDiscriminator(), string}, null));
                    SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), securityContext.getDiscriminator(), string}, null));
                    sIMPNotAuthorizedException.setExceptionReason(20);
                    sIMPNotAuthorizedException.setExceptionInserts(new String[]{this._destination.getName(), securityContext.getDiscriminator(), string});
                    throw sIMPNotAuthorizedException;
                }
            }
        }
        boolean bl4 = bl2 = (bl = messageItem.isForcePut()) || this._itemStream.isSendAllowed();
        if (!bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"Destination send disallowed");
            }
            object = new SIMPNotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_SEND_DISALLOWED_CWSIP0253", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            ((SIMPNotPossibleInCurrentConfigurationException)((Object)object)).setExceptionReason(901);
            ((SIMPNotPossibleInCurrentConfigurationException)((Object)object)).setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler.localPut", "1:1346:1.273.1.1", SIMPUtils.getStackTrace((Throwable)object)});
            throw object;
        }
        object = this._itemStream.getStatistics();
        long l = this._destination.getPublishPoint().getDestHighMsgs();
        if (!bl && l != -1L && object.getTotalItemCount() > l) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"Destination reached high limit");
            }
            SIMPLimitExceededException sIMPLimitExceededException = new SIMPLimitExceededException(nls.getFormattedMessage("DESTINATION_HIGH_MESSAGES_ERROR_CWSIP0251", new Object[]{this._destination.getName(), new Long(l), this._messageProcessor.getMessagingEngineName()}, null));
            sIMPLimitExceededException.setExceptionReason(25);
            sIMPLimitExceededException.setExceptionInserts(new String[]{this._destination.getName(), new Long(l).toString()});
            throw sIMPLimitExceededException;
        }
        if (messageItem.isTransacted()) {
            this.registerMessage(messageItem, transaction);
        } else {
            ExternalLocalTransaction externalLocalTransaction = this._txManager.createLocalTransaction();
            if (messageItem.getReportCOD() != null && this._destination instanceof BaseDestinationHandler) {
                messageItem.registerMessageEventListener(11, (BaseDestinationHandler)this._destination);
            }
            try {
                bl3 = this.localFanOut(messageItem, externalLocalTransaction, false);
                if (bl3) {
                    externalLocalTransaction.commit();
                } else {
                    externalLocalTransaction.rollback();
                }
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.localPut", (String)"1:1410:1.273.1.1", (Object)this);
                SIMPErrorException sIMPErrorException = new SIMPErrorException(runtimeException);
                sIMPErrorException.setExceptionReason(901);
                sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1417:1.273.1.1", SIMPUtils.getStackTrace(runtimeException)});
                if (tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPErrorException));
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIMPErrorException));
                }
                throw sIMPErrorException;
            }
            catch (SIRollbackException sIRollbackException) {
                this.handleRollback(externalLocalTransaction);
                SIMPRollbackException sIMPRollbackException = new SIMPRollbackException(sIRollbackException.getMessage());
                sIMPRollbackException.setStackTrace(sIRollbackException.getStackTrace());
                sIMPRollbackException.setExceptionReason(901);
                sIMPRollbackException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1437:1.273.1.1", SIMPUtils.getStackTrace(sIRollbackException)});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIMPRollbackException));
                }
                throw sIMPRollbackException;
            }
            catch (SIConnectionLostException sIConnectionLostException) {
                this.handleRollback(externalLocalTransaction);
                SIMPConnectionLostException sIMPConnectionLostException = new SIMPConnectionLostException(sIConnectionLostException.getMessage());
                sIMPConnectionLostException.setStackTrace(sIConnectionLostException.getStackTrace());
                sIMPConnectionLostException.setExceptionReason(901);
                sIMPConnectionLostException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1454:1.273.1.1", SIMPUtils.getStackTrace(sIConnectionLostException)});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIMPConnectionLostException));
                }
                throw sIMPConnectionLostException;
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                this.handleRollback(externalLocalTransaction);
                SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(sIIncorrectCallException.getMessage());
                sIMPIncorrectCallException.setStackTrace(sIIncorrectCallException.getStackTrace());
                sIMPIncorrectCallException.setExceptionReason(901);
                sIMPIncorrectCallException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1471:1.273.1.1", SIMPUtils.getStackTrace(sIIncorrectCallException)});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIMPIncorrectCallException));
                }
                throw sIMPIncorrectCallException;
            }
            catch (SIResourceException sIResourceException) {
                this.handleRollback(externalLocalTransaction);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIResourceException));
                }
                SIMPResourceException sIMPResourceException = new SIMPResourceException(sIResourceException);
                sIMPResourceException.setExceptionReason(901);
                sIMPResourceException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1488:1.273.1.1", SIMPUtils.getStackTrace(sIResourceException)});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)sIMPResourceException));
                }
                throw sIMPResourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"localPut");
        }
    }

    private void remotePut(MessageItem messageItem, Cellule cellule) throws SIResourceException, SIDiscriminatorSyntaxException {
        SIBUuid12 sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remotePut", (Object)new Object[]{messageItem, cellule});
        }
        if (!this._originStreamMap.containsKey(sIBUuid12 = messageItem.getMessage().getGuaranteedStreamUUID())) {
            this._originStreamMap.put(sIBUuid12, cellule);
        }
        MessageProcessorSearchResults messageProcessorSearchResults = this.matchMessage(messageItem);
        String string = messageItem.getMessage().getDiscriminator();
        HashMap hashMap = this._destination.getAllPubSubOutputHandlers();
        List list = messageProcessorSearchResults.getPubSubOutputHandlers(string);
        if (hashMap != null && hashMap.size() > 0) {
            this.remoteToRemotePut(messageItem, hashMap, list);
        }
        this._destination.unlockPubsubOutputHandlers();
        Set set = messageProcessorSearchResults.getConsumerDispatchers(string);
        if (set != null && set.size() > 0) {
            messageItem.setSearchResults(messageProcessorSearchResults);
            this.remoteToLocalPut(messageItem);
        } else {
            this.remoteToLocalPutSilence(messageItem);
            this._searchResultsObjectPool.add(messageProcessorSearchResults);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remotePut");
        }
    }

    private void remoteToRemotePut(MessageItem messageItem, HashMap hashMap, List list) throws SIResourceException {
        CellulePair[] cellulePairArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToRemotePut", (Object)new Object[]{messageItem, list});
        }
        boolean bl = false;
        ArrayList<CellulePair> arrayList = null;
        Iterator iterator = hashMap.values().iterator();
        JsMessage jsMessage = null;
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList<CellulePair>(list.size());
            bl = true;
        }
        while (iterator.hasNext()) {
            cellulePairArray = (CellulePair[])iterator.next();
            if (bl && list.contains(cellulePairArray)) {
                if (!cellulePairArray.okToForward(messageItem)) continue;
                this._internalInputStreamManager.processMessage(messageItem.getMessage());
                if (jsMessage == null) {
                    try {
                        boolean bl2;
                        boolean bl3 = bl2 = messageItem.getReliability().compareTo((Object)Reliability.RELIABLE_PERSISTENT) > 0;
                        if (bl2) {
                            jsMessage = messageItem.getMessage().getReceived();
                            jsMessage.setBus(this._messageProcessor.getMessagingEngineBus());
                            messageItem = new MessageItem(jsMessage);
                        } else {
                            jsMessage = messageItem.getMessage();
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.remoteToRemotePut", (String)"1:1667:1.273.1.1", (Object)this);
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"remoteToRemotePut", (Object)exception);
                        }
                        throw new SIResourceException((Throwable)exception);
                    }
                }
                cellulePairArray.put(messageItem, null, this, true);
                if (cellulePairArray.isLink()) {
                    cellulePairArray.sendLinkMessage(messageItem, false);
                    continue;
                }
                MessagingEngine messagingEngine = new MessagingEngine(cellulePairArray.getTargetMEUuid());
                arrayList.add(new CellulePair(this._localCellule, messagingEngine));
                continue;
            }
            if (!cellulePairArray.okToForward(messageItem)) continue;
            cellulePairArray.putSilence(messageItem);
        }
        if (arrayList != null && arrayList.size() != 0) {
            cellulePairArray = new CellulePair[arrayList.size()];
            cellulePairArray = arrayList.toArray(cellulePairArray);
            this._mpio.sendDownTree(cellulePairArray, 1, messageItem.getPriority(), messageItem.getMessage());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToRemotePut");
        }
    }

    protected void remoteToLocalPutSilence(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToLocalPutSilence", (Object)new Object[]{messageItem});
        }
        this._targetStreamManager.handleSilence(messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToLocalPutSilence");
        }
    }

    private MessageProcessorSearchResults matchMessage(MessageItem messageItem) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"matchMessage", (Object)new Object[]{messageItem});
        }
        JsMessage jsMessage = messageItem.getMessage();
        MessageProcessorSearchResults messageProcessorSearchResults = (MessageProcessorSearchResults)this._searchResultsObjectPool.remove();
        messageProcessorSearchResults = this._matchspace.retrieveMatchingOutputHandlers(this._destination, jsMessage.getDiscriminator(), (MatchSpaceKey)jsMessage, messageProcessorSearchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"matchMessage", (Object)new Object[]{messageProcessorSearchResults});
        }
        return messageProcessorSearchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean localFanOut(MessageItem var1_1, Transaction var2_2, boolean var3_3) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (PubSubInputHandler.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)PubSubInputHandler.tc, (String)"localFanOut", (Object)new Object[]{var1_1, var2_2, new Boolean(var3_3)});
        }
        var4_4 = var1_1.getReliability().compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0;
        var5_5 = var1_1.isTransacted();
        var6_6 = this.matchMessage(var1_1);
        var7_7 = var1_1.getMessage().getDiscriminator();
        var8_8 = var1_1.getMessage();
        var9_9 = var6_6.getPubSubOutputHandlers(var7_7);
        var10_10 = null;
        var11_11 = false;
        if (var9_9 != null && var9_9.size() > 0) {
            var12_12 = null;
            var13_13 = null;
            if (var4_4) {
                if (!var3_3) {
                    this.storeMessage(var1_1, var2_2);
                }
                var3_3 = true;
                var10_10 = this.addProxyReference(var1_1, var6_6, var2_2);
            } else if (var5_5) {
                var1_1.setSearchResults(var6_6);
                var1_1.registerMessageEventListener(9, this);
            } else {
                var12_12 = this._messageProcessor.getMECellule();
                var13_13 = new CellulePair[var9_9.size()];
            }
            if (var4_4 || !var5_5) {
                var14_14 = this._destination.getAllPubSubOutputHandlers();
                try {
                    var15_15 = var14_14.values().iterator();
                    var16_16 = 0;
                    while (var15_15.hasNext()) {
                        var17_17 = (PubSubOutputHandler)var15_15.next();
                        if (!var17_17.okToForward(var1_1)) continue;
                        if (var9_9.contains(var17_17)) {
                            if (!var11_11) {
                                this.setPropertiesInMessage(var8_8, this._destination.getUuid(), var1_1.getProducerConnectionUuid());
                                this._sourceStreamManager.addMessage(var1_1);
                                var11_11 = true;
                            }
                            var3_3 = var17_17.put(var1_1, var2_2, this, var3_3);
                            if (var4_4) continue;
                            var8_8.setBus(this._messageProcessor.getMessagingEngineBus());
                            if (var17_17.isLink()) {
                                var17_17.sendLinkMessage(var1_1, false);
                                continue;
                            }
                            var18_18 = new MessagingEngine(var17_17.getTargetMEUuid());
                            var13_13[var16_16++] = new CellulePair(var12_12, var18_18);
                            if (!UserTrace.tc_mt.isDebugEnabled()) continue;
                            UserTrace.traceOutboundSend(var8_8, var17_17.getTargetMEUuid(), this._destination.getName());
                            continue;
                        }
                        if (!var4_4) continue;
                        var17_17.putSilence(var1_1);
                    }
                    if (var16_16 <= 0) ** GOTO lbl65
                    this._mpio.sendDownTree(var13_13, 1, var1_1.getPriority(), var8_8);
                }
                finally {
                    this._destination.unlockPubsubOutputHandlers();
                }
            }
        } else if (var1_1.getRequiresNewId() || var8_8.getSystemMessageId() == null) {
            var8_8.setSystemMessageSourceUuid(this._messageProcessor.getMessagingEngineUuid());
            var8_8.setSystemMessageValue(this._messageProcessor.nextTick());
            var1_1.setRequiresNewId(false);
        }
lbl65:
        // 6 sources

        var3_3 = this.deliverToConsumerDispatchers(var6_6, var1_1, var2_2, var3_3);
        if (var10_10 == null) {
            this._searchResultsObjectPool.add(var6_6);
        }
        if (this._stats != null) {
            this._stats.onFanOut(var1_1);
        }
        if (PubSubInputHandler.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)PubSubInputHandler.tc, (String)"localFanOut", (Object)new Boolean(var3_3));
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean restoreFanOut(MessageItemReference messageItemReference, boolean bl) throws SIDiscriminatorSyntaxException, SIResourceException {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreFanOut", (Object)new Object[]{messageItemReference, new Boolean(bl)});
        }
        boolean bl2 = true;
        MessageItem messageItem = (MessageItem)messageItemReference.getReferredItem();
        MessageProcessorSearchResults messageProcessorSearchResults = this.matchMessage(messageItem);
        List list = messageProcessorSearchResults.getPubSubOutputHandlers(string = messageItem.getMessage().getDiscriminator());
        if (list != null && list.size() > 0) {
            HashMap hashMap = this._destination.getAllPubSubOutputHandlers();
            try {
                Iterator iterator = hashMap.values().iterator();
                while (iterator.hasNext()) {
                    PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)iterator.next();
                    if (!pubSubOutputHandler.okToForward(messageItem)) continue;
                    if (list.contains(pubSubOutputHandler)) {
                        pubSubOutputHandler.putInsert(messageItem, bl);
                        continue;
                    }
                    pubSubOutputHandler.putSilence(messageItem);
                }
            }
            finally {
                this._destination.unlockPubsubOutputHandlers();
            }
        } else {
            bl2 = false;
        }
        if (bl2 && !bl) {
            messageItemReference.setSearchResults(messageProcessorSearchResults);
        } else {
            this._searchResultsObjectPool.add(messageProcessorSearchResults);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreFanOut");
        }
        return bl2;
    }

    private boolean deliverToConsumerDispatchers(MessageProcessorSearchResults messageProcessorSearchResults, MessageItem messageItem, Transaction transaction, boolean bl) throws SIDiscriminatorSyntaxException, SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deliverToConsumerDispatchers", (Object)new Object[]{messageItem, transaction, new Boolean(bl)});
        }
        String string = messageItem.getMessage().getDiscriminator();
        Set set = messageProcessorSearchResults.getConsumerDispatchers(string);
        if (UserTrace.tc_mt.isDebugEnabled()) {
            object = null;
            if (messageItem.getMessage() instanceof JsApiMessage) {
                object = ((JsApiMessage)messageItem.getMessage()).getApiMessageId();
            } else if (messageItem.getMessage().getApiMessageIdAsBytes() != null) {
                object = messageItem.getMessage().getApiMessageIdAsBytes().toString();
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("PUBLICATION_COUNT_CWSJU0008", new Object[]{object, this._destination.getName(), new Integer(set.size())}, null));
        }
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                ConsumerDispatcher consumerDispatcher = ((MatchingConsumerDispatcher)((Object)object.next())).getConsumerDispatcher();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found consumerDispatcher: " + consumerDispatcher.getConsumerDispatcherState()));
                }
                if (!consumerDispatcher.getConsumerDispatcherState().isReady()) continue;
                bl = consumerDispatcher.put(messageItem, transaction, this, bl);
            }
            messageItem.setFanOut(set.size());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deliverToConsumerDispatchers", (Object)new Boolean(bl));
        }
        return bl;
    }

    private MessageItemReference addProxyReference(MessageItem messageItem, MessageProcessorSearchResults messageProcessorSearchResults, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addProxyReference", (Object)new Object[]{messageItem, transaction});
        }
        MessageItemReference messageItemReference = new MessageItemReference(messageItem);
        messageItem.addPersistentRef();
        messageItemReference.setSearchResults(messageProcessorSearchResults);
        try {
            messageItemReference.registerMessageEventListener(2, this);
            messageItemReference.registerMessageEventListener(4, this);
            this._proxyReferenceStream.add(messageItemReference, transaction);
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addProxyReference", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.addProxyReference", (String)"1:2249:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2256:1.273.1.1", messageStoreException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addProxyReference", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2266:1.273.1.1", messageStoreException}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addProxyReference");
        }
        return messageItemReference;
    }

    void referenceCountZeroCallback(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"referenceCountZeroCallback", (Object)messageItem);
        }
        LockingCursor lockingCursor = null;
        try {
            lockingCursor = this._itemStream.newLockingItemCursor(null);
            messageItem.lockItemIfAvailable(lockingCursor.getLockID());
            messageItem.remove(this._txManager.createAutoCommitTransaction(), messageItem.getLockID());
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.referenceCountZeroCallback", (String)"1:2293:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"referenceCountZeroCallback", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        finally {
            lockingCursor.finished();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"referenceCountZeroCallback");
        }
    }

    void recordDurableSub(MessageItem messageItem, String string, Transaction transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAckExpectedMessage(long l, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)new Object[]{new Long(l), new Integer(n), reliability, sIBUuid12});
        }
        HashMap hashMap = this._destination.getAllPubSubOutputHandlers();
        try {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)iterator.next();
                pubSubOutputHandler.processAckExpected(l, n, reliability, sIBUuid12);
            }
        }
        finally {
            this._destination.unlockPubsubOutputHandlers();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage");
        }
    }

    public void sendSilenceMessage(long l, long l2, long l3, boolean bl, int n, Reliability reliability, SIBUuid12 sIBUuid12) {
    }

    private ControlSilence createSilenceMessage(long l, long l2, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSilenceMessage", (Object)new Object[]{new Long(l), new Long(l2), new Integer(n), reliability, sIBUuid12});
        }
        ControlSilence controlSilence = null;
        try {
            controlSilence = this._cmf.createNewControlSilence();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.createSilenceMessage", (String)"1:2405:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2411:1.273.1.1", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2421:1.273.1.1", exception}, null), (Throwable)exception);
        }
        controlSilence.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlSilence.setGuaranteedTargetMessagingEngineUUID(null);
        controlSilence.setGuaranteedTargetDestinationDefinitionUUID(this._destination.getUuid());
        controlSilence.setGuaranteedStreamUUID(sIBUuid12);
        controlSilence.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlSilence.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlSilence.setStartTick(l);
        controlSilence.setEndTick(l);
        controlSilence.setPriority(n);
        controlSilence.setReliability(reliability);
        controlSilence.setCompletedPrefix(l2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)controlSilence);
        }
        return controlSilence;
    }

    public List sendValueMessages(List list, long l, boolean bl, int n, Reliability reliability, SIBUuid12 sIBUuid12) {
        return null;
    }

    public MessageItem getValueMessage(long l) {
        return null;
    }

    private ControlAck createControlAckMessage(int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlAck controlAck;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAckMessage");
        }
        try {
            controlAck = this._cmf.createNewControlAck();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.createControlAckMessage", (String)"1:2498:1.273.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2510:1.273.1.1", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2518:1.273.1.1", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlAck.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlAck.setGuaranteedTargetMessagingEngineUUID(null);
        controlAck.setGuaranteedTargetDestinationDefinitionUUID(this._destination.getUuid());
        controlAck.setGuaranteedStreamUUID(sIBUuid12);
        controlAck.setGuaranteedProtocolType(ProtocolType.PUBSUBOUTPUT);
        controlAck.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlAck.setPriority(n);
        controlAck.setReliability(reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage");
        }
        return controlAck;
    }

    private ControlNack createControlNackMessage(int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNackMessage", (Object)new Object[]{new Integer(n), reliability, sIBUuid12});
        }
        ControlNack controlNack = null;
        try {
            controlNack = this._cmf.createNewControlNack();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.createControlNackMessage", (String)"1:2572:1.273.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2584:1.273.1.1", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2592:1.273.1.1", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlNack.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlNack.setGuaranteedTargetMessagingEngineUUID(null);
        controlNack.setGuaranteedTargetDestinationDefinitionUUID(this._destination.getUuid());
        controlNack.setGuaranteedStreamUUID(sIBUuid12);
        controlNack.setGuaranteedProtocolType(ProtocolType.PUBSUBOUTPUT);
        controlNack.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlNack.setPriority(n);
        controlNack.setReliability(reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage");
        }
        return controlNack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverOrderedMessages(List list, GuaranteedTargetStream guaranteedTargetStream, int n, Reliability reliability) throws SIDiscriminatorSyntaxException {
        boolean bl;
        block21: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deliverOrderedMessages", (Object)new Object[]{list, guaranteedTargetStream, new Integer(n), reliability});
            }
            Transaction transaction = this._targetBatchHandler.registerInBatch();
            bl = false;
            try {
                block20: {
                    MessageItem messageItem = null;
                    messageItem = (MessageItem)list.get(list.size() - 1);
                    long l = messageItem.getMessage().getGuaranteedValueEndTick();
                    if (guaranteedTargetStream.getDoubtHorizon() > l) {
                        int n2 = -1;
                        long l2 = -1L;
                        long l3 = -1L;
                        int n3 = 0;
                        while (n3 < list.size()) {
                            boolean bl2 = true;
                            try {
                                messageItem = (MessageItem)list.get(n3);
                                l3 = messageItem.getMessage().getGuaranteedValueEndTick();
                                messageItem.setTransacted(true);
                                MessageProcessorSearchResults messageProcessorSearchResults = messageItem.getSearchResults();
                                this.deliverToConsumerDispatchers(messageProcessorSearchResults, messageItem, transaction, false);
                                n2 = n3++;
                                l2 = l3;
                                bl2 = false;
                            }
                            catch (SIResourceException sIResourceException) {
                                break;
                            }
                            finally {
                                if (bl2) {
                                    guaranteedTargetStream.resetDoubtHorizon(l3);
                                }
                            }
                        }
                        if (n2 != -1) {
                            bl = true;
                            guaranteedTargetStream.setNextCompletedPrefix(l2);
                            try {
                                this._targetBatchHandler.messagesAdded(n2 + 1, guaranteedTargetStream);
                            }
                            catch (SIResourceException sIResourceException) {
                                if (!tc.isEventEnabled()) break block20;
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                            }
                        }
                    }
                }
                Object var20_18 = null;
                if (bl) break block21;
            }
            catch (Throwable throwable) {
                block22: {
                    Object var20_19 = null;
                    if (!bl) {
                        try {
                            this._targetBatchHandler.messagesAdded(0);
                        }
                        catch (SIResourceException sIResourceException) {
                            if (!tc.isEventEnabled()) break block22;
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deliverOrderedMessages", (Object)new Boolean(bl));
                }
                throw throwable;
            }
            try {
                this._targetBatchHandler.messagesAdded(0);
            }
            catch (SIResourceException sIResourceException) {
                if (!tc.isEventEnabled()) break block21;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deliverOrderedMessages", (Object)new Boolean(bl));
        }
    }

    public void deliverExpressMessage(MessageItem messageItem, ExpressTargetStream expressTargetStream) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deliverExpressMessage", (Object)new Object[]{messageItem});
        }
        ExternalLocalTransaction externalLocalTransaction = this._txManager.createLocalTransaction();
        try {
            long l = messageItem.getMessage().getGuaranteedValueValueTick();
            messageItem.setTransacted(true);
            MessageProcessorSearchResults messageProcessorSearchResults = messageItem.getSearchResults();
            boolean bl = this.deliverToConsumerDispatchers(messageProcessorSearchResults, messageItem, externalLocalTransaction, false);
            expressTargetStream.setCompletedPrefix(l);
            if (bl) {
                externalLocalTransaction.commit();
            } else {
                externalLocalTransaction.rollback();
            }
        }
        catch (SIResourceException sIResourceException) {
            this.handleRollback(externalLocalTransaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.deliverExpressMessage", (String)"1:2823:1.273.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)runtimeException);
            }
            throw runtimeException;
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            this.handleRollback(externalLocalTransaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage");
        }
    }

    public NonLockingCursor getBrowseCursor(Filter filter) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)filter);
        }
        try {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor");
            }
            return this._itemStream.newNonLockingItemCursor(filter);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.getBrowseCursor", (String)"1:2867:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2874:1.273.1.1", messageStoreException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2882:1.273.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
    }

    public void storeMessage(MessageItem messageItem, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"storeMessage", (Object)new Object[]{messageItem, transaction});
        }
        try {
            if (transaction == null) {
                transaction = this._txManager.createAutoCommitTransaction();
            }
            this._destination.registerForMessageEvents(messageItem);
            this._itemStream.addItem(messageItem, transaction);
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"storeMessage", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.storeMessage", (String)"1:2919:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2924:1.273.1.1", messageStoreException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"storeMessage", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2932:1.273.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"storeMessage");
        }
    }

    public ItemStream getItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getItemStream", (Object)this._itemStream);
        }
        return this._itemStream;
    }

    public void setStats(TopicspaceInstrumentation topicspaceInstrumentation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStats", (Object)topicspaceInstrumentation);
        }
        super.setStats(topicspaceInstrumentation);
        this._stats = topicspaceInstrumentation;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStats");
        }
    }

    public void setPropertiesInMessage(JsMessage jsMessage, SIBUuid12 sIBUuid12, SIBUuid12 sIBUuid122) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPropertiesInMessage", (Object)new Object[]{jsMessage, sIBUuid12, sIBUuid122});
        }
        jsMessage.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        jsMessage.setGuaranteedTargetMessagingEngineUUID(null);
        jsMessage.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        jsMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        jsMessage.setGuaranteedTargetDestinationDefinitionUUID(sIBUuid12);
        if (jsMessage.getConnectionUuid() == null) {
            jsMessage.setConnectionUuid(sIBUuid122);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setPropertiesInMessage");
        }
    }

    public void reconstitutePubSubSourceStreams(StreamSet streamSet, int n) throws SIErrorException, SIDiscriminatorSyntaxException, SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)new Object[]{streamSet, new Integer(n)});
        }
        this._sourceStreamManager.reconstituteStreamSet(streamSet);
        if ((n & 1) == 1 && (n & 2) == 0) {
            this.sendFlushedMessage(null, streamSet.getStreamID());
            streamSet.setStreamID(new SIBUuid12());
            object = this._txManager.createAutoCommitTransaction();
            try {
                streamSet.requestUpdate((Transaction)object);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.reconstitutePubSubSourceStreams", (String)"1:3042:1.273.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)"SIStoreException");
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
        }
        try {
            object = this._proxyReferenceStream.newNonLockingCursor(new ClassEqualsFilter(MessageItemReference.class));
            object.allowUnavailableItems();
            MessageItemReference messageItemReference = (MessageItemReference)object.next();
            ExternalLocalTransaction externalLocalTransaction = this._txManager.createLocalTransaction();
            while (messageItemReference != null) {
                boolean bl = false;
                if (messageItemReference.getGuaranteedStreamUuid() != streamSet.getStreamID()) {
                    messageItemReference.setGuaranteedStreamUuid(streamSet.getStreamID());
                }
                if (!messageItemReference.isAdding() && !messageItemReference.isRemoving()) {
                    bl = true;
                }
                if (!(this.restoreFanOut(messageItemReference, bl) || messageItemReference.isAdding() || messageItemReference.isRemoving())) {
                    messageItemReference.remove(externalLocalTransaction, messageItemReference.getLockID());
                }
                messageItemReference = (MessageItemReference)object.next();
            }
            try {
                externalLocalTransaction.commit();
            }
            catch (SIIncorrectCallException sIIncorrectCallException) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)sIIncorrectCallException);
            }
            object.finished();
            object = this._proxyReferenceStream.newNonLockingCursor(new ClassEqualsFilter(MessageItemReference.class));
            object.allowUnavailableItems();
            messageItemReference = (MessageItemReference)object.next();
            while (messageItemReference != null) {
                if (messageItemReference.getGuaranteedStreamUuid() != streamSet.getStreamID()) {
                    messageItemReference.setGuaranteedStreamUuid(streamSet.getStreamID());
                }
                if (!messageItemReference.isAdding() && !messageItemReference.isRemoving()) {
                    this._sourceStreamManager.restoreMessage(messageItemReference, true);
                } else {
                    this._sourceStreamManager.restoreMessage(messageItemReference, false);
                }
                messageItemReference = (MessageItemReference)object.next();
            }
            this._sourceStreamManager.consolidateStreams(n);
            object.finished();
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.reconstitutePubSubSourceStreams", (String)"1:3142:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3149:1.273.1.1", messageStoreException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3160:1.273.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushedMessage", (Object)new Object[]{sIBUuid12});
        }
        HashMap hashMap = this._destination.getAllPubSubOutputHandlers();
        try {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)iterator.next();
                pubSubOutputHandler.sendFlushedMessage(null, sIBUuid12);
                pubSubOutputHandler.removeStream(sIBUuid12);
            }
        }
        finally {
            this._destination.unlockPubsubOutputHandlers();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushedMessage");
        }
    }

    public void sendNotFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushedMessage", (Object)new Object[]{cellule, sIBUuid12, new Long(l)});
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3231:1.273.1.1"}, null));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3237:1.273.1.1"});
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.sendNotFlushedMessage", (String)"1:3243:1.273.1.1", (Object)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushedMessage");
        }
    }

    public void sendAreYouFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, SIBUuid12 sIBUuid122) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)new Object[]{cellule, new Long(l), sIBUuid122});
        }
        ControlAreYouFlushed controlAreYouFlushed = this.createControlAreYouFlushed(cellule, l, sIBUuid122);
        this._mpio.sendUpTree(this._localCellule, cellule, null, 9, (ControlMessage)controlAreYouFlushed);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushedMessage");
        }
    }

    public void sendRequestFlushMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, SIBUuid12 sIBUuid122, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)new Object[]{cellule, new Long(l), sIBUuid122});
        }
        ControlRequestFlush controlRequestFlush = this.createControlRequestFlush(cellule, l, sIBUuid122);
        controlRequestFlush.setIndoubtDiscard(bl);
        this._mpio.sendUpTree(this._localCellule, cellule, null, 9, (ControlMessage)controlRequestFlush);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlushMessage");
        }
    }

    public void startFlush(FlushComplete flushComplete) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException, FlushAlreadyInProgressException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startFlush", (Object)flushComplete);
        }
        this._sourceStreamManager.startFlush(flushComplete);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startFlush");
        }
    }

    private void traceSend(MessageItem messageItem) {
        if (UserTrace.tc_mt.isDebugEnabled()) {
            String string = null;
            String string2 = null;
            if (messageItem.getMessage() instanceof JsApiMessage) {
                string = ((JsApiMessage)messageItem.getMessage()).getApiMessageId();
                string2 = ((JsApiMessage)messageItem.getMessage()).getCorrelationId();
            } else {
                if (messageItem.getMessage().getApiMessageIdAsBytes() != null) {
                    string = new String(messageItem.getMessage().getApiMessageIdAsBytes());
                }
                if (messageItem.getMessage().getCorrelationIdAsBytes() != null) {
                    string2 = new String(messageItem.getMessage().getCorrelationIdAsBytes());
                }
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("PRODUCER_SEND_TOPICSPACE_CWSJU0005", new Object[]{string, string2, this._destination.getName()}, null));
        }
    }

    private void eventPostCommit(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommit", (Object)sIMPMessage);
        }
        MessageItem messageItem = (MessageItem)sIMPMessage;
        JsMessage jsMessage = messageItem.getMessage();
        MessageProcessorSearchResults messageProcessorSearchResults = messageItem.getSearchResults();
        boolean bl = false;
        List list = messageProcessorSearchResults.getPubSubOutputHandlers(null);
        MessagingEngine messagingEngine = this._messageProcessor.getMECellule();
        CellulePair[] cellulePairArray = new CellulePair[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)iterator.next();
            if (!pubSubOutputHandler.okToForward(messageItem)) continue;
            if (UserTrace.tc_mt.isDebugEnabled()) {
                UserTrace.traceOutboundSend(jsMessage, pubSubOutputHandler.getTargetMEUuid(), this._destination.getName());
            }
            if (!bl) {
                this.setPropertiesInMessage(jsMessage, this._destination.getUuid(), sIMPMessage.getProducerConnectionUuid());
                jsMessage.setBus(this._messageProcessor.getMessagingEngineBus());
                this._sourceStreamManager.addMessage(sIMPMessage);
                bl = true;
            }
            pubSubOutputHandler.put(sIMPMessage, null, null, false);
            if (pubSubOutputHandler.isLink()) {
                pubSubOutputHandler.sendLinkMessage(messageItem, false);
                continue;
            }
            MessagingEngine messagingEngine2 = new MessagingEngine(pubSubOutputHandler.getTargetMEUuid());
            cellulePairArray[n++] = new CellulePair(messagingEngine, messagingEngine2);
        }
        if (n > 0) {
            this._mpio.sendDownTree(cellulePairArray, 1, messageItem.getPriority(), jsMessage);
        }
        messageItem.setSearchResults(null);
        this._searchResultsObjectPool.add(messageProcessorSearchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDeleteSource() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDeleteSource");
        }
        PubSubInputHandler pubSubInputHandler = this;
        synchronized (pubSubInputHandler) {
            if (this._flushedForDeleteSource) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)Boolean.TRUE);
                }
                return true;
            }
            if (this._deleteFlushSource != null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)Boolean.FALSE);
                }
                return false;
            }
            final PubSubInputHandler pubSubInputHandler2 = this;
            this._deleteFlushSource = new FlushComplete(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void flushComplete(DestinationHandler destinationHandler) {
                    PubSubInputHandler pubSubInputHandler = pubSubInputHandler2;
                    synchronized (pubSubInputHandler) {
                        pubSubInputHandler2._flushedForDeleteSource = true;
                        pubSubInputHandler2._deleteFlushSource = null;
                    }
                    ((BaseDestinationHandler)pubSubInputHandler2._destination).deleteAllPubSubOutputHandlers();
                    pubSubInputHandler2._messageProcessor.getDestinationManager().startAsynchDeletion();
                }
            };
        }
        try {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)("Started source flush for destination: " + this._destination.getName()));
            }
            this.startFlush(this._deleteFlushSource);
        }
        catch (FlushAlreadyInProgressException flushAlreadyInProgressException) {
            FFDCFilter.processException((Throwable)flushAlreadyInProgressException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.flushAllForDeleteSource", (String)"1:3524:1.273.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)flushAlreadyInProgressException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)"FlushAlreadyInProgressException");
            }
            throw new SIResourceException((Throwable)flushAlreadyInProgressException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDeleteTarget() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDeleteTarget");
        }
        PubSubInputHandler pubSubInputHandler = this;
        synchronized (pubSubInputHandler) {
            if (this._flushedForDeleteTarget) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.TRUE);
                }
                return true;
            }
            if (this._deleteFlushTarget != null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.FALSE);
                }
                return false;
            }
            if (this._targetStreamManager.isEmpty()) {
                this._flushedForDeleteTarget = true;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.TRUE);
                }
                return true;
            }
            this._deleteFlushTarget = new AlarmListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void alarm(Object object) {
                    block10: {
                        if (tc.isEntryEnabled()) {
                            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
                        }
                        PubSubInputHandler pubSubInputHandler = (PubSubInputHandler)object;
                        if (pubSubInputHandler._targetStreamManager.isEmpty()) {
                            PubSubInputHandler pubSubInputHandler2 = pubSubInputHandler;
                            synchronized (pubSubInputHandler2) {
                                pubSubInputHandler._flushedForDeleteTarget = true;
                                pubSubInputHandler._deleteFlushTarget = null;
                            }
                            pubSubInputHandler._messageProcessor.getDestinationManager().startAsynchDeletion();
                        } else {
                            try {
                                pubSubInputHandler._targetStreamManager.queryUnflushedStreams();
                                if (tc.isEventEnabled()) {
                                    SibTr.event((TraceComponent)tc, (String)("Querying target for flush on destination: " + PubSubInputHandler.this._destination.getName()));
                                }
                                pubSubInputHandler._messageProcessor.getAlarmManager().create(3000L, this, pubSubInputHandler);
                            }
                            catch (SIResourceException sIResourceException) {
                                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.alarm", (String)"1:3621:1.273.1.1", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                                if (!tc.isEventEnabled()) break block10;
                                SibTr.event((TraceComponent)tc, (String)"Target flushed cancelled by SIResourceException");
                            }
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"alarm");
                    }
                }
            };
            this._targetStreamManager.queryUnflushedStreams();
            this._messageProcessor.getAlarmManager().create(3000L, this._deleteFlushTarget, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.FALSE);
        }
        return false;
    }

    public boolean isDestinationFull(JsDestinationAddress jsDestinationAddress) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDestinationFull", (Object)jsDestinationAddress);
        }
        boolean bl = this._itemStream.isRemoteQueueHighLimit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDestinationFull", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isDestinationNotFull() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDestinationNotFull");
        }
        boolean bl = this._itemStream.isQLowRemoteLimit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDestinationNotFull", (Object)new Boolean(bl));
        }
        return bl;
    }

    boolean isPostMediated() {
        return true;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/PubSubInputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.273.1.1");
        }
    }
}

