/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.SourceStreamManager;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.FlushAlreadyInProgressException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.Reallocator;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SourceMediatedProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetMediatedProtocolItemStream;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PtoPOutputHandler
implements OutputHandler,
ControlHandler,
DownstreamControl,
MessageEventListener,
Reallocator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)PtoPOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private BatchHandler sourceBatchHandler;
    private ControlMessageFactory cmf;
    private boolean isForMediation = false;
    private Cellule targetCellule;
    private Cellule routingCellule;
    private SIBUuid8 unknownUuid = new SIBUuid8("0000000000000001");
    private SourceStreamManager sourceStreamManager;
    private PtoPMessageItemStream transmissionItemStream;
    JsDestinationAddress routingDestination = null;
    boolean isSystemOrTemp = false;
    private DestinationHandler destinationHandler;
    private boolean isLink = false;
    private String linkName = null;
    private boolean linkSetOutboundUserId = false;
    private String linkOutboundUserid = null;
    private SIBUuid12 destinationUuid;
    private MessageProcessor messageProcessor;
    private boolean isGuess = false;
    private MPIO mpio;
    private long lockID = 0L;
    protected boolean flushedForDeleteSource = false;
    protected FlushComplete deleteFlushSource = null;

    PtoPOutputHandler(DestinationHandler destinationHandler, MessageProcessor messageProcessor, ProtocolItemStream protocolItemStream, Cellule cellule, PtoPMessageItemStream ptoPMessageItemStream) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PtoPOutputHandler", (Object)new Object[]{destinationHandler, messageProcessor, protocolItemStream, cellule, ptoPMessageItemStream});
        }
        try {
            this.lockID = messageProcessor.getMessageStore().getUniqueLockID(1);
        }
        catch (PersistenceException persistenceException) {
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)persistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"PtoPOutputHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)persistenceException));
        }
        this.sourceStreamManager = new SourceStreamManager(messageProcessor, this, destinationHandler, protocolItemStream, cellule, this);
        this.destinationHandler = destinationHandler;
        if (destinationHandler.isLink() && !destinationHandler.isMQLink()) {
            String string;
            this.isLink = true;
            this.linkName = destinationHandler.getName();
            this.linkOutboundUserid = ((LinkHandler)destinationHandler).getOutboundUserid();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("outbound userid: " + this.linkOutboundUserid));
            }
            if ((string = ((LinkHandler)destinationHandler).getType()).equals("SIBVirtualGatewayLink")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"SIBLink type, set null routing cell");
                }
                this.routingCellule = null;
                if (this.linkOutboundUserid != null) {
                    this.linkSetOutboundUserId = true;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Set outbound userid flag");
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MQLink type, set routingCell: " + cellule));
                }
                this.routingCellule = cellule;
            }
        } else {
            this.routingCellule = cellule;
        }
        this.destinationUuid = destinationHandler.getUuid();
        this.messageProcessor = messageProcessor;
        this.targetCellule = cellule;
        this.transmissionItemStream = ptoPMessageItemStream;
        if (protocolItemStream instanceof SourceMediatedProtocolItemStream || protocolItemStream instanceof TargetMediatedProtocolItemStream) {
            this.isForMediation = true;
        }
        this.mpio = messageProcessor.getMPIO();
        this.sourceBatchHandler = messageProcessor.getSourceBatchHandler();
        this.cmf = MessageProcessor.getControlMessageFactory();
        if (destinationHandler.isSystem() || destinationHandler.isTemporary()) {
            this.routingDestination = SIMPUtils.createJsDestinationAddress(destinationHandler.getName(), null);
            this.isSystemOrTemp = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PtoPOutputHandler", (Object)this);
        }
    }

    public void startFlush(FlushComplete flushComplete) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException, FlushAlreadyInProgressException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startFlush");
        }
        this.sourceStreamManager.startFlush(flushComplete);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startFlush");
        }
    }

    public boolean put(SIMPMessage sIMPMessage, Transaction transaction, InputHandlerStore inputHandlerStore, boolean bl) throws SIResourceException {
        block23: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{sIMPMessage, transaction, inputHandlerStore, new Boolean(bl)});
            }
            JsMessage jsMessage = sIMPMessage.getMessage();
            jsMessage.setGuaranteedSourceMessagingEngineUUID(this.messageProcessor.getMessagingEngineUuid());
            jsMessage.setGuaranteedTargetMessagingEngineUUID(this.transmissionItemStream.getMessagingEngineUuid());
            jsMessage.setGuaranteedTargetDestinationDefinitionUUID(this.destinationUuid);
            jsMessage.setGuaranteedProtocolType(ProtocolType.UNICASTINPUT);
            jsMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
            try {
                boolean bl2 = this.sourceStreamManager.addMessage(sIMPMessage);
                if (!bl2) {
                    if (this.isLink) {
                        jsMessage = this.addLinkProps(jsMessage);
                    }
                    if (!sIMPMessage.isTransacted()) {
                        if (UserTrace.tc_mt.isDebugEnabled()) {
                            UserTrace.traceOutboundSend(jsMessage, ((MessagingEngine)this.targetCellule).getUuid(), this.destinationHandler.getName());
                        }
                        this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, sIMPMessage.getPriority(), jsMessage);
                    } else {
                        sIMPMessage.registerMessageEventListener(9, this);
                    }
                    break block23;
                }
                ExternalLocalTransaction externalLocalTransaction = null;
                if (!sIMPMessage.isTransacted()) {
                    externalLocalTransaction = this.messageProcessor.getTXManager().createLocalTransaction();
                    transaction = externalLocalTransaction;
                }
                try {
                    this.transmissionItemStream.addItem((MessageItem)sIMPMessage, transaction);
                }
                catch (OutOfCacheSpace outOfCacheSpace) {
                    this.sourceStreamManager.removeMessage(sIMPMessage);
                    throw outOfCacheSpace;
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.put", (String)"1:583:1.187.1.1", (Object)this);
                    this.sourceStreamManager.removeMessage(sIMPMessage);
                    throw messageStoreException;
                }
                this.registerForEvents(sIMPMessage);
                if (externalLocalTransaction == null) break block23;
                try {
                    externalLocalTransaction.commit();
                }
                catch (SIConnectionLostException sIConnectionLostException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)sIConnectionLostException);
                }
                catch (SIIncorrectCallException sIIncorrectCallException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)sIIncorrectCallException);
                }
                catch (SIErrorException sIErrorException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)sIErrorException);
                }
            }
            catch (OutOfCacheSpace outOfCacheSpace) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)((Object)outOfCacheSpace));
                }
                throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.put", (String)"1:633:1.187.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)((Object)messageStoreException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:643:1.187.1.1", messageStoreException});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:649:1.187.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void registerForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)sIMPMessage);
        }
        sIMPMessage.registerMessageEventListener(2, this);
        sIMPMessage.registerMessageEventListener(4, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) != ControlMessageType.REQUESTFLUSH) {
            if (controlMessageType == ControlMessageType.AREYOUFLUSHED) {
                this.sourceStreamManager.processFlushQuery((ControlAreYouFlushed)controlMessage);
            } else if (controlMessageType == ControlMessageType.ACK) {
                this.processAck((ControlAck)controlMessage);
            } else if (controlMessageType == ControlMessageType.NACK) {
                this.sourceStreamManager.processNack((ControlNack)controlMessage);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    private JsMessage addLinkProps(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps");
        }
        jsMessage.setGuaranteedCrossBusLinkName(this.linkName);
        jsMessage.setGuaranteedCrossBusSourceBusUUID(this.messageProcessor.getMessagingEngineBusUuid());
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Test whether outbound userid should be set in message");
        }
        if (this.linkSetOutboundUserId && !this.messageProcessor.getAuthorisationUtils().sentBySIBServer(jsMessage)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Set outbound userid: " + this.linkOutboundUserid + ", in message"));
            }
            this.messageProcessor.getAccessChecker().setSecurityIDInMessage(this.linkOutboundUserid, jsMessage);
            jsMessage.setApiUserId(this.linkOutboundUserid);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return jsMessage;
    }

    private ControlMessage addLinkProps(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps");
        }
        controlMessage.setGuaranteedCrossBusLinkName(this.linkName);
        controlMessage.setGuaranteedCrossBusSourceBusUUID(this.messageProcessor.getMessagingEngineBusUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return controlMessage;
    }

    public void sendAckExpectedMessage(long l, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)new Object[]{new Long(l), new Integer(n), reliability});
        }
        if (this.routingCellule != null) {
            ControlAckExpected controlAckExpected;
            try {
                controlAckExpected = this.cmf.createNewControlAckExpected();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.sendAckExpectedMessage", (String)"1:810:1.187.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)exception);
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:821:1.187.1.1", exception});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:829:1.187.1.1", exception}, null), (Throwable)exception);
            }
            controlAckExpected.setGuaranteedSourceMessagingEngineUUID(this.messageProcessor.getMessagingEngineUuid());
            controlAckExpected.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)this.targetCellule).getUuid());
            controlAckExpected.setGuaranteedTargetDestinationDefinitionUUID(this.destinationUuid);
            controlAckExpected.setGuaranteedStreamUUID(sIBUuid12);
            controlAckExpected.setGuaranteedProtocolType(ProtocolType.UNICASTINPUT);
            controlAckExpected.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
            controlAckExpected.setTick(l);
            controlAckExpected.setPriority(n);
            controlAckExpected.setReliability(reliability);
            if (this.isLink) {
                controlAckExpected = (ControlAckExpected)this.addLinkProps((ControlMessage)controlAckExpected);
            }
            if (this.isForMediation) {
                controlAckExpected.setMediated(false);
            }
            if (this.isSystemOrTemp) {
                controlAckExpected.setRoutingDestination(this.routingDestination);
            }
            this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n, (ControlMessage)controlAckExpected);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unable to send AckExpected as Link not started");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage");
        }
    }

    public void sendSilenceMessage(long l, long l2, long l3, boolean bl, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlSilence controlSilence;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSilenceMessage");
        }
        try {
            controlSilence = this.cmf.createNewControlSilence();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.sendSilenceMessage", (String)"1:911:1.187.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:918:1.187.1.1", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage", (Object)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:929:1.187.1.1", exception}, null), (Throwable)exception);
        }
        controlSilence.setGuaranteedSourceMessagingEngineUUID(this.messageProcessor.getMessagingEngineUuid());
        controlSilence.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)this.targetCellule).getUuid());
        controlSilence.setGuaranteedTargetDestinationDefinitionUUID(this.destinationUuid);
        controlSilence.setGuaranteedStreamUUID(sIBUuid12);
        controlSilence.setGuaranteedProtocolType(ProtocolType.UNICASTINPUT);
        controlSilence.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlSilence.setStartTick(l);
        controlSilence.setEndTick(l2);
        controlSilence.setPriority(n);
        controlSilence.setReliability(reliability);
        controlSilence.setCompletedPrefix(l3);
        if (this.isLink) {
            controlSilence = (ControlSilence)this.addLinkProps((ControlMessage)controlSilence);
        }
        if (this.isForMediation) {
            controlSilence.setMediated(false);
        }
        if (this.isSystemOrTemp) {
            controlSilence.setRoutingDestination(this.routingDestination);
        }
        if (bl) {
            this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n + 1, (ControlMessage)controlSilence);
        } else {
            this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n, (ControlMessage)controlSilence);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage");
        }
    }

    public MessageItem getValueMessage(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getValueMessage", (Object)new Long(l));
        }
        MessageItem messageItem = null;
        messageItem = (MessageItem)this.transmissionItemStream.findById(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getValueMessage", (Object)messageItem);
        }
        return messageItem;
    }

    public List sendValueMessages(List list, long l, boolean bl, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendValueMessages", (Object)new Object[]{list, new Long(l), this.targetCellule});
        }
        JsMessage jsMessage = null;
        TickRange tickRange = null;
        MessageItem messageItem = null;
        long l2 = -1L;
        ArrayList<TickRange> arrayList = null;
        for (int i = 0; i < list.size(); ++i) {
            tickRange = (TickRange)list.get(i);
            l2 = tickRange.itemStreamIndex;
            messageItem = this.getValueMessage(l2);
            boolean bl2 = false;
            if (messageItem == null) {
                bl2 = true;
            } else if (!messageItem.lockItemIfAvailable(this.lockID) && !messageItem.isLocked()) {
                bl2 = true;
            }
            if (bl2) {
                if (arrayList == null) {
                    arrayList = new ArrayList<TickRange>();
                }
                arrayList.add(tickRange);
                ControlSilence controlSilence = this.createSilenceMessage(tickRange.valuestamp, l, n, reliability, sIBUuid12);
                if (this.isLink) {
                    controlSilence = this.addLinkProps((ControlMessage)controlSilence);
                }
                if (this.isSystemOrTemp) {
                    controlSilence.setRoutingDestination(this.routingDestination);
                }
                if (bl) {
                    this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n + 1, (ControlMessage)controlSilence);
                    continue;
                }
                this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n, (ControlMessage)controlSilence);
                continue;
            }
            jsMessage = messageItem.getMessage();
            if (jsMessage.getGuaranteedStreamUUID() != sIBUuid12) {
                jsMessage.setGuaranteedStreamUUID(sIBUuid12);
            }
            if (jsMessage.getGuaranteedTargetMessagingEngineUUID().equals((Object)this.unknownUuid)) {
                jsMessage.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)this.targetCellule).getUuid());
            }
            if (tickRange.endstamp > tickRange.valuestamp) {
                jsMessage.setGuaranteedValueEndTick(tickRange.endstamp);
            }
            jsMessage.setGuaranteedValueCompletedPrefix(l);
            long l3 = messageItem.updateStatisticsMessageWaitTime();
            jsMessage.setMessageWaitTime(l3);
            if (this.isLink) {
                jsMessage = this.addLinkProps(jsMessage);
            }
            if (this.isSystemOrTemp) {
                jsMessage.setRoutingDestination(this.routingDestination);
            }
            if (UserTrace.tc_mt.isDebugEnabled()) {
                UserTrace.traceOutboundSend(jsMessage, ((MessagingEngine)this.targetCellule).getUuid(), this.destinationHandler.getName());
            }
            if (bl) {
                this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n + 1, jsMessage);
                continue;
            }
            this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, n, jsMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendValueMessages", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void processAck(ControlAck var1_1) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (PtoPOutputHandler.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)PtoPOutputHandler.tc, (String)"processAck", (Object)new Object[]{var1_1});
        }
        var2_2 = this.sourceStreamManager.processAck(var1_1);
        var3_3 = 0L;
        var5_4 = null;
        if (var2_2 != null) {
            var6_5 = this.sourceBatchHandler.registerInBatch();
            var7_6 = false;
            try {
                var8_7 = this.sourceStreamManager.getBatchListener(var1_1);
                var9_8 = null;
                for (var10_9 = 0; var10_9 < var2_2.size(); ++var10_9) {
                    var9_8 = (TickRange)var2_2.get(var10_9);
                    var8_7.addToBatchList(var9_8);
                    var3_3 = var9_8.itemStreamIndex;
                    try {
                        var5_4 = (MessageItem)this.transmissionItemStream.findById(var3_3);
                        if (var5_4 == null) continue;
                        var5_4.remove(var6_5, var5_4.getLockID());
                        continue;
                    }
                    catch (MessageStoreException var11_10) {
                        FFDCFilter.processException((Throwable)var11_10, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.processAck", (String)"1:1187:1.187.1.1", (Object)this);
                        SibTr.exception((TraceComponent)PtoPOutputHandler.tc, (Exception)var11_10);
                        SibTr.error((TraceComponent)PtoPOutputHandler.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1194:1.187.1.1", var11_10});
                        if (PtoPOutputHandler.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)PtoPOutputHandler.tc, (String)"processAck", (Object)var11_10);
                        }
                        throw new SIResourceException(PtoPOutputHandler.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1205:1.187.1.1", var11_10}, null), (Throwable)var11_10);
                    }
                }
                var7_6 = true;
                this.sourceBatchHandler.messagesAdded(var2_2.size(), var8_7);
                var13_11 = null;
                ** if (var7_6) goto lbl-1000
            }
            catch (Throwable var12_15) {
                block15: {
                    var13_12 = null;
                    if (!var7_6) {
                        try {
                            this.sourceBatchHandler.messagesAdded(0);
                        }
                        catch (SIResourceException var14_14) {
                            if (!PtoPOutputHandler.tc.isEventEnabled()) break block15;
                            SibTr.exception((TraceComponent)PtoPOutputHandler.tc, (Exception)var14_14);
                        }
                    }
                }
                throw var12_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.sourceBatchHandler.messagesAdded(0);
                }
                catch (SIResourceException var14_13) {
                    if (PtoPOutputHandler.tc.isEventEnabled()) {
                        SibTr.exception((TraceComponent)PtoPOutputHandler.tc, (Exception)var14_13);
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
            }
        }
        this.sourceStreamManager.attemptFlushIfNecessary();
        if (PtoPOutputHandler.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)PtoPOutputHandler.tc, (String)"processAck");
        }
    }

    public void messageEventOccurred(int n, SIMPMessage sIMPMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(n), sIMPMessage, transaction});
        }
        if (n == 9) {
            this.eventPostCommit(sIMPMessage);
        } else if (n == 2) {
            this.eventPostAdd(sIMPMessage, transaction, false);
        } else if (n == 4) {
            this.eventPostAdd(sIMPMessage, transaction, true);
        } else {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1271:1.187.1.1"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.messageEventOccurred", (String)"1:1277:1.187.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1284:1.187.1.1"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    private ControlSilence createSilenceMessage(long l, long l2, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSilenceMessage", (Object)new Object[]{new Long(l), new Long(l2), new Integer(n), reliability, sIBUuid12});
        }
        ControlSilence controlSilence = null;
        try {
            controlSilence = this.cmf.createNewControlSilence();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.createSilenceMessage", (String)"1:1323:1.187.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1329:1.187.1.1", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1340:1.187.1.1", exception}, null), (Throwable)exception);
        }
        controlSilence.setGuaranteedSourceMessagingEngineUUID(this.messageProcessor.getMessagingEngineUuid());
        controlSilence.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)this.targetCellule).getUuid());
        controlSilence.setGuaranteedTargetDestinationDefinitionUUID(this.destinationUuid);
        controlSilence.setGuaranteedStreamUUID(sIBUuid12);
        controlSilence.setGuaranteedProtocolType(ProtocolType.UNICASTINPUT);
        controlSilence.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlSilence.setStartTick(l);
        controlSilence.setEndTick(l);
        controlSilence.setPriority(n);
        controlSilence.setReliability(reliability);
        controlSilence.setCompletedPrefix(l2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)controlSilence);
        }
        return controlSilence;
    }

    private void eventPostAdd(SIMPMessage sIMPMessage, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostAdd", (Object)new Object[]{sIMPMessage, transaction, new Boolean(bl)});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        boolean bl2 = false;
        bl2 = bl ? this.rollbackInsert((MessageItem)sIMPMessage) : this.commitInsert((MessageItem)sIMPMessage);
        if (this.isReallocationRequired(sIMPMessage)) {
            this.reallocateMsgs(this.destinationHandler, false, false);
            bl2 = false;
        }
        if (bl2 && !bl && !sIMPMessage.lockItemIfAvailable(this.lockID)) {
            this.sourceStreamManager.removeMessage(sIMPMessage);
            bl = true;
        }
        if (bl2) {
            if (bl) {
                ControlSilence controlSilence = this.createSilenceMessage(jsMessage.getGuaranteedValueValueTick(), jsMessage.getGuaranteedValueCompletedPrefix(), sIMPMessage.getPriority(), sIMPMessage.getReliability(), sIMPMessage.getMessage().getGuaranteedStreamUUID());
                if (this.isLink) {
                    controlSilence = this.addLinkProps((ControlMessage)controlSilence);
                }
                this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, (int)controlSilence.getPriority(), (ControlMessage)controlSilence);
            } else {
                if (this.isLink) {
                    jsMessage = this.addLinkProps(jsMessage);
                }
                long l = sIMPMessage.updateStatisticsMessageWaitTime();
                jsMessage.setMessageWaitTime(l);
                if (UserTrace.tc_mt.isDebugEnabled()) {
                    UserTrace.traceOutboundSend(jsMessage, ((MessagingEngine)this.targetCellule).getUuid(), this.destinationHandler.getName());
                }
                this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, (int)jsMessage.getPriority(), jsMessage);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostAdd");
        }
    }

    private void eventPostCommit(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommit", (Object)sIMPMessage);
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        if (UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.traceOutboundSend(jsMessage, ((MessagingEngine)this.targetCellule).getUuid(), this.destinationHandler.getName());
        }
        this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, sIMPMessage.getPriority(), jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommit");
        }
    }

    public String toString() {
        return "PtoPOutputHandler: " + this.destinationHandler.getName() + " on " + this.transmissionItemStream.getMessagingEngineUuid().toString();
    }

    public SIBUuid8 getTargetMEUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTargetMEUuid", (Object)this.transmissionItemStream.getMessagingEngineUuid());
        }
        return this.transmissionItemStream.getMessagingEngineUuid();
    }

    public boolean commitInsert(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInsert", (Object)messageItem);
        }
        boolean bl = this.updateSourceStream(messageItem, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInsert", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean rollbackInsert(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackInsert", (Object)messageItem);
        }
        boolean bl = this.updateSourceStream(messageItem, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackInsert", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected void handleRollback(ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)externalLocalTransaction);
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.rollback();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.handleRollback", (String)"1:1569:1.187.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    public boolean isReallocationRequired(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReallocationRequired", (Object)sIMPMessage);
        }
        boolean bl = false;
        bl = this.sourceStreamManager.isReallocationRequired(sIMPMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired");
        }
        return bl;
    }

    public boolean updateSourceStream(MessageItem messageItem, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateSourceStream", (Object)new Object[]{messageItem, new Boolean(bl)});
        }
        boolean bl2 = true;
        bl2 = this.sourceStreamManager.updateSourceStream(messageItem, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateSourceStream");
        }
        return bl2;
    }

    private ControlFlushed createControlFlushed(SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlFlushed controlFlushed;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlFlushed", (Object)new Object[]{sIBUuid12});
        }
        try {
            controlFlushed = this.cmf.createNewControlFlushed();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.createControlFlushed", (String)"1:1655:1.187.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlFlushed", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1667:1.187.1.1", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1675:1.187.1.1", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlFlushed.setGuaranteedSourceMessagingEngineUUID(this.messageProcessor.getMessagingEngineUuid());
        controlFlushed.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)this.targetCellule).getUuid());
        controlFlushed.setGuaranteedTargetDestinationDefinitionUUID(this.destinationUuid);
        controlFlushed.setGuaranteedStreamUUID(sIBUuid12);
        controlFlushed.setGuaranteedProtocolType(ProtocolType.UNICASTINPUT);
        controlFlushed.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlFlushed.setPriority(11);
        controlFlushed.setReliability(Reliability.ASSURED_PERSISTENT);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlFlushed");
        }
        return controlFlushed;
    }

    private ControlNotFlushed createControlNotFlushed(SIBUuid12 sIBUuid12, long l) throws SIResourceException {
        ControlNotFlushed controlNotFlushed;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNotFlushed", (Object)new Object[]{sIBUuid12, new Long(l)});
        }
        try {
            controlNotFlushed = this.cmf.createNewControlNotFlushed();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.createControlNotFlushed", (String)"1:1726:1.187.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1738:1.187.1.1", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1746:1.187.1.1", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlNotFlushed.setGuaranteedSourceMessagingEngineUUID(this.messageProcessor.getMessagingEngineUuid());
        controlNotFlushed.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)this.targetCellule).getUuid());
        controlNotFlushed.setGuaranteedTargetDestinationDefinitionUUID(this.destinationUuid);
        controlNotFlushed.setGuaranteedStreamUUID(sIBUuid12);
        controlNotFlushed.setGuaranteedProtocolType(ProtocolType.UNICASTINPUT);
        controlNotFlushed.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlNotFlushed.setPriority(11);
        controlNotFlushed.setReliability(Reliability.ASSURED_PERSISTENT);
        controlNotFlushed.setRequestID(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed");
        }
        return controlNotFlushed;
    }

    public void reconstitutePtoPSourceStreams(StreamSet streamSet, int n) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams", (Object)new Object[]{streamSet, new Integer(n)});
        }
        this.sourceStreamManager.reconstituteStreamSet(streamSet);
        if ((n & 1) == 1 && (n & 2) == 0) {
            this.sendFlushedMessage(null, streamSet.getStreamID());
            streamSet.setStreamID(new SIBUuid12());
            object = this.messageProcessor.getTXManager().createAutoCommitTransaction();
            try {
                streamSet.requestUpdate((Transaction)object);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.reconstitutePtoPSourceStreams", (String)"1:1804:1.187.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams", (Object)"SIStoreException");
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
        }
        object = null;
        try {
            object = this.transmissionItemStream.newNonLockingItemCursor(new ClassEqualsFilter(MessageItem.class));
            object.allowUnavailableItems();
            MessageItem messageItem = (MessageItem)object.next();
            while (messageItem != null) {
                if (messageItem.getGuaranteedStreamUuid() != streamSet.getStreamID()) {
                    messageItem.setGuaranteedStreamUuid(streamSet.getStreamID());
                }
                if (!messageItem.isAdding() && !messageItem.isRemoving()) {
                    this.sourceStreamManager.restoreMessage(messageItem, true);
                } else {
                    this.sourceStreamManager.restoreMessage(messageItem, false);
                }
                messageItem = (MessageItem)object.next();
            }
            List list = this.sourceStreamManager.consolidateStreams(n);
            long l = 0L;
            MessageItem messageItem2 = null;
            for (int i = 0; i < list.size(); ++i) {
                l = (Long)list.get(i);
                messageItem2 = (MessageItem)this.transmissionItemStream.findById(l);
                if (messageItem2 != null) {
                    messageItem2.lockItemIfAvailable(this.lockID);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"message wasn't there when we tried to lock it");
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.reconstitutePtoPSourceStreams", (String)"1:1877:1.187.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1884:1.187.1.1", messageStoreException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1895:1.187.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        finally {
            if (object != null) {
                object.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams");
        }
    }

    public void sendFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushedMessage", (Object)new Object[]{cellule, sIBUuid12});
        }
        ControlFlushed controlFlushed = this.createControlFlushed(sIBUuid12);
        if (this.isLink) {
            controlFlushed = (ControlFlushed)this.addLinkProps((ControlMessage)controlFlushed);
        }
        if (this.isSystemOrTemp) {
            controlFlushed.setRoutingDestination(this.routingDestination);
        }
        if (this.isForMediation) {
            controlFlushed.setMediated(false);
        }
        this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, 9, (ControlMessage)controlFlushed);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushedMessage");
        }
    }

    public void sendNotFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12, long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushedMessage", (Object)new Object[]{cellule, sIBUuid12, new Long(l)});
        }
        ControlNotFlushed controlNotFlushed = this.createControlNotFlushed(sIBUuid12, l);
        controlNotFlushed = this.sourceStreamManager.stampNotFlushed(controlNotFlushed);
        if (this.isLink) {
            controlNotFlushed = (ControlNotFlushed)this.addLinkProps((ControlMessage)controlNotFlushed);
        }
        if (this.isSystemOrTemp) {
            controlNotFlushed.setRoutingDestination(this.routingDestination);
        }
        if (this.isForMediation) {
            controlNotFlushed.setMediated(false);
        }
        this.mpio.sendToMe((MessagingEngine)this.routingCellule, 1, 9, (ControlMessage)controlNotFlushed);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushedMessage");
        }
    }

    public synchronized void reallocateMsgs(DestinationHandler destinationHandler, boolean bl, boolean bl2) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateMsgs", (Object)new Object[]{destinationHandler, new Boolean(bl), new Boolean(bl2)});
        }
        ExternalLocalTransaction externalLocalTransaction = null;
        int n = -1;
        boolean bl3 = false;
        ((BaseDestinationHandler)destinationHandler).getReallocationLockManager().lockExclusive();
        ((BaseDestinationHandler)destinationHandler).getReallocationLockManager().unlockExclusive();
        StreamSet streamSet = this.sourceStreamManager.getStreamSet();
        if (streamSet == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs");
            }
            return;
        }
        Iterator iterator = streamSet.iterator();
        while (iterator.hasNext()) {
            SIMPMessage sIMPMessage;
            Iterator iterator2;
            SIMPMessage sIMPMessage2 = null;
            n = 0;
            externalLocalTransaction = destinationHandler.getTxManager().createLocalTransaction();
            bl3 = false;
            SourceStream sourceStream = (SourceStream)iterator.next();
            sourceStream.guessesInStream();
            List list = null;
            list = bl ? sourceStream.getAllMessagesOnStream() : sourceStream.getMessagesAfterSendWindow();
            ArrayList<AbstractItem> arrayList = new ArrayList<AbstractItem>();
            ArrayList<SIMPMessage> arrayList2 = new ArrayList<SIMPMessage>();
            Iterator iterator3 = list.iterator();
            long l = -1L;
            while (iterator3.hasNext()) {
                l = (Long)iterator3.next();
                arrayList.add(this.transmissionItemStream.findById(l));
            }
            Iterator iterator4 = arrayList.iterator();
            OutputHandler outputHandler = null;
            while (iterator4.hasNext()) {
                sIMPMessage2 = (SIMPMessage)iterator4.next();
                boolean bl4 = true;
                if (!destinationHandler.isToBeDeleted()) {
                    outputHandler = destinationHandler.choosePtoPOutputHandler(null, sIMPMessage2.getMessage().isMediated(), this.transmissionItemStream.getMessagingEngineUuid(), !sIMPMessage2.isFromRemoteME(), false);
                } else {
                    bl3 = false;
                }
                if (outputHandler != null) {
                    if (outputHandler == this) {
                        bl3 = outputHandler.isWLMGuess();
                        if (bl3) break;
                        bl4 = false;
                    } else {
                        iterator2 = destinationHandler.getInputHandler();
                        try {
                            sIMPMessage = sIMPMessage2.getMessage().getReceived();
                            MessageItem messageItem = new MessageItem((JsMessage)sIMPMessage);
                            sIMPMessage2.setStreamIsGuess(outputHandler.isWLMGuess());
                            iterator2.handleMessage(messageItem, externalLocalTransaction, null, this.messageProcessor.getMECellule());
                            ++n;
                        }
                        catch (SIException sIException) {
                            this.handleReallocationFailure((Exception)((Object)sIException), destinationHandler, externalLocalTransaction);
                        }
                        catch (MessageCopyFailedException messageCopyFailedException) {
                            this.handleReallocationFailure((Exception)((Object)messageCopyFailedException), destinationHandler, externalLocalTransaction);
                        }
                    }
                } else if (!this.messageProcessor.discardMsgsAfterQueueDeletion()) {
                    bl4 = false;
                }
                if (bl4 || bl2) {
                    try {
                        sIMPMessage2.remove(externalLocalTransaction, sIMPMessage2.getLockID());
                        ++n;
                        arrayList2.add(sIMPMessage2);
                    }
                    catch (MessageStoreException messageStoreException) {
                        this.handleReallocationFailure((Exception)((Object)messageStoreException), destinationHandler, externalLocalTransaction);
                    }
                }
                if (n <= Integer.MAX_VALUE) continue;
                try {
                    externalLocalTransaction.commit();
                    externalLocalTransaction = destinationHandler.getTxManager().createLocalTransaction();
                    n = 0;
                    iterator2 = arrayList2.iterator();
                    while (iterator2.hasNext()) {
                        sIMPMessage = (SIMPMessage)iterator2.next();
                        sourceStream.writeSilenceForced(sIMPMessage);
                    }
                    arrayList2 = new ArrayList();
                }
                catch (SIException sIException) {
                    this.handleReallocationFailure((Exception)((Object)sIException), destinationHandler, externalLocalTransaction);
                }
            }
            try {
                externalLocalTransaction.commit();
                iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    sIMPMessage = (SIMPMessage)iterator2.next();
                    sourceStream.writeSilenceForced(sIMPMessage);
                }
            }
            catch (SIException sIException) {
                this.handleReallocationFailure((Exception)((Object)sIException), destinationHandler, externalLocalTransaction);
            }
            if (bl3) continue;
            sourceStream.noGuessesInStream();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs");
        }
    }

    private void handleReallocationFailure(Exception exception, DestinationHandler destinationHandler, ExternalLocalTransaction externalLocalTransaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleReallocationFailure", (Object)new Object[]{exception, destinationHandler, externalLocalTransaction});
        }
        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.handleReallocationFailure", (String)"1:2211:1.187.1.1", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)exception);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleReallocationFailure", (Object)exception);
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.rollback();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.handleReallocationFailure", (String)"1:2232:1.187.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:2239:1.187.1.1", sIException, destinationHandler.getName()});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleReallocationFailure", (Object)"SIStoreException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:2251:1.187.1.1", sIException, destinationHandler.getName()}, null), (Throwable)sIException);
            }
        }
        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:2264:1.187.1.1", exception, destinationHandler.getName()}, null), (Throwable)exception);
    }

    public boolean isWLMGuess() {
        return this.isGuess;
    }

    public void setWLMGuess(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWLMGuess", (Object)new Boolean(bl));
        }
        this.isGuess = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWLMGuess");
        }
    }

    public boolean isQHighLimit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQHighLimit");
        }
        boolean bl = this.transmissionItemStream.isQHighLimit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQHighLimit", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void updateTargetCellule(Cellule cellule) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateTargetCellule", (Object)cellule);
        }
        this.targetCellule = cellule;
        this.sourceStreamManager.updateTargetCellule(cellule);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateTargetCellule");
        }
    }

    public void updateRoutingCellule(Cellule cellule) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateRoutingCellule", (Object)cellule);
        }
        this.routingCellule = cellule;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRoutingCellule");
        }
    }

    public SourceStreamManager getSourceStreamManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceStreamManager");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSourceStreamManager", (Object)this.sourceStreamManager);
        }
        return this.sourceStreamManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDelete() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDelete");
        }
        PtoPOutputHandler ptoPOutputHandler = this;
        synchronized (ptoPOutputHandler) {
            if (this.flushedForDeleteSource) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)Boolean.TRUE);
                }
                return true;
            }
            if (this.deleteFlushSource != null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)Boolean.FALSE);
                }
                return false;
            }
            final PtoPOutputHandler ptoPOutputHandler2 = this;
            this.deleteFlushSource = new FlushComplete(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void flushComplete(DestinationHandler destinationHandler) {
                    PtoPOutputHandler ptoPOutputHandler = ptoPOutputHandler2;
                    synchronized (ptoPOutputHandler) {
                        ptoPOutputHandler2.flushedForDeleteSource = true;
                        ptoPOutputHandler2.deleteFlushSource = null;
                    }
                    ptoPOutputHandler2.messageProcessor.getDestinationManager().startAsynchDeletion();
                }
            };
        }
        try {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)("Started PtoP source flush for destination: " + this.destinationHandler.getName()));
            }
            this.startFlush(this.deleteFlushSource);
        }
        catch (FlushAlreadyInProgressException flushAlreadyInProgressException) {
            FFDCFilter.processException((Throwable)flushAlreadyInProgressException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.flushAllForDelete", (String)"1:2420:1.187.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)flushAlreadyInProgressException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)"FlushAlreadyInProgressException");
            }
            throw new SIResourceException((Throwable)flushAlreadyInProgressException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)Boolean.FALSE);
        }
        return false;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/PtoPOutputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.187.1.1");
        }
    }
}

