/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.impl.AsynchConsumer;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.ConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.RemoteConsumerKey;
import com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.mediation.StoppedEventListener;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class LocalConsumerPoint
implements ConsumerPoint,
TransactionCallback {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static final TraceComponent tc = SibTr.register((Class)LocalConsumerPoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final long NO_WAIT = -1L;
    static final long INFINITE_WAIT = 0L;
    static final int NO_LOCAL_BATCH_SIZE = 10;
    private SIMPTransactionManager _txManager;
    private MessageProcessor _messageProcessor;
    private LockingCursor _getCursor;
    private ConsumerKey _consumerKey;
    private ConsumerSessionImpl _consumerSession;
    private ConsumerDispatcher _consumerDispatcher;
    private boolean _waitingToStart;
    private boolean _stopped = true;
    private boolean _stoppedByRequest = true;
    private boolean _stoppedForReceiveAllowed = false;
    private boolean _transacted = true;
    private Reliability _unrecoverableOptions = Reliability.NONE;
    private Reliability _baseUnrecoverableOptions = Reliability.NONE;
    private boolean _closed = false;
    private boolean _closing = false;
    private AsynchConsumer _asynchConsumer = new AsynchConsumer();
    private DestinationHandler _destinationAttachedTo;
    private Object _asynchConsumerBusyLock;
    private ExternalConsumerLock _externalConsumerLock = null;
    private boolean _yieldAsynch = false;
    private boolean _asynchConsumerRegistered = false;
    private int _maxBatchSize = 0;
    private int _maxActiveMessages = 0;
    private int _currentActiveMessages = 0;
    private boolean _consumerSuspended = false;
    private boolean _retryTimerSuspend = false;
    private boolean _activeMessageSuspend = false;
    private boolean _bifurcatable = false;
    private boolean _inLine = false;
    private boolean _waiting = false;
    private boolean _ready = false;
    private SIMPMessage _attachedMessage = null;
    private boolean _msgOnItemStream = false;
    private boolean _msgAttached = false;
    private boolean _msgLocked = false;
    private LockedMessageEnumerationImpl _allLockedMessages;
    private SIBUuid12 _connectionUuid;
    private ConsumerKeyGroup _keyGroup = null;
    private OrderingContextImpl _orderingGroup = null;
    private LocalConsumerPoint _transferredConsumer;
    boolean _drainQueue;
    private volatile boolean _lockRequested = false;
    private boolean _consumerIsMediation = false;
    private Transaction _autoCommitTransaction = null;
    private boolean _remoteME;
    private SingleLockedMessageEnumerationImpl _singleLockedMessageEnum = null;
    private boolean _isolatedRun = false;
    private StoppedEventListener _mediationStoppedEventListener;
    private boolean _mediationStoppedEventListenerRegistered;

    LocalConsumerPoint(DestinationHandler destinationHandler, ConsumerDispatcherState consumerDispatcherState, ConsumerSessionImpl consumerSessionImpl, Reliability reliability, boolean bl, boolean bl2) throws SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException, SIIncorrectCallException, SISessionDroppedException, SISessionUnavailableException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalConsumerPoint", (Object)new Object[]{destinationHandler, consumerDispatcherState, consumerSessionImpl, reliability, new Boolean(bl), new Boolean(bl2)});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Constructing local consumer point " + this));
        }
        this._consumerSession = consumerSessionImpl;
        ConnectionImpl connectionImpl = (ConnectionImpl)consumerSessionImpl.getConnection();
        this._destinationAttachedTo = destinationHandler;
        this._asynchConsumerBusyLock = this._asynchConsumer;
        this._messageProcessor = connectionImpl.getMessageProcessor();
        this._txManager = this._messageProcessor.getTXManager();
        this._connectionUuid = consumerSessionImpl.getConnectionUuid();
        this._bifurcatable = bl2;
        if (reliability != null) {
            this.setBaseRecoverability(reliability);
        }
        if (bl) {
            this._consumerDispatcher = destinationHandler.getMediationConsumerDispatcher();
            this._consumerKey = this._consumerDispatcher.attachConsumerPoint(this, consumerDispatcherState.getSelectionCriteria(), consumerSessionImpl.getConnectionUuid(), consumerSessionImpl.getReadAhead(), consumerSessionImpl.getForwardScanning());
            this._consumerIsMediation = true;
        } else if (destinationHandler.isPubSub()) {
            if (consumerDispatcherState.isDurable()) {
                this._consumerKey = destinationHandler.attachToDurableSubscription(this, consumerDispatcherState);
                this._consumerDispatcher = this._consumerKey.getConsumerDispatcher();
            } else {
                this._consumerDispatcher = destinationHandler.createSubscriptionConsumerDispatcher(consumerDispatcherState);
                this._consumerKey = this._consumerDispatcher.attachConsumerPoint(this, null, consumerSessionImpl.getConnectionUuid(), consumerSessionImpl.getReadAhead(), consumerSessionImpl.getForwardScanning());
            }
        } else {
            this._consumerDispatcher = destinationHandler.chooseConsumerDispatcher();
            this._consumerKey = this._consumerDispatcher.attachConsumerPoint(this, consumerDispatcherState.getSelectionCriteria(), consumerSessionImpl.getConnectionUuid(), consumerSessionImpl.getReadAhead(), consumerSessionImpl.getForwardScanning());
        }
        this._remoteME = this._consumerKey instanceof RemoteConsumerKey;
        this._getCursor = this._consumerKey.getGetCursor();
        this._allLockedMessages = new LockedMessageEnumerationImpl(this, this._getCursor, this._txManager, this._remoteME);
        this.checkReceiveAllowed();
        this._autoCommitTransaction = this._messageProcessor.getTXManager().createAutoCommitTransaction();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalConsumerPoint", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(SIMPMessage sIMPMessage, boolean bl) {
        boolean bl2;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{this, sIMPMessage, new Boolean(bl), this});
        }
        boolean bl3 = false;
        ConsumerKeyGroup consumerKeyGroup = this._keyGroup;
        this._lockRequested = true;
        if (consumerKeyGroup != null) {
            object = consumerKeyGroup;
            synchronized (object) {
                LocalConsumerPoint localConsumerPoint = this;
                synchronized (localConsumerPoint) {
                    this._lockRequested = false;
                    bl2 = this.takeMessage(sIMPMessage, bl);
                    if (bl2) {
                        bl3 = this._asynchConsumerRegistered && !this._isolatedRun;
                    }
                }
            }
        }
        object = this;
        synchronized (object) {
            this._lockRequested = false;
            bl2 = this.takeMessage(sIMPMessage, bl);
            if (bl2) {
                bl3 = this._asynchConsumerRegistered && !this._isolatedRun;
            }
        }
        if (bl3) {
            if (this._inLine && !sIMPMessage.isReavailable()) {
                try {
                    this.runAsynchConsumer(false);
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.put", (String)"1:670:1.236", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                }
            } else {
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, false));
                }
                catch (InterruptedException interruptedException) {
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    private boolean takeMessage(SIMPMessage sIMPMessage, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"takeMessage", (Object)new Object[]{this, sIMPMessage, new Boolean(bl)});
        }
        boolean bl2 = false;
        if (this._ready && this._keyGroup == null || this._keyGroup != null && this._keyGroup.isGroupReady()) {
            this._ready = false;
            if (this._keyGroup != null) {
                this._keyGroup.groupNotReady();
            }
            bl2 = true;
            boolean bl3 = this.attachAndLockMsg(sIMPMessage, bl);
            if (!bl3 && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Missed the message!");
            }
            if (!this._waiting && !this._asynchConsumerRegistered) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.takeMessage", "1:758:1.236"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.takeMessage", (String)"1:764:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.takeMessage", "1:771:1.236"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"takeMessage", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
            if (this._waiting || this._isolatedRun) {
                this.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"takeMessage", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    private boolean attachAndLockMsg(SIMPMessage sIMPMessage, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachAndLockMsg", (Object)new Object[]{sIMPMessage, new Boolean(bl), this});
        }
        boolean bl2 = true;
        if (bl) {
            if (this._consumerSession.getForwardScanning()) {
                this._msgLocked = false;
                this._msgAttached = true;
                this._msgOnItemStream = true;
                this._attachedMessage = null;
            } else if (sIMPMessage.lockItemIfAvailable(this._consumerKey.getGetCursor().getLockID())) {
                this._msgLocked = true;
                this._msgAttached = true;
                this._msgOnItemStream = true;
                this._attachedMessage = sIMPMessage;
            } else {
                bl2 = false;
                this._msgLocked = false;
                this._msgAttached = true;
                this._msgOnItemStream = true;
                this._attachedMessage = null;
            }
        } else {
            this._msgLocked = false;
            this._msgAttached = true;
            this._msgOnItemStream = false;
            this._attachedMessage = sIMPMessage;
        }
        if (this._msgAttached && this._keyGroup != null) {
            this._keyGroup.attachMessage(this._consumerKey);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachAndLockMsg", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    SIMPMessage getAttachedMessage() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttachedMessage", (Object)this);
        }
        SIMPMessage sIMPMessage = null;
        if (this._msgAttached) {
            sIMPMessage = this._msgOnItemStream && !this._msgLocked ? this.getEligibleMsgLocked(null) : this._attachedMessage;
            this._msgAttached = false;
            this._msgLocked = false;
            this._attachedMessage = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttachedMessage", (Object)sIMPMessage);
        }
        return sIMPMessage;
    }

    private boolean checkReceiveAllowed() throws SISessionUnavailableException, SIResourceException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkReceiveAllowed");
        }
        if (!(bl = this._destinationAttachedTo.isReceiveAllowed())) {
            this._stoppedForReceiveAllowed = true;
            if (!this._stopped) {
                this.internalStop();
            }
        } else {
            this._stoppedForReceiveAllowed = false;
            if (this._stopped && !this._stoppedByRequest) {
                this.internalStart(false);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkReceiveAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void checkReceiveState() throws SIIncorrectCallException, SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkReceiveState");
        }
        this.checkNotClosed();
        if (this._asynchConsumerRegistered) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkReceiveState", (Object)"asynchConsumerRegistered == true ");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("RECEIVE_USAGE_ERROR_CWSIP0171", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (this._waiting) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("RECEIVE_USAGE_ERROR_CWSIP0178", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkReceiveState", (Object)"receive already in progress");
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkReceiveState");
        }
    }

    private void removeUnwantedMsgs(List list, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)new Object[]{this, list, transaction});
        }
        ExternalLocalTransaction externalLocalTransaction = null;
        if (transaction == null) {
            externalLocalTransaction = this._txManager.createLocalTransaction();
            transaction = externalLocalTransaction;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                SIMPMessage sIMPMessage = (SIMPMessage)iterator.next();
                sIMPMessage.remove(transaction, this._getCursor.getLockID());
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.removeUnwantedMsgs", (String)"1:1074:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1082:1.236", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException)), this._consumerDispatcher.getDestination().getName()});
                this._waiting = false;
                this.unsetReady();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)((Object)messageStoreException));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1099:1.236", messageStoreException, this._consumerDispatcher.getDestination().getName()}, null), (Throwable)((Object)messageStoreException));
            }
        }
        try {
            if (externalLocalTransaction != null) {
                externalLocalTransaction.commit();
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.removeUnwantedMsgs", (String)"1:1121:1.236", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            this._waiting = false;
            this.unsetReady();
            try {
                externalLocalTransaction.rollback();
            }
            catch (SIException sIException2) {
                FFDCFilter.processException((Throwable)sIException2, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.removeUnwantedMsgs", (String)"1:1142:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1150:1.236", SIMPUtils.getStackTrace(sIException2)});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)((Object)sIException2));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1162:1.236", sIException2}, null), (Throwable)sIException2);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)((Object)sIException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1175:1.236", SIMPUtils.getStackTrace(sIException)});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1183:1.236", sIException}, null), (Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs");
        }
    }

    private SIMPMessage getEligibleMsgLocked(Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEligibleMsgLocked", (Object)new Object[]{this, transaction});
        }
        SIMPMessage sIMPMessage = null;
        sIMPMessage = this.retrieveMsgLocked();
        if (sIMPMessage != null && this._consumerDispatcher.getConsumerDispatcherState().isNoLocal()) {
            LinkedList<SIMPMessage> linkedList = new LinkedList<SIMPMessage>();
            int n = 0;
            while (sIMPMessage != null && this._connectionUuid.equals((Object)sIMPMessage.getProducerConnectionUuid())) {
                linkedList.add(sIMPMessage);
                if (++n >= 10) {
                    this.removeUnwantedMsgs(linkedList, null);
                    linkedList.clear();
                    n = 0;
                }
                sIMPMessage = this.retrieveMsgLocked();
            }
            if (!linkedList.isEmpty()) {
                Transaction transaction2 = null;
                if (transaction != null && sIMPMessage != null) {
                    transaction2 = transaction;
                }
                this.removeUnwantedMsgs(linkedList, transaction2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEligibleMsgLocked", (Object)sIMPMessage);
        }
        return sIMPMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsMessage receive(long l, Transaction transaction) throws SISessionUnavailableException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        LocalConsumerPoint localConsumerPoint;
        long l2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receive", (Object)new Object[]{this, new Long(l), transaction});
        }
        if (transaction != null && !transaction.isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777", new Object[]{this._destinationAttachedTo}, null));
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"receive", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        long l3 = l;
        boolean bl = true;
        SIMPMessage sIMPMessage = null;
        long l4 = l2 = System.currentTimeMillis();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ExternalLocalTransaction externalLocalTransaction = null;
        while (bl) {
            localConsumerPoint = this;
            synchronized (localConsumerPoint) {
                this.checkReceiveState();
                this._waiting = true;
                this._transacted = transaction != null;
                if (this._stopped || this._retryTimerSuspend) {
                    this._waitingToStart = true;
                } else {
                    this.setReady();
                    sIMPMessage = this.getEligibleMsgLocked(transaction);
                    if (sIMPMessage != null) {
                        bl2 = true;
                        bl = false;
                        this.unsetReady();
                    }
                }
                if (sIMPMessage == null) {
                    l3 = this._consumerKey.waiting(l3, true);
                }
                if (l3 == -1L) {
                    bl = false;
                }
                if (sIMPMessage == null && bl) {
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._waitingToStart = false;
                this._waiting = false;
                this.unsetReady();
                if (this._msgAttached) {
                    bl3 = this._msgOnItemStream;
                    sIMPMessage = this.getAttachedMessage();
                    if (sIMPMessage != null) {
                        if (bl3) {
                            bl2 = true;
                        }
                        bl = false;
                    }
                }
            }
            if (!bl || l == 0L || (l3 = l - ((l4 = System.currentTimeMillis()) - l2)) > 0L) continue;
            bl = false;
        }
        localConsumerPoint = null;
        if (sIMPMessage != null) {
            try {
                localConsumerPoint = bl2 && ((ConnectionImpl)this._consumerSession.getConnection()).getMessageCopiedWhenReceived() ? sIMPMessage.getMessage().getReceived() : sIMPMessage.getMessage();
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.receive", (String)"1:1479:1.236", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1485:1.236", SIMPUtils.getStackTrace(messageCopyFailedException)});
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"receive", (Object)((Object)messageCopyFailedException));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1498:1.236", messageCopyFailedException}, null), (Throwable)messageCopyFailedException);
            }
            if (!sIMPMessage.isItemReference() && (sIMPMessage.getReportCOD() != null || this._remoteME)) {
                if (!bl2) {
                    ((MessageItem)sIMPMessage).beforeCompletion(this._autoCommitTransaction);
                } else {
                    if (transaction == null) {
                        externalLocalTransaction = this._txManager.createLocalTransaction();
                        transaction = externalLocalTransaction;
                        bl4 = true;
                    }
                    transaction.registerCallback((MessageItem)sIMPMessage);
                }
            }
            if (localConsumerPoint != null && bl2) {
                if (sIMPMessage.guessRedeliveredCount() != 0) {
                    localConsumerPoint.setRedeliveredCount(sIMPMessage.guessRedeliveredCount());
                }
                long l5 = sIMPMessage.updateStatisticsMessageWaitTime();
                if (this.isConsumerAMediation() || ((ConnectionImpl)this._consumerSession.getConnection()).getSetWaitTimeInMessage()) {
                    localConsumerPoint.setMessageWaitTime(l5);
                }
            }
            try {
                if (bl2) {
                    if (transaction == null) {
                        transaction = this._autoCommitTransaction;
                    }
                    sIMPMessage.remove(transaction, this._getCursor.getLockID());
                    if (bl4) {
                        externalLocalTransaction.commit();
                        transaction = null;
                    }
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.receive", (String)"1:1581:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1589:1.236", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException)), this._consumerDispatcher.getDestination().getName()});
                this._waiting = false;
                this.unsetReady();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"receive", (Object)((Object)messageStoreException));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1604:1.236", messageStoreException, this._consumerDispatcher.getDestination().getName()}, null), (Throwable)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receive", (Object)sIMPMessage);
        }
        return localConsumerPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitingNotify() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitingNotify");
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            if (this._waiting) {
                this.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitingNotify");
        }
    }

    private SIMPMessage retrieveMsgLocked() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMsgLocked", (Object)new Object[]{this});
        }
        SIMPMessage sIMPMessage = null;
        try {
            sIMPMessage = (SIMPMessage)((Object)this._consumerKey.getGetCursor().next());
            if (sIMPMessage != null) {
                sIMPMessage.eventLocked();
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.retrieveMsgLocked", (String)"1:1662:1.236", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1669:1.236", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMsgLocked", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:1680:1.236", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMsgLocked", (Object)sIMPMessage);
        }
        return sIMPMessage;
    }

    private void checkParams(int n, long l, int n2) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkParams", (Object)new Object[]{new Integer(n), new Long(l), new Integer(n2)});
        }
        if (n < 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkParams", (Object)"SIIncorrectCallException maxActiveMessages < 0");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("REG_ASYNCH_CONSUMER_ERROR_CWSIR0141", new Object[]{new Integer(n)}, null));
        }
        if (l < 0L) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkParams", (Object)"SIIncorrectCallException messageLockExpiry < 0");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("REG_ASYNCH_CONSUMER_ERROR_CWSIR0141", new Object[]{new Long(l)}, null));
        }
        if (n2 <= 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkParams", (Object)"SIIncorrectCallException maxBatchSize <= 0");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("REG_ASYNCH_CONSUMER_ERROR_CWSIR0141", new Object[]{new Integer(n2)}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkParams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAsynchConsumer(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, Reliability reliability, boolean bl, OrderingContextImpl orderingContextImpl, ExternalConsumerLock externalConsumerLock) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)new Object[]{this, asynchConsumerCallback, new Integer(n), new Long(l), new Integer(n2), reliability, new Boolean(bl), orderingContextImpl, externalConsumerLock});
        }
        this.checkParams(n, l, n2);
        if (externalConsumerLock != null) {
            this._asynchConsumerBusyLock = externalConsumerLock;
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            LocalConsumerPoint localConsumerPoint = this;
            synchronized (localConsumerPoint) {
                this.checkNotClosed();
                if (!this._stopped) {
                    SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("ASYNCH_CONSUMER_RUN_ERROR_CWSIP0176", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.messageProcessor.getMessagingEngineName()}, null));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)((Object)sIIncorrectCallException));
                    }
                    throw sIIncorrectCallException;
                }
                if (this._waiting) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)"waiting == true");
                    }
                    throw new SIIncorrectCallException(nls.getFormattedMessage("RECEIVE_USAGE_ERROR_CWSIP0174", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (reliability != null) {
                    this.setUnrecoverability(reliability);
                }
                this._asynchConsumer.registerCallback(asynchConsumerCallback);
                if (asynchConsumerCallback != null) {
                    this._maxBatchSize = n2;
                    this._inLine = bl;
                    this._maxActiveMessages = n;
                    this._currentActiveMessages = 0;
                    this._allLockedMessages.setMessageLockExpiry(l);
                    this._asynchConsumerRegistered = true;
                    this._transacted = true;
                    if (orderingContextImpl != null && !this._consumerDispatcher.isPubSub() && !this._consumerSession.getReadAhead() && this._orderingGroup != orderingContextImpl) {
                        if (this._orderingGroup != null) {
                            this._consumerKey.leaveKeyGroup();
                        }
                        this._orderingGroup = orderingContextImpl;
                        try {
                            this._keyGroup = this._consumerDispatcher.joinKeyGroup(this._consumerKey, orderingContextImpl);
                        }
                        catch (SIResourceException sIResourceException) {
                            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.registerAsynchConsumer", (String)"1:1903:1.236", (Object)this);
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)"SIIncorrectCallException");
                            }
                            throw new SIIncorrectCallException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1912:1.236", SIMPUtils.getStackTrace(sIResourceException)}, null));
                        }
                        if (this._keyGroup != null && externalConsumerLock == null) {
                            this._asynchConsumerBusyLock = this._keyGroup.asynchGroupLock;
                        }
                    }
                } else {
                    this._asynchConsumerRegistered = false;
                    this.resetBaseUnrecoverability();
                    this._inLine = false;
                    if (this._orderingGroup != null) {
                        this._consumerKey.leaveKeyGroup();
                        this._keyGroup = null;
                        this._asynchConsumerBusyLock = this._asynchConsumer;
                        this._orderingGroup = null;
                    }
                }
                this._externalConsumerLock = externalConsumerLock;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processAttachedMsgs() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAttachedMsgs", (Object)this);
        }
        SIMPMessage sIMPMessage = null;
        Object object = this;
        synchronized (object) {
            sIMPMessage = this.getAttachedMessage();
            if (this._maxActiveMessages != 0 && sIMPMessage != null && (this._msgOnItemStream || this._bifurcatable)) {
                this.addActiveMessage();
            }
        }
        if (this._keyGroup != null && (object = this._keyGroup.getAttachedMember()) != null && object != this._consumerKey) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processAttachedMsgs");
            }
            return ((LocalConsumerPoint)((ConsumerKey)object).getConsumerPoint()).processAttachedMsgs();
        }
        if (sIMPMessage != null) {
            if (!this._msgOnItemStream && !this._bifurcatable) {
                if (!sIMPMessage.isItemReference() && sIMPMessage.getReportCOD() != null) {
                    ((MessageItem)sIMPMessage).beforeCompletion(this._autoCommitTransaction);
                }
                if (this._singleLockedMessageEnum != null) {
                    this._singleLockedMessageEnum.newMessage(sIMPMessage);
                } else {
                    this._singleLockedMessageEnum = new SingleLockedMessageEnumerationImpl(this, sIMPMessage);
                }
                this._asynchConsumer.processMsgs(this._singleLockedMessageEnum, this._consumerSession);
                this._singleLockedMessageEnum.clearMessage();
            } else {
                boolean bl = true;
                if (this._msgOnItemStream && this._unrecoverableOptions != Reliability.NONE && sIMPMessage.getReliability().compareTo((Object)this._unrecoverableOptions) <= 0) {
                    bl = false;
                }
                this._allLockedMessages.addNewMessage(sIMPMessage, this._msgOnItemStream, bl);
                this._asynchConsumer.processMsgs(this._allLockedMessages, this._consumerSession);
                this._allLockedMessages.resetCallbackCursor();
            }
            if (this._externalConsumerLock != null) {
                this._yieldAsynch = this._externalConsumerLock.isLockYieldRequested();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processAttachedMsgs", (Object)new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAttachedMsgs", (Object)new Boolean(false));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalConsumerPoint processQueuedMsgs(boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processQueuedMsgs", (Object)new Object[]{this, new Boolean(bl)});
        }
        LocalConsumerPoint localConsumerPoint = null;
        boolean bl2 = true;
        this._drainQueue = true;
        long l = 0L;
        if (bl) {
            l = -1L;
        }
        int n = 0;
        while (this._drainQueue && bl2 && !this._yieldAsynch) {
            Object object;
            this._transferredConsumer = null;
            localConsumerPoint = null;
            if (this._lockRequested) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Yield requested");
                }
                Thread.yield();
            }
            if (this._keyGroup != null) {
                object = this._keyGroup;
                synchronized (object) {
                    LocalConsumerPoint localConsumerPoint2 = this;
                    synchronized (localConsumerPoint2) {
                        if (this._closed || this._consumerSuspended) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"processQueuedMsgs", (Object)("Closed:" + this._closed + " Suspended:" + this._consumerSuspended));
                            }
                            bl2 = false;
                        } else {
                            n = this.lockMessages(n, bl);
                            localConsumerPoint = this._transferredConsumer;
                        }
                        if ((this._ready && this._keyGroup == null || this._keyGroup != null && this._keyGroup.isGroupReady()) && n == 0) {
                            l = this._consumerKey.waiting(l, false);
                        }
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (this._closed || this._consumerSuspended) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"processQueuedMsgs", (Object)("Closed:" + this._closed + " Suspended:" + this._consumerSuspended));
                    }
                    bl2 = false;
                } else {
                    n = this.lockMessages(n, bl);
                }
                if (this._ready && n == 0) {
                    l = this._consumerKey.waiting(l, false);
                }
            }
            if (bl2 && n > 0 && localConsumerPoint == null) {
                this._asynchConsumer.processMsgs(this._allLockedMessages, this._consumerSession);
                this._allLockedMessages.resetCallbackCursor();
                this._drainQueue = !bl;
            }
            if (localConsumerPoint != null) {
                localConsumerPoint.processTransferredMsg();
            }
            if (bl && l != -1L) {
                object = this;
                synchronized (object) {
                    if (!this._msgAttached) {
                        try {
                            this.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.unsetReady();
                    this._isolatedRun = false;
                }
                this.processAttachedMsgs();
            }
            if (this._externalConsumerLock != null) {
                if (!this._yieldAsynch) {
                    this._yieldAsynch = this._externalConsumerLock.isLockYieldRequested();
                }
                if (this._yieldAsynch && localConsumerPoint == null) {
                    localConsumerPoint = this;
                }
            }
            n = 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processQueuedMsgs");
        }
        return localConsumerPoint;
    }

    protected void processTransferredMsg() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processTransferredMsg", (Object)this);
        }
        this._asynchConsumer.processMsgs(this._allLockedMessages, this._consumerSession);
        this._allLockedMessages.resetCallbackCursor();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processTransferredMsg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockMessages(int n, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lockMessages", (Object)new Object[]{this, new Integer(n), new Boolean(bl)});
        }
        int n2 = n;
        this._transferredConsumer = null;
        if (!bl || this._remoteME) {
            if (this._stopped && !bl) {
                this.unsetReady();
                this._drainQueue = false;
            } else {
                try {
                    this.setReady();
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    this._drainQueue = false;
                }
            }
            if (bl) {
                this._isolatedRun = bl;
            }
        }
        if (this._keyGroup != null && !this._keyGroup.isStarted()) {
            this._drainQueue = false;
        }
        while (n2 < this._maxBatchSize && this._drainQueue && !this._yieldAsynch) {
            SIMPMessage sIMPMessage = null;
            sIMPMessage = this.getEligibleMsgLocked(null);
            if (sIMPMessage != null) {
                LocalConsumerPoint localConsumerPoint = this;
                if (this._keyGroup != null) {
                    localConsumerPoint = (LocalConsumerPoint)this._keyGroup.getMatchingMember(this._consumerKey).getConsumerPoint();
                }
                if (localConsumerPoint == this) {
                    boolean bl2 = true;
                    if (this._unrecoverableOptions != Reliability.NONE && sIMPMessage.getReliability().compareTo((Object)this._unrecoverableOptions) <= 0) {
                        bl2 = false;
                    }
                    this._allLockedMessages.addNewMessage(sIMPMessage, true, bl2);
                    ++n2;
                    if (this._externalConsumerLock != null) {
                        this._yieldAsynch = this._externalConsumerLock.isLockYieldRequested();
                    }
                    if (this.addActiveMessage()) {
                        this._drainQueue = false;
                        this.unsetReady();
                    } else if (n2 == this._maxBatchSize || this._yieldAsynch) {
                        this.unsetReady();
                    }
                } else {
                    if (n2 > 0) {
                        try {
                            this.unsetReady();
                            sIMPMessage.unlock(sIMPMessage.getLockID());
                            sIMPMessage = null;
                        }
                        catch (MessageStoreException messageStoreException) {
                            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.lockMessages", (String)"1:2432:1.236", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"lockMessages", (Object)((Object)messageStoreException));
                            }
                            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalConsumerPoint", "1:2445:1.236", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                        }
                    }
                    ++n2;
                    LocalConsumerPoint localConsumerPoint2 = this._transferredConsumer = localConsumerPoint;
                    synchronized (localConsumerPoint2) {
                        this._transferredConsumer.addLockedMessage(sIMPMessage);
                        this._transferredConsumer.unsetReady();
                    }
                    this._drainQueue = false;
                    if (this._externalConsumerLock != null) {
                        this._yieldAsynch = this._externalConsumerLock.isLockYieldRequested();
                    }
                }
            }
            if (sIMPMessage == null) {
                if (n2 > 0) {
                    this.unsetReady();
                }
                this._drainQueue = false;
            }
            if (this._externalConsumerLock == null) continue;
            this._yieldAsynch = this._externalConsumerLock.isLockYieldRequested();
        }
        if (bl && !this._ready) {
            this._isolatedRun = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lockMessages", (Object)new Integer(n2));
        }
        return n2;
    }

    protected void addLockedMessage(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLockedMessage", (Object)new Object[]{this, sIMPMessage});
        }
        this.unsetReady();
        boolean bl = true;
        if (this._unrecoverableOptions != Reliability.NONE && sIMPMessage.getReliability().compareTo((Object)this._unrecoverableOptions) <= 0) {
            bl = false;
        }
        this._allLockedMessages.addNewMessage(sIMPMessage, true, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLockedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runIsolatedAsynch(boolean bl) throws SIIncorrectCallException, SISessionUnavailableException, SIResourceException {
        block15: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)new Object[]{this, new Boolean(bl)});
            }
            Object object = this._asynchConsumerBusyLock;
            synchronized (object) {
                LocalConsumerPoint localConsumerPoint = this;
                synchronized (localConsumerPoint) {
                    this.checkNotClosed();
                    if (!this._asynchConsumerRegistered) {
                        SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("ASYNCH_CONSUMER_ERROR_CWSIP0175", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)((Object)sIIncorrectCallException));
                        }
                        throw sIIncorrectCallException;
                    }
                    if (!this._stopped) {
                        SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("ASYNCH_CONSUMER_RUN_ERROR_CWSIP0176", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.messageProcessor.getMessagingEngineName()}, null));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)((Object)sIIncorrectCallException));
                        }
                        throw sIIncorrectCallException;
                    }
                }
            }
            if (bl) {
                this.runAsynchConsumer(true);
            } else {
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, true));
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isEntryEnabled()) break block15;
                    SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAsynchConsumer(boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runAsynchConsumer", (Object)new Object[]{this, new Boolean(bl)});
        }
        LocalConsumerPoint localConsumerPoint = null;
        boolean bl2 = true;
        do {
            if (this._yieldAsynch) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"External yield requested");
                }
                Thread.yield();
                this._yieldAsynch = false;
            }
            Object object = this._asynchConsumerBusyLock;
            synchronized (object) {
                if (bl2) {
                    bl2 = false;
                    if (this._stopped && !bl || !this._stopped && bl || !this._asynchConsumerRegistered) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runAsynchConsumer", (Object)"No-op");
                        }
                        return;
                    }
                    boolean bl3 = this.processAttachedMsgs();
                    if (!bl3 || !bl) {
                        localConsumerPoint = !this._yieldAsynch ? this.processQueuedMsgs(bl) : this;
                    } else {
                        this._yieldAsynch = false;
                    }
                }
                if (!bl && localConsumerPoint != null) {
                    while (localConsumerPoint != null && !this._yieldAsynch) {
                        localConsumerPoint = localConsumerPoint.processQueuedMsgs(bl);
                    }
                }
            }
        } while (this._yieldAsynch);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runAsynchConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close", (Object)this);
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            Object object2;
            Object object3;
            if (this._closed || this._closing) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"close", (Object)"Already Closed");
                }
                return;
            }
            this._lockRequested = true;
            if (this._keyGroup != null) {
                object3 = this._keyGroup;
                synchronized (object3) {
                    object2 = this;
                    synchronized (object2) {
                        this._lockRequested = false;
                        this._consumerKey.stop();
                        this.unsetReady();
                        this._closing = true;
                    }
                }
            }
            object3 = this;
            synchronized (object3) {
                this._lockRequested = false;
                this.unsetReady();
                this._closing = true;
            }
            if (this._asynchConsumerRegistered) {
                if (!this._asynchConsumer.isAsynchConsumerRunning()) {
                    this.processAttachedMsgs();
                }
                if (this._keyGroup != null) {
                    this._consumerKey.leaveKeyGroup();
                    this._keyGroup = null;
                }
            }
            object3 = this;
            synchronized (object3) {
                object2 = this._allLockedMessages;
                synchronized (object2) {
                    this._allLockedMessages.unlockAll();
                    this._closed = true;
                }
                if (this._waiting) {
                    this.notify();
                }
            }
        }
        this._consumerKey.detach();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public boolean isClosed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosed", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"isClosed", (Object)new Boolean(this._closed));
        }
        return this._closed;
    }

    protected void start(boolean bl) throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)new Object[]{new Boolean(bl), this});
        }
        this._stoppedByRequest = false;
        this.internalStart(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStart(boolean bl) throws SISessionUnavailableException {
        block28: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"internalStart", (Object)new Object[]{new Boolean(bl), this});
            }
            boolean bl2 = false;
            Object object = this._asynchConsumerBusyLock;
            synchronized (object) {
                Object object2;
                if (this._keyGroup != null) {
                    object2 = this._keyGroup;
                    synchronized (object2) {
                        LocalConsumerPoint localConsumerPoint = this;
                        synchronized (localConsumerPoint) {
                            this.checkNotClosed();
                            if (!this._stoppedForReceiveAllowed) {
                                this._stopped = false;
                                this._consumerKey.start();
                                if (this._waitingToStart) {
                                    this.notify();
                                }
                            }
                        }
                    }
                }
                object2 = this;
                synchronized (object2) {
                    this.checkNotClosed();
                    if (!this._stoppedForReceiveAllowed) {
                        this._stopped = false;
                        this._consumerKey.start();
                        if (this._waitingToStart) {
                            this.notify();
                        }
                    }
                }
                if (this._asynchConsumerRegistered) {
                    if (bl) {
                        try {
                            this.runAsynchConsumer(false);
                        }
                        catch (SIResourceException sIResourceException) {
                            if (tc.isEntryEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, false));
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.internalStart", (String)"1:3025:1.236", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                    if (!tc.isEntryEnabled()) break block28;
                    SibTr.exit((TraceComponent)tc, (String)"internalStart", (Object)interruptedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalStart");
        }
    }

    public void checkForMessages() {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkForMessages", (Object)this);
            }
            try {
                this._messageProcessor.startNewThread(new AsynchThread(this, false));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.checkForMessages", (String)"1:3061:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit((TraceComponent)tc, (String)"checkForMessages", (Object)interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkForMessages");
        }
    }

    protected void stop() throws SISessionUnavailableException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this);
        }
        this._stoppedByRequest = true;
        this.internalStop();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStop() throws SISessionUnavailableException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalStop", (Object)this);
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            this._lockRequested = true;
            if (this._keyGroup != null) {
                ConsumerKeyGroup consumerKeyGroup = this._keyGroup;
                synchronized (consumerKeyGroup) {
                    LocalConsumerPoint localConsumerPoint = this;
                    synchronized (localConsumerPoint) {
                        this._lockRequested = false;
                        this.checkNotClosed();
                        this._stopped = true;
                        this._consumerKey.stop();
                        this.unsetReady();
                        if (this._waiting) {
                            this._waitingToStart = true;
                        }
                    }
                }
            }
            LocalConsumerPoint localConsumerPoint = this;
            synchronized (localConsumerPoint) {
                this._lockRequested = false;
                this.checkNotClosed();
                this._stopped = true;
                this._consumerKey.stop();
                this.unsetReady();
                if (this._waiting) {
                    this._waitingToStart = true;
                }
            }
            if (this._asynchConsumerRegistered && !this._asynchConsumer.isAsynchConsumerRunning()) {
                this.processAttachedMsgs();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalStop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockAll() throws SISessionUnavailableException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll", (Object)this);
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            LocalConsumerPoint localConsumerPoint = this;
            synchronized (localConsumerPoint) {
                this.checkNotClosed();
                this._allLockedMessages.unlockAll();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll");
        }
    }

    private void setBaseRecoverability(Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBaseRecoverability", (Object)new Object[]{this, reliability});
        }
        this.setUnrecoverability(reliability);
        this._baseUnrecoverableOptions = this._unrecoverableOptions;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBaseRecoverability");
        }
    }

    private void resetBaseUnrecoverability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetBaseUnrecoverability", (Object)this);
        }
        this._unrecoverableOptions = this._baseUnrecoverableOptions;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetBaseUnrecoverability");
        }
    }

    private void setUnrecoverability(Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setUnrecoverability", (Object)new Object[]{this, reliability});
        }
        this._unrecoverableOptions = reliability;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setUnrecoverability");
        }
    }

    private void setReady() throws SINotPossibleInCurrentConfigurationException {
        Reliability reliability = Reliability.ASSURED_PERSISTENT;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReady", (Object)this);
        }
        if (this._transacted) {
            reliability = this._unrecoverableOptions;
        }
        this._ready = true;
        if (this._keyGroup != null) {
            this._keyGroup.groupReady();
        }
        this._consumerKey.ready(reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReady");
        }
    }

    protected void unsetReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetReady", (Object)this);
        }
        this._ready = false;
        if (this._keyGroup != null) {
            this._keyGroup.groupNotReady();
        }
        this._consumerKey.notReady();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetReady");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIBusMessage[] processMsgSet(SIMessageHandle[] sIMessageHandleArray, Transaction transaction, BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl, boolean bl, boolean bl2, boolean bl3) throws SISessionUnavailableException, SIMPMessageNotLockedException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMsgSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(sIMessageHandleArray), transaction, bifurcatedConsumerSessionImpl, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            this.checkNotClosed();
        }
        int n = 0;
        SIBusMessage[] sIBusMessageArray = null;
        if (sIMessageHandleArray != null && sIMessageHandleArray.length > 0) {
            n = sIMessageHandleArray.length;
        }
        if (n > 0) {
            sIBusMessageArray = this._allLockedMessages.processMsgSet(sIMessageHandleArray, transaction, bifurcatedConsumerSessionImpl, bl, bl2, bl3);
        }
        if (this._mediationStoppedEventListenerRegistered && this._allLockedMessages.getNumberOfLockedMessages() == 0) {
            this._mediationStoppedEventListener.stopped();
            this.unregisterMediationStoppedEventListener();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)sIBusMessageArray);
        }
        return sIBusMessageArray;
    }

    protected ConsumerSessionImpl getConsumerSession() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerSession");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerSession", (Object)this._consumerSession);
        }
        return this._consumerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyException(SIException sIException) {
        block17: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"notifyException", (Object)new Object[]{this, sIException});
            }
            if (sIException instanceof SINotPossibleInCurrentConfigurationException || sIException instanceof SIResourceException || sIException instanceof SILimitExceededException || sIException instanceof SIIncorrectCallException || sIException instanceof SIDestinationLockedException) {
                block16: {
                    try {
                        if (this._asynchConsumerRegistered) {
                            this._asynchConsumer.notifyExceptionListeners(sIException, this._consumerSession);
                        }
                        this.close();
                    }
                    catch (SIException sIException2) {
                        if (!tc.isDebugEnabled()) break block16;
                        SibTr.debug((TraceComponent)tc, (String)"notifyException", (Object)((Object)sIException2));
                    }
                }
                LocalConsumerPoint localConsumerPoint = this;
                synchronized (localConsumerPoint) {
                    if (this._waiting) {
                        this.notify();
                    }
                }
            }
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.notifyException", (String)"1:3404:1.236", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            try {
                this.close();
            }
            catch (SIException sIException3) {
                if (!tc.isDebugEnabled()) break block17;
                SibTr.debug((TraceComponent)tc, (String)"notifyException", (Object)((Object)sIException3));
            }
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            if (this._waiting) {
                this.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReceiveAllowed(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{new Boolean(bl), this});
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            try {
                this.checkReceiveAllowed();
            }
            catch (SISessionUnavailableException sISessionUnavailableException) {
                FFDCFilter.processException((Throwable)sISessionUnavailableException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.notifyReceiveAllowed", (String)"1:3454:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.notifyReceiveAllowed", (String)"1:3465:1.236", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    public void checkNotClosed() throws SISessionUnavailableException {
        if (this._closed || this._closing && !this._asynchConsumer.isAsynchConsumerRunning()) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
            }
            SISessionUnavailableException sISessionUnavailableException = new SISessionUnavailableException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"consumer closed");
            }
            throw sISessionUnavailableException;
        }
    }

    protected ConsumerDispatcher getConsumerDispatcher() {
        return this._consumerDispatcher;
    }

    public boolean isConsumerAMediation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isConsumerAMediation", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"isConsumerAMediation", (Object)new Boolean(this._consumerIsMediation));
        }
        return this._consumerIsMediation;
    }

    public boolean destinationMatches(DestinationHandler destinationHandler, ConsumerDispatcher consumerDispatcher) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationMatches", (Object)new Object[]{this, destinationHandler, consumerDispatcher});
        }
        boolean bl2 = bl = this._destinationAttachedTo == destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationMatches", (Object)new Boolean(bl));
        }
        return bl;
    }

    public DestinationHandler getNamedDestination(ConsumerDispatcher consumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNamedDestination", (Object)consumerDispatcher);
            SibTr.exit((TraceComponent)tc, (String)"getNamedDestination", (Object)this._destinationAttachedTo);
        }
        return this._destinationAttachedTo;
    }

    protected Transaction getAutoCommitTransaction() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAutoCommitTransaction", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"getAutoCommitTransaction", (Object)this._autoCommitTransaction);
        }
        return this._autoCommitTransaction;
    }

    public SIBusMessage relockMessageUnderAsynchCursor() throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor");
        }
        this.checkNotClosed();
        SIBusMessage sIBusMessage = this._allLockedMessages.relockSavedMsg();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    private boolean addActiveMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addActiveMessage", (Object)new Object[]{new Integer(this._currentActiveMessages), new Integer(this._maxActiveMessages), new Boolean(this._consumerSuspended)});
        }
        if (this._maxActiveMessages != 0) {
            ++this._currentActiveMessages;
            if (this._currentActiveMessages >= this._maxActiveMessages && !this._consumerSuspended) {
                this._consumerSuspended = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addActiveMessage", (Object)new Boolean(this._consumerSuspended));
        }
        return this._consumerSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActiveMessages(int n) {
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeActiveMessages", (Object)new Object[]{new Integer(n), new Integer(this._currentActiveMessages), new Integer(this._maxActiveMessages), new Boolean(this._consumerSuspended), new Boolean(this._bifurcatable)});
            }
            boolean bl = false;
            if (this._bifurcatable) {
                LocalConsumerPoint localConsumerPoint = this;
                synchronized (localConsumerPoint) {
                    if (this._maxActiveMessages != 0) {
                        this._currentActiveMessages -= n;
                        if (this._consumerSuspended && this._currentActiveMessages < this._maxActiveMessages && !this._retryTimerSuspend) {
                            this._consumerSuspended = false;
                            if (!(this._stopped || this._closing || this._asynchConsumer.isAsynchConsumerRunning())) {
                                bl = true;
                            }
                        }
                    }
                }
            }
            if (bl) {
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, false));
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.removeActiveMessages", (String)"1:3680:1.236", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                    if (!tc.isEntryEnabled()) break block12;
                    SibTr.exit((TraceComponent)tc, (String)"removeActiveMessages", (Object)interruptedException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeActiveMessages");
        }
    }

    public boolean isCountingActiveMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isCountingActiveMessages");
            SibTr.exit((TraceComponent)tc, (String)"isCountingActiveMessages", (Object)new Boolean(this._maxActiveMessages != 0));
        }
        return this._maxActiveMessages != 0;
    }

    public int getMaxActiveMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxActiveMessages");
            SibTr.exit((TraceComponent)tc, (String)"getMaxActiveMessages", (Object)new Integer(this._maxActiveMessages));
        }
        return this._maxActiveMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActiveMessages(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMaxActiveMessages", (Object)new Integer(n));
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            if (n > this._maxActiveMessages && n < this._currentActiveMessages) {
                if (this._consumerSuspended) {
                    this._consumerSuspended = false;
                }
            } else if (n <= this._currentActiveMessages && !this._consumerSuspended) {
                this._consumerSuspended = true;
            }
            this._maxActiveMessages = n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaxActiveMessages");
        }
    }

    protected void cleanupBifurcatedConsumer(BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupBifurcatedConsumer", (Object)bifurcatedConsumerSessionImpl);
        }
        this._allLockedMessages.cleanOutBifurcatedMessages(bifurcatedConsumerSessionImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupBifurcatedConsumer");
        }
    }

    public void beforeCompletion(Transaction transaction) {
    }

    public void afterCompletion(Transaction transaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, new Boolean(bl)});
        }
        this.removeActiveMessages(1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeConsumer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resumeConsumer", (Object)this);
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            if (this._retryTimerSuspend) {
                this._retryTimerSuspend = false;
                if (!this._activeMessageSuspend) {
                    this._consumerSuspended = false;
                    if (!this._stopped && !this._closing) {
                        if (this._asynchConsumerRegistered) {
                            try {
                                this._messageProcessor.startNewThread(new AsynchThread(this, false));
                            }
                            catch (InterruptedException interruptedException) {
                                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.resumeConsumer", (String)"1:3842:1.236", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                                if (tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"resumeConsumer", (Object)interruptedException);
                                }
                            }
                        } else {
                            this.notify();
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resumeConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendConsumer() {
        ConsumerKeyGroup consumerKeyGroup;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"suspendConsumer", (Object)this);
        }
        if ((consumerKeyGroup = this._keyGroup) != null) {
            ConsumerKeyGroup consumerKeyGroup2 = consumerKeyGroup;
            synchronized (consumerKeyGroup2) {
                LocalConsumerPoint localConsumerPoint = this;
                synchronized (localConsumerPoint) {
                    this._consumerSuspended = true;
                    this._retryTimerSuspend = true;
                    this.unsetReady();
                }
            }
        }
        LocalConsumerPoint localConsumerPoint = this;
        synchronized (localConsumerPoint) {
            this._consumerSuspended = true;
            this._retryTimerSuspend = true;
            this.unsetReady();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"suspendConsumer");
        }
    }

    public void registerMediationStoppedEventListener(StoppedEventListener stoppedEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerMediationStoppedEventListener", (Object)stoppedEventListener);
        }
        if (this._allLockedMessages.getNumberOfLockedMessages() == 0) {
            stoppedEventListener.stopped();
        } else {
            this._mediationStoppedEventListener = stoppedEventListener;
            this._mediationStoppedEventListenerRegistered = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerMediationStoppedEventListener");
        }
    }

    public void unregisterMediationStoppedEventListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unregisterMediationStoppedEventListener");
        }
        this._mediationStoppedEventListener = null;
        this._mediationStoppedEventListenerRegistered = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unregisterMediationStoppedEventListener");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/LocalConsumerPoint.java, SIB.processor, WAS602.SIB, o0610.11 1.236");
        }
    }

    private class AsynchThread
    implements Runnable {
        private boolean _isolatedRun;
        private LocalConsumerPoint _localConsumerPoint;

        AsynchThread(LocalConsumerPoint localConsumerPoint2, boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AsynchThread", (Object)new Object[]{localConsumerPoint2, new Boolean(bl)});
            }
            this._localConsumerPoint = localConsumerPoint2;
            this._isolatedRun = bl;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AsynchThread", (Object)this);
            }
        }

        public void run() {
            block4: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)this);
                }
                try {
                    this._localConsumerPoint.runAsynchConsumer(this._isolatedRun);
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.LocalConsumerPoint.AsynchThread.run", (String)"1:2884:1.236", (Object)this);
                    if (!tc.isEntryEnabled()) break block4;
                    SibTr.exit((TraceComponent)tc, (String)"run", (Object)((Object)sIResourceException));
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

