/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPInputHandler;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.VirtualLinkControl;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.LinkSelection;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class LinkHandler
extends BaseDestinationHandler {
    private static final TraceComponent tc = SibTr.register((Class)LinkHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String _name;
    private SIBUuid12 _uuid;
    private String _busName;
    private String _outboundUserid = null;
    private String _inboundUserid = null;
    private String _type = null;
    private LinkManager _linkManager;
    private OutputHandler _lastKnownMEOutputHandler = null;

    public LinkHandler() {
    }

    public LinkHandler(VirtualLinkDefinition virtualLinkDefinition, MessageProcessor messageProcessor, SIMPItemStream sIMPItemStream, Transaction transaction, HashMap hashMap) throws SIResourceException {
        super(messageProcessor, sIMPItemStream, transaction, hashMap, messageProcessor.getMessagingEngineBus());
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkHandler", (Object)new Object[]{virtualLinkDefinition, messageProcessor, sIMPItemStream, transaction, hashMap});
        }
        this._name = virtualLinkDefinition.getName();
        this._uuid = virtualLinkDefinition.getUuid();
        this._outboundUserid = virtualLinkDefinition.getOutboundUserid();
        this._inboundUserid = virtualLinkDefinition.getInboundUserid();
        this._type = virtualLinkDefinition.getType();
        ForeignBusDefinition foreignBusDefinition = virtualLinkDefinition.getForeignBus();
        if (foreignBusDefinition == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_LINK_CONFIGURATION_ERROR_CWSIP0007", new Object[]{this._name, this._uuid}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.LinkHandler", (String)"1:227:1.88", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LinkHandler", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        this._busName = foreignBusDefinition.getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkHandler", (Object)this);
        }
    }

    public boolean isPubSub() {
        return false;
    }

    public boolean isLink() {
        return true;
    }

    protected void initializePtoPStats(ConsumerDispatcher consumerDispatcher) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"initializePtoPStats", (Object)consumerDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination");
        }
        LinkHandler linkHandler = this;
        synchronized (linkHandler) {
            bl = super.cleanupLocalisations();
            if (this.isToBeDeleted()) {
                this.messageProcessor.getProxyHandler().cleanupLinkNeighbour(this._busName);
                PtoPInputHandler ptoPInputHandler = (PtoPInputHandler)this.getInputHandler(ProtocolType.UNICASTINPUT, null, null);
                TargetStreamManager targetStreamManager = ptoPInputHandler.getTargetStreamManager();
                if (targetStreamManager.isEmpty()) {
                    bl = super.cleanupDestination();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._name);
        }
        return this._name;
    }

    public final SIBUuid12 getUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._uuid);
        }
        return this._uuid;
    }

    public SIBUuid8 getRemoteMEUuid() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEUuid");
        }
        LinkSelection linkSelection = null;
        SIBUuid8 sIBUuid8 = null;
        try {
            linkSelection = this._linkManager.select(this.getUuid());
        }
        catch (LinkException linkException) {
            FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.getRemoteMEUuid", (String)"1:359:1.88", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)linkException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)linkException);
            }
            throw new SIResourceException((Throwable)linkException);
        }
        sIBUuid8 = linkSelection == null ? null : linkSelection.getInboundMeUuid();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)sIBUuid8);
        }
        return sIBUuid8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocalisationSet(SIBUuid8 sIBUuid8, SIBUuid8 sIBUuid82) throws SIIncorrectCallException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalisationSet", (Object)new Object[]{sIBUuid8, sIBUuid82});
        }
        ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
        LinkHandler linkHandler = this;
        synchronized (linkHandler) {
            HashMap hashMap = this._xmitQueuePoints;
            synchronized (hashMap) {
                if (this._xmitQueuePoints.size() > 1 || this._xmitQueuePoints.size() > 0 && this._pToPLocalMsgsItemStream != null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet");
                    }
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:424:1.88"});
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:430:1.88"}, null));
                }
                PtoPMessageItemStream ptoPMessageItemStream = (PtoPMessageItemStream)this._deletedQueuePoints.get(sIBUuid8);
                if (ptoPMessageItemStream != null && !ptoPMessageItemStream.isInStore()) {
                    ptoPMessageItemStream = null;
                }
                if (this._xmitQueuePoints.size() == 0 && this._pToPLocalMsgsItemStream == null) {
                    if (ptoPMessageItemStream != null) {
                        ptoPMessageItemStream.unmarkAsToBeDeleted(externalLocalTransaction);
                        this._deletedQueuePoints.remove(sIBUuid8);
                        this.attachPtoPLocalisation(ptoPMessageItemStream, true);
                        this.assignQueuePointOutputHandler(ptoPMessageItemStream.getOutputHandler(), sIBUuid8);
                    } else {
                        this.addNewPtoPLocalisation(true, externalLocalTransaction, sIBUuid8, null, true);
                    }
                } else {
                    Object object;
                    PtoPMessageItemStream ptoPMessageItemStream2;
                    if (this._pToPLocalMsgsItemStream != null) {
                        ptoPMessageItemStream2 = this._pToPLocalMsgsItemStream;
                    } else {
                        object = this._xmitQueuePoints.values().iterator();
                        ptoPMessageItemStream2 = (PtoPMessageItemStream)object.next();
                    }
                    SIBUuid8 sIBUuid83 = ptoPMessageItemStream2.getMessagingEngineUuid();
                    if (!sIBUuid83.equals((Object)sIBUuid8) && !sIBUuid8.toString().equals("0000000000000001")) {
                        if (sIBUuid83.equals((Object)new SIBUuid8("0000000000000001")) && !sIBUuid8.equals((Object)this.messageProcessor.getMessagingEngineUuid())) {
                            ptoPMessageItemStream2.replaceUuid(sIBUuid8, externalLocalTransaction);
                            this._xmitQueuePoints.put(sIBUuid8, ptoPMessageItemStream2);
                            this._xmitQueuePoints.remove(sIBUuid83);
                            object = (PtoPOutputHandler)ptoPMessageItemStream2.getOutputHandler();
                            if (sIBUuid82 != null) {
                                ((PtoPOutputHandler)object).updateRoutingCellule(new MessagingEngine(sIBUuid82));
                            }
                            ((PtoPOutputHandler)object).updateTargetCellule(new MessagingEngine(sIBUuid8));
                            HashMap hashMap2 = this._queuePointOutputHandlers;
                            synchronized (hashMap2) {
                                this._queuePointOutputHandlers.put(sIBUuid8, object);
                                this._queuePointOutputHandlers.remove(sIBUuid83);
                            }
                        } else {
                            if (ptoPMessageItemStream != null) {
                                ptoPMessageItemStream.unmarkAsToBeDeleted(externalLocalTransaction);
                                this._deletedQueuePoints.remove(sIBUuid8);
                                this._xmitQueuePoints.put(ptoPMessageItemStream.getMessagingEngineUuid(), ptoPMessageItemStream);
                                this.assignQueuePointOutputHandler(ptoPMessageItemStream.getOutputHandler(), sIBUuid8);
                            } else {
                                this.addNewPtoPLocalisation(true, externalLocalTransaction, sIBUuid8, null, true);
                            }
                            this._postMediatedItemStreamsRequiringCleanup.put(sIBUuid83, ptoPMessageItemStream2);
                            externalLocalTransaction.registerCallback(new BaseDestinationHandler.LocalizationRemoveTransactionCallback(ptoPMessageItemStream2));
                            ptoPMessageItemStream2.markAsToBeDeleted(externalLocalTransaction);
                            this._deletedQueuePoints.put(sIBUuid83, ptoPMessageItemStream2);
                            this.destinationManager.markDestinationAsCleanUpPending(this);
                        }
                    }
                }
            }
            externalLocalTransaction.commit();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet");
        }
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap hashMap = new HashMap();
            this.addPersistentLinkData(hashMap);
            objectOutputStream.writeObject(hashMap);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.getPersistentData", (String)"1:606:1.88", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:613:1.88", iOException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:623:1.88", iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void addPersistentLinkData(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentLinkData", (Object)hashMap);
        }
        hashMap.put("uuid", this._uuid.toByteArray());
        hashMap.put("name", this._name);
        hashMap.put("busName", this._busName);
        hashMap.put("hasLocal", new Boolean(this.hasLocal()));
        hashMap.put("type", this._type);
        hashMap.put("inboundUserid", this._inboundUserid);
        hashMap.put("outboundUserid", this._outboundUserid);
        hashMap.put("TBD", new Boolean(this.isToBeDeleted()));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentLinkData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            this.restorePersistentLinkData(hashMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.restore", (String)"1:692:1.88", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:699:1.88", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:709:1.88", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void restorePersistentLinkData(HashMap hashMap) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentLinkData", (Object)new Object[]{hashMap});
        }
        this._name = (String)hashMap.get("name");
        this._busName = (String)hashMap.get("busName");
        this._uuid = new SIBUuid12((byte[])hashMap.get("uuid"));
        if (((Boolean)hashMap.get("hasLocal")).booleanValue()) {
            this.setLocal();
        }
        this._type = (String)hashMap.get("type");
        this._inboundUserid = (String)hashMap.get("inboundUserid");
        this._outboundUserid = (String)hashMap.get("outboundUserid");
        if (((Boolean)hashMap.get("TBD")).booleanValue()) {
            this.setToBeDeleted(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentLinkData");
        }
    }

    public void updateUuid(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateUuid", (Object)sIBUuid12);
        }
        this._uuid = sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateUuid");
        }
    }

    public void updateLinkDefinition(VirtualLinkDefinition virtualLinkDefinition, ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLinkDefinition", (Object)virtualLinkDefinition);
        }
        this._outboundUserid = virtualLinkDefinition.getOutboundUserid();
        this._inboundUserid = virtualLinkDefinition.getInboundUserid();
        ForeignBusDefinition foreignBusDefinition = virtualLinkDefinition.getForeignBus();
        if (foreignBusDefinition != null && !this._busName.equals(foreignBusDefinition.getName())) {
            this.setCorrupt(true);
        }
        try {
            this.requestUpdate(externalLocalTransaction);
        }
        catch (MessageStoreException messageStoreException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLinkDefinition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputHandler choosePtoPOutputHandler(JsDestinationAddress jsDestinationAddress, boolean bl, SIBUuid8 sIBUuid8, boolean bl2, boolean bl3) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)new Object[]{jsDestinationAddress, new Boolean(bl), sIBUuid8, new Boolean(bl2), new Boolean(bl3)});
        }
        OutputHandler outputHandler = null;
        LinkSelection linkSelection = null;
        if (this._pToPLocalMsgsItemStream != null) {
            outputHandler = this.getLocalPtoPConsumerDispatcher();
            outputHandler.setWLMGuess(false);
        } else {
            HashMap hashMap = this._xmitQueuePoints;
            synchronized (hashMap) {
                try {
                    linkSelection = this._linkManager.select(this.getUuid());
                }
                catch (LinkException linkException) {
                    FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.choosePtoPOutputHandler", (String)"1:850:1.88", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)linkException);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)linkException);
                    }
                    throw new SIResourceException((Throwable)linkException);
                }
            }
            if (linkSelection == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Link not available in WLM");
                }
                if (this._lastKnownMEOutputHandler == null) {
                    hashMap = new SIBUuid8("0000000000000001");
                    try {
                        this.updateLocalisationSet((SIBUuid8)hashMap, null);
                    }
                    catch (SIIncorrectCallException sIIncorrectCallException) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)"SIResourceException");
                        }
                        throw new SIResourceException((Throwable)sIIncorrectCallException);
                    }
                }
                outputHandler = this._lastKnownMEOutputHandler;
                outputHandler.setWLMGuess(true);
            } else {
                hashMap = linkSelection.getInboundMeUuid();
                Object object = linkSelection.getOutboundMeUuid();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("InboundMeUuid is " + hashMap + " OutboundMeUuid is  " + object));
                }
                if (hashMap == null) {
                    hashMap = linkSelection.getOutboundMeUuid();
                }
                HashMap hashMap2 = this._queuePointOutputHandlers;
                synchronized (hashMap2) {
                    outputHandler = (OutputHandler)this._queuePointOutputHandlers.get(hashMap);
                }
                if (outputHandler == null) {
                    try {
                        this.updateLocalisationSet((SIBUuid8)hashMap, (SIBUuid8)object);
                    }
                    catch (SIIncorrectCallException sIIncorrectCallException) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)"SIResourceException");
                        }
                        throw new SIResourceException((Throwable)sIIncorrectCallException);
                    }
                    hashMap2 = this._queuePointOutputHandlers;
                    synchronized (hashMap2) {
                        outputHandler = (OutputHandler)this._queuePointOutputHandlers.get(hashMap);
                    }
                }
                outputHandler.setWLMGuess(false);
                if (object != null) {
                    if (object.equals((Object)this.messageProcessor.getMessagingEngineUuid())) {
                        object = hashMap;
                    }
                    ((PtoPOutputHandler)outputHandler).updateRoutingCellule(new MessagingEngine((SIBUuid8)object));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)outputHandler);
        }
        return outputHandler;
    }

    void assignQueuePointOutputHandler(OutputHandler outputHandler, SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assignQueuePointOutputHandler", (Object)new Object[]{outputHandler, sIBUuid8});
        }
        super.assignQueuePointOutputHandler(outputHandler, sIBUuid8);
        this._lastKnownMEOutputHandler = outputHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assignQueuePointOutputHandler");
        }
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new VirtualLinkControl(this.messageProcessor, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    void initializeNonPersistent(MessageProcessor messageProcessor, HashMap hashMap, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)new Object[]{messageProcessor, hashMap, transaction});
        }
        super.initializeNonPersistent(messageProcessor, hashMap, transaction);
        this._linkManager = messageProcessor.getLinkManager();
        DestinationDefinition destinationDefinition = messageProcessor.createDestinationDefinition(DestinationType.QUEUE, this._name);
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        this.updateDefinition((BaseDestinationDefinition)destinationDefinition);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    void registerDestination() {
    }

    void deregisterDestination() {
    }

    public String getType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType");
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)this._type);
        }
        return this._type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getXmitQueueIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getXmitQueueIterator");
        }
        Iterator iterator = null;
        HashMap hashMap = this._xmitQueuePoints;
        synchronized (hashMap) {
            iterator = ((HashMap)this._xmitQueuePoints.clone()).values().iterator();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getXmitQueueIterator", iterator);
        }
        return iterator;
    }

    public String getInboundUserid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInboundUserid");
            SibTr.exit((TraceComponent)tc, (String)"getInboundUserid", (Object)this._inboundUserid);
        }
        return this._inboundUserid;
    }

    public String getOutboundUserid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOutboundUserid");
            SibTr.exit((TraceComponent)tc, (String)"getOutboundUserid", (Object)this._outboundUserid);
        }
        return this._outboundUserid;
    }

    public String getBusName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusName");
            SibTr.exit((TraceComponent)tc, (String)"getBusName", (Object)this._busName);
        }
        return this._busName;
    }

    void updateTrmAdvertisements() {
    }

    public void updateGetRegistration(boolean bl) {
    }

    public void updatePostRegistration(boolean bl) {
    }

    public void updatePreRegistration(boolean bl) {
    }

    public void requestReallocation() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestReallocation");
        }
        this._isToBeReallocated = true;
        this.destinationManager.getLinkIndex().cleanup(this);
        this.destinationManager.startAsynchDeletion();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestReallocation", (Object)new Boolean(this._isToBeReallocated));
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/LinkHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.88");
        }
    }
}

