/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPLimitExceededException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.ReportHandler;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.Properties;

public class ExceptionDestinationHandlerImpl
implements ExceptionDestinationHandler {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)ExceptionDestinationHandlerImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DestinationHandler _originalDestination;
    private String _exceptionDestinationName;
    private InputHandler _inputHandler = null;
    private DestinationHandler _exceptionDestination;
    private MessageProcessor _messageProcessor;
    private static String _defaultExceptionDestinationName;
    private ReportHandler _reportHandler = null;

    private static String constructDefaultExceptionDestinationName(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"constructDefaultExceptionDestinationName", (Object)string);
        }
        String string2 = "_SYSTEM.Exception.Destination." + string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"constructDefaultExceptionDestinationName", (Object)string2);
        }
        return string2;
    }

    public static String getDefaultExceptionDestinationName(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultExceptionDestinationName", (Object)string);
        }
        if (_defaultExceptionDestinationName == null) {
            _defaultExceptionDestinationName = ExceptionDestinationHandlerImpl.constructDefaultExceptionDestinationName(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultExceptionDestinationName", (Object)_defaultExceptionDestinationName);
        }
        return _defaultExceptionDestinationName;
    }

    public ExceptionDestinationHandlerImpl(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)destinationHandler);
        }
        this._originalDestination = destinationHandler;
        this._messageProcessor = destinationHandler.getMessageProcessor();
        String string = this._messageProcessor.getMessagingEngineName();
        this._exceptionDestinationName = _defaultExceptionDestinationName = ExceptionDestinationHandlerImpl.getDefaultExceptionDestinationName(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)this);
        }
    }

    public ExceptionDestinationHandlerImpl(String string, MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)new Object[]{string, messageProcessor});
        }
        this._messageProcessor = messageProcessor;
        this.setDestination(string);
        String string2 = this._messageProcessor.getMessagingEngineName();
        this._exceptionDestinationName = _defaultExceptionDestinationName = ExceptionDestinationHandlerImpl.getDefaultExceptionDestinationName(string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)this);
        }
    }

    public void setDestination(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestination", (Object)destinationHandler);
        }
        this._originalDestination = destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestination");
        }
    }

    public void setDestination(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestination", (Object)this._originalDestination);
        }
        if (string != null) {
            try {
                this._originalDestination = this._messageProcessor.getDestinationManager().getDestination(string, true);
            }
            catch (SIException sIException) {
                SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{"of " + string, this._messageProcessor.getMessagingEngineName()});
                this._originalDestination = null;
            }
        } else {
            this._originalDestination = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestination");
        }
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage sIMPMessage, Transaction transaction, int n, String[] stringArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{sIMPMessage, transaction, stringArray, new Integer(n), new Boolean(bl)});
        }
        UndeliverableReturnCode undeliverableReturnCode = this.handleUndeliverableMessage(sIMPMessage, null, transaction, n, stringArray, this._messageProcessor.getMECellule(), bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)undeliverableReturnCode);
        }
        return undeliverableReturnCode;
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage sIMPMessage, Transaction transaction, int n, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{sIMPMessage, transaction, stringArray, new Integer(n)});
        }
        UndeliverableReturnCode undeliverableReturnCode = this.handleUndeliverableMessage(sIMPMessage, null, transaction, n, stringArray, this._messageProcessor.getMECellule(), false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)undeliverableReturnCode);
        }
        return undeliverableReturnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage sIMPMessage, String string, Transaction transaction, int n, String[] stringArray, Cellule cellule, boolean bl) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{sIMPMessage, string, transaction, stringArray, new Integer(n), cellule, new Boolean(bl)});
        }
        boolean bl2 = false;
        boolean bl3 = false;
        UndeliverableReturnCode undeliverableReturnCode = UndeliverableReturnCode.OK;
        ExternalLocalTransaction externalLocalTransaction = null;
        if (!(bl || (undeliverableReturnCode = this.checkMessage(sIMPMessage)) != UndeliverableReturnCode.BLOCK && undeliverableReturnCode != UndeliverableReturnCode.ERROR)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)undeliverableReturnCode);
            }
            return undeliverableReturnCode;
        }
        if (undeliverableReturnCode != UndeliverableReturnCode.DISCARD) {
            object = null;
            try {
                object = sIMPMessage.getMessage().getReceived();
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:538:1.102.1.2", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                }
                return UndeliverableReturnCode.ERROR;
            }
            object = this.setMessageProperties((JsMessage)object, n, stringArray);
            String string2 = null;
            if (this._originalDestination != null) {
                string2 = this._originalDestination.getExceptionDestination();
                if (string2 == null) {
                    string2 = _defaultExceptionDestinationName;
                    bl3 = true;
                } else if (string2.equals(_defaultExceptionDestinationName)) {
                    bl3 = true;
                }
            } else {
                string2 = _defaultExceptionDestinationName;
                bl3 = true;
            }
            String string3 = this._exceptionDestinationName;
            synchronized (string3) {
                Object object2;
                Object object3;
                if (this._inputHandler == null || !string2.equals(this._exceptionDestination)) {
                    this._exceptionDestinationName = string2;
                    try {
                        this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                        if (this._messageProcessor.isBusSecure() && !((AccessResult)(object3 = this.checkExceptionDestinationAccess((JsMessage)object, null, string, bl3))).isAllowed()) {
                            this.handleAccessDenied((AccessResult)object3, (JsMessage)object, string);
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.BLOCK);
                            }
                            return UndeliverableReturnCode.BLOCK;
                        }
                        object.setPriority(this._exceptionDestination.getDefaultPriority());
                        this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMECellule(), null);
                    }
                    catch (SIException sIException) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        if (bl3) {
                            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:673:1.102.1.2", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:679:1.102.1.2", sIException, this._exceptionDestinationName});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                            }
                            return UndeliverableReturnCode.ERROR;
                        }
                        SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                        this._exceptionDestinationName = _defaultExceptionDestinationName;
                        try {
                            this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                            if (this._messageProcessor.isBusSecure() && !((AccessResult)(object2 = this.checkExceptionDestinationAccess((JsMessage)object, null, string, true))).isAllowed()) {
                                this.handleAccessDenied((AccessResult)object2, (JsMessage)object, string);
                                if (tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.BLOCK);
                                }
                                return UndeliverableReturnCode.BLOCK;
                            }
                            object.setPriority(this._exceptionDestination.getDefaultPriority());
                            this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMECellule(), null);
                            bl3 = true;
                        }
                        catch (SIException sIException2) {
                            FFDCFilter.processException((Throwable)sIException2, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:749:1.102.1.2", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:756:1.102.1.2", sIException2, this._exceptionDestinationName});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                            }
                            return UndeliverableReturnCode.ERROR;
                        }
                    }
                }
                bl2 = false;
                object3 = new MessageItem((JsMessage)object);
                ((MessageItem)object3).setRequiresNewId(sIMPMessage.getRequiresNewId());
                while (!bl2) {
                    try {
                        ((MessageItem)object3).setTransacted(sIMPMessage.isTransacted());
                        ((MessageItem)object3).setStoreAtSendTime(sIMPMessage.isToBeStoredAtSendTime());
                        object2 = null;
                        if (transaction == null) {
                            externalLocalTransaction = this._exceptionDestination.getTxManager().createLocalTransaction();
                            object2 = externalLocalTransaction;
                        } else {
                            object2 = transaction;
                        }
                        boolean bl4 = bl && bl3;
                        ((MessageItem)object3).setForcePut(bl4);
                        this._inputHandler.handleMessage((MessageItem)object3, (Transaction)object2, ((MessageItem)object3).getDestinationAddress(), cellule);
                        JsMessagingEngine jsMessagingEngine = this._messageProcessor.getMessagingEngine();
                        if (jsMessagingEngine.isEventNotificationEnabled() || UserTrace.tc_mt.isDebugEnabled()) {
                            String string4 = null;
                            String string5 = null;
                            if (sIMPMessage.getMessage() instanceof JsApiMessage) {
                                string4 = ((JsApiMessage)sIMPMessage.getMessage()).getApiMessageId();
                                string5 = ((JsApiMessage)sIMPMessage.getMessage()).getCorrelationId();
                            } else {
                                if (sIMPMessage.getMessage().getApiMessageIdAsBytes() != null) {
                                    string4 = new String(sIMPMessage.getMessage().getApiMessageIdAsBytes());
                                }
                                if (sIMPMessage.getMessage().getCorrelationIdAsBytes() != null) {
                                    string5 = new String(sIMPMessage.getMessage().getCorrelationIdAsBytes());
                                }
                            }
                            if (UserTrace.tc_mt.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_EXCEPTION_DESTINATIONED_CWSJU0012", new Object[]{string4, sIMPMessage.getMessage().getSystemMessageId(), string5, this._exceptionDestinationName, new Integer(n), sIMPMessage.getMessage().getExceptionMessage()}, null));
                            }
                            if (jsMessagingEngine.isEventNotificationEnabled()) {
                                this.fireMessageExceptionedEvent(string4, sIMPMessage, n);
                            }
                        }
                        bl2 = true;
                    }
                    catch (SIException sIException) {
                        if (!bl3) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                            this._exceptionDestinationName = _defaultExceptionDestinationName;
                            try {
                                this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                                object.setPriority(this._exceptionDestination.getDefaultPriority());
                                this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMECellule(), null);
                                bl3 = true;
                                continue;
                            }
                            catch (SIException sIException3) {
                                FFDCFilter.processException((Throwable)sIException3, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:890:1.102.1.2", (Object)this);
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:901:1.102.1.2", sIException3, this._exceptionDestinationName});
                                if (tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                                }
                                return UndeliverableReturnCode.ERROR;
                            }
                        }
                        if (sIException instanceof SIMPLimitExceededException) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.BLOCK);
                            }
                            return UndeliverableReturnCode.BLOCK;
                        }
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:930:1.102.1.2", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:935:1.102.1.2", sIException, this._exceptionDestinationName});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                        }
                        return UndeliverableReturnCode.ERROR;
                    }
                }
            }
        }
        if (sIMPMessage.getMessage().getReportException() != null) {
            if (this._reportHandler == null) {
                this._reportHandler = new ReportHandler(this._messageProcessor);
            }
            object = null;
            object = transaction == null ? externalLocalTransaction : transaction;
            try {
                this._reportHandler.handleMessage(sIMPMessage, (Transaction)object, SIApiConstants.REPORT_EXCEPTION);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:977:1.102.1.2", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_ERROR_CWSIP0295", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                }
                return UndeliverableReturnCode.ERROR;
            }
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.commit();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:1004:1.102.1.2", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1009:1.102.1.2", sIException, this._exceptionDestinationName});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                }
                return UndeliverableReturnCode.ERROR;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.OK);
        }
        return UndeliverableReturnCode.OK;
    }

    private boolean isBlockRequired(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isBlockRequired", (Object)sIMPMessage);
        }
        boolean bl = false;
        if (this._originalDestination != null) {
            JsMessage jsMessage;
            BaseDestinationHandler baseDestinationHandler;
            if (this._originalDestination.getExceptionDestination() == null) {
                bl = true;
            }
            if ((baseDestinationHandler = this._originalDestination.getResolvedDestinationHandler()).isMediated() && !(jsMessage = sIMPMessage.getMessage()).isMediated() && !baseDestinationHandler.isMediatedLocally()) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isBlockRequired", (Object)new Boolean(bl));
        }
        return bl;
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIBusMessage sIBusMessage, String string, Transaction transaction, int n, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{sIBusMessage, string, transaction, new Integer(n), stringArray});
        }
        UndeliverableReturnCode undeliverableReturnCode = this.handleUndeliverableMessage(new MessageItem((JsMessage)sIBusMessage), string, transaction, n, stringArray, this._messageProcessor.getMECellule(), false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)undeliverableReturnCode);
        }
        return undeliverableReturnCode;
    }

    private JsMessage setMessageProperties(JsMessage jsMessage, int n, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageProperties", (Object)new Object[]{jsMessage, new Integer(n), stringArray});
        }
        jsMessage.setExceptionReason(n);
        jsMessage.setExceptionInserts(stringArray);
        jsMessage.setExceptionTimestamp(System.currentTimeMillis());
        jsMessage.setReportCOA(null);
        jsMessage.setReportCOD(null);
        jsMessage.setReportException(null);
        jsMessage.setReportExpiry(null);
        jsMessage.setReportNAN(null);
        jsMessage.setReportPAN(null);
        jsMessage.setForwardRoutingPath(null);
        jsMessage.setMediated(false);
        if (this._originalDestination != null) {
            jsMessage.setExceptionProblemDestination(this._originalDestination.getName());
        } else {
            jsMessage.setExceptionProblemDestination(null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageProperties", (Object)jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToExceptionDestination(SIBusMessage sIBusMessage, String string, Transaction transaction, int n, ConnectionImpl connectionImpl, String[] stringArray) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)new Object[]{sIBusMessage, string, transaction, new Integer(n), connectionImpl, stringArray});
        }
        boolean bl = false;
        boolean bl2 = false;
        ExternalLocalTransaction externalLocalTransaction = null;
        MessageItem messageItem = new MessageItem((JsMessage)sIBusMessage);
        UndeliverableReturnCode undeliverableReturnCode = this.checkMessage(messageItem);
        if (undeliverableReturnCode == UndeliverableReturnCode.BLOCK) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)undeliverableReturnCode);
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1232:1.102.1.2", undeliverableReturnCode});
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1239:1.102.1.2", undeliverableReturnCode}, null));
        }
        if (undeliverableReturnCode != UndeliverableReturnCode.DISCARD) {
            object = null;
            try {
                object = messageItem.getMessage().getReceived();
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1258:1.102.1.2", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)messageCopyFailedException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1267:1.102.1.2", messageCopyFailedException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1275:1.102.1.2", messageCopyFailedException}, null), (Throwable)messageCopyFailedException);
            }
            object = this.setMessageProperties((JsMessage)object, n, stringArray);
            String string2 = null;
            if (this._originalDestination != null) {
                string2 = this._originalDestination.getExceptionDestination();
                if (string2.equals(_defaultExceptionDestinationName)) {
                    bl2 = true;
                }
            } else {
                string2 = _defaultExceptionDestinationName;
                bl2 = true;
            }
            String string3 = this._exceptionDestinationName;
            synchronized (string3) {
                Object object2;
                Object object3;
                if (this._inputHandler == null || !string2.equals(this._exceptionDestination)) {
                    this._exceptionDestinationName = string2;
                    try {
                        this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                        if (this._messageProcessor.isBusSecure() && !((AccessResult)(object3 = this.checkExceptionDestinationAccess((JsMessage)object, connectionImpl, string, bl2))).isAllowed()) {
                            this.handleAccessDenied((AccessResult)object3, (JsMessage)object, string);
                            undeliverableReturnCode = UndeliverableReturnCode.BLOCK;
                        }
                        object.setPriority(this._exceptionDestination.getDefaultPriority());
                        this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMECellule(), null);
                    }
                    catch (SIException sIException) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        if (bl2) {
                            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1402:1.102.1.2", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1408:1.102.1.2", sIException, this._exceptionDestinationName});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)sIException));
                            }
                            throw new SIErrorException((Throwable)sIException);
                        }
                        SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                        this._exceptionDestinationName = _defaultExceptionDestinationName;
                        try {
                            this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                            if (this._messageProcessor.isBusSecure() && !((AccessResult)(object2 = this.checkExceptionDestinationAccess((JsMessage)object, connectionImpl, string, true))).isAllowed()) {
                                this.handleAccessDenied((AccessResult)object2, (JsMessage)object, string);
                                undeliverableReturnCode = UndeliverableReturnCode.BLOCK;
                            }
                            object.setPriority(this._exceptionDestination.getDefaultPriority());
                            this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMECellule(), null);
                            bl2 = true;
                        }
                        catch (SIException sIException2) {
                            FFDCFilter.processException((Throwable)sIException2, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1477:1.102.1.2", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException2));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1485:1.102.1.2", sIException2, this._exceptionDestinationName});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)sIException2));
                            }
                            throw new SIErrorException((Throwable)sIException2);
                        }
                    }
                }
                if (undeliverableReturnCode == UndeliverableReturnCode.BLOCK) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)undeliverableReturnCode);
                    }
                    throw new SINotAuthorizedException(nls.getFormattedMessage("EXCEPTION_DESTINATION_AUTH_ERROR_SIMP0314", new Object[]{this._exceptionDestinationName, object.getSecurityUserid()}, null));
                }
                bl = false;
                object3 = new MessageItem((JsMessage)object);
                while (!bl) {
                    try {
                        ((MessageItem)object3).setTransacted(messageItem.isTransacted());
                        ((MessageItem)object3).setStoreAtSendTime(messageItem.isToBeStoredAtSendTime());
                        object2 = null;
                        if (transaction == null) {
                            externalLocalTransaction = this._exceptionDestination.getTxManager().createLocalTransaction();
                            object2 = externalLocalTransaction;
                        } else {
                            object2 = transaction;
                        }
                        this._inputHandler.handleMessage((MessageItem)object3, (Transaction)object2, ((MessageItem)object3).getDestinationAddress(), this._messageProcessor.getMECellule());
                        JsMessagingEngine jsMessagingEngine = this._messageProcessor.getMessagingEngine();
                        if (jsMessagingEngine.isEventNotificationEnabled() || UserTrace.tc_mt.isDebugEnabled()) {
                            String string4 = null;
                            if (messageItem.getMessage() instanceof JsApiMessage) {
                                string4 = ((JsApiMessage)messageItem.getMessage()).getApiMessageId();
                            } else if (messageItem.getMessage().getApiMessageIdAsBytes() != null) {
                                string4 = messageItem.getMessage().getApiMessageIdAsBytes().toString();
                            }
                            if (UserTrace.tc_mt.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_EXCEPTION_DESTINATIONED_CWSJU0012", new Object[]{string4, messageItem.getMessage().getSystemMessageId(), this._exceptionDestinationName, new Integer(n), messageItem.getMessage().getExceptionMessage()}, null));
                            }
                            if (jsMessagingEngine.isEventNotificationEnabled()) {
                                this.fireMessageExceptionedEvent(string4, messageItem, n);
                            }
                        }
                        bl = true;
                    }
                    catch (SIException sIException) {
                        if (!bl2) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                            this._exceptionDestinationName = _defaultExceptionDestinationName;
                            try {
                                this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                                object.setPriority(this._exceptionDestination.getDefaultPriority());
                                this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMECellule(), null);
                                bl2 = true;
                                continue;
                            }
                            catch (SIException sIException3) {
                                FFDCFilter.processException((Throwable)sIException3, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1616:1.102.1.2", (Object)this);
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1627:1.102.1.2", sIException3, this._exceptionDestinationName});
                                if (tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)sIException3));
                                }
                                throw new SIErrorException((Throwable)sIException3);
                            }
                        }
                        if (sIException instanceof SIMPLimitExceededException) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)UndeliverableReturnCode.BLOCK);
                            }
                            throw (SIMPLimitExceededException)((Object)sIException);
                        }
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1655:1.102.1.2", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1661:1.102.1.2", sIException, this._exceptionDestinationName});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)sIException));
                        }
                        throw new SIErrorException((Throwable)sIException);
                    }
                }
            }
        }
        if (messageItem.getMessage().getReportException() != null) {
            if (this._reportHandler == null) {
                this._reportHandler = new ReportHandler(this._messageProcessor);
            }
            object = transaction == null ? externalLocalTransaction : transaction;
            try {
                this._reportHandler.handleMessage(messageItem, (Transaction)object, SIApiConstants.REPORT_EXCEPTION);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1705:1.102.1.2", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_ERROR_CWSIP0295", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)sIException));
                }
                throw new SIResourceException((Throwable)sIException);
            }
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.commit();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1733:1.102.1.2", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.sendToExceptionDestination", "1:1738:1.102.1.2", sIException, this._exceptionDestinationName});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)UndeliverableReturnCode.ERROR);
                }
                throw new SIResourceException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination");
        }
    }

    private UndeliverableReturnCode checkMessage(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkMessage", (Object)sIMPMessage);
        }
        UndeliverableReturnCode undeliverableReturnCode = UndeliverableReturnCode.OK;
        if (sIMPMessage.getReliability().equals(Reliability.BEST_EFFORT_NONPERSISTENT)) {
            undeliverableReturnCode = UndeliverableReturnCode.DISCARD;
        } else if (this._originalDestination != null && this._originalDestination.isTemporary()) {
            undeliverableReturnCode = UndeliverableReturnCode.DISCARD;
        } else if (Boolean.TRUE.equals(sIMPMessage.getMessage().getReportDiscardMsg())) {
            undeliverableReturnCode = UndeliverableReturnCode.DISCARD;
        } else if (this.isBlockRequired(sIMPMessage)) {
            undeliverableReturnCode = UndeliverableReturnCode.BLOCK;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkMessage", (Object)undeliverableReturnCode);
        }
        return undeliverableReturnCode;
    }

    private AccessResult checkExceptionDestinationAccess(JsMessage jsMessage, ConnectionImpl connectionImpl, String string, boolean bl) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)new Object[]{jsMessage, connectionImpl, string, new Boolean(bl)});
        }
        SecurityContext securityContext = new SecurityContext(jsMessage, string, null, this._messageProcessor.getAuthorisationUtils());
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            if (connectionImpl != null) {
                object = new SecurityContext(connectionImpl.getSecuritySubject(), string, null, this._messageProcessor.getAuthorisationUtils());
                if (string != null && !this._messageProcessor.getAccessChecker().checkDestinationAccess((SecurityContext)object, null, "_SYSTEM.Exception.Destination", OperationType.IDENTITY_ADOPTER)) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)"not authorized to perform alternate user checks on this destination");
                    }
                    bl2 = false;
                    bl3 = false;
                }
                if (bl2 && !this._messageProcessor.getAccessChecker().checkDestinationAccess((SecurityContext)object, null, "_SYSTEM.Exception.Destination", OperationType.SEND)) {
                    bl2 = false;
                }
            } else if (!this._messageProcessor.getAccessChecker().checkDestinationAccess(securityContext, null, "_SYSTEM.Exception.Destination", OperationType.SEND)) {
                bl2 = false;
            }
        } else if (connectionImpl != null) {
            object = new SecurityContext(connectionImpl.getSecuritySubject(), string, null, this._messageProcessor.getAuthorisationUtils());
            if (string != null && !this._exceptionDestination.checkDestinationAccess((SecurityContext)object, OperationType.IDENTITY_ADOPTER)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)"not authorized to perform alternate user checks on this destination");
                }
                bl2 = false;
                bl3 = false;
            }
            if (bl2 && !this._exceptionDestination.checkDestinationAccess((SecurityContext)object, OperationType.SEND)) {
                bl2 = false;
            }
        } else if (!this._exceptionDestination.checkDestinationAccess(securityContext, OperationType.SEND)) {
            bl2 = false;
        }
        object = new AccessResult(bl2, bl3);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)object);
        }
        return object;
    }

    private void handleAccessDenied(AccessResult accessResult, JsMessage jsMessage, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleAccessDenied", (Object)new Object[]{accessResult, jsMessage, string});
        }
        String string2 = null;
        OperationType operationType = null;
        if (accessResult.didIdentityAdoptionFail()) {
            string2 = jsMessage.getSecurityUserid();
            operationType = OperationType.IDENTITY_ADOPTER;
        } else {
            operationType = OperationType.SEND;
            string2 = string != null ? string : jsMessage.getSecurityUserid();
        }
        String string3 = nls.getFormattedMessage("USER_NOT_AUTH_EXCEPTION_DEST_ERROR_CWSIP0313", new Object[]{string2, this._exceptionDestinationName}, null);
        this._messageProcessor.getAccessChecker().fireDestinationAccessNotAuthorizedEvent(this._exceptionDestinationName, string2, operationType, string3);
        SibTr.warning((TraceComponent)tc, (String)"USER_NOT_AUTH_EXCEPTION_DEST_ERROR_CWSIP0313", (Object)new Object[]{string2, this._exceptionDestinationName});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleAccessDenied");
        }
    }

    private void fireMessageExceptionedEvent(String string, SIMPMessage sIMPMessage, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireMessageExceptionedEvent", (Object)new Object[]{string, sIMPMessage, new Integer(n)});
        }
        JsMessagingEngine jsMessagingEngine = this._messageProcessor.getMessagingEngine();
        RuntimeEventListener runtimeEventListener = this._messageProcessor.getRuntimeEventListener();
        String string2 = sIMPMessage.getMessage().getSystemMessageId();
        if (runtimeEventListener != null) {
            String string3 = nls_mt.getFormattedMessage("MESSAGE_EXCEPTION_DESTINATIONED_CWSJU0012", new Object[]{string, string2, this._exceptionDestinationName, new Integer(n), sIMPMessage.getMessage().getExceptionMessage()}, null);
            Properties properties = new Properties();
            String string4 = "";
            String string5 = SIBUuid12.toZeroString();
            if (this._originalDestination != null) {
                string4 = this._originalDestination.getName();
                string5 = this._originalDestination.getUuid().toString();
            }
            properties.put("intended.destination.name", string4);
            properties.put("intended.destination.UUID", string5);
            properties.put("exception.destination.name", this._exceptionDestination.getName());
            properties.put("exception.destination.UUID", this._exceptionDestination.getUuid().toString());
            properties.put("system.message.identifier", string2 == null ? "" : string2);
            properties.put("message.exception.reason", String.valueOf(n));
            runtimeEventListener.runtimeEventOccurred(jsMessagingEngine, "SIB.message.exceptioned", string3, properties);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireMessageExceptionedEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ExceptionDestinationHandlerImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.102.1.2");
        }
    }

    public class AccessResult {
        private boolean _allowed = false;
        private boolean _identityAdoptionFailed = false;

        AccessResult(boolean bl, boolean bl2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AccessResult", (Object)new Object[]{new Boolean(bl), new Boolean(bl2)});
            }
            this._allowed = bl;
            this._identityAdoptionFailed = bl2;
        }

        public boolean isAllowed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isAllowed");
                SibTr.exit((TraceComponent)tc, (String)"isAllowed", (Object)new Boolean(this._allowed));
            }
            return this._allowed;
        }

        public boolean didIdentityAdoptionFail() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"didIdentityAdoptionFail");
                SibTr.exit((TraceComponent)tc, (String)"didIdentityAdoptionFail", (Object)new Boolean(this._identityAdoptionFailed));
            }
            return this._identityAdoptionFailed;
        }
    }
}

