/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCreateDurable;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDeleteDurable;
import com.ibm.ws.sib.mfp.control.ControlDurableConfirm;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DurableConstants;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.HashMap;

public class DurableOutputHandler
implements ControlHandler,
DurableConstants {
    private static final TraceComponent tc = SibTr.register((Class)DurableOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;

    private DurableOutputHandler() {
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:127:1.37"}, null));
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleControlMessage", (String)"1:134:1.37", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:142:1.37"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public static void staticHandleControlMessage(Cellule cellule, ControlMessage controlMessage, DestinationManager destinationManager, MessageProcessor messageProcessor) {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"staticHandleControlMessage", (Object)new Object[]{cellule, controlMessage, destinationManager, messageProcessor});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) == ControlMessageType.CREATEDURABLE) {
            DurableOutputHandler.handleCreateDurable(destinationManager, (ControlCreateDurable)controlMessage, messageProcessor);
        } else if (controlMessageType == ControlMessageType.DELETEDURABLE) {
            DurableOutputHandler.handleDeleteDurable(destinationManager, (ControlDeleteDurable)controlMessage, messageProcessor);
        } else if (controlMessageType == ControlMessageType.CREATESTREAM) {
            DurableOutputHandler.handleCreateStream(destinationManager, (ControlCreateStream)controlMessage, messageProcessor);
        } else {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:189:1.37"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.staticHandleControlMessage", (String)"1:196:1.37", (Object)DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableOutputHandler", "1:203:1.37"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"staticHandleControlMessage", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"staticHandleControlMessage");
        }
    }

    protected static void handleCreateDurable(DestinationManager destinationManager, ControlCreateDurable controlCreateDurable, MessageProcessor messageProcessor) {
        SelectionCriteria selectionCriteria;
        BaseDestinationHandler baseDestinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleCreateDurable", (Object)new Object[]{destinationManager, controlCreateDurable, messageProcessor});
        }
        int n = 2;
        SIBUuid12 sIBUuid12 = controlCreateDurable.getGuaranteedTargetDestinationDefinitionUUID();
        String string = controlCreateDurable.getDurableSubName();
        String string2 = controlCreateDurable.getDurableDiscriminator();
        String string3 = controlCreateDurable.getDurableSelector();
        SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain((int)controlCreateDurable.getDurableSelectorDomain());
        String string4 = controlCreateDurable.getSecurityUserid();
        boolean bl = controlCreateDurable.isSecurityUseridSentBySystem();
        try {
            baseDestinationHandler = (BaseDestinationHandler)destinationManager.getDestination(sIBUuid12, false);
            selectionCriteria = messageProcessor.getSelectionCriteriaFactory().createSelectionCriteria(string2, string3, selectorDomain);
            n = baseDestinationHandler.createDurableFromRemote(string, selectionCriteria, string4, controlCreateDurable.isCloned(), controlCreateDurable.isNoLocal(), bl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleCreateDurable", (String)"1:262:1.37", (Object)DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        baseDestinationHandler = controlCreateDurable.getGuaranteedSourceMessagingEngineUUID();
        selectionCriteria = DurableOutputHandler.createDurableConfirm(messageProcessor, (SIBUuid8)baseDestinationHandler, controlCreateDurable.getRequestID(), n);
        messageProcessor.getMPIO().sendToMe(new MessagingEngine((SIBUuid8)baseDestinationHandler), 1, 11, (ControlMessage)selectionCriteria);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleCreateDurable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleDeleteDurable(DestinationManager destinationManager, ControlDeleteDurable controlDeleteDurable, MessageProcessor messageProcessor) {
        HashMap hashMap;
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleDeleteDurable", (Object)new Object[]{destinationManager, controlDeleteDurable, messageProcessor});
        }
        int n = 2;
        try {
            string = controlDeleteDurable.getDurableSubName();
            HashMap hashMap2 = hashMap = destinationManager.getDurableSubscriptionsTable();
            synchronized (hashMap2) {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)hashMap.get(string);
                if (consumerDispatcher == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleDeleteDurable", (Object)"SIDurableSubscriptionNotFoundException");
                    }
                    n = 3;
                    throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{string, messageProcessor.getMessagingEngineName()}, null));
                }
                BaseDestinationHandler baseDestinationHandler = consumerDispatcher.getDestination();
                boolean bl = true;
                if (messageProcessor.isBusSecure()) {
                    ConsumerDispatcherState consumerDispatcherState = consumerDispatcher.getConsumerDispatcherState();
                    String string2 = controlDeleteDurable.getSecurityUserid();
                    if (string2 == null) {
                        if (consumerDispatcherState.getUser() != null) {
                            bl = false;
                        }
                    } else if (!string2.equals(consumerDispatcherState.getUser())) {
                        bl = false;
                    }
                }
                n = !bl ? 5 : baseDestinationHandler.deleteDurableFromRemote(string);
            }
        }
        catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDurableSubscriptionNotFoundException));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleDeleteDurable", (String)"1:368:1.37", (Object)DurableOutputHandler.class);
        }
        string = controlDeleteDurable.getGuaranteedSourceMessagingEngineUUID();
        hashMap = DurableOutputHandler.createDurableConfirm(messageProcessor, (SIBUuid8)string, controlDeleteDurable.getRequestID(), n);
        messageProcessor.getMPIO().sendToMe(new MessagingEngine((SIBUuid8)string), 1, 11, (ControlMessage)hashMap);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleDeleteDurable");
        }
    }

    protected static void handleCreateStream(DestinationManager destinationManager, ControlCreateStream controlCreateStream, MessageProcessor messageProcessor) {
        SIBUuid12 sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleCreateStream", (Object)new Object[]{destinationManager, controlCreateStream, messageProcessor});
        }
        ControlCardinalityInfo controlCardinalityInfo = null;
        try {
            sIBUuid12 = controlCreateStream.getGuaranteedTargetDestinationDefinitionUUID();
            BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)destinationManager.getDestination(sIBUuid12, false);
            baseDestinationHandler.attachDurableFromRemote(controlCreateStream);
        }
        catch (SIDestinationLockedException sIDestinationLockedException) {
            controlCardinalityInfo = DurableOutputHandler.createCardinalityInfo(messageProcessor, controlCreateStream.getGuaranteedSourceMessagingEngineUUID(), controlCreateStream.getRequestID(), 1);
        }
        catch (Exception exception) {
            int n = 2;
            SIBUuid8 sIBUuid8 = controlCreateStream.getGuaranteedSourceMessagingEngineUUID();
            if (exception instanceof SIDurableSubscriptionNotFoundException) {
                n = 3;
            } else if (exception instanceof SIDurableSubscriptionMismatchException) {
                n = 6;
            } else if (exception instanceof SINotAuthorizedException) {
                n = 5;
            } else {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.handleCreateStream", (String)"1:435:1.37", (Object)DurableOutputHandler.class);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            controlCardinalityInfo = DurableOutputHandler.createDurableConfirm(messageProcessor, sIBUuid8, controlCreateStream.getRequestID(), n);
        }
        if (controlCardinalityInfo != null) {
            sIBUuid12 = controlCreateStream.getGuaranteedSourceMessagingEngineUUID();
            messageProcessor.getMPIO().sendToMe(new MessagingEngine((SIBUuid8)sIBUuid12), 1, 11, (ControlMessage)controlCardinalityInfo);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleCreateStream");
        }
    }

    protected static ControlDurableConfirm createDurableConfirm(MessageProcessor messageProcessor, SIBUuid8 sIBUuid8, long l, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableConfirm", (Object)new Object[]{messageProcessor, sIBUuid8, new Long(l), new Integer(n)});
        }
        ControlDurableConfirm controlDurableConfirm = null;
        try {
            controlDurableConfirm = MessageProcessor.getControlMessageFactory().createNewControlDurableConfirm();
            DurableOutputHandler.initializeControlMessage(messageProcessor.getMessagingEngineUuid(), (ControlMessage)controlDurableConfirm, sIBUuid8);
            controlDurableConfirm.setRequestID(l);
            controlDurableConfirm.setStatus(n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.createDurableConfirm", (String)"1:490:1.37", (Object)DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableConfirm", (Object)controlDurableConfirm);
        }
        return controlDurableConfirm;
    }

    protected static ControlCardinalityInfo createCardinalityInfo(MessageProcessor messageProcessor, SIBUuid8 sIBUuid8, long l, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createCardinalityInfo", (Object)new Object[]{messageProcessor, sIBUuid8, new Long(l), new Integer(n)});
        }
        ControlCardinalityInfo controlCardinalityInfo = null;
        try {
            controlCardinalityInfo = MessageProcessor.getControlMessageFactory().createNewControlCardinalityInfo();
            DurableOutputHandler.initializeControlMessage(messageProcessor.getMessagingEngineUuid(), (ControlMessage)controlCardinalityInfo, sIBUuid8);
            controlCardinalityInfo.setRequestID(l);
            controlCardinalityInfo.setCardinality(n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableOutputHandler.createCardinalityInfo", (String)"1:533:1.37", (Object)DurableOutputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createCardinalityInfo", (Object)controlCardinalityInfo);
        }
        return controlCardinalityInfo;
    }

    protected static void initializeControlMessage(SIBUuid8 sIBUuid8, ControlMessage controlMessage, SIBUuid8 sIBUuid82) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{controlMessage, sIBUuid82});
        }
        controlMessage.setGuaranteedSourceMessagingEngineUUID(sIBUuid8);
        controlMessage.setGuaranteedTargetMessagingEngineUUID(sIBUuid82);
        controlMessage.setGuaranteedProtocolType(ProtocolType.DURABLEINPUT);
        controlMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlMessage.setGuaranteedTargetDestinationDefinitionUUID(null);
        controlMessage.setGuaranteedStreamUUID(null);
        controlMessage.setPriority(11);
        controlMessage.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/DurableOutputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.37");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

