/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCreateDurable;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDeleteDurable;
import com.ibm.ws.sib.mfp.control.ControlDurableConfirm;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DurableConstants;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.HashMap;
import java.util.Map;

public class DurableInputHandler
implements InputHandler,
ControlHandler,
DurableConstants {
    private static final TraceComponent tc = SibTr.register((Class)DurableInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static Map _requestMap = new HashMap();
    private static AlarmListener _alarmHandler;
    private static final TraceNLS nls;

    private DurableInputHandler() {
    }

    public void handleMessage(MessageItem messageItem, Transaction transaction, JsDestinationAddress jsDestinationAddress, Cellule cellule) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{messageItem, transaction, jsDestinationAddress, cellule});
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:162:1.42"}, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.handleMessage", (String)"1:169:1.42", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:177:1.42"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)((Object)sIErrorException));
        }
        throw sIErrorException;
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:202:1.42"}, null));
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.handleControlMessage", (String)"1:209:1.42", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:216:1.42"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public static void staticHandleControlMessage(Cellule cellule, ControlMessage controlMessage) {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"staticHandleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) == ControlMessageType.NOTFLUSHED || controlMessageType == ControlMessageType.CARDINALITYINFO || controlMessageType == ControlMessageType.DURABLECONFIRM) {
            long l = 0L;
            if (controlMessage instanceof ControlNotFlushed) {
                l = ((ControlNotFlushed)controlMessage).getRequestID();
            } else if (controlMessage instanceof ControlCardinalityInfo) {
                l = ((ControlCardinalityInfo)controlMessage).getRequestID();
            } else if (controlMessage instanceof ControlDurableConfirm) {
                l = ((ControlDurableConfirm)controlMessage).getRequestID();
            }
            DurableInputHandler.wakeupWaiter(l, controlMessage);
        } else {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:264:1.42"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.staticHandleControlMessage", (String)"1:271:1.42", (Object)DurableInputHandler.class);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:277:1.42"});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"staticHandleControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void wakeupWaiter(long l, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"wakeupWaiter", (Object)new Object[]{new Long(l), object});
        }
        Map map = _requestMap;
        // MONITORENTER : map
        Long l2 = new Long(l);
        Object[] objectArray = (Object[])_requestMap.get(l2);
        if (objectArray != null) {
            objectArray[0] = object;
            _requestMap.remove(l2);
            Object[] objectArray2 = objectArray;
            // MONITORENTER : objectArray
            objectArray.notify();
            // MONITOREXIT : objectArray2
        }
        // MONITOREXIT : map
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"wakeupWaiter");
    }

    protected static ControlCreateStream createDurableCreateStream(MessageProcessor messageProcessor, ConsumerDispatcherState consumerDispatcherState, long l, SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableCreateStream", (Object)new Object[]{messageProcessor, consumerDispatcherState, new Long(l), sIBUuid8});
        }
        ControlCreateStream controlCreateStream = null;
        try {
            controlCreateStream = MessageProcessor.getControlMessageFactory().createNewControlCreateStream();
            DurableInputHandler.initializeControlMessage(messageProcessor.getMessagingEngineUuid(), (ControlMessage)controlCreateStream, sIBUuid8);
            controlCreateStream.setRequestID(l);
            controlCreateStream.setDurableSubName(consumerDispatcherState.getSubscriberID());
            controlCreateStream.setGuaranteedTargetDestinationDefinitionUUID(consumerDispatcherState.getTopicSpaceUuid());
            SelectionCriteria selectionCriteria = consumerDispatcherState.getSelectionCriteria();
            if (selectionCriteria == null || selectionCriteria.getDiscriminator() == null) {
                controlCreateStream.setDurableDiscriminator(null);
            } else {
                controlCreateStream.setDurableDiscriminator(selectionCriteria.getDiscriminator());
            }
            if (selectionCriteria == null || selectionCriteria.getSelectorString() == null) {
                controlCreateStream.setDurableSelector(null);
            } else {
                controlCreateStream.setDurableSelector(consumerDispatcherState.getSelectionCriteria().getSelectorString());
            }
            if (selectionCriteria == null || selectionCriteria.getSelectorDomain() == null) {
                controlCreateStream.setDurableSelectorDomain(SelectorDomain.SIMESSAGE.toInt());
            } else {
                controlCreateStream.setDurableSelectorDomain(selectionCriteria.getSelectorDomain().toInt());
            }
            controlCreateStream.setCloned(consumerDispatcherState.isCloned());
            controlCreateStream.setNoLocal(consumerDispatcherState.isNoLocal());
            controlCreateStream.setSecurityUserid(consumerDispatcherState.getUser());
            controlCreateStream.setSecurityUseridSentBySystem(consumerDispatcherState.isSIBServerSubject());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.createDurableCreateStream", (String)"1:391:1.42", (Object)DurableInputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableCreateStream", (Object)controlCreateStream);
        }
        return controlCreateStream;
    }

    protected static ControlCreateDurable createDurableCreateDurable(MessageProcessor messageProcessor, ConsumerDispatcherState consumerDispatcherState, long l, SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableCreateDurable", (Object)new Object[]{messageProcessor, consumerDispatcherState, new Long(l), sIBUuid8});
        }
        ControlCreateDurable controlCreateDurable = null;
        try {
            controlCreateDurable = MessageProcessor.getControlMessageFactory().createNewControlCreateDurable();
            DurableInputHandler.initializeControlMessage(messageProcessor.getMessagingEngineUuid(), (ControlMessage)controlCreateDurable, sIBUuid8);
            controlCreateDurable.setRequestID(l);
            controlCreateDurable.setDurableSubName(consumerDispatcherState.getSubscriberID());
            SelectionCriteria selectionCriteria = consumerDispatcherState.getSelectionCriteria();
            if (selectionCriteria == null || selectionCriteria.getDiscriminator() == null) {
                controlCreateDurable.setDurableDiscriminator(null);
            } else {
                controlCreateDurable.setDurableDiscriminator(selectionCriteria.getDiscriminator());
            }
            if (selectionCriteria == null || selectionCriteria.getSelectorString() == null) {
                controlCreateDurable.setDurableSelector(null);
            } else {
                controlCreateDurable.setDurableSelector(consumerDispatcherState.getSelectionCriteria().getSelectorString());
            }
            if (selectionCriteria == null || selectionCriteria.getSelectorDomain() == null) {
                controlCreateDurable.setDurableSelectorDomain(SelectorDomain.SIMESSAGE.toInt());
            } else {
                controlCreateDurable.setDurableSelectorDomain(selectionCriteria.getSelectorDomain().toInt());
            }
            controlCreateDurable.setCloned(consumerDispatcherState.isCloned());
            controlCreateDurable.setNoLocal(consumerDispatcherState.isNoLocal());
            controlCreateDurable.setSecurityUserid(consumerDispatcherState.getUser());
            controlCreateDurable.setSecurityUseridSentBySystem(consumerDispatcherState.isSIBServerSubject());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.createDurableCreateDurable", (String)"1:475:1.42", (Object)DurableInputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableCreateDurable", (Object)controlCreateDurable);
        }
        return controlCreateDurable;
    }

    protected static ControlDeleteDurable createDurableDeleteDurable(MessageProcessor messageProcessor, String string, String string2, long l, SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDurableDeleteDurable", (Object)new Object[]{messageProcessor, string, string2, new Long(l), sIBUuid8});
        }
        ControlDeleteDurable controlDeleteDurable = null;
        try {
            controlDeleteDurable = MessageProcessor.getControlMessageFactory().createNewControlDeleteDurable();
            DurableInputHandler.initializeControlMessage(messageProcessor.getMessagingEngineUuid(), (ControlMessage)controlDeleteDurable, sIBUuid8);
            controlDeleteDurable.setRequestID(l);
            controlDeleteDurable.setDurableSubName(string);
            controlDeleteDurable.setSecurityUserid(string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DurableInputHandler.createDurableDeleteDurable", (String)"1:520:1.42", (Object)DurableInputHandler.class);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDurableDeleteDurable", (Object)controlDeleteDurable);
        }
        return controlDeleteDurable;
    }

    protected static void initializeControlMessage(SIBUuid8 sIBUuid8, ControlMessage controlMessage, SIBUuid8 sIBUuid82) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{sIBUuid8, controlMessage, sIBUuid82});
        }
        controlMessage.setGuaranteedSourceMessagingEngineUUID(sIBUuid8);
        controlMessage.setGuaranteedTargetMessagingEngineUUID(sIBUuid82);
        controlMessage.setGuaranteedProtocolType(ProtocolType.DURABLEOUTPUT);
        controlMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlMessage.setGuaranteedTargetDestinationDefinitionUUID(null);
        controlMessage.setGuaranteedStreamUUID(null);
        controlMessage.setPriority(11);
        controlMessage.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object issueRequest(MessageProcessor messageProcessor, ControlMessage controlMessage, MessagingEngine messagingEngine, long l, int n, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueRequest", (Object)new Object[]{messageProcessor, controlMessage, messagingEngine, new Long(l), new Integer(n), new Long(l2)});
        }
        if (!messageProcessor.getMPIO().isMEReachable(messagingEngine)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueRequest", null);
            }
            return null;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = _requestMap;
        synchronized (_requestMap) {
            _requestMap.put(new Long(l2), objectArray);
            // ** MonitorExit[var9_7] (shouldn't be in output)
            objectArray2 = objectArray;
            synchronized (objectArray) {
                messageProcessor.getMPIO().sendToMe(messagingEngine, 1, 11, controlMessage);
                ResendRecord resendRecord = new ResendRecord(messageProcessor, controlMessage, messagingEngine, l, n, l2);
                messageProcessor.getAlarmManager().create(l, _alarmHandler, resendRecord);
                while (true) {
                    try {
                        objectArray.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                // ** MonitorExit[var9_7] (shouldn't be in output)
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueRequest", (Object)objectArray[0]);
                }
                return objectArray[0];
            }
        }
    }

    public static ControlNotFlushed issueCreateStreamRequest(MessageProcessor messageProcessor, ConsumerDispatcherState consumerDispatcherState, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8) throws SIResourceException, SIDestinationLockedException, SIDurableSubscriptionNotFoundException, SINotAuthorizedException, SIDurableSubscriptionMismatchException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)new Object[]{messageProcessor, consumerDispatcherState, sIBUuid12});
        }
        long l = messageProcessor.nextTick();
        SIBUuid8 sIBUuid82 = sIBUuid8;
        ControlCreateStream controlCreateStream = DurableInputHandler.createDurableCreateStream(messageProcessor, consumerDispatcherState, l, sIBUuid82);
        controlCreateStream.setGuaranteedTargetDestinationDefinitionUUID(sIBUuid12);
        Object object = DurableInputHandler.issueRequest(messageProcessor, (ControlMessage)controlCreateStream, new MessagingEngine(sIBUuid82), 3000L, -1, l);
        if (object == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_DURABLE_TIMEOUT_ERROR_CWSIP0631", new Object[]{"attach", consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getDurableHome()}, null));
        }
        if (object instanceof ControlCardinalityInfo) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIDurableSubscriptionLockedException");
            }
            throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getDurableHome()}, null));
        }
        if (object instanceof ControlDurableConfirm) {
            int n = ((ControlDurableConfirm)object).getStatus();
            if (n == 3) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIDurableSubscriptionNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getDurableHome()}, null));
            }
            if (n == 5) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SINotAuthorizedException");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_ACTIVATE_ERROR_CWSIP0312", new Object[]{consumerDispatcherState.getUser(), consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getTopicSpaceUuid()}, null));
            }
            if (n == 6) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIDurableSubscriptionMismatchException");
                }
                throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getDurableHome()}, null));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:731:1.42"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:738:1.42"}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueCreateStreamRequest", (Object)object);
        }
        return (ControlNotFlushed)object;
    }

    public static int issueCreateDurableRequest(MessageProcessor messageProcessor, ConsumerDispatcherState consumerDispatcherState, MessagingEngine messagingEngine, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueCreateDurableRequest", (Object)new Object[]{messageProcessor, consumerDispatcherState, messagingEngine, sIBUuid12});
        }
        long l = messageProcessor.nextTick();
        SIBUuid8 sIBUuid8 = messagingEngine.getUuid();
        ControlCreateDurable controlCreateDurable = DurableInputHandler.createDurableCreateDurable(messageProcessor, consumerDispatcherState, l, sIBUuid8);
        controlCreateDurable.setGuaranteedTargetDestinationDefinitionUUID(sIBUuid12);
        Object object = DurableInputHandler.issueRequest(messageProcessor, (ControlMessage)controlCreateDurable, new MessagingEngine(sIBUuid8), 3000L, -1, l);
        if (object == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueCreateDurableRequest", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_DURABLE_TIMEOUT_ERROR_CWSIP0631", new Object[]{"create", consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getDurableHome()}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueCreateDurableRequest", (Object)new Integer(((ControlDurableConfirm)object).getStatus()));
        }
        return ((ControlDurableConfirm)object).getStatus();
    }

    public static int issueDeleteDurableRequest(MessageProcessor messageProcessor, String string, String string2, MessagingEngine messagingEngine) throws SIResourceException {
        SIBUuid8 sIBUuid8;
        long l;
        ControlDeleteDurable controlDeleteDurable;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueDeleteDurableRequest", (Object)new Object[]{messageProcessor, string, string2, messagingEngine});
        }
        if ((object = DurableInputHandler.issueRequest(messageProcessor, (ControlMessage)(controlDeleteDurable = DurableInputHandler.createDurableDeleteDurable(messageProcessor, string, string2, l = messageProcessor.nextTick(), sIBUuid8 = messagingEngine.getUuid())), new MessagingEngine(sIBUuid8), 3000L, -1, l)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"issueDeleteDurableRequest", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_DURABLE_TIMEOUT_ERROR_CWSIP0631", new Object[]{"delete", string, messagingEngine}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueDeleteDurableRequest", (Object)new Integer(((ControlDurableConfirm)object).getStatus()));
        }
        return ((ControlDurableConfirm)object).getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void internalAlarmHandler(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalAlarmHandler", (Object)object);
        }
        ResendRecord resendRecord = (ResendRecord)object;
        Map map = _requestMap;
        synchronized (map) {
            Long l = new Long(resendRecord.requestID);
            if (_requestMap.containsKey(l)) {
                if (resendRecord.triesRemaining != 0) {
                    if (!resendRecord.MP.getMPIO().isMEReachable(resendRecord.target)) {
                        DurableInputHandler.wakeupWaiter(resendRecord.requestID, null);
                    }
                    resendRecord.MP.getMPIO().sendToMe(resendRecord.target, 1, 11, resendRecord.msg);
                    if (resendRecord.triesRemaining > 0) {
                        --resendRecord.triesRemaining;
                    }
                    resendRecord.MP.getAlarmManager().create(resendRecord.resendInterval, _alarmHandler, resendRecord);
                } else {
                    DurableInputHandler.wakeupWaiter(resendRecord.requestID, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalAlarmHandler");
        }
    }

    public static void createRemoteDurableSubscription(MessageProcessor messageProcessor, ConsumerDispatcherState consumerDispatcherState, MessagingEngine messagingEngine, SIBUuid12 sIBUuid12) throws SIDurableSubscriptionAlreadyExistsException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteDurableSubscription", (Object)new Object[]{messageProcessor, consumerDispatcherState, messagingEngine, sIBUuid12});
        }
        int n = DurableInputHandler.issueCreateDurableRequest(messageProcessor, consumerDispatcherState, messagingEngine, sIBUuid12);
        switch (n) {
            case 1: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createRemoteDurableSubscription", (Object)"SIDurableSubscriptionAlreadyExistsException");
                }
                throw new SIDurableSubscriptionAlreadyExistsException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{consumerDispatcherState.getSubscriberID(), consumerDispatcherState.getDurableHome()}, null));
            }
            case 2: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createRemoteDurableSubscription", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:937:1.42"});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:944:1.42"}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteDurableSubscription");
        }
    }

    public static void deleteRemoteDurableSub(MessageProcessor messageProcessor, String string, String string2, MessagingEngine messagingEngine) throws SIResourceException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)new Object[]{messageProcessor, string, string2, messagingEngine});
        }
        int n = DurableInputHandler.issueDeleteDurableRequest(messageProcessor, string, string2, messagingEngine);
        switch (n) {
            case 3: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIDurableSubscriptionNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{string, messagingEngine}, null));
            }
            case 4: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIDurableSubscriptionLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{string, messagingEngine}, null));
            }
            case 5: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SINotAuthorizedException");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_DELETE_ERROR_CWSIP0311", new Object[]{string2, string, null}, null));
            }
            case 7: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIDestinationLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0153", new Object[]{string, messagingEngine}, null));
            }
            case 2: {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub", (Object)"SIResourceException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:1035:1.42"});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DurableInputHandler", "1:1042:1.42"}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableSub");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/DurableInputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.42");
        }
        _alarmHandler = new AlarmListener(){

            public void alarm(Object object) {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
                }
                DurableInputHandler.internalAlarmHandler(object);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alarm");
                }
            }
        };
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    static class ResendRecord {
        MessageProcessor MP;
        ControlMessage msg;
        MessagingEngine target;
        long resendInterval;
        int triesRemaining;
        long requestID;

        public ResendRecord(MessageProcessor messageProcessor, ControlMessage controlMessage, MessagingEngine messagingEngine, long l, int n, long l2) {
            this.MP = messageProcessor;
            this.msg = controlMessage;
            this.target = messagingEngine;
            this.resendInterval = l;
            this.triesRemaining = n;
            this.requestID = l2;
        }
    }
}

