/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.trm.dlm.DestinationLocationChangeListener;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class DestinationChangeListener
implements DestinationLocationChangeListener {
    private static final TraceComponent tc = SibTr.register((Class)DestinationChangeListener.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private SIMPTransactionManager _txManager;
    private List _destinationChangeListeners = new ArrayList();

    public DestinationChangeListener(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationChangeListener", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        this._txManager = messageProcessor.getTXManager();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationChangeListener", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destinationLocationChange(SIBUuid12 sIBUuid12, Set set, Set set2, Capability capability) {
        Object object;
        BaseDestinationHandler baseDestinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationLocationChange", (Object)new Object[]{sIBUuid12, set, set2, capability});
        }
        if ((baseDestinationHandler = (BaseDestinationHandler)this._destinationManager.getDestinationInternal(sIBUuid12, false)) != null) {
            Set set3 = null;
            try {
                set3 = capability == Capability.PRE_MEDIATION_PUT ? this._messageProcessor.getSIBMediationLocalitySet(null, baseDestinationHandler.getUuid().toString(), true) : this._messageProcessor.getSIBDestinationLocalitySet(null, baseDestinationHandler.getUuid().toString(), true);
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                FFDCFilter.processException((Throwable)sIBExceptionBase, (String)"com.ibm.ws.sib.processor.impl.DestinationChangeListener.destinationLocationChange", (String)"1:151:1.37", (Object)this);
            }
            object = baseDestinationHandler;
            synchronized (object) {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    PtoPXmitMsgsItemStream ptoPXmitMsgsItemStream;
                    SIBUuid8 sIBUuid8 = (SIBUuid8)iterator.next();
                    if (sIBUuid8.equals((Object)this._messageProcessor.getMessagingEngineUuid()) || (ptoPXmitMsgsItemStream = capability == Capability.PRE_MEDIATION_PUT ? baseDestinationHandler.getXmitMediationPoint(sIBUuid8) : baseDestinationHandler.getXmitQueuePoint(sIBUuid8)) == null || set3.contains(sIBUuid8.toString())) continue;
                    try {
                        ptoPXmitMsgsItemStream.markAsToBeDeleted(this._txManager.createAutoCommitTransaction());
                        if (capability == Capability.PRE_MEDIATION_PUT) {
                            baseDestinationHandler._postMediatedItemStreamsRequiringCleanup.put(sIBUuid8, ptoPXmitMsgsItemStream);
                            continue;
                        }
                        if (capability == Capability.POST_MEDIATION_PUT) {
                            baseDestinationHandler._postMediatedItemStreamsRequiringCleanup.put(sIBUuid8, ptoPXmitMsgsItemStream);
                            continue;
                        }
                        baseDestinationHandler.closeRemoteConsumer(sIBUuid8);
                    }
                    catch (SIResourceException sIResourceException) {
                        FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.DestinationChangeListener.destinationLocationChange", (String)"1:213:1.37", (Object)this);
                    }
                }
                if (capability != Capability.GET) {
                    baseDestinationHandler.requestReallocation();
                }
            }
        }
        for (int i = 0; i < this._destinationChangeListeners.size(); ++i) {
            object = (DestinationLocationChangeListener)this._destinationChangeListeners.get(i);
            if (object == null) continue;
            object.destinationLocationChange(sIBUuid12, set, set2, capability);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationLocationChange");
        }
    }

    protected void addMPDestinationChangeListener(DestinationLocationChangeListener destinationLocationChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMPDestinationChangeListener", (Object)new Object[]{destinationLocationChangeListener});
        }
        this._destinationChangeListeners.add(destinationLocationChangeListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMPDestinationChangeListener");
        }
    }

    protected void removeMPDestinationChangeListener(DestinationLocationChangeListener destinationLocationChangeListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMPDestinationChangeListener", (Object)new Object[]{destinationLocationChangeListener});
        }
        this._destinationChangeListeners.remove(destinationLocationChangeListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMPDestinationChangeListener");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/DestinationChangeListener.java, SIB.processor, WAS602.SIB, o0610.11 1.37");
        }
    }
}

