/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public class ConsumerKey
extends SimpleEntry
implements DispatchableKey,
Filter {
    private static final TraceComponent tc = SibTr.register((Class)ConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private LockingCursor getCursor;
    protected boolean ready;
    protected boolean detached;
    protected final ConsumerPoint consumerPoint;
    protected long version;
    private Reliability unrecoverability = null;
    private final ConsumerDispatcher consumerDispatcher;
    private final SIBUuid12 connectionUuid;
    private boolean forwardScanning;
    protected ConsumerKeyGroup keyGroup;
    private boolean specific;
    private Selector selectorTree;
    private Selector discriminatorTree;
    private boolean started = false;
    private boolean closedDueToDelete = false;
    private boolean closedReceivedExclusive = false;
    private boolean closedLocalisationUnreachable = false;

    ConsumerKey(ConsumerPoint consumerPoint, ConsumerDispatcher consumerDispatcher, SelectionCriteria selectionCriteria, SIBUuid12 sIBUuid12, boolean bl) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerKey", (Object)new Object[]{consumerPoint, consumerDispatcher, selectionCriteria, sIBUuid12, new Boolean(bl)});
        }
        this.consumerDispatcher = consumerDispatcher;
        this.consumerPoint = consumerPoint;
        this.connectionUuid = sIBUuid12;
        this.detached = false;
        this.ready = false;
        this.forwardScanning = bl;
        this.keyGroup = null;
        try {
            ItemStream itemStream = consumerDispatcher.getItemStream();
            this.getCursor = itemStream != null ? itemStream.newLockingItemCursor(this) : consumerDispatcher.getReferenceStream().newLockingCursor(null);
            if (bl) {
                this.getCursor.disableJumpback();
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.ConsumerKey.ConsumerKey", (String)"1:202:1.57", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKey", "1:212:1.57", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumerKey", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        try {
            this.specific = false;
            if (selectionCriteria != null) {
                if (selectionCriteria.getSelectorString() != null && !selectionCriteria.getSelectorString().equals("")) {
                    this.selectorTree = consumerDispatcher.getMessageProcessor().getMessageProcessorMatching().parseSelector(selectionCriteria.getSelectorString(), selectionCriteria.getSelectorDomain());
                    this.specific = true;
                }
                if (selectionCriteria.getDiscriminator() != null && !selectionCriteria.getDiscriminator().equals("")) {
                    this.discriminatorTree = consumerDispatcher.getMessageProcessor().getMessageProcessorMatching().parseDiscriminator(selectionCriteria.getDiscriminator());
                    this.specific = true;
                }
            }
        }
        catch (SISelectorSyntaxException sISelectorSyntaxException) {
            FFDCFilter.processException((Throwable)sISelectorSyntaxException, (String)"com.ibm.ws.sib.processor.impl.ConsumerKey.ConsumerKey", (String)"1:254:1.57", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumerKey", (Object)((Object)sISelectorSyntaxException));
            }
            throw sISelectorSyntaxException;
        }
        catch (SIDiscriminatorSyntaxException sIDiscriminatorSyntaxException) {
            FFDCFilter.processException((Throwable)sIDiscriminatorSyntaxException, (String)"com.ibm.ws.sib.processor.impl.ConsumerKey.ConsumerKey", (String)"1:268:1.57", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumerKey", (Object)((Object)sIDiscriminatorSyntaxException));
            }
            throw sIDiscriminatorSyntaxException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerKey", (Object)this);
        }
    }

    public void joinKeyGroup(ConsumerKeyGroup consumerKeyGroup) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"joinKeyGroup", (Object)consumerKeyGroup);
        }
        if (this.keyGroup != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"joinKeyGroup", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKey", "1:301:1.57"}, null));
        }
        this.keyGroup = consumerKeyGroup;
        consumerKeyGroup.addMember(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"joinKeyGroup");
        }
    }

    public void leaveKeyGroup() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"leaveKeyGroup");
        }
        if (this.keyGroup == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"leaveKeyGroup", (Object)"Error");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKey", "1:328:1.57"}, null));
        }
        this.keyGroup.removeMember(this);
        this.keyGroup = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"leaveKeyGroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(Reliability reliability) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ready", (Object)reliability);
        }
        if (this.closedDueToDelete) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ready", (Object)"SINotPossibleInCurrentConfigurationException - deleted");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP00221", new Object[]{this.consumerDispatcher.getDestination().getName(), this.consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
        }
        if (this.closedReceivedExclusive) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ready", (Object)"SINotPossibleInCurrentConfigurationException - receive Exclusive");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_EXCLUSIVE_ERROR_CWSIP00222", new Object[]{this.consumerDispatcher.getDestination().getName(), this.consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
        }
        if (this.closedLocalisationUnreachable) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ready", (Object)"SINotPossibleInCurrentConfigurationException - localisation unreachable");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_UNREACHABLE_ERROR_CWSIP00223", new Object[]{this.consumerDispatcher.getDestination().getName(), this.consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
        }
        Object object = this.consumerDispatcher.getReadyConsumerPointLock();
        synchronized (object) {
            this.unrecoverability = reliability;
            if (this.keyGroup == null) {
                if (!this.ready) {
                    this.version = this.consumerDispatcher.newReadyConsumer(this, this.specific);
                }
            } else {
                this.keyGroup.ready();
            }
            this.ready = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ready", (Object)new Long(this.version));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notReady");
        }
        Object object = this.consumerDispatcher.getReadyConsumerPointLock();
        synchronized (object) {
            if (this.keyGroup == null) {
                if (this.ready) {
                    this.consumerDispatcher.removeReadyConsumer(this, this.specific);
                }
            } else {
                this.keyGroup.notReady();
            }
            this.ready = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notReady");
        }
    }

    protected long waiting(long l, boolean bl) {
        return l;
    }

    protected LockingCursor getGetCursor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursor");
        }
        LockingCursor lockingCursor = this.getCursor;
        if (this.keyGroup != null) {
            lockingCursor = this.keyGroup.getCursor();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursor", (Object)lockingCursor);
        }
        return lockingCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detach() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detach");
        }
        this.notReady();
        if (this.keyGroup != null) {
            this.keyGroup.removeMember(this);
        }
        this.consumerDispatcher.detachConsumerPoint(this);
        this.getCursor.finished();
        ConsumerKey consumerKey = this;
        synchronized (consumerKey) {
            this.detached = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detach");
        }
    }

    public SIBUuid12 getConnectionUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionUuid");
            SibTr.exit((TraceComponent)tc, (String)"getConnectionUuid", (Object)this.connectionUuid);
        }
        return this.connectionUuid;
    }

    public boolean getForwardScanning() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardScanning");
            SibTr.exit((TraceComponent)tc, (String)"getForwardScanning", (Object)new Boolean(this.forwardScanning));
        }
        return this.forwardScanning;
    }

    public boolean requiresRecovery(SIMPMessage sIMPMessage) {
        Reliability reliability;
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requiresRecovery", (Object)new Object[]{sIMPMessage});
        }
        boolean bl2 = bl = (reliability = sIMPMessage.getReliability()).compareTo((Object)this.unrecoverability) > 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requiresRecovery", (Object)new Boolean(bl));
        }
        return bl;
    }

    public ConsumerDispatcher getConsumerDispatcher() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatcher");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatcher", (Object)this.consumerDispatcher);
        }
        return this.consumerDispatcher;
    }

    public void closeForDelete(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeForDelete", (Object)destinationHandler);
        }
        if (this.consumerPoint.destinationMatches(destinationHandler, this.consumerDispatcher)) {
            this.closedDueToDelete = true;
            this.ready = false;
        }
        if (this.keyGroup != null) {
            this.keyGroup.markNotReady();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeForDelete");
        }
    }

    public void closeReceiveExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeReceiveExclusive");
        }
        this.closedReceivedExclusive = true;
        this.closeInternal();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeReceiveExclusive");
        }
    }

    public void closeLocalisationUnreachable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeLocalisationUnreachable");
        }
        this.closedLocalisationUnreachable = true;
        this.closeInternal();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeLocalisationUnreachable");
        }
    }

    private final void closeInternal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeInternal");
        }
        this.ready = false;
        if (this.keyGroup != null) {
            this.keyGroup.markNotReady();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeInternal");
        }
    }

    public void notifyConsumerPointAboutException(SIException sIException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyConsumerPointAboutException", (Object)((Object)sIException));
        }
        this.consumerPoint.notifyException(sIException);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyConsumerPointAboutException");
        }
    }

    public void notifyReceiveAllowed(boolean bl, DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Boolean(bl));
        }
        if (this.consumerPoint.destinationMatches(destinationHandler, this.consumerDispatcher)) {
            this.consumerPoint.notifyReceiveAllowed(bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    public boolean isClosedDueToDelete() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosedDueToDelete");
            SibTr.exit((TraceComponent)tc, (String)"isClosedDueToDelete", (Object)new Boolean(this.closedDueToDelete));
        }
        return this.closedDueToDelete;
    }

    public boolean isKeyReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKeyReady");
            if (this.keyGroup == null) {
                SibTr.exit((TraceComponent)tc, (String)"isKeyReady", (Object)new Boolean(this.ready));
            }
        }
        if (this.keyGroup == null) {
            return this.ready;
        }
        boolean bl = this.keyGroup.isKeyReady();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isKeyReady", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void markNotReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markNotReady");
        }
        this.ready = false;
        if (this.keyGroup != null) {
            this.keyGroup.markNotReady();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markNotReady");
        }
    }

    public long getVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVersion");
            SibTr.exit((TraceComponent)tc, (String)"getVersion", (Object)new Long(this.version));
        }
        return this.version;
    }

    public ConsumerPoint getConsumerPoint() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerPoint");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerPoint", (Object)this.consumerPoint);
        }
        return this.consumerPoint;
    }

    public boolean isSpecific() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSpecific");
            SibTr.exit((TraceComponent)tc, (String)"isSpecific", (Object)new Boolean(this.specific));
        }
        return this.specific;
    }

    public DispatchableKey resolvedKey() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolvedKey");
            SibTr.exit((TraceComponent)tc, (String)"resolvedKey", (Object)this);
        }
        return this;
    }

    public boolean filterMatches(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)abstractItem);
        }
        boolean bl = true;
        JsMessage jsMessage = ((SIMPMessage)((Object)abstractItem)).getMessage();
        if (this.selectorTree != null || this.discriminatorTree != null) {
            bl = this.consumerDispatcher.getMessageProcessor().getMessageProcessorMatching().evaluateMessage(this.selectorTree, this.discriminatorTree, (SIBusMessage)jsMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)new Boolean(bl));
        }
        return bl;
    }

    public DispatchableKey getParent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getParent");
        }
        SimpleEntry simpleEntry = this;
        if (this.keyGroup != null) {
            simpleEntry = this.keyGroup;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getParent", (Object)simpleEntry);
        }
        return simpleEntry;
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (!this.started) {
            this.started = true;
            if (this.keyGroup != null) {
                this.keyGroup.startMember();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this.started) {
            this.started = false;
            if (this.keyGroup != null) {
                this.keyGroup.stopMember();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public boolean isStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted");
        }
        boolean bl = this.started;
        if (this.keyGroup != null) {
            bl = this.keyGroup.isStarted();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String toString() {
        String string = super.toString();
        if (this.consumerDispatcher != null) {
            string = this.consumerDispatcher.toString() + string;
        }
        return string;
    }

    public Selector getSelector() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelector");
            SibTr.exit((TraceComponent)tc, (String)"getSelector", (Object)this.selectorTree);
        }
        return this.selectorTree;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ConsumerKey.java, SIB.processor, WAS602.SIB, o0610.11 1.57");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

