/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkIndex;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.statemodel.State;
import com.ibm.ws.sib.processor.impl.interfaces.MPCallsToUnitTestHandler;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class AsynchDeletionThread
implements Runnable,
StoppableThread {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)AsynchDeletionThread.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private volatile boolean _isRunning = false;
    private volatile boolean _isStopping = false;
    private volatile boolean _rerunRequested = false;

    AsynchDeletionThread(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AsynchDeletionThread", (Object)new Object[]{messageProcessor});
        }
        this._messageProcessor = messageProcessor;
        this._messageProcessor.getStoppableThreadCache().registerThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AsynchDeletionThread", (Object)this);
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"run");
        }
        MPCallsToUnitTestHandler mPCallsToUnitTestHandler = MessageProcessor.getMPCallsToUnitTestHandler();
        DestinationManager destinationManager = this._messageProcessor.getDestinationManager();
        DestinationIndex destinationIndex = destinationManager.getDestinationIndex();
        LinkIndex linkIndex = destinationManager.getLinkIndex();
        SIMPIterator sIMPIterator = null;
        boolean bl = true;
        try {
            while (bl && !this._isStopping) {
                this._messageProcessor.getProxyHandler().removeUnusedNeighbours();
                List list = (List)((ArrayList)destinationManager.getSubscriptionsToDelete()).clone();
                SubscriptionItemStream subscriptionItemStream = null;
                while (!list.isEmpty()) {
                    subscriptionItemStream = (SubscriptionItemStream)list.remove(0);
                    this.cleanupSubscription(subscriptionItemStream);
                    destinationManager.removeSubscriptionAsDeleted(subscriptionItemStream);
                }
                DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
                destinationTypeFilter.ALIAS = Boolean.FALSE;
                destinationTypeFilter.FOREIGN_DESTINATION = Boolean.FALSE;
                destinationTypeFilter.and = false;
                destinationTypeFilter.CLEANUP_PENDING = Boolean.TRUE;
                destinationTypeFilter.DELETE_PENDING = Boolean.TRUE;
                sIMPIterator = destinationIndex.iterator(destinationTypeFilter);
                BaseDestinationHandler baseDestinationHandler = null;
                while (sIMPIterator.hasNext() && !this._isStopping) {
                    boolean bl2;
                    if (mPCallsToUnitTestHandler != null) {
                        mPCallsToUnitTestHandler.asyncDeletionThreadReadyToStart();
                    }
                    if (bl2 = this.cleanUpDestination(baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next())) {
                        State state = destinationIndex.getState(baseDestinationHandler);
                        if (state.isCleanupPending()) {
                            destinationIndex.cleanupComplete(baseDestinationHandler);
                        } else {
                            destinationIndex.remove(baseDestinationHandler);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Destination " + baseDestinationHandler.getName() + " cleaned up"));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Failed to cleanup destination " + baseDestinationHandler.getName()));
                }
                sIMPIterator.finished();
                LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
                linkTypeFilter.and = false;
                linkTypeFilter.CLEANUP_PENDING = Boolean.TRUE;
                linkTypeFilter.DELETE_PENDING = Boolean.TRUE;
                sIMPIterator = linkIndex.iterator(linkTypeFilter);
                while (sIMPIterator.hasNext() && !this._isStopping) {
                    boolean bl3;
                    if (mPCallsToUnitTestHandler != null) {
                        mPCallsToUnitTestHandler.asyncDeletionThreadReadyToStart();
                    }
                    if (bl3 = this.cleanUpDestination(baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next())) {
                        State state = linkIndex.getState(baseDestinationHandler);
                        if (state.isCleanupPending()) {
                            linkIndex.cleanupComplete(baseDestinationHandler);
                        } else {
                            linkIndex.remove(baseDestinationHandler);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Link " + baseDestinationHandler.getName() + " cleaned up"));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Failed to cleanup Link " + baseDestinationHandler.getName()));
                }
                sIMPIterator.finished();
                bl = this._rerunRequested;
                this._rerunRequested = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AsynchDeletionThread.run", (String)"1:249:1.42", (Object)this);
            try {
                sIMPIterator.finished();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            mPCallsToUnitTestHandler = MessageProcessor.getMPCallsToUnitTestHandler();
            if (null != mPCallsToUnitTestHandler) {
                mPCallsToUnitTestHandler.unitTestFailure("Async background deletion thread failed with an exception ", exception);
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:284:1.42"}, null), (Throwable)exception);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
            throw sIErrorException;
        }
        finally {
            destinationManager.notifyAsynchDeletionEnd(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private void cleanupSubscription(SubscriptionItemStream subscriptionItemStream) {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"cleanupSubscription", (Object)subscriptionItemStream);
            }
            try {
                subscriptionItemStream.deleteIfPossible(true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AsynchDeletionThread.cleanupSubscription", (String)"1:318:1.42", (Object)subscriptionItemStream);
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)("Failed to delete subscription " + subscriptionItemStream));
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupSubscription");
        }
    }

    private boolean cleanUpDestination(BaseDestinationHandler baseDestinationHandler) {
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"cleanUpDestination", (Object)new Object[]{baseDestinationHandler});
            }
            bl = false;
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Starting clean-up for " + baseDestinationHandler.getName() + " : " + baseDestinationHandler.getUuid()));
                }
                bl = baseDestinationHandler.cleanupDestination();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Ended clean-up for " + baseDestinationHandler.getName() + " : " + baseDestinationHandler.getUuid() + " : Success " + bl));
                }
            }
            catch (Exception exception) {
                MPCallsToUnitTestHandler mPCallsToUnitTestHandler;
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)(" Failed to cleanup destination " + baseDestinationHandler.getName() + " : " + baseDestinationHandler.getUuid()));
                }
                if (null == (mPCallsToUnitTestHandler = MessageProcessor.getMPCallsToUnitTestHandler())) break block7;
                mPCallsToUnitTestHandler.unitTestFailure("Failed to clean up a destination on the async deletion thread.\nThe test reporting this failure may not be the one which caused the problem.\nLikely that the test which created + used the destination will show it up when\nre-running the tests stand-alone.\n" + baseDestinationHandler.toString() + "\n", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanUpDestination", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setRunning(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRunning");
            SibTr.exit((TraceComponent)tc, (String)"setRunning");
        }
        this._isRunning = bl;
    }

    public boolean isRunning() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRunning");
            SibTr.exit((TraceComponent)tc, (String)"isRunning", (Object)new Boolean(this._isRunning));
        }
        return this._isRunning;
    }

    public void setStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStopping");
            SibTr.exit((TraceComponent)tc, (String)"setStopping");
        }
        this._isStopping = true;
    }

    public boolean isStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStopping");
            SibTr.exit((TraceComponent)tc, (String)"isStopping", (Object)new Boolean(this._isStopping));
        }
        return this._isStopping;
    }

    public void rerun() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rerun");
        }
        this._rerunRequested = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rerun");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread(StoppableThreadCache stoppableThreadCache) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopThread", (Object)stoppableThreadCache);
        }
        Object object = this._messageProcessor.getDestinationManager().deletionThreadLock;
        synchronized (object) {
            this.setStopping();
            if (this.isRunning()) {
                try {
                    this._messageProcessor.getDestinationManager().deletionThreadLock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                }
            }
        }
        stoppableThreadCache.deregisterThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopThread");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AsynchDeletionThread.java, SIB.processor, WAS602.SIB, o0610.11 1.42");
        }
    }
}

