/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAccept;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlBrowseEnd;
import com.ibm.ws.sib.mfp.control.ControlBrowseGet;
import com.ibm.ws.sib.mfp.control.ControlBrowseStatus;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCompleted;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDecisionExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlReject;
import com.ibm.ws.sib.mfp.control.ControlRequest;
import com.ibm.ws.sib.mfp.control.ControlRequestAck;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.mfp.control.ControlRequestHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAck;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAckAck;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.AIRequestedTick;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.gd.AIValueTick;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.AIBrowseCursor;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.AIExecuteUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter;
import com.ibm.ws.sib.processor.impl.store.items.AICompletedPrefixItem;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.processor.runtime.AttachedRemoteSubscriberControl;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.utils.Queue;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.AbstractBatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.trm.dlm.DestinationLocationChangeListener;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AnycastInputHandler
implements InputHandler,
ControlHandler {
    public static final long INVALID_ACCEPTED_ITEM_ID = -1L;
    public static final long INVALID_COMPLETED_ITEM_ID = -1L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final long INVALID_TICK = -1L;
    private static int NUM_OF_BUCKETS = 4;
    private MPAlarmManager _alarmManager;
    private MessageProcessor _messageProcessor;
    private String _destName;
    private SIBUuid12 _destUuid;
    private MessagingEngine _dme;
    private ItemStream _containerItemStream;
    private AIProtocolItemStream _persistentStreamState;
    private boolean _streamStateRemoveNeedsToWait;
    private AIStream _aiStream;
    private RemoteConsumerDispatcher _remoteCD;
    protected AIStreamStatus _streamStatus;
    private boolean _cardinalityOne;
    private boolean _deliverInOrder;
    private long _currentRoundtripTime;
    private long[] _highestDeliveredExpressTicks;
    Queue msgsToBeDelivered = null;
    private Hashtable _browseCursorTable;
    private AsyncUpdateThread _msUpdateThread;
    private LinkedList _flushWorkQueue;
    protected long areYouFlushedId;
    private BatchedTimeoutManager _createStreamTOM;
    private CreateStreamTimeoutEntry _createStreamEntry;
    private BatchedTimeoutManager _requestFlushTOM;
    private RequestFlushTimeoutEntry _requestFlushEntry;
    private Alarm _inactivityTimeoutAlarm;
    private AlarmListener _inactivityTimeoutListener;
    private ReachabilityChangeListener _reachabilityChangeListener;
    private SIResourceException _dmeNotReachableException = null;
    private BaseDestinationHandler _baseDestinationHandler;
    private ArrayList _flushCallbacks = new ArrayList();
    private MyBoolean _forceDeleteMonitor = new MyBoolean(false);
    private boolean _needToRedriveDeleteDestination = false;
    private volatile long _totalCompletedRequests = 0L;
    private volatile long _totalSentRequests = 0L;
    private AttachedRemoteSubscriberControl _control;
    private int _numberOfFlushWorkItemsOnStream = 0;
    private static final TraceComponent tc = SibTr.register((Class)AnycastInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private boolean flushedWillDelete = false;

    public AnycastInputHandler(String string, SIBUuid12 sIBUuid12, boolean bl, MessageProcessor messageProcessor, ItemStream itemStream, SIBUuid8 sIBUuid8, AsyncUpdateThread asyncUpdateThread, BaseDestinationHandler baseDestinationHandler, boolean bl2) throws SIResourceException {
        this(string, sIBUuid12, bl, messageProcessor, itemStream, sIBUuid8, asyncUpdateThread, baseDestinationHandler, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastInputHandler(String string, SIBUuid12 sIBUuid12, boolean bl, MessageProcessor messageProcessor, ItemStream itemStream, SIBUuid8 sIBUuid8, AsyncUpdateThread asyncUpdateThread, BaseDestinationHandler baseDestinationHandler, boolean bl2, boolean bl3) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AnycastInputHandler", (Object)new Object[]{string, sIBUuid12, new Boolean(bl), messageProcessor, itemStream, sIBUuid8, asyncUpdateThread, baseDestinationHandler, new Boolean(bl2), new Boolean(bl3)});
        }
        AnycastInputHandler anycastInputHandler = this;
        synchronized (anycastInputHandler) {
            this._messageProcessor = messageProcessor;
            this._destName = string;
            this._destUuid = sIBUuid12;
            this._alarmManager = messageProcessor.getAlarmManager();
            this._containerItemStream = itemStream;
            this._dme = new MessagingEngine(sIBUuid8);
            this._msUpdateThread = asyncUpdateThread;
            this._baseDestinationHandler = baseDestinationHandler;
            this._cardinalityOne = bl;
            this._streamStatus = new AIStreamStatus(0);
            this._deliverInOrder = this._cardinalityOne;
            long l = this.generateUniqueValue();
            this.msgsToBeDelivered = new Queue();
            this._createStreamTOM = new BatchedTimeoutManager(NUM_OF_BUCKETS, SIMPConstants.CREATE_STREAM_REPETITION_INTERVAL, null, new CreateStreamTimeoutProcessor(), messageProcessor);
            this._createStreamEntry = null;
            this._requestFlushTOM = new BatchedTimeoutManager(NUM_OF_BUCKETS, 10000L, null, new RequestFlushTimeoutProcessor(), messageProcessor);
            this._requestFlushEntry = null;
            this.areYouFlushedId = -1L;
            boolean bl4 = false;
            this._streamStateRemoveNeedsToWait = false;
            NonLockingCursor nonLockingCursor = null;
            try {
                nonLockingCursor = itemStream.newNonLockingItemStreamCursor(null);
                this._persistentStreamState = (AIProtocolItemStream)nonLockingCursor.next();
                if (this._persistentStreamState != null) {
                    SIBUuid12 sIBUuid122 = null;
                    this._aiStream = new AIStream(sIBUuid122, this._persistentStreamState, this, asyncUpdateThread, l, null, true, messageProcessor);
                    if (bl2 || this._persistentStreamState.isFlushStarted()) {
                        this._streamStatus.set(7);
                        try {
                            this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
                        }
                        catch (SIResourceException sIResourceException) {
                            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.AnycastInputHandler", (String)"1:557:1.151", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                            bl4 = true;
                        }
                    } else if (this._cardinalityOne) {
                        this._streamStatus.set(1);
                    } else {
                        this._streamStatus.set(4);
                        bl4 = true;
                    }
                } else {
                    this._aiStream = null;
                    this._persistentStreamState = null;
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.AnycastInputHandler", (String)"1:593:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"AnycastInputHandler", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
            finally {
                if (nonLockingCursor != null) {
                    nonLockingCursor.finished();
                }
            }
            this._currentRoundtripTime = SIMPConstants.INIT_ROUND_TRIP_TIME;
            this._highestDeliveredExpressTicks = new long[10];
            for (int i = 0; i < 9; ++i) {
                this._highestDeliveredExpressTicks[i] = l;
            }
            this._browseCursorTable = new Hashtable();
            this.start();
            if (bl4) {
                this.startInactivityTimer();
            }
            this._reachabilityChangeListener = new ReachabilityChangeListener();
            messageProcessor.getDestinationChangeListener().addMPDestinationChangeListener(this._reachabilityChangeListener);
        }
        if (bl3) {
            this.createControlAdapter();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AnycastInputHandler", (Object)this);
        }
    }

    public void initRCD(RemoteConsumerDispatcher remoteConsumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initRCD", (Object)remoteConsumerDispatcher);
        }
        this._remoteCD = remoteConsumerDispatcher;
        this._reachabilityChangeListener.initRCD(remoteConsumerDispatcher);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initRCD");
        }
    }

    public RemoteConsumerDispatcher getRCD() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRCD");
            SibTr.exit((TraceComponent)tc, (String)"getRCD", (Object)this._remoteCD);
        }
        return this._remoteCD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete");
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            try {
                if (!this._streamStatus.test(0)) {
                    this.cleanupStreamState();
                    this._streamStatus.set(0);
                }
            }
            catch (SIResourceException sIResourceException) {
            }
            catch (SIErrorException sIErrorException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        this._createStreamTOM.startTimer();
        this._requestFlushTOM.startTimer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this._createStreamTOM.stopTimer();
        this._requestFlushTOM.stopTimer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void startInactivityTimer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startInactivityTimer");
        }
        if (this._inactivityTimeoutListener == null) {
            this._inactivityTimeoutListener = new InactivityTimeoutListener();
        }
        this._inactivityTimeoutAlarm = this._alarmManager.create(SIMPConstants.SENDER_INACTIVITY_TIMEOUT, this._inactivityTimeoutListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startInactivityTimer");
        }
    }

    public void cancelInactivityTimer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelInactivityTimer");
        }
        if (this._inactivityTimeoutAlarm != null) {
            this._inactivityTimeoutAlarm.cancel();
            this._inactivityTimeoutAlarm = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelInactivityTimer");
        }
    }

    public void changeReceiveExclusive(boolean bl) {
        this._cardinalityOne = bl;
        this._deliverInOrder = bl;
    }

    public void handleMessage(MessageItem messageItem, Transaction transaction, JsDestinationAddress jsDestinationAddress, Cellule cellule) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{messageItem, transaction, jsDestinationAddress, cellule});
        }
        messageItem.setCurrentMEArrivalTimestamp(System.currentTimeMillis());
        JsMessage jsMessage = messageItem.getMessage();
        if (jsMessage.isGuaranteedRemoteBrowse()) {
            this.handleBrowseDataMessage(messageItem);
        } else {
            this.handleDataMessage(messageItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) throws SIResourceException {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) == ControlMessageType.COMPLETED) {
            this.processCompletedMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.DECISIONEXPECTED) {
            this.processDecisionExpectedMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.REQUESTHIGHESTGENERATEDTICK) {
            this.processRequestHighestGeneratedTickMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.BROWSEEND) {
            this.processBrowseEndMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.REQUESTACK) {
            this.processRequestAckMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.RESETREQUESTACK) {
            this.processResetRequestAckMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.FLUSHED) {
            this.processFlushedMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.NOTFLUSHED) {
            this.processNotFlushedMessage(controlMessage);
        } else if (controlMessageType == ControlMessageType.CARDINALITYINFO) {
            this.processCardinalityInfoMessage(controlMessage);
        } else {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:864:1.151"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.handleControlMessage", (String)"1:870:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:877:1.151"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void consumerAttaching() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumerAttaching");
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object = this._streamStatus;
        synchronized (object) {
            switch (this._streamStatus.get()) {
                case 0: {
                    this._streamStatus.set(3);
                    bl = true;
                    break;
                }
                case 1: {
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_NOT_FLUSHED_CWSIP0512", new Object[]{this._destName, this._dme.toString()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"consumerAttaching");
                    }
                    throw sIResourceException;
                }
                case 2: {
                    bl2 = true;
                    break;
                }
                case 4: {
                    this._remoteCD.readyToIssueGet();
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_NOT_FLUSHED_CWSIP0512", new Object[]{this._destName, this._dme.toString()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"consumerAttaching");
                    }
                    throw sIResourceException;
                }
            }
        }
        this.cancelInactivityTimer();
        if (bl) {
            this.sendCreateStreamAndWait();
        }
        if (bl2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.consumerAttaching", (String)"1:983:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
            }
            object = null;
            AnycastInputHandler anycastInputHandler = this;
            synchronized (anycastInputHandler) {
                if (this._dmeNotReachableException != null) {
                    object = this._dmeNotReachableException;
                    this._dmeNotReachableException = null;
                }
            }
            if (object != null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", null);
                }
                throw object;
            }
            this.sendCreateStreamAndWait();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumerAttaching");
        }
    }

    public void lastCardNConsumerDetached() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lastCardNConsumerDetached");
        }
        this.startInactivityTimer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lastCardNConsumerDetached");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIStreamKey issueGet(SelectionCriteria[] selectionCriteriaArray, long l, RemoteDispatchableKey remoteDispatchableKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueGet", (Object)new Object[]{selectionCriteriaArray, new Long(l), remoteDispatchableKey});
        }
        AIStreamKey aIStreamKey = null;
        long l2 = -1L;
        long l3 = -1L;
        boolean bl = false;
        Object object = this._streamStatus;
        synchronized (object) {
            if (this.isStreamReady() && this.checkStreamHasNoFlushWork()) {
                l2 = this.generateUniqueValue();
                long l4 = System.currentTimeMillis();
                aIStreamKey = new AIStreamKey(l2, remoteDispatchableKey, l, l4);
                try {
                    l3 = this._aiStream.insertRequest(l2, selectionCriteriaArray, l, remoteDispatchableKey, l4);
                    this._aiStream.setLatestTick(l2);
                    ++this._totalSentRequests;
                    bl = true;
                }
                catch (SIErrorException sIErrorException) {}
            } else {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1099:1.151"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.issueGet", (String)"1:1105:1.151", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (bl) {
            object = new long[]{l3};
            long[] lArray = new long[]{l2};
            long[] lArray2 = new long[]{l};
            this.sendRequest((long[])object, lArray, selectionCriteriaArray, lArray2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)aIStreamKey);
        }
        return aIStreamKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIStreamKey[] issueGet(SelectionCriteria[] selectionCriteriaArray, int n, RemoteDispatchableKey remoteDispatchableKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueGet", (Object)new Object[]{selectionCriteriaArray, new Integer(n), remoteDispatchableKey});
        }
        AIStreamKey[] aIStreamKeyArray = null;
        long[] lArray = null;
        long[] lArray2 = null;
        long l = SIMPConstants.INFINITE_TIMEOUT;
        long[] lArray3 = null;
        boolean bl = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.isStreamReady() && this.checkStreamHasNoFlushWork()) {
                lArray = new long[n];
                lArray2 = new long[n];
                lArray3 = new long[n];
                aIStreamKeyArray = new AIStreamKey[n];
                for (int i = 0; i < n; ++i) {
                    long l2 = -1L;
                    lArray2[i] = l2 = this.generateUniqueValue();
                    long l3 = System.currentTimeMillis();
                    aIStreamKeyArray[i] = new AIStreamKey(l2, remoteDispatchableKey, l, l3);
                    lArray3[i] = l;
                    try {
                        lArray[i] = this._aiStream.insertRequest(l2, selectionCriteriaArray, l, remoteDispatchableKey, l3);
                        this._aiStream.setLatestTick(l2);
                        ++this._totalSentRequests;
                        bl = true;
                        continue;
                    }
                    catch (SIErrorException sIErrorException) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"issueGet", null);
                        }
                        return null;
                    }
                }
            } else {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1205:1.151"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.issueGet", (String)"1:1211:1.151", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (bl) {
            this.sendRequest(lArray, lArray2, selectionCriteriaArray, lArray3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)aIStreamKeyArray);
        }
        return aIStreamKeyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(AIStreamKey aIStreamKey, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"accept", (Object)new Object[]{aIStreamKey, transaction});
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            AIProtocolItem aIProtocolItem;
            if (!(this._streamStatus.test(5) || this._streamStatus.test(2) || this._streamStatus.test(6) || this._streamStatus.test(8) || !this.isStreamReady() || (aIProtocolItem = this._aiStream.processAccepted(aIStreamKey.getTimestamp(), transaction)) == null)) {
                aIStreamKey.setAcceptedItem(aIProtocolItem);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"accept");
        }
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        SIBUuid8 sIBUuid8 = this.getLocalisationME().getUuid();
        PubSubOutputHandler pubSubOutputHandler = this.getBaseDestinationHandler().getPubSubOutputHandler(sIBUuid8);
        RemoteTopicSpaceControl remoteTopicSpaceControl = null;
        if (pubSubOutputHandler == null || pubSubOutputHandler.getControlAdapter() == null) {
            remoteTopicSpaceControl = new RemoteTopicSpaceControl(null, this, this._messageProcessor);
        } else {
            remoteTopicSpaceControl = (RemoteTopicSpaceControl)pubSubOutputHandler.getControlAdapter();
            remoteTopicSpaceControl.setAnycastInputHandler(this);
        }
        this._control = new AttachedRemoteSubscriberControl(this._destName, this, this._messageProcessor, remoteTopicSpaceControl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public AttachedRemoteSubscriberControl getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this._control);
        }
        return this._control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void committed(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"committed", (Object)new Object[]{aIStreamKey});
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (!(this._streamStatus.test(5) || this._streamStatus.test(2) || this._streamStatus.test(6) || this._streamStatus.test(8) || !this.isStreamReady())) {
                long l = aIStreamKey.getTimestamp();
                AIProtocolItem aIProtocolItem = aIStreamKey.getAcceptedItem();
                try {
                    this._aiStream.updateToAccepted(l, aIProtocolItem);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
                if (this._flushWorkQueue != null && !this.streamHasIndoubtTransactions() && this._flushWorkQueue.size() > 0) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (tc.isEntryEnabled()) {
                                SibTr.entry((TraceComponent)tc, (String)"run");
                            }
                            AnycastInputHandler.this.drainFlushWorkQueue();
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"run");
                            }
                        }
                    };
                    try {
                        this._messageProcessor.startNewSystemThread(runnable);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.committed", (String)"1:1392:1.151", (Object)this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"committed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rolledback(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)new Object[]{aIStreamKey});
        }
        SendDispatcher sendDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (!(this._streamStatus.test(5) || this._streamStatus.test(2) || this._streamStatus.test(6) || this._streamStatus.test(8) || !this.isStreamReady())) {
                try {
                    this._aiStream.updateToRejected(aIStreamKey.getTimestamp(), sendDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
            }
        }
        sendDispatcher.dispatch();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rolledback");
        }
    }

    public void reject(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reject", (Object)aIStreamKey);
        }
        this.reject(aIStreamKey.getTimestamp());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reject", (Object)new Long(l));
        }
        SendDispatcher sendDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (!(this._streamStatus.test(5) || this._streamStatus.test(2) || this._streamStatus.test(6) || this._streamStatus.test(8) || !this.isStreamReady())) {
                try {
                    this._aiStream.updateToRejected(l, sendDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
            }
        }
        sendDispatcher.dispatch();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectAll() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rejectAll");
        }
        boolean bl = false;
        SendDispatcher sendDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(4) || this._streamStatus.test(1) || this._streamStatus.test(8)) {
                this._streamStatus.set(2);
                try {
                    this._aiStream.updateAllToRejected(sendDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
                bl = true;
            } else if (!(this._streamStatus.test(5) || this._streamStatus.test(2) || this._streamStatus.test(6) || this._streamStatus.test(7) || this._streamStatus.test(0))) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1566:1.151"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.rejectAll", (String)"1:1573:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1581:1.151"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rejectAll", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        sendDispatcher.dispatch();
        if (bl) {
            try {
                this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.rejectAll", (String)"1:1604:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                AIStreamStatus aIStreamStatus2 = this._streamStatus;
                synchronized (aIStreamStatus2) {
                    this._streamStatus.set(1);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rejectAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForFlushDone() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForFlushDone");
        }
        if (!this.flushedWillDelete) {
            this.delete();
        }
        if (this._forceDeleteMonitor != null) {
            MyBoolean myBoolean = this._forceDeleteMonitor;
            synchronized (myBoolean) {
                if (this._forceDeleteMonitor.booleanValue()) {
                    this._forceDeleteMonitor.setBooleanValue(false);
                    this._forceDeleteMonitor.notifyAll();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForFlushDone");
        }
    }

    public long getRoundTripTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoundTripTime");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRoundTripTime", (Object)new Long(this._currentRoundtripTime));
        }
        return this._currentRoundtripTime;
    }

    public void forceFlushAtTarget() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
        FlushWorkItem flushWorkItem = new FlushWorkItem(){

            public void performWorkItem() {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                }
                AnycastInputHandler.this.forceFlushAtTargetInternal(false);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"performWorkItem");
                }
            }
        };
        this.performFlushWork(flushWorkItem, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceFlushAtTargetInternal(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTargetInternal");
        }
        boolean bl2 = false;
        this.flushedWillDelete = bl;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(0)) {
                this._needToRedriveDeleteDestination = false;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTargetInternal", (Object)"Stream non existent");
                }
                return true;
            }
            if (this._streamStatus.test(8) || this._streamStatus.test(2)) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTargetInternal", (Object)"Stream force deleting or flushing");
                }
                return false;
            }
            this._streamStatus.set(8);
            if (bl) {
                this._needToRedriveDeleteDestination = true;
            }
        }
        this._forceDeleteMonitor.setBooleanValue(true);
        this._remoteCD.closeAllConsumersForFlush();
        if (!bl) {
            this.waitOnForceDeleteMonitor();
            bl2 = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTargetInternal", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStreamHasNoFlushWork() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStreamHasNoFlushWork");
        }
        boolean bl = true;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._numberOfFlushWorkItemsOnStream > 0) {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStreamHasNoFlushWork", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnForceDeleteMonitor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitOnForceDeleteMonitor");
        }
        if (this._forceDeleteMonitor != null) {
            MyBoolean myBoolean = this._forceDeleteMonitor;
            synchronized (myBoolean) {
                if (this._forceDeleteMonitor.booleanValue()) {
                    try {
                        this._forceDeleteMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.waitOnForceDeleteMonitor", (String)"1:1855:1.151", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitOnForceDeleteMonitor");
        }
    }

    public boolean destinationDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationDeleted");
        }
        boolean bl = false;
        boolean bl2 = this.streamHasIndoubtTransactions();
        if (!bl2) {
            bl = this.forceFlushAtTargetInternal(true);
        } else {
            FlushWorkItem flushWorkItem = new FlushWorkItem(){

                public void performWorkItem() {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                    }
                    AnycastInputHandler.this.forceFlushAtTargetInternal(true);
                }
            };
            this.performFlushWork(flushWorkItem, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationDeleted", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonLockingCursor newBrowseCursor(Filter filter) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newBrowseCursor", (Object)filter);
        }
        long l = 0L;
        AIBrowseCursor aIBrowseCursor = null;
        l = this.generateUniqueValue();
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            aIBrowseCursor = new AIBrowseCursor(this, filter, l, this._alarmManager);
            this._browseCursorTable.put(new Long(l), aIBrowseCursor);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newBrowseCursor", (Object)aIBrowseCursor);
        }
        return aIBrowseCursor;
    }

    public void sendRequest(long[] lArray, long[] lArray2, SelectionCriteria[] selectionCriteriaArray, long[] lArray3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequest", (Object)new Object[]{SIMPUtils.longArrayToString(lArray), SIMPUtils.longArrayToString(lArray2), selectionCriteriaArray, SIMPUtils.longArrayToString(lArray3)});
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlRequest controlRequest = controlMessageFactory.createNewControlRequest();
            this.initializeControlMessage((ControlMessage)controlRequest, this._dme.getUuid(), this._aiStream.getStreamId());
            String[] stringArray = null;
            int[] nArray = null;
            String[] stringArray2 = null;
            if (selectionCriteriaArray != null) {
                stringArray = new String[selectionCriteriaArray.length];
                nArray = new int[selectionCriteriaArray.length];
                stringArray2 = new String[selectionCriteriaArray.length];
                for (int i = 0; i < selectionCriteriaArray.length; ++i) {
                    stringArray[i] = selectionCriteriaArray[i].getSelectorString();
                    nArray[i] = selectionCriteriaArray[i].getSelectorDomain().toInt();
                    stringArray2[i] = selectionCriteriaArray[i].getDiscriminator();
                }
            } else {
                stringArray = new String[]{};
                stringArray2 = new String[]{};
                nArray = new int[]{};
            }
            controlRequest.setRejectStartTick(lArray);
            controlRequest.setGetTick(lArray2);
            controlRequest.setFilter(stringArray);
            controlRequest.setSelectorDomain(nArray);
            controlRequest.setControlDiscriminator(stringArray2);
            controlRequest.setTimeout(lArray3);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlRequest);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendRequest", (String)"1:2019:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequest");
        }
    }

    public void sendAccept(long[] lArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAccept", (Object)SIMPUtils.longArrayToString(lArray));
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlAccept controlAccept = controlMessageFactory.createNewControlAccept();
            this.initializeControlMessage((ControlMessage)controlAccept, this._dme.getUuid(), this._aiStream.getStreamId());
            controlAccept.setTick(lArray);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlAccept);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendAccept", (String)"1:2057:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAccept");
        }
    }

    public void sendReject(long[] lArray, long[] lArray2, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendReject", (Object)new Object[]{SIMPUtils.longArrayToString(lArray), SIMPUtils.longArrayToString(lArray2), new Boolean(bl)});
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlReject controlReject = controlMessageFactory.createNewControlReject();
            this.initializeControlMessage((ControlMessage)controlReject, this._dme.getUuid(), this._aiStream.getStreamId());
            controlReject.setStartTick(lArray);
            controlReject.setEndTick(lArray2);
            controlReject.setRecovery(bl);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlReject);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendReject", (String)"1:2100:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendReject");
        }
    }

    public void resolve(int n, AIStreamKey aIStreamKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{new Integer(n), aIStreamKey});
        }
        this._remoteCD.resolve(n, aIStreamKey);
    }

    public void sendCompleted(long[] lArray, long[] lArray2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompleted", (Object)new Object[]{SIMPUtils.longArrayToString(lArray), SIMPUtils.longArrayToString(lArray2)});
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlCompleted controlCompleted = controlMessageFactory.createNewControlCompleted();
            this.initializeControlMessage((ControlMessage)controlCompleted, this._dme.getUuid(), this._aiStream.getStreamId());
            controlCompleted.setStartTick(lArray);
            controlCompleted.setEndTick(lArray2);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlCompleted);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCompleted", (String)"1:2149:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompleted");
        }
    }

    public void sendAreYouFlushed(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushed", (Object)sIBUuid12);
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlAreYouFlushed controlAreYouFlushed = controlMessageFactory.createNewControlAreYouFlushed();
            this.initializeControlMessage((ControlMessage)controlAreYouFlushed, this._dme.getUuid(), sIBUuid12);
            this.areYouFlushedId = this.generateUniqueValue();
            controlAreYouFlushed.setRequestID(this.areYouFlushedId);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlAreYouFlushed);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendAreYouFlushed", (String)"1:2193:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushed");
        }
    }

    public long getUniqueLockID(int n) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUniqueLockID");
        }
        long l = this._messageProcessor.getMessageStore().getUniqueLockID(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUniqueLockID", (Object)new Long(l));
        }
        return l;
    }

    public long getTotalSentRequests() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalSentRequests");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalSentRequests", (Object)new Long(this._totalSentRequests));
        }
        return this._totalSentRequests;
    }

    public void sendHighestGeneratedTick(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendHighestGeneratedTick", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlHighestGeneratedTick controlHighestGeneratedTick = controlMessageFactory.createNewControlHighestGeneratedTick();
            this.initializeControlMessage((ControlMessage)controlHighestGeneratedTick, this._dme.getUuid(), this._aiStream.getStreamId());
            controlHighestGeneratedTick.setRequestID(l);
            controlHighestGeneratedTick.setTick(l2);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlHighestGeneratedTick);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendHighestGeneratedTick", (String)"1:2259:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendHighestGeneratedTick");
        }
    }

    public void sendDecision(long l) {
    }

    public void sendResetRequestAckAck(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendResetRequestAckAck", (Object)new Long(l));
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlResetRequestAckAck controlResetRequestAckAck = controlMessageFactory.createNewControlResetRequestAckAck();
            this.initializeControlMessage((ControlMessage)controlResetRequestAckAck, this._dme.getUuid(), this._aiStream.getStreamId());
            controlResetRequestAckAck.setDMEVersion(l);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlResetRequestAckAck);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendResetRequestAckAck", (String)"1:2302:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendResetRequestAckAck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCreateStream(long l) throws SIResourceException {
        MPIO mPIO;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCreateStream", (Object)new Long(l));
        }
        if (!(mPIO = this._messageProcessor.getMPIO()).isMEReachable(this._dme)) {
            String string;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCreateStream", null);
            }
            if ((string = JsAdminUtils.getMENameByUuid((String)this._dme.getUuid().toString())) == null) {
                string = this._dme.getUuid().toString();
            }
            throw new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{this._destName, string}, null));
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlCreateStream controlCreateStream = controlMessageFactory.createNewControlCreateStream();
            this.initializeControlMessage((ControlMessage)controlCreateStream, this._dme.getUuid(), null);
            controlCreateStream.setRequestID(l);
            controlCreateStream.setDurableSubName(null);
            controlCreateStream.setDurableDiscriminator(null);
            controlCreateStream.setDurableSelector(null);
            controlCreateStream.setDurableSelectorDomain(0);
            controlCreateStream.setSecurityUserid(null);
            controlCreateStream.setSecurityUseridSentBySystem(false);
            controlCreateStream.setCloned(false);
            controlCreateStream.setNoLocal(false);
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlCreateStream);
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (this._streamStatus.test(0)) {
                    this._streamStatus.set(3);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCreateStream", (String)"1:2378:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCreateStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestFlush(IndoubtAction indoubtAction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlush", (Object)indoubtAction);
        }
        if (this._requestFlushEntry != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
            }
            return;
        }
        if (!this._persistentStreamState.isFlushStarted()) {
            AIProtocolItemStream aIProtocolItemStream = this._persistentStreamState;
            synchronized (aIProtocolItemStream) {
                this._persistentStreamState.setFlushStarted(true);
                PersistentStreamAsyncUpdate persistentStreamAsyncUpdate = new PersistentStreamAsyncUpdate();
                this._streamStateRemoveNeedsToWait = true;
                AIExecuteUpdate aIExecuteUpdate = new AIExecuteUpdate(persistentStreamAsyncUpdate, this._messageProcessor);
                aIExecuteUpdate.run();
            }
        }
        this._requestFlushEntry = new RequestFlushTimeoutEntry();
        this._requestFlushTOM.addTimeoutEntry(this._requestFlushEntry);
        try {
            this.sendRequestFlush(this._requestFlushEntry.requestFlushId, indoubtAction);
        }
        catch (SIResourceException sIResourceException) {
            this._requestFlushTOM.removeTimeoutEntry(this._requestFlushEntry);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
        }
    }

    protected void sendRequestFlush(long l, IndoubtAction indoubtAction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlush", (Object)new Object[]{new Long(l), indoubtAction});
        }
        if (this._messageProcessor.getProxyHandler().getNeighbour(this._dme.getUuid()) == null) {
            String string;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush", null);
            }
            if ((string = JsAdminUtils.getMENameByUuid((String)this._dme.getUuid().toString())) == null) {
                string = this._dme.getUuid().toString();
            }
            throw new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_REQUEST_FLUSH_CWSIP0518", new Object[]{this._destName, string}, null));
        }
        MPIO mPIO = this._messageProcessor.getMPIO();
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlRequestFlush controlRequestFlush = controlMessageFactory.createNewControlRequestFlush();
            this.initializeControlMessage((ControlMessage)controlRequestFlush, this._dme.getUuid(), this._aiStream.getStreamId());
            controlRequestFlush.setRequestID(l);
            if (indoubtAction == IndoubtAction.INDOUBT_DELETE) {
                controlRequestFlush.setIndoubtDiscard(true);
            } else if (indoubtAction == IndoubtAction.INDOUBT_LEAVE) {
                controlRequestFlush.setIndoubtDiscard(false);
            }
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlRequestFlush);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendRequestFlush", (String)"1:2522:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
        }
    }

    protected final void initializeControlMessage(ControlMessage controlMessage, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{controlMessage, sIBUuid8, sIBUuid12});
        }
        controlMessage.setPriority(11);
        controlMessage.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        controlMessage.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlMessage.setGuaranteedStreamUUID(sIBUuid12);
        controlMessage.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlMessage.setGuaranteedTargetMessagingEngineUUID(sIBUuid8);
        controlMessage.setGuaranteedProtocolType(ProtocolType.ANYCASTOUTPUT);
        controlMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    public void sendBrowseGet(long l, long l2, Filter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseGet", (Object)new Object[]{new Long(l), new Long(l2), filter});
        }
        try {
            Object object;
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlBrowseGet controlBrowseGet = controlMessageFactory.createNewControlBrowseGet();
            this.initializeControlMessage((ControlMessage)controlBrowseGet, this._dme.getUuid(), null);
            controlBrowseGet.setBrowseID(l);
            controlBrowseGet.setSequenceNumber(l2);
            if (filter != null && filter instanceof MessageSelectorFilter) {
                object = (MessageSelectorFilter)filter;
                String string = ((MessageSelectorFilter)object).getSelectorString();
                controlBrowseGet.setFilter(string);
                controlBrowseGet.setSelectorDomain(((MessageSelectorFilter)object).getDomain().toInt());
                controlBrowseGet.setControlDiscriminator(((MessageSelectorFilter)object).getDiscriminator());
            } else {
                controlBrowseGet.setFilter("");
                controlBrowseGet.setSelectorDomain(0);
                controlBrowseGet.setControlDiscriminator(null);
            }
            object = this._messageProcessor.getMPIO();
            ((MPIO)object).sendToMe(this._dme, 1, 11, (ControlMessage)controlBrowseGet);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendBrowseGet", (String)"1:2612:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseGet");
        }
    }

    public void sendBrowseStatus(int n, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseStatus", (Object)new Object[]{new Integer(n), new Long(l)});
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlBrowseStatus controlBrowseStatus = controlMessageFactory.createNewControlBrowseStatus();
            this.initializeControlMessage((ControlMessage)controlBrowseStatus, this._dme.getUuid(), null);
            controlBrowseStatus.setStatus(n);
            controlBrowseStatus.setBrowseID(l);
            MPIO mPIO = this._messageProcessor.getMPIO();
            mPIO.sendToMe(this._dme, 1, 11, (ControlMessage)controlBrowseStatus);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendBrowseStatus", (String)"1:2654:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseStatus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBrowseCursor(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBrowseCursor", (Object)new Object[]{new Long(l)});
        }
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            Long l2 = new Long(l);
            AIBrowseCursor aIBrowseCursor = (AIBrowseCursor)this._browseCursorTable.get(l2);
            if (aIBrowseCursor != null) {
                this._browseCursorTable.remove(l2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBrowseCursor");
        }
    }

    public long getCompletedRequestCount() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedRequestCount");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedRequestCount", (Object)new Long(this._totalCompletedRequests));
        }
        return this._totalCompletedRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCreateStreamAndWait() throws SIResourceException {
        Object object;
        SIResourceException sIResourceException;
        block26: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendCreateStreamAndWait");
            }
            sIResourceException = null;
            this._createStreamEntry = new CreateStreamTimeoutEntry();
            try {
                this.sendCreateStream(this._createStreamEntry.createStreamId);
            }
            catch (SIResourceException sIResourceException2) {
                FFDCFilter.processException((Throwable)sIResourceException2, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCreateStreamAndWait", (String)"1:2721:1.151", (Object)this);
                AIStreamStatus aIStreamStatus = this._streamStatus;
                synchronized (aIStreamStatus) {
                    this._streamStatus.set(0);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)sIResourceException2));
                }
                throw sIResourceException2;
            }
            this._createStreamTOM.addTimeoutEntry(this._createStreamEntry);
            this._createStreamTOM.startTimer();
            try {
                this.wait();
                object = this;
                synchronized (object) {
                    if (this._dmeNotReachableException != null) {
                        sIResourceException = this._dmeNotReachableException;
                        this._dmeNotReachableException = null;
                    }
                }
                if (sIResourceException != null) break block26;
                object = this._streamStatus;
                synchronized (object) {
                    if (this._streamStatus.test(0)) {
                        SIResourceException sIResourceException3 = new SIResourceException(nls.getFormattedMessage("CONSUMERCARDINALITY_LIMIT_REACHED_CWSIP0514", new Object[]{this._destName, this._dme.toString()}, null));
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException3));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)sIResourceException3));
                        }
                        throw sIResourceException3;
                    }
                    if (!this._streamStatus.test(4)) {
                        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:2795:1.151"}, null));
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCreateStreamAndWait", (String)"1:2802:1.151", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:2810:1.151"});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)sIErrorException));
                        }
                        throw sIErrorException;
                    }
                    this._remoteCD.readyToIssueGet();
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCreateStreamAndWait", (String)"1:2823:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
            }
        }
        if (sIResourceException != null) {
            object = this._streamStatus;
            synchronized (object) {
                this._streamStatus.set(0);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", null);
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getRedeliveredCount(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRedeliveredCount", (Object)new Long(l));
        }
        int n = -1;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(4)) {
                n = this._aiStream.getRedeliveredCount(l);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRedeliveredCount", (Object)new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataMessage(MessageItem messageItem) throws SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleDataMessage", (Object)messageItem);
        }
        long l = System.currentTimeMillis();
        JsMessage jsMessage = messageItem.getMessage();
        AIMessageItem aIMessageItem = new AIMessageItem(jsMessage);
        aIMessageItem.setCurrentMEArrivalTimestamp(messageItem.getCurrentMEArrivalTimestamp());
        aIMessageItem.setFromRemoteME(messageItem.isFromRemoteME());
        aIMessageItem.setFromRemoteBus(messageItem.isFromRemoteBus());
        AIRequestedTick aIRequestedTick = null;
        long l2 = jsMessage.getGuaranteedRemoteGetValueTick();
        long l3 = jsMessage.getGuaranteedRemoteGetPrevTick();
        long l4 = jsMessage.getGuaranteedRemoteGetStartTick();
        SendDispatcher sendDispatcher = new SendDispatcher();
        boolean bl = true;
        Object object2 = this._streamStatus;
        synchronized (object2) {
            if (this.okToProcess(jsMessage)) {
                if (l4 < l2 && l2 > 0L) {
                    try {
                        this._aiStream.updateToCompleted(l4, l2 - 1L);
                    }
                    catch (SIErrorException sIErrorException) {
                        // empty catch block
                    }
                }
                boolean bl2 = (object = jsMessage.getReliability()).compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0;
                int n = jsMessage.getPriority();
                boolean bl3 = true;
                if (this._deliverInOrder) {
                    bl3 = bl2 ? this.canDeliverExpressInOrder(l2, n) : this._aiStream.canDeliverAssuredInOrder(l2, l3, n);
                }
                try {
                    aIRequestedTick = this._aiStream.updateRequestToValue(l2, aIMessageItem, bl3, sendDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleDataMessage");
                    }
                    return;
                }
                if (aIRequestedTick != null) {
                    RemoteDispatchableKey remoteDispatchableKey = aIRequestedTick.getRemoteDispatchableKey();
                    if (bl3) {
                        AIStreamKey aIStreamKey = new AIStreamKey(l2, remoteDispatchableKey, aIRequestedTick.getOriginalTimeout(), aIRequestedTick.getIssueTime());
                        aIMessageItem.setInfo(this._remoteCD, aIStreamKey);
                        Object object3 = this.msgsToBeDelivered;
                        synchronized (object3) {
                            this.msgsToBeDelivered.enqueue(aIMessageItem);
                        }
                        if (this._deliverInOrder) {
                            if (bl2) {
                                this.setHighestDeliveredExpress(n, l2);
                            } else {
                                object3 = this._aiStream.findUndeliveredList(l2, jsMessage);
                                if (object3 != null) {
                                    int n2 = object3.size();
                                    Queue queue = this.msgsToBeDelivered;
                                    synchronized (queue) {
                                        for (int i = 0; i < n2; ++i) {
                                            AIValueTick aIValueTick = (AIValueTick)object3.get(i);
                                            AIMessageItem aIMessageItem2 = aIValueTick.getMsg();
                                            aIStreamKey = new AIStreamKey(aIValueTick.getTick(), aIValueTick.getRemoteDispatchableKey(), aIValueTick.getOriginalTimeout(), aIValueTick.getIssueTime());
                                            aIMessageItem2.setInfo(this._remoteCD, aIStreamKey);
                                            this.msgsToBeDelivered.enqueue(aIMessageItem2);
                                        }
                                    }
                                    this._aiStream.markListDelivered((List)object3);
                                }
                            }
                        }
                    } else if (bl2 && this._deliverInOrder) {
                        try {
                            this._aiStream.updateToAccepted(l2, null);
                        }
                        catch (SIErrorException sIErrorException) {}
                    }
                } else {
                    bl = false;
                }
            }
        }
        sendDispatcher.dispatch();
        if (bl) {
            object2 = this.msgsToBeDelivered;
            synchronized (object2) {
                object = null;
                while (!this.msgsToBeDelivered.isEmpty()) {
                    if (object == null) {
                        object = new ArrayList(this.msgsToBeDelivered.size());
                    }
                    AIMessageItem aIMessageItem3 = (AIMessageItem)this.msgsToBeDelivered.dequeue();
                    object.add(aIMessageItem3);
                }
                if (object != null) {
                    this._remoteCD.put((List)object);
                }
            }
        }
        if (aIRequestedTick != null) {
            long l5 = jsMessage.getGuaranteedRemoteGetWaitTime();
            this.updateRoundtripTime(aIRequestedTick.getIssueTime(), l, l5);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleDataMessage");
        }
    }

    private boolean isStreamReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStreamReady");
        }
        boolean bl = false;
        if (!this._streamStatus.test(4)) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3092:1.151"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.isStreamReady", (String)"1:3098:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3105:1.151"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isStreamReady", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        bl = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStreamReady", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean okToProcess(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToProcess", (Object)jsMessage);
        }
        boolean bl = false;
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        if (this._streamStatus.test(4) && this.checkStreamHasNoFlushWork()) {
            SIBUuid12 sIBUuid122 = this._aiStream.getStreamId();
            if (!sIBUuid12.equals((Object)sIBUuid122)) {
                this.sendAreYouFlushed(sIBUuid122);
                bl = false;
            } else {
                bl = true;
            }
        } else if (this._streamStatus.test(0)) {
            this.sendAreYouFlushed(sIBUuid12);
            bl = false;
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToProcess", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean okToProcess(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToProcess", (Object)controlMessage);
        }
        boolean bl = false;
        SIBUuid12 sIBUuid12 = controlMessage.getGuaranteedStreamUUID();
        if (this._streamStatus.test(4)) {
            SIBUuid12 sIBUuid122 = this._aiStream.getStreamId();
            if (!sIBUuid12.equals((Object)sIBUuid122)) {
                this.sendAreYouFlushed(sIBUuid122);
                bl = false;
            } else {
                bl = true;
            }
        } else if (this._streamStatus.test(0)) {
            this.sendAreYouFlushed(sIBUuid12);
            bl = false;
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToProcess", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean canDeliverExpressInOrder(long l, int n) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"canDeliverExpressInOrder", (Object)new Object[]{new Long(l), new Integer(n)});
        }
        boolean bl2 = bl = l > this._highestDeliveredExpressTicks[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"canDeliverExpressInOrder", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void setHighestDeliveredExpress(int n, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setHighestDeliveredExpress", (Object)new Object[]{new Integer(n), new Long(l)});
        }
        this._highestDeliveredExpressTicks[n] = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setHighestDeliveredExpress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBrowseDataMessage(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleBrowseDataMessage", (Object)messageItem);
        }
        JsMessage jsMessage = messageItem.getMessage();
        long l = jsMessage.getGuaranteedRemoteBrowseID();
        AIBrowseCursor aIBrowseCursor = null;
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            aIBrowseCursor = (AIBrowseCursor)this._browseCursorTable.get(new Long(l));
        }
        if (aIBrowseCursor != null) {
            aIBrowseCursor.put(messageItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleBrowseDataMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompletedMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCompletedMessage", (Object)controlMessage);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(controlMessage) || this._streamStatus.test(2) || this._streamStatus.test(8)) {
                ControlCompleted controlCompleted = (ControlCompleted)controlMessage;
                long[] lArray = controlCompleted.getStartTick();
                long[] lArray2 = controlCompleted.getEndTick();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        this._aiStream.updateToCompleted(lArray[i], lArray2[i]);
                        ++this._totalCompletedRequests;
                        continue;
                    }
                    catch (SIResourceException sIResourceException) {
                        break;
                    }
                    catch (SIErrorException sIErrorException) {
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCompletedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDecisionExpectedMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDecisionExpectedMessage", (Object)controlMessage);
        }
        SendDispatcher sendDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(controlMessage)) {
                long[] lArray = ((ControlDecisionExpected)controlMessage).getTick();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    this._aiStream.processDecisionExpected(lArray[i], sendDispatcher);
                }
            }
        }
        sendDispatcher.dispatch();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDecisionExpectedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestHighestGeneratedTickMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestHighestGeneratedTickMessage", (Object)controlMessage);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(controlMessage)) {
                long l = ((ControlRequestHighestGeneratedTick)controlMessage).getRequestID();
                long l2 = this._aiStream.getLatestTick();
                this.sendHighestGeneratedTick(l, l2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestHighestGeneratedTickMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBrowseEndMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processBrowseEndMessage", (Object)controlMessage);
        }
        ControlBrowseEnd controlBrowseEnd = (ControlBrowseEnd)controlMessage;
        long l = controlBrowseEnd.getBrowseID();
        AIBrowseCursor aIBrowseCursor = null;
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            aIBrowseCursor = (AIBrowseCursor)this._browseCursorTable.get(new Long(l));
        }
        if (aIBrowseCursor != null) {
            int n = controlBrowseEnd.getExceptionCode();
            switch (n) {
                case 0: {
                    aIBrowseCursor.endBrowse();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    aIBrowseCursor.browseFailed(n);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processBrowseEndMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestAckMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestAckMessage", (Object)controlMessage);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(controlMessage)) {
                ControlRequestAck controlRequestAck = (ControlRequestAck)controlMessage;
                long[] lArray = controlRequestAck.getTick();
                long l = controlRequestAck.getDMEVersion();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    this._aiStream.processRequestAck(lArray[i], l);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestAckMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResetRequestAckMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processResetRequestAckMessage", (Object)controlMessage);
        }
        SendDispatcher sendDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(controlMessage)) {
                long l = ((ControlResetRequestAck)controlMessage).getDMEVersion();
                this._aiStream.processResetRequestAck(l, sendDispatcher);
            }
        }
        sendDispatcher.dispatch();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processResetRequestAckMessage");
        }
    }

    private void processFlushedMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushedMessage", (Object)controlMessage);
        }
        final ControlMessage controlMessage2 = controlMessage;
        FlushWorkItem flushWorkItem = new FlushWorkItem(){

            public void performWorkItem() {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                }
                AnycastInputHandler.this.processFlushedMessageInternal(controlMessage2);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"performWorkItem");
                }
            }
        };
        this.performFlushWork(flushWorkItem, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushedMessage", (Object)controlMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFlushedMessageInternal(ControlMessage controlMessage) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushedMessageInternal", (Object)controlMessage);
        }
        if (this._requestFlushEntry != null) {
            this._requestFlushTOM.removeTimeoutEntry(this._requestFlushEntry);
            this._requestFlushEntry = null;
        }
        boolean bl = false;
        boolean bl2 = false;
        Object object3 = this._streamStatus;
        synchronized (object3) {
            switch (this._streamStatus.get()) {
                case 2: {
                    bl2 = true;
                    bl = true;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bl = true;
                    break;
                }
                case 4: {
                    object2 = ((ControlFlushed)controlMessage).getGuaranteedStreamUUID();
                    object = this._aiStream.getStreamId();
                    if (!object2.equals(object)) break;
                    AIStreamStatus aIStreamStatus = this._streamStatus;
                    synchronized (aIStreamStatus) {
                        this._streamStatus.set(8);
                    }
                    this.flushedWillDelete = false;
                    this._remoteCD.closeAllConsumersForFlush();
                    break;
                }
            }
        }
        if (bl) {
            try {
                this.waitOnForceDeleteMonitor();
                this.delete();
            }
            catch (SIErrorException sIErrorException) {
                // empty catch block
            }
        }
        if (bl2) {
            object3 = this;
            synchronized (object3) {
                this.notifyAll();
            }
        }
        object3 = this._flushCallbacks;
        synchronized (object3) {
            object2 = this._flushCallbacks.iterator();
            while (object2.hasNext()) {
                object = (Runnable)object2.next();
                try {
                    this._messageProcessor.startNewSystemThread((Runnable)object);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processFlushedMessageInternal", (String)"1:3619:1.151", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                }
            }
            this._flushCallbacks.clear();
        }
        if (bl && this._needToRedriveDeleteDestination) {
            this._baseDestinationHandler.getDestinationManager().startAsynchDeletion();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushedMessageInternal");
        }
    }

    private void cleanupStreamState() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupStreamState");
        }
        this.stop();
        this._aiStream.stop();
        this._aiStream.updateAllToCompleted();
        if (this._control != null) {
            this._control.deregisterControlAdapterMBean();
            this._control = null;
        }
        RemovePersistentStream removePersistentStream = new RemovePersistentStream();
        AIExecuteUpdate aIExecuteUpdate = new AIExecuteUpdate(removePersistentStream, this._messageProcessor);
        aIExecuteUpdate.run();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupStreamState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotFlushedMessage(ControlMessage controlMessage) throws SIResourceException {
        SIBUuid12 sIBUuid12;
        SIBUuid12 sIBUuid122;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)controlMessage);
        }
        ControlNotFlushed controlNotFlushed = (ControlNotFlushed)controlMessage;
        long l = controlNotFlushed.getRequestID();
        if (this._createStreamEntry != null && l == this._createStreamEntry.createStreamId) {
            if (controlMessage.getGuaranteedProtocolType() != ProtocolType.DURABLEINPUT) {
                this._createStreamTOM.removeTimeoutEntry(this._createStreamEntry);
            }
            this._createStreamEntry = null;
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (!this._streamStatus.test(3)) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3706:1.151"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processNotFlushedMessage", (String)"1:3711:1.151", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3718:1.151"});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)((Object)sIErrorException));
                    }
                    return;
                }
            }
            aIStreamStatus = controlNotFlushed.getGuaranteedStreamUUID();
            long l2 = this.generateUniqueValue();
            CreatePersistentStream createPersistentStream = new CreatePersistentStream((SIBUuid12)aIStreamStatus, l2, l2);
            AIExecuteUpdate aIExecuteUpdate = new AIExecuteUpdate(createPersistentStream, this._messageProcessor);
            aIExecuteUpdate.run();
            Object object = this._streamStatus;
            synchronized (object) {
                if (this._streamStatus.test(3)) {
                    this._streamStatus.set(4);
                }
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
        if (l == this.areYouFlushedId && !(sIBUuid122 = controlNotFlushed.getGuaranteedStreamUUID()).equals((Object)(sIBUuid12 = this._aiStream.getStreamId()))) {
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (this._streamStatus.test(0)) {
                    long l3 = this.generateUniqueValue();
                    long[] lArray = controlNotFlushed.getCompletedPrefixTicks();
                    long l4 = lArray[0];
                    CreatePersistentStream createPersistentStream = new CreatePersistentStream(sIBUuid122, l3, l4);
                    AIExecuteUpdate aIExecuteUpdate = new AIExecuteUpdate(createPersistentStream, this._messageProcessor);
                    aIExecuteUpdate.run();
                    this._streamStatus.set(4);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCardinalityInfoMessage(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCardinalityInfoMessage", (Object)controlMessage);
        }
        ControlCardinalityInfo controlCardinalityInfo = (ControlCardinalityInfo)controlMessage;
        SIBUuid12 sIBUuid12 = controlCardinalityInfo.getGuaranteedStreamUUID();
        long l = controlCardinalityInfo.getRequestID();
        if (sIBUuid12 != null) {
            SIBUuid12 sIBUuid122 = this._aiStream.getStreamId();
            boolean bl = false;
            if (sIBUuid12.equals((Object)sIBUuid122)) {
                SendDispatcher sendDispatcher = new SendDispatcher();
                AIStreamStatus aIStreamStatus = this._streamStatus;
                synchronized (aIStreamStatus) {
                    if (this._streamStatus.test(4)) {
                        try {
                            this._aiStream.updateAllToRejected(sendDispatcher);
                        }
                        catch (SIErrorException sIErrorException) {
                            // empty catch block
                        }
                        this._streamStatus.set(5);
                        bl = true;
                    }
                }
                sendDispatcher.dispatch();
                try {
                    this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processCardinalityInfoMessage", (String)"1:3852:1.151", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    AIStreamStatus aIStreamStatus2 = this._streamStatus;
                    synchronized (aIStreamStatus2) {
                        this._streamStatus.set(1);
                    }
                }
                if (bl) {
                    this._remoteCD.disconnectCardOneConsumer();
                }
            }
        } else if (this._createStreamEntry != null && l == this._createStreamEntry.createStreamId) {
            this._createStreamTOM.removeTimeoutEntry(this._createStreamEntry);
            this._createStreamEntry = null;
            Object object = this._streamStatus;
            synchronized (object) {
                if (this._streamStatus.test(3)) {
                    this._streamStatus.set(0);
                }
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCardinalityInfoMessage");
        }
    }

    private void updateRoundtripTime(long l, long l2, long l3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateRoundtripTime", (Object)new Object[]{new Long(l), new Long(l2), new Long(l3)});
        }
        long l4 = l2 - l - l3;
        this._currentRoundtripTime = (this._currentRoundtripTime + l4) / 2L;
        if (this._currentRoundtripTime < SIMPConstants.ROUND_TRIP_TIME_LOW_LIMIT) {
            this._currentRoundtripTime = SIMPConstants.INIT_ROUND_TRIP_TIME;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRoundtripTime");
        }
    }

    protected long generateUniqueValue() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateUniqueValue");
        }
        long l = 0L;
        l = this._messageProcessor.nextTick();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateUniqueValue", (Object)new Long(l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForDurableStartup(long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepareForDurableStartup", (Object)new Long(l));
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            this._streamStatus.set(3);
        }
        this._createStreamEntry = new CreateStreamTimeoutEntry();
        this._createStreamEntry.createStreamId = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepareForDurableStartup");
        }
    }

    public final String getDestName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestName");
            SibTr.exit((TraceComponent)tc, (String)"getDestName");
        }
        return this._destName;
    }

    public final SIBUuid12 getDestUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"getDestUuid");
        }
        return this._destUuid;
    }

    public final MessagingEngine getLocalisationME() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalisationME");
            SibTr.exit((TraceComponent)tc, (String)"getLocalisationME", (Object)this._dme);
        }
        return this._dme;
    }

    public AIStream getAIStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIStream");
            SibTr.exit((TraceComponent)tc, (String)"getAIStream", (Object)new Object[]{this._aiStream});
        }
        return this._aiStream;
    }

    public BaseDestinationHandler getBaseDestinationHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBaseDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getBaseDestinationHandler", (Object)new Object[]{this._baseDestinationHandler});
        }
        return this._baseDestinationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFlushedCallback(Runnable runnable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addFlushedCallback", (Object)runnable);
        }
        ArrayList arrayList = this._flushCallbacks;
        synchronized (arrayList) {
            this._flushCallbacks.add(runnable);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addFlushedCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testStreamStatus(int n) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"testStreamStatus", (Object)new Integer(n));
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            bl = this._streamStatus.test(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"testStreamStatus", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFlushWork(FlushWorkItem flushWorkItem, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"performFlushWork", (Object)new Object[]{flushWorkItem, new Boolean(bl)});
        }
        boolean bl2 = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            ++this._numberOfFlushWorkItemsOnStream;
            if (!bl && this.streamHasIndoubtTransactions()) {
                if (this._flushWorkQueue == null) {
                    this._flushWorkQueue = new LinkedList();
                } else {
                    this._flushWorkQueue.add(flushWorkItem);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"flush work has queued until all indoubt-transactions are resolved");
                    }
                }
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            try {
                flushWorkItem.performWorkItem();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.performFlushWork", (String)"1:4748:1.151", (Object)this);
            }
            aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                --this._numberOfFlushWorkItemsOnStream;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"performFlushWork");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainFlushWorkQueue() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"drainFlushWorkQueue");
        }
        LinkedList linkedList = null;
        Object object2 = this._streamStatus;
        synchronized (object2) {
            linkedList = this._flushWorkQueue;
            this._flushWorkQueue = null;
        }
        object2 = linkedList.iterator();
        int n = 0;
        while (object2.hasNext()) {
            ++n;
            object = (FlushWorkItem)object2.next();
            try {
                object.performWorkItem();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.drainFlushWorkQueue", (String)"1:4803:1.151", (Object)this);
            }
        }
        object = this._streamStatus;
        synchronized (object) {
            this._numberOfFlushWorkItemsOnStream -= n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"drainFlushWorkQueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean streamHasIndoubtTransactions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"streamHasIndoubtTransactions");
        }
        boolean bl = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._aiStream != null && this._aiStream.countAllMessagesOnStream() > 0L) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"streamHasIndoubtTransactions", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AnycastInputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.151");
        }
    }

    public class MyBoolean {
        private boolean myBooleanValue;

        public MyBoolean(boolean bl) {
            this.myBooleanValue = bl;
        }

        public boolean booleanValue() {
            return this.myBooleanValue;
        }

        public void setBooleanValue(boolean bl) {
            this.myBooleanValue = bl;
        }
    }

    public class SendDispatcher {
        private boolean needToSend = false;
        private int typeToSend = 0;
        private long[] rejectStartTicks = null;
        private long[] ticks = null;
        private SelectionCriteria[] criterias = null;
        private long[] timeout = null;
        private long[] startTicks = null;
        private long[] endTicks = null;
        private boolean recovery = false;
        private long dmeVersion = -1L;

        public void sendRequest(long[] lArray, long[] lArray2, SelectionCriteria[] selectionCriteriaArray, long[] lArray3) {
            this.rejectStartTicks = lArray;
            this.ticks = lArray2;
            this.criterias = selectionCriteriaArray;
            this.timeout = lArray3;
            this.needToSend = true;
            this.typeToSend = 9;
        }

        public void sendAccept(long[] lArray) {
            this.ticks = lArray;
            this.needToSend = true;
            this.typeToSend = 6;
        }

        public void sendReject(long[] lArray, long[] lArray2, boolean bl) {
            this.startTicks = lArray;
            this.endTicks = lArray2;
            this.recovery = bl;
            this.needToSend = true;
            this.typeToSend = 7;
        }

        public void sendCompleted(long[] lArray, long[] lArray2) {
            this.startTicks = lArray;
            this.endTicks = lArray2;
            this.needToSend = true;
            this.typeToSend = 18;
        }

        public void sendResetRequestAckAck(long l) {
            this.dmeVersion = l;
            this.needToSend = true;
            this.typeToSend = 14;
        }

        public void dispatch() {
            if (this.needToSend) {
                switch (this.typeToSend) {
                    case 9: {
                        AnycastInputHandler.this.sendRequest(this.rejectStartTicks, this.ticks, this.criterias, this.timeout);
                        break;
                    }
                    case 6: {
                        AnycastInputHandler.this.sendAccept(this.ticks);
                        break;
                    }
                    case 7: {
                        AnycastInputHandler.this.sendReject(this.startTicks, this.endTicks, this.recovery);
                        break;
                    }
                    case 18: {
                        AnycastInputHandler.this.sendCompleted(this.startTicks, this.endTicks);
                        break;
                    }
                    case 14: {
                        AnycastInputHandler.this.sendResetRequestAckAck(this.dmeVersion);
                    }
                }
                this.reset();
            }
        }

        private void reset() {
            this.needToSend = false;
            this.typeToSend = 0;
            this.rejectStartTicks = null;
            this.ticks = null;
            this.criterias = null;
            this.timeout = null;
            this.startTicks = null;
            this.endTicks = null;
            this.recovery = false;
            this.dmeVersion = -1L;
        }
    }

    public static interface FlushWorkItem {
        public void performWorkItem();
    }

    public class ReachabilityChangeListener
    implements DestinationLocationChangeListener {
        private RemoteConsumerDispatcher rcd = null;

        public void initRCD(RemoteConsumerDispatcher remoteConsumerDispatcher) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"initRCD", (Object)new Object[]{this, remoteConsumerDispatcher});
            }
            this.rcd = remoteConsumerDispatcher;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initRCD");
            }
        }

        public void destinationLocationChange(SIBUuid12 sIBUuid12, Set set, Set set2, Capability capability) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"destinationLocationChange", (Object)new Object[]{this, sIBUuid12, set, set2, capability});
            }
            if (this.rcd != null && AnycastInputHandler.this._destUuid.equals((Object)sIBUuid12)) {
                SIBUuid8 sIBUuid8;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    sIBUuid8 = (SIBUuid8)iterator.next();
                    if (!AnycastInputHandler.this._dme.getUuid().equals((Object)sIBUuid8) || capability != Capability.GET) continue;
                    this.rcd.reachabilityChange(true);
                }
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    sIBUuid8 = (SIBUuid8)iterator.next();
                    if (!AnycastInputHandler.this._dme.getUuid().equals((Object)sIBUuid8) || capability != Capability.GET) continue;
                    this.rcd.reachabilityChange(false);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"destinationLocationChange");
            }
        }
    }

    public class InactivityTimeoutListener
    implements AlarmListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            SendDispatcher sendDispatcher = new SendDispatcher();
            boolean bl = false;
            AIStreamStatus aIStreamStatus = AnycastInputHandler.this._streamStatus;
            synchronized (aIStreamStatus) {
                if (AnycastInputHandler.this._streamStatus.test(4)) {
                    try {
                        AnycastInputHandler.this._aiStream.updateAllToRejected(sendDispatcher);
                        AnycastInputHandler.this._streamStatus.set(6);
                        bl = true;
                    }
                    catch (SIErrorException sIErrorException) {}
                } else if (AnycastInputHandler.this._streamStatus.test(7)) {
                    bl = true;
                }
            }
            sendDispatcher.dispatch();
            if (bl) {
                try {
                    AnycastInputHandler.this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
                    AnycastInputHandler.this._inactivityTimeoutAlarm.cancel();
                    AnycastInputHandler.this._inactivityTimeoutAlarm = null;
                }
                catch (SIResourceException sIResourceException) {
                    AIStreamStatus aIStreamStatus2 = AnycastInputHandler.this._streamStatus;
                    synchronized (aIStreamStatus2) {
                        if (AnycastInputHandler.this._streamStatus.test(6)) {
                            AnycastInputHandler.this._streamStatus.set(4);
                        }
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    class RequestFlushTimeoutEntry
    extends AbstractBatchedTimeoutEntry {
        public long requestFlushId;

        public RequestFlushTimeoutEntry() throws SIResourceException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"RequestFlushTimeoutEntry");
            }
            this.requestFlushId = AnycastInputHandler.this.generateUniqueValue();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"RequestFlushTimeoutEntry", (Object)this);
            }
        }
    }

    class RequestFlushTimeoutProcessor
    implements BatchedTimeoutProcessor {
        RequestFlushTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimedoutEntries(List list) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                RequestFlushTimeoutEntry requestFlushTimeoutEntry = (RequestFlushTimeoutEntry)list.get(i);
                try {
                    AnycastInputHandler.this.sendRequestFlush(requestFlushTimeoutEntry.requestFlushId, IndoubtAction.INDOUBT_DELETE);
                    continue;
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.RequestFlushTimeoutProcessor.processTimedoutEntries", (String)"1:4483:1.151", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    AnycastInputHandler.this._requestFlushTOM.removeTimeoutEntry(AnycastInputHandler.this._requestFlushEntry);
                    AnycastInputHandler.this._requestFlushEntry = null;
                    AnycastInputHandler anycastInputHandler = AnycastInputHandler.this;
                    synchronized (anycastInputHandler) {
                        AnycastInputHandler.this._dmeNotReachableException = sIResourceException;
                        AnycastInputHandler.this.notify();
                        continue;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
            }
        }
    }

    class CreateStreamTimeoutEntry
    extends AbstractBatchedTimeoutEntry {
        public long createStreamId;

        public CreateStreamTimeoutEntry() throws SIResourceException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CreateStreamTimeoutEntry");
            }
            this.createStreamId = AnycastInputHandler.this.generateUniqueValue();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CreateStreamTimeoutEntry", (Object)this);
            }
        }
    }

    class CreateStreamTimeoutProcessor
    implements BatchedTimeoutProcessor {
        CreateStreamTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimedoutEntries(List list) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                CreateStreamTimeoutEntry createStreamTimeoutEntry = (CreateStreamTimeoutEntry)list.get(i);
                try {
                    AnycastInputHandler.this.sendCreateStream(createStreamTimeoutEntry.createStreamId);
                    continue;
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.CreateStreamTimeoutProcessor.processTimedoutEntries", (String)"1:4413:1.151", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    AnycastInputHandler.this._createStreamTOM.removeTimeoutEntry(AnycastInputHandler.this._createStreamEntry);
                    AnycastInputHandler.this._createStreamEntry = null;
                    Object object = AnycastInputHandler.this._streamStatus;
                    synchronized (object) {
                        if (AnycastInputHandler.this._streamStatus.test(3)) {
                            AnycastInputHandler.this._streamStatus.set(0);
                        }
                    }
                    object = AnycastInputHandler.this;
                    synchronized (object) {
                        AnycastInputHandler.this._dmeNotReachableException = sIResourceException;
                        AnycastInputHandler.this.notify();
                        continue;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
            }
        }
    }

    class RemovePersistentStream
    extends SyncUpdateWithRetry {
        RemovePersistentStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            AnycastInputHandler.this._aiStream.removeCompletedPrefix(transaction, AnycastInputHandler.this._messageProcessor.getMessageStore().getUniqueLockID(1));
            AIProtocolItemStream aIProtocolItemStream = AnycastInputHandler.this._persistentStreamState;
            synchronized (aIProtocolItemStream) {
                if (AnycastInputHandler.this._streamStateRemoveNeedsToWait) {
                    AnycastInputHandler.this._persistentStreamState.wait();
                }
                long l = AnycastInputHandler.this._messageProcessor.getMessageStore().getUniqueLockID(1);
                AnycastInputHandler.this._persistentStreamState.lockItemIfAvailable(l);
                AnycastInputHandler.this._persistentStreamState.remove(transaction, l);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            AIStreamStatus aIStreamStatus = AnycastInputHandler.this._streamStatus;
            synchronized (aIStreamStatus) {
                AnycastInputHandler.this._aiStream = null;
                AnycastInputHandler.this._persistentStreamState = null;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class PersistentStreamAsyncUpdate
    extends SyncUpdateWithRetry {
        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{this, transaction});
            }
            AnycastInputHandler.this._persistentStreamState.requestUpdate(transaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed", (Object)this);
            }
            if (AnycastInputHandler.this._streamStateRemoveNeedsToWait) {
                AIProtocolItemStream aIProtocolItemStream = AnycastInputHandler.this._persistentStreamState;
                synchronized (aIProtocolItemStream) {
                    AnycastInputHandler.this._streamStateRemoveNeedsToWait = false;
                    AnycastInputHandler.this._persistentStreamState.notify();
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class CreatePersistentStream
    extends SyncUpdateWithRetry {
        private SIBUuid12 streamId;
        private AIProtocolItemStream itemStream;
        private long latestTick;
        private AICompletedPrefixItem completedPrefixItem;

        CreatePersistentStream(SIBUuid12 sIBUuid12, long l, long l2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CreatePersistentStream", (Object)new Object[]{sIBUuid12, new Long(l), new Long(l2)});
            }
            this.streamId = sIBUuid12;
            this.latestTick = l;
            this.completedPrefixItem = new AICompletedPrefixItem(l2);
            this.itemStream = new AIProtocolItemStream(sIBUuid12);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CreatePersistentStream", (Object)this);
            }
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            AnycastInputHandler.this._containerItemStream.addItemStream(this.itemStream, transaction);
            this.itemStream.addItem(this.completedPrefixItem, transaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            try {
                AnycastInputHandler.this._aiStream = new AIStream(this.streamId, this.itemStream, AnycastInputHandler.this, AnycastInputHandler.this._msUpdateThread, this.latestTick, this.completedPrefixItem, false, AnycastInputHandler.this._messageProcessor);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.CreatePersistentStream.committed", (String)"1:4282:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            AnycastInputHandler.this._persistentStreamState = this.itemStream;
            AnycastInputHandler.this.start();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    abstract class SyncUpdateWithRetry
    extends AsyncUpdate {
        private int repetitionCount;

        public SyncUpdateWithRetry() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"SyncUpdateWithRetry");
            }
            this.repetitionCount = 1;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"SyncUpdateWithRetry", (Object)this);
            }
        }

        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.SyncUpdateWithRetry.rolledback", (String)"1:4175:1.151", (Object)this);
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            ++this.repetitionCount;
            if (this.repetitionCount > 4) {
                Exception exception = new Exception(nls.getFormattedMessage("MSGSTORE_STOP_RETRY_CWSIP0515", new Object[]{AnycastInputHandler.this._destName, new Integer(4)}, null));
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.SyncUpdateWithRetry.rolledback", (String)"1:4196:1.151", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            } else {
                AIExecuteUpdate aIExecuteUpdate = new AIExecuteUpdate(this, AnycastInputHandler.this._messageProcessor);
                aIExecuteUpdate.run();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    public class AIStreamStatus {
        public static final int STREAM_NON_EXISTENT = 0;
        public static final int STREAM_NOT_FLUSHED = 1;
        public static final int STREAM_FLUSHING = 2;
        public static final int STREAM_CREATING = 3;
        public static final int STREAM_READY = 4;
        public static final int STREAM_CARD1_FLUSH = 5;
        public static final int STREAM_INACT_FLUSH = 6;
        public static final int STREAM_RESTART_FLUSH = 7;
        public static final int STREAM_FORCE_DELETING = 8;
        private int status;

        public AIStreamStatus(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIStreamStatus", (Object)new Integer(n));
            }
            this.status = n;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIStreamStatus", (Object)this);
            }
        }

        public boolean test(int n) {
            boolean bl;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"test", (Object)new Integer(n));
            }
            boolean bl2 = bl = this.status == n;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"test", (Object)new Boolean(bl));
            }
            return bl;
        }

        public int get() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"get");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"get", (Object)new Integer(this.status));
            }
            return this.status;
        }

        public void set(int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"set", (Object)new Integer(n));
            }
            this.status = n;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"set");
            }
        }
    }
}

