/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.ExtendedBoolean;
import com.ibm.ws.sib.admin.QualifiedDestinationName;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.Alias;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AliasDestinationHandler
extends AbstractAliasDestinationHandler {
    private static final TraceComponent tc = SibTr.register((Class)AliasDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DestinationAliasDefinition _definition;
    private List _forwardRoutingPath = null;
    private boolean _frpSet = false;
    private boolean _isReceiveAllowed;

    public AliasDestinationHandler(DestinationAliasDefinition destinationAliasDefinition, MessageProcessor messageProcessor, SIMPItemStream sIMPItemStream, DestinationHandler destinationHandler, String string) {
        super(messageProcessor, destinationHandler, string);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AliasDestinationHandler", (Object)new Object[]{destinationAliasDefinition, messageProcessor, sIMPItemStream, destinationHandler, string});
        }
        this._definition = destinationAliasDefinition;
        if (destinationAliasDefinition != null) {
            this.setReceiveAllowed(destinationAliasDefinition);
        } else {
            this._isReceiveAllowed = true;
        }
        this.createControlAdapter();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AliasDestinationHandler", (Object)this);
        }
    }

    public Object getContextValue(String string) {
        Map map;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getContextValue", (Object)string);
        }
        if (null == (object = (map = this._definition.getDestinationContext()).get(string))) {
            object = this.getTarget().getContextValue(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getContextValue", object);
        }
        return object;
    }

    public int getDefaultPriority() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultPriority");
        }
        if ((n = this._definition.getDefaultPriority()) == -1) {
            n = this.getTarget().getDefaultPriority();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultPriority", (Object)new Integer(n));
        }
        return n;
    }

    public Reliability getDefaultReliability() {
        Reliability reliability;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultReliability");
        }
        if ((reliability = this._definition.getDefaultReliability()).equals(Reliability.NONE)) {
            reliability = this.getTarget().getDefaultReliability();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultReliability", (Object)reliability);
        }
        return reliability;
    }

    public String getDescription() {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        if (null == (string = this._definition.getDescription())) {
            string = this.getTarget().getDescription();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)string);
        }
        return string;
    }

    public DestinationType getDestinationType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationType");
        }
        DestinationType destinationType = this.getTarget().getDestinationType();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationType", (Object)destinationType);
        }
        return destinationType;
    }

    public Reliability getMaxReliability() {
        Reliability reliability;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxReliability");
        }
        if ((reliability = this._definition.getMaxReliability()).equals(Reliability.NONE)) {
            reliability = this.getTarget().getMaxReliability();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaxReliability", (Object)reliability);
        }
        return reliability;
    }

    public boolean isOverrideOfQOSByProducerAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed");
        }
        ExtendedBoolean extendedBoolean = this._definition.isOverrideOfQOSByProducerAllowed();
        boolean bl = false;
        bl = extendedBoolean.equals(ExtendedBoolean.NONE) ? this.getTarget().isOverrideOfQOSByProducerAllowed() : !extendedBoolean.equals(ExtendedBoolean.FALSE);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isAlias() {
        return true;
    }

    public boolean isForeign() {
        return false;
    }

    public boolean isSendAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        ExtendedBoolean extendedBoolean = this._definition.isSendAllowed();
        boolean bl = false;
        bl = extendedBoolean.equals(ExtendedBoolean.NONE) ? this.getTarget().isSendAllowed() : !extendedBoolean.equals(ExtendedBoolean.FALSE);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    public synchronized boolean isReceiveAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed");
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)new Boolean(this._isReceiveAllowed));
        }
        return this._isReceiveAllowed;
    }

    private synchronized void setReceiveAllowed(DestinationAliasDefinition destinationAliasDefinition) {
        ExtendedBoolean extendedBoolean;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReceiveAllowed", (Object)destinationAliasDefinition);
        }
        this._isReceiveAllowed = (extendedBoolean = destinationAliasDefinition.isReceiveAllowed()).equals(ExtendedBoolean.NONE) ? this.getTarget().isReceiveAllowed() : !extendedBoolean.equals(ExtendedBoolean.FALSE);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReceiveAllowed", (Object)new Boolean(this._isReceiveAllowed));
        }
    }

    public BaseDestinationDefinition getDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefinition");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefinition", (Object)this._definition);
        }
        return this._definition;
    }

    public void updateDefinition(BaseDestinationDefinition baseDestinationDefinition) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDefinition", (Object)baseDestinationDefinition);
        }
        DestinationAliasDefinition destinationAliasDefinition = this._definition;
        DestinationAliasDefinition destinationAliasDefinition2 = (DestinationAliasDefinition)baseDestinationDefinition;
        this._definition = (DestinationAliasDefinition)baseDestinationDefinition;
        if (destinationAliasDefinition == null || destinationAliasDefinition.isReceiveAllowed() != destinationAliasDefinition2.isReceiveAllowed()) {
            this.setReceiveAllowed(destinationAliasDefinition2);
            if (this.isPubSub()) {
                SubscriptionTypeFilter subscriptionTypeFilter = new SubscriptionTypeFilter();
                subscriptionTypeFilter.LOCAL = Boolean.TRUE;
                SIMPIterator sIMPIterator = this.getSubscriptionIndex().iterator(subscriptionTypeFilter);
                while (sIMPIterator.hasNext()) {
                    ControllableSubscription controllableSubscription = (ControllableSubscription)sIMPIterator.next();
                    ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)controllableSubscription.getOutputHandler();
                    if (consumerDispatcher == null || !consumerDispatcher.getConsumerDispatcherState().getTopicSpaceUuid().equals((Object)this.getUuid())) continue;
                    consumerDispatcher.notifyReceiveAllowed(this);
                }
                sIMPIterator.finished();
            } else {
                ConsumerDispatcher consumerDispatcher = this.getLocalPtoPConsumerDispatcher();
                if (consumerDispatcher != null) {
                    consumerDispatcher.notifyReceiveAllowed(this);
                }
            }
            this.notifyReceiveAllowedRCD(this);
            this.notifyTargettingAliasesReceiveAllowed();
        }
        this._forwardRoutingPath = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDefinition");
        }
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new Alias(this.messageProcessor, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter", (Object)this.controlAdapter);
        }
    }

    public ControlAdapter getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public String getTargetName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetName");
            SibTr.exit((TraceComponent)tc, (String)"getTargetName", (Object)this._definition.getTargetName());
        }
        return this._definition.getTargetName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getForwardRoutingPath() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardRoutingPath");
        }
        if (!this._frpSet) {
            AliasDestinationHandler aliasDestinationHandler = this;
            synchronized (aliasDestinationHandler) {
                QualifiedDestinationName[] qualifiedDestinationNameArray = this._definition.getForwardRoutingPath();
                if (qualifiedDestinationNameArray != null) {
                    this._forwardRoutingPath = new ArrayList(qualifiedDestinationNameArray.length);
                    for (int i = 0; i < qualifiedDestinationNameArray.length; ++i) {
                        this._forwardRoutingPath.add(SIMPUtils.createJsDestinationAddress(qualifiedDestinationNameArray[i].getDestination(), null, qualifiedDestinationNameArray[i].getBus()));
                    }
                }
                this._frpSet = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForwardRoutingPath", (Object)this._forwardRoutingPath);
        }
        return this._forwardRoutingPath;
    }

    public SIDestinationAddress[] getDefaultForwardRoutingPath() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultForwardRoutingPath");
        }
        QualifiedDestinationName[] qualifiedDestinationNameArray = this._definition.getForwardRoutingPath();
        SIDestinationAddress[] sIDestinationAddressArray = null;
        if (qualifiedDestinationNameArray != null) {
            sIDestinationAddressArray = new SIDestinationAddress[qualifiedDestinationNameArray.length];
            for (int i = 0; i < qualifiedDestinationNameArray.length; ++i) {
                sIDestinationAddressArray[i] = SIMPUtils.createJsDestinationAddress(qualifiedDestinationNameArray[i].getDestination(), null, qualifiedDestinationNameArray[i].getBus());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultForwardRoutingPath", (Object)sIDestinationAddressArray);
        }
        return sIDestinationAddressArray;
    }

    public JsDestinationAddress getReplyDestination() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplyDestination");
        }
        JsDestinationAddress jsDestinationAddress = null;
        QualifiedDestinationName qualifiedDestinationName = this._definition.getReplyDestination();
        if (qualifiedDestinationName != null) {
            jsDestinationAddress = SIMPUtils.createJsDestinationAddress(qualifiedDestinationName.getDestination(), this.messageProcessor.getMessagingEngineUuid(), qualifiedDestinationName.getBus());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", jsDestinationAddress);
        }
        return jsDestinationAddress;
    }

    public boolean checkDestinationAccess(SecurityContext securityContext, OperationType operationType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{securityContext, operationType});
        }
        boolean bl = false;
        if (this._definition.getDelegateAuthorizationCheckToTarget()) {
            if (this.getTarget().checkDestinationAccess(securityContext, operationType)) {
                bl = true;
            }
        } else if (this.accessChecker.checkDestinationAccess(securityContext, this.getBus(), this.getDefinition().getName(), operationType)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isTopicAccessCheckRequired() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTopicAccessCheckRequired");
        }
        boolean bl = this.getTarget().isTopicAccessCheckRequired();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkDiscriminatorAccess(SecurityContext securityContext, OperationType operationType) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Object[]{securityContext, operationType});
        }
        boolean bl = true;
        if (this.isTopicAccessCheckRequired() && !this.getTarget().checkDiscriminatorAccess(securityContext, operationType)) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void notifyReceiveAllowed(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{destinationHandler});
        }
        if (this._definition.isReceiveAllowed() == ExtendedBoolean.NONE) {
            this.getTarget().notifyReceiveAllowed(destinationHandler);
            this.notifyTargettingAliasesReceiveAllowed();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AliasDestinationHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.66");
        }
    }
}

