/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MessageProducer;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.processor.stats.interfaces.AbstractInputHandlerInstrumentor;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractInputHandler
implements ProducerInputHandler,
MessageDeliverer,
UpstreamControl,
ControlHandler,
MessageEventListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register((Class)AbstractInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected SIMPTransactionManager _txManager;
    protected MessageProcessor _messageProcessor;
    protected DestinationHandler _destination;
    protected BatchHandler _targetBatchHandler;
    protected MPIO _mpio;
    protected TargetStreamManager _targetStreamManager;
    protected ControlMessageFactory _cmf;
    private List _producers;
    private AbstractInputHandlerInstrumentor _stats;
    private boolean _destinationDeleted = false;

    AbstractInputHandler(DestinationHandler destinationHandler, TargetProtocolItemStream targetProtocolItemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractInputHandler", (Object)new Object[]{destinationHandler, targetProtocolItemStream});
        }
        this._destination = destinationHandler;
        this._messageProcessor = destinationHandler.getMessageProcessor();
        this._txManager = this._messageProcessor.getTXManager();
        this._mpio = this._messageProcessor.getMPIO();
        this._targetBatchHandler = this._messageProcessor.getTargetBatchHandler();
        this._producers = new LinkedList();
        this._targetStreamManager = new TargetStreamManager(this._messageProcessor, this, this, targetProtocolItemStream, this._txManager);
        this._cmf = MessageProcessor.getControlMessageFactory();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractInputHandler", (Object)this);
        }
    }

    public void setStats(AbstractInputHandlerInstrumentor abstractInputHandlerInstrumentor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStats", (Object)abstractInputHandlerInstrumentor);
        }
        this._stats = abstractInputHandlerInstrumentor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStats");
        }
    }

    public void registerForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)sIMPMessage);
        }
        sIMPMessage.registerMessageEventListener(8, this);
        if (sIMPMessage.getReportCOD() != null && this._destination instanceof BaseDestinationHandler) {
            sIMPMessage.registerMessageEventListener(11, (BaseDestinationHandler)this._destination);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachProducer(MessageProducer messageProducer) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachProducer", (Object)messageProducer);
        }
        List list = this._producers;
        synchronized (list) {
            if (this._destinationDeleted) {
                SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_32", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(32);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachProducer", (Object)((Object)sIMPNotPossibleInCurrentConfigurationException));
                }
                throw sIMPNotPossibleInCurrentConfigurationException;
            }
            this._producers.add(messageProducer);
            if (this._stats != null) {
                this._stats.onAttachProducer();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachProducer");
        }
    }

    protected void remoteToLocalPut(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToLocalPut", (Object)new Object[]{messageItem});
        }
        this._targetStreamManager.handleMessage(messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToLocalPut");
        }
    }

    public void reconstituteTargetStreams(StreamSet streamSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteTargetStreams", (Object)streamSet);
        }
        this._targetStreamManager.reconstituteStreamSet(streamSet);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteTargetStreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachProducer(MessageProducer messageProducer) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachProducer", (Object)messageProducer);
        }
        List list = this._producers;
        synchronized (list) {
            this._producers.remove(messageProducer);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachProducer");
        }
    }

    public String toString() {
        return "Dest InputHandler: " + this._destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProducerCount() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProducerCount");
        }
        List list = this._producers;
        synchronized (list) {
            n = this._producers.size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProducerCount", (Object)new Integer(n));
        }
        return n;
    }

    protected void handleRollback(ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)externalLocalTransaction);
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.rollback();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.AbstractInputHandler.handleRollback", (String)"1:443:1.156", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    public void handleMessage(MessageItem messageItem, Transaction transaction, JsDestinationAddress jsDestinationAddress, Cellule cellule) throws SINotPossibleInCurrentConfigurationException, SIConnectionLostException, SIRollbackException, SIIncorrectCallException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{messageItem, transaction, jsDestinationAddress, cellule});
        }
        messageItem.setCurrentMEArrivalTimestamp(System.currentTimeMillis());
        Reliability reliability = messageItem.getReliability();
        if (reliability == Reliability.NONE) {
            reliability = this._destination.getDefaultReliability();
            messageItem.setReliability(reliability);
        } else if (reliability.compareTo((Object)this._destination.getMaxReliability()) > 0) {
            if ((this._destination.isTemporary() || this._destination.getName().equals(this._messageProcessor.getTDReceiverAddr().getDestinationName())) && messageItem.getReliability().compareTo((Object)Reliability.RELIABLE_PERSISTENT) >= 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"handleMessage", (Object)"Sending ASSURED message to temporary destination");
                }
            } else {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleMessage", (Object)"Reliablity greater than dest");
                }
                SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_33", new Object[]{messageItem.getReliability().toString(), this._destination.getMaxReliability().toString(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(33);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{messageItem.getReliability().toString(), this._destination.getMaxReliability().toString(), this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
                throw sIMPNotPossibleInCurrentConfigurationException;
            }
        }
        if (this._destination.isTemporary() || this._destination.getName().equals(this._messageProcessor.getTDReceiverAddr().getDestinationName())) {
            messageItem.setMaxStorageStrategy(2);
        }
        if (this.isPostMediated()) {
            messageItem.getMessage().setRedeliveredCount(0);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    public void registerMessage(MessageItem messageItem, Transaction transaction) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerMessage", (Object)new Object[]{messageItem, transaction});
        }
        if (transaction != null && !transaction.isAlive()) {
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_16", new Object[]{this._destination}, null));
            sIMPIncorrectCallException.setExceptionReason(16);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{this._destination.getName()});
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPIncorrectCallException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerMessage", (Object)((Object)sIMPIncorrectCallException));
            }
            throw sIMPIncorrectCallException;
        }
        this.registerForEvents(messageItem);
        transaction.registerCallback(messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProducersDestinationDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeProducersDestinationDeleted");
        }
        List list = this._producers;
        synchronized (list) {
            this._destinationDeleted = true;
            Iterator iterator = this._producers.iterator();
            while (iterator.hasNext()) {
                ProducerSessionImpl producerSessionImpl = (ProducerSessionImpl)iterator.next();
                if (producerSessionImpl.isMediationsSession()) continue;
                producerSessionImpl._closeProducerDestinationDeleted();
                iterator.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeProducersDestinationDeleted");
        }
    }

    protected ControlAreYouFlushed createControlAreYouFlushed(Cellule cellule, long l, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlAreYouFlushed controlAreYouFlushed;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAreYouFlushed");
        }
        try {
            controlAreYouFlushed = this._cmf.createNewControlAreYouFlushed();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AbstractInputHandler.createControlAreYouFlushed", (String)"1:661:1.156", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlAreYouFlushed", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:673:1.156", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:681:1.156", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlAreYouFlushed.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlAreYouFlushed.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlAreYouFlushed.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)cellule).getUuid());
        controlAreYouFlushed.setGuaranteedTargetDestinationDefinitionUUID(this._destination.getUuid());
        controlAreYouFlushed.setGuaranteedStreamUUID(sIBUuid12);
        if (this._destination.isPubSub()) {
            controlAreYouFlushed.setGuaranteedProtocolType(ProtocolType.PUBSUBOUTPUT);
        } else {
            controlAreYouFlushed.setGuaranteedProtocolType(ProtocolType.UNICASTOUTPUT);
        }
        controlAreYouFlushed.setRequestID(l);
        controlAreYouFlushed.setPriority(11);
        controlAreYouFlushed.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAreYouFlushed", (Object)controlAreYouFlushed);
        }
        return controlAreYouFlushed;
    }

    protected ControlRequestFlush createControlRequestFlush(Cellule cellule, long l, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlRequestFlush controlRequestFlush;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlRequestFlush");
        }
        try {
            controlRequestFlush = this._cmf.createNewControlRequestFlush();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AbstractInputHandler.createControlRequestFlush", (String)"1:740:1.156", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlRequestFlush", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:752:1.156", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractInputHandler", "1:760:1.156", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlRequestFlush.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlRequestFlush.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlRequestFlush.setGuaranteedTargetMessagingEngineUUID(((MessagingEngine)cellule).getUuid());
        controlRequestFlush.setGuaranteedTargetDestinationDefinitionUUID(this._destination.getUuid());
        controlRequestFlush.setGuaranteedStreamUUID(sIBUuid12);
        if (this._destination.isPubSub()) {
            controlRequestFlush.setGuaranteedProtocolType(ProtocolType.PUBSUBOUTPUT);
        } else {
            controlRequestFlush.setGuaranteedProtocolType(ProtocolType.UNICASTOUTPUT);
        }
        controlRequestFlush.setRequestID(l);
        controlRequestFlush.setPriority(11);
        controlRequestFlush.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlRequestFlush", (Object)controlRequestFlush);
        }
        return controlRequestFlush;
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) == ControlMessageType.FLUSHED) {
            this._targetStreamManager.handleFlushedMessage((ControlFlushed)controlMessage);
        } else if (controlMessageType == ControlMessageType.NOTFLUSHED) {
            this._targetStreamManager.handleNotFlushedMessage((ControlNotFlushed)controlMessage);
        } else if (controlMessageType == ControlMessageType.SILENCE) {
            this._targetStreamManager.handleSilenceMessage((ControlSilence)controlMessage);
        } else if (controlMessageType == ControlMessageType.ACKEXPECTED) {
            this._targetStreamManager.handleAckExpectedMessage((ControlAckExpected)controlMessage);
        }
    }

    public TargetStreamManager getTargetStreamManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetStreamManager");
            SibTr.exit((TraceComponent)tc, (String)"getTargetStreamManager", (Object)this._targetStreamManager);
        }
        return this._targetStreamManager;
    }

    public void forceTargetBatchCompletion(BatchListener batchListener) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceTargetBatchCompletion", (Object)new Object[]{batchListener});
        }
        this._targetBatchHandler.completeBatch(true, batchListener);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceTargetBatchCompletion");
        }
    }

    abstract boolean isPostMediated();

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AbstractInputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.156");
        }
    }
}

