/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.ras.SibTr;

public class AIBrowseCursor
implements NonLockingCursor,
AlarmListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)AIBrowseCursor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AnycastInputHandler parent;
    private long browseId;
    private Filter filter;
    private long seqNum;
    private AbstractItem nextItem;
    private boolean browseClosed;
    private boolean browseFailed;
    private int failureReason;
    private Alarm keepAliveAlarmHandle;
    private MPAlarmManager am;

    public AIBrowseCursor(AnycastInputHandler anycastInputHandler, Filter filter, long l, MPAlarmManager mPAlarmManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIBrowseCursor", (Object)new Object[]{anycastInputHandler, filter, new Long(l), mPAlarmManager});
        }
        this.am = mPAlarmManager;
        this.parent = anycastInputHandler;
        this.filter = filter;
        this.browseId = l;
        this.seqNum = -1L;
        this.nextItem = null;
        this.browseClosed = false;
        this.browseFailed = false;
        this.failureReason = 0;
        this.keepAliveAlarmHandle = mPAlarmManager.create(SIMPConstants.BROWSE_LIVENESS_TIMEOUT, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIBrowseCursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        AIBrowseCursor aIBrowseCursor = this;
        synchronized (aIBrowseCursor) {
            this.parent.sendBrowseStatus(1, this.browseId);
            if (this.keepAliveAlarmHandle != null) {
                this.keepAliveAlarmHandle.cancel();
                this.keepAliveAlarmHandle = null;
            }
            this.parent.removeBrowseCursor(this.browseId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public AbstractItem next() throws MessageStoreException {
        AbstractItem abstractItem;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            abstractItem = null;
            AIBrowseCursor aIBrowseCursor = this;
            // MONITORENTER : aIBrowseCursor
            if (!this.browseClosed && !this.browseFailed) {
                this.keepAliveAlarmHandle.cancel();
                ++this.seqNum;
                Filter filter = this.seqNum == 0L ? this.filter : null;
                this.parent.sendBrowseGet(this.browseId, this.seqNum, filter);
                try {
                    this.wait(SIMPConstants.BROWSE_GET_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.AIBrowseCursor.next", (String)"1:178:1.21", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"next", (Object)abstractItem);
                    }
                    // MONITOREXIT : aIBrowseCursor
                    return null;
                }
            }
            if (this.nextItem == null) {
                this.keepAliveAlarmHandle = null;
                if (this.browseClosed) {
                    abstractItem = null;
                    break block11;
                } else {
                    if (this.browseFailed) {
                        MessageStoreException messageStoreException = new MessageStoreException(nls.getFormattedMessage("BROWSE_FAILED_CWSIP0533", new Object[]{this.parent.getDestName(), this.failureReasonToString(this.failureReason)}, null));
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.AIBrowseCursor.next", (String)"1:214:1.21", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        if (!tc.isEntryEnabled()) throw messageStoreException;
                        SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)messageStoreException));
                        throw messageStoreException;
                    }
                    MessageStoreException messageStoreException = new MessageStoreException(nls.getFormattedMessage("BROWSE_TIMEOUT_CWSIP0532", new Object[]{this.parent.getDestName()}, null));
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.AIBrowseCursor.next", (String)"1:235:1.21", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    if (!tc.isEntryEnabled()) throw messageStoreException;
                    SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)messageStoreException));
                    throw messageStoreException;
                }
            }
            abstractItem = this.nextItem;
            this.nextItem = null;
            this.keepAliveAlarmHandle = this.am.create(SIMPConstants.BROWSE_LIVENESS_TIMEOUT, this);
        }
        // MONITOREXIT : aIBrowseCursor
        if (!tc.isEntryEnabled()) return abstractItem;
        SibTr.exit((TraceComponent)tc, (String)"next", (Object)abstractItem);
        return abstractItem;
    }

    public Filter getFilter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFilter");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFilter", (Object)this.filter);
        }
        return this.filter;
    }

    public void allowUnavailableItems() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        AIBrowseCursor aIBrowseCursor = this;
        synchronized (aIBrowseCursor) {
            this.keepAliveAlarmHandle = this.am.create(SIMPConstants.BROWSE_LIVENESS_TIMEOUT, this);
            this.parent.sendBrowseStatus(0, this.browseId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public synchronized void put(MessageItem messageItem) {
        JsMessage jsMessage;
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)messageItem);
        }
        if ((l = (jsMessage = messageItem.getMessage()).getGuaranteedRemoteBrowseSequenceNumber()) != this.seqNum) {
            this.nextItem = null;
            this.browseFailed = true;
            this.failureReason = 2;
        } else {
            this.nextItem = messageItem;
        }
        this.notify();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    public synchronized void endBrowse() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"endBrowse");
        }
        this.browseClosed = true;
        this.notify();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"endBrowse");
        }
    }

    public synchronized void browseFailed(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"browseFailed");
        }
        this.browseFailed = true;
        this.failureReason = n;
        this.notify();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"browseFailed");
        }
    }

    private String failureReasonToString(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"failureReasonToString", (Object)new Integer(n));
        }
        String string = "";
        switch (n) {
            case 1: {
                string = "browse store exception";
                break;
            }
            case 2: {
                string = "browse out of order";
                break;
            }
            case 3: {
                string = "browse bad filter";
                break;
            }
            default: {
                string = "";
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"failureReasonToString", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AIBrowseCursor.java, SIB.processor, WAS602.SIB, o0610.11 1.21");
        }
    }
}

