/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.gd.RangeObject;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class TickRange
extends RangeObject {
    private static TraceComponent tc = SibTr.register((Class)TickRange.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static final byte Unknown = 0;
    public static final byte Requested = 1;
    public static final byte Uncommitted = 2;
    public static final byte Value = 3;
    public static final byte Discarded = 4;
    public static final byte Accepted = 5;
    public static final byte Rejected = 6;
    public static final byte Completed = 7;
    public static final byte Error = 8;
    public byte type;
    public Object value;
    public long itemStreamIndex;
    private boolean reallocateOnCommit = false;
    public long valuestamp;

    public TickRange(byte by, long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TickRange", (Object)new Object[]{new Byte(by), new Long(l), new Long(l2)});
        }
        if (l <= l2) {
            this.type = by;
            this.startstamp = l;
            this.endstamp = l2;
            this.value = null;
            this.valuestamp = 0L;
            this.itemStreamIndex = -1L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TickRange", (Object)this);
        }
    }

    public static TickRange newValueTick(long l, Object object, long l2) {
        TickRange tickRange = new TickRange(3, l, l);
        tickRange.itemStreamIndex = l2;
        tickRange.value = object;
        tickRange.valuestamp = l;
        return tickRange;
    }

    public static TickRange newUncommittedTick(long l) {
        TickRange tickRange = new TickRange(2, l, l);
        tickRange.valuestamp = l;
        return tickRange;
    }

    public void reallocateOnCommit() {
        this.reallocateOnCommit = true;
    }

    public boolean isReallocationRequired() {
        return this.reallocateOnCommit;
    }

    public String toString() {
        String string = "[" + TickRange.stateToString(this.type) + " Start:" + TickRange.tickToString(this.startstamp) + ", End:" + (this.endstamp == Long.MAX_VALUE ? "      LAST" : TickRange.tickToString(this.endstamp)) + " ValueTick:" + TickRange.tickToString(this.valuestamp) + ", Value:" + (this.value == null ? "null     " : "@" + Integer.toString(this.value.hashCode(), 16)) + ", Index:" + (this.itemStreamIndex == -1L ? "none     " : Long.toString(this.itemStreamIndex)) + "]";
        return string;
    }

    protected static String stateToString(byte by) {
        String string = "*";
        switch (by) {
            case 0: {
                string = "Unknown    ";
                break;
            }
            case 1: {
                string = "Requested  ";
                break;
            }
            case 2: {
                string = "Uncommitted";
                break;
            }
            case 3: {
                string = "Value      ";
                break;
            }
            case 4: {
                string = "Discarded  ";
                break;
            }
            case 5: {
                string = "Accepted   ";
                break;
            }
            case 6: {
                string = "Rejected   ";
                break;
            }
            case 7: {
                string = "Completed  ";
                break;
            }
        }
        return string;
    }

    protected static String tickToString(long l) {
        String string = "          ";
        String string2 = Long.toString(l >>> 32);
        string2 = string.substring(0, string.length() - string2.length()) + string2;
        String string3 = Long.toString(l & 0xFFFFFFFFL);
        string3 = string.substring(0, string.length() - string3.length()) + string3;
        return string3;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/TickRange.java, SIB.processor, WAS602.SIB, o0610.11 1.20");
        }
    }
}

