/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.CommonMessageHeaders;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.ExpressTargetStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.GuaranteedTargetStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.TargetStreamSetControllableIterator;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TargetStreamManager
implements AlarmListener,
BatchListener {
    private static final TraceComponent tc = SibTr.register((Class)TargetStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap sourceMap;
    private Index streamSets;
    private List flushedStreamSets;
    private HashMap flushMap;
    private MessageDeliverer deliverer;
    private UpstreamControl upControl;
    private SIMPTransactionManager txManager;
    protected ProtocolItemStream protocolItemStream = null;
    private MPAlarmManager am;
    private MessageProcessor messageProcessor;

    public TargetStreamManager(MessageProcessor messageProcessor, MessageDeliverer messageDeliverer, UpstreamControl upstreamControl, ProtocolItemStream protocolItemStream, SIMPTransactionManager sIMPTransactionManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TargetStreamManager", (Object)new Object[]{messageProcessor, messageDeliverer, upstreamControl, protocolItemStream, sIMPTransactionManager});
        }
        this.messageProcessor = messageProcessor;
        this.am = messageProcessor.getAlarmManager();
        this.deliverer = messageDeliverer;
        this.upControl = upstreamControl;
        this.txManager = sIMPTransactionManager;
        this.protocolItemStream = protocolItemStream;
        this.sourceMap = new HashMap();
        this.streamSets = new Index();
        this.flushMap = new HashMap();
        this.flushedStreamSets = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TargetStreamManager", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{messageItem});
        }
        JsMessage jsMessage = messageItem.getMessage();
        int n = jsMessage.getPriority();
        Reliability reliability = jsMessage.getReliability();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        StreamSet streamSet = null;
        Object object = this.streamSets;
        synchronized (object) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
        }
        if (streamSet == null) {
            this.handleNewStreamID(messageItem);
        } else {
            object = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                object = (TargetStream)streamSet.getStream(n, reliability);
                if (object == null) {
                    object = this.createStream(streamSet, n, reliability, streamSet.getPersistentData(n, reliability));
                }
            }
            object.writeValue(messageItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSilence(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleSilence", (Object)new Object[]{messageItem});
        }
        JsMessage jsMessage = messageItem.getMessage();
        int n = jsMessage.getPriority();
        Reliability reliability = jsMessage.getReliability();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        StreamSet streamSet = null;
        Object object = this.streamSets;
        synchronized (object) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
        }
        if (streamSet != null) {
            object = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                object = (TargetStream)streamSet.getStream(n, reliability);
            }
            if (object != null) {
                object.writeSilence(messageItem);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleSilence");
        }
    }

    private void handleNewStreamID(ControlMessage controlMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewStreamID", (Object)new Object[]{controlMessage});
        }
        this.handleNewStreamID((CommonMessageHeaders)controlMessage, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewStreamID");
        }
    }

    private void handleNewStreamID(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewStreamID", (Object)new Object[]{messageItem});
        }
        JsMessage jsMessage = messageItem.getMessage();
        this.handleNewStreamID((CommonMessageHeaders)jsMessage, messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewStreamID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewStreamID(CommonMessageHeaders commonMessageHeaders, MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewStreamID", (Object)new Object[]{commonMessageHeaders, messageItem});
        }
        SIBUuid12 sIBUuid12 = commonMessageHeaders.getGuaranteedStreamUUID();
        HashMap hashMap = this.flushMap;
        synchronized (hashMap) {
            FlushQueryRecord flushQueryRecord = (FlushQueryRecord)this.flushMap.get(sIBUuid12);
            if (flushQueryRecord != null && messageItem != null) {
                flushQueryRecord.append(messageItem);
            } else {
                MessagingEngine messagingEngine = new MessagingEngine(commonMessageHeaders.getGuaranteedSourceMessagingEngineUUID());
                SIBUuid12 sIBUuid122 = commonMessageHeaders.getGuaranteedTargetDestinationDefinitionUUID();
                SIBUuid8 sIBUuid8 = commonMessageHeaders.getGuaranteedCrossBusSourceBusUUID();
                long l = this.messageProcessor.nextTick();
                flushQueryRecord = new FlushQueryRecord(messagingEngine, sIBUuid122, sIBUuid8, messageItem, l);
                this.flushMap.put(sIBUuid12, flushQueryRecord);
                this.upControl.sendAreYouFlushedMessage(messagingEngine, sIBUuid122, sIBUuid8, l, sIBUuid12);
                flushQueryRecord.resend = this.am.create(GDConfig.FLUSH_QUERY_INTERVAL, this, sIBUuid12);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewStreamID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSet addNewStreamSet(SIBUuid12 sIBUuid12, Cellule cellule, SIBUuid12 sIBUuid122, SIBUuid8 sIBUuid8) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewStreamSet", (Object)new Object[]{sIBUuid12, cellule, sIBUuid122, sIBUuid8});
        }
        StreamSet streamSet = null;
        try {
            ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
            streamSet = new StreamSet(sIBUuid12, cellule, sIBUuid122, sIBUuid8, this.protocolItemStream, this.txManager, 0L, StreamSet.Type.TARGET, externalLocalTransaction);
            this.protocolItemStream.addItem(streamSet, externalLocalTransaction);
            externalLocalTransaction.commit();
            Index index = this.streamSets;
            synchronized (index) {
                this.streamSets.put(sIBUuid12, streamSet);
                this.sourceMap.put(sIBUuid12, cellule);
            }
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewStreamSet", (Object)((Object)outOfCacheSpace));
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.TargetStreamManager.addNewStreamSet", (String)"1:437:1.50", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewStreamSet", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewStreamSet", (Object)streamSet);
        }
        return streamSet;
    }

    private TargetStream createStream(StreamSet streamSet, int n, Reliability reliability, long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, new Integer(n), reliability, new Long(l)});
        }
        TargetStream targetStream = null;
        targetStream = this.createStream(streamSet, n, reliability);
        targetStream.setCompletedPrefix(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream");
        }
        return targetStream;
    }

    private TargetStream createStream(StreamSet streamSet, int n, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, new Integer(n), reliability});
        }
        ControllableStream controllableStream = null;
        controllableStream = reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) <= 0 ? new ExpressTargetStream(this.deliverer, streamSet.getRemoteEngineUUID(), streamSet.getStreamID()) : new GuaranteedTargetStream(this.deliverer, this.upControl, this.am, streamSet, n, reliability, new ArrayList());
        streamSet.setStream(n, reliability, controllableStream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", (Object)controllableStream);
        }
        return controllableStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkAck(ControlAck controlAck, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkAck", (Object)new Object[]{controlAck, new Long(l)});
        }
        int n = controlAck.getPriority();
        Reliability reliability = controlAck.getReliability();
        SIBUuid12 sIBUuid12 = controlAck.getGuaranteedStreamUUID();
        StreamSet streamSet = null;
        Object object = this.streamSets;
        synchronized (object) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
        }
        if (streamSet != null) {
            long l2;
            object = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                object = (TargetStream)streamSet.getStream(n, reliability);
            }
            if (object != null && (l2 = object.getCompletedPrefix()) < l) {
                l = l2;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkAck", (Object)new Long(l));
        }
        return l;
    }

    public void handleFlushedMessage(ControlFlushed controlFlushed) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleFlushedMessage", (Object)new Object[]{controlFlushed});
        }
        SIBUuid12 sIBUuid12 = controlFlushed.getGuaranteedStreamUUID();
        this.forceFlush(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlush(SIBUuid12 sIBUuid12) throws SIResourceException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlush", (Object)new Object[]{sIBUuid12});
        }
        HashMap hashMap = this.flushMap;
        synchronized (hashMap) {
            FlushQueryRecord flushQueryRecord = (FlushQueryRecord)this.flushMap.remove(sIBUuid12);
            if (flushQueryRecord != null) {
                flushQueryRecord.resend.cancel();
            }
            this.flush(sIBUuid12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFlushAtSource(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid122, boolean bl) throws SIException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestFlushAtSource", (Object)new Object[]{cellule, sIBUuid122});
        }
        HashMap hashMap = this.flushMap;
        synchronized (hashMap) {
            if (this.flushMap.containsKey(sIBUuid122)) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
                }
                return;
            }
            long l = this.messageProcessor.nextTick();
            FlushQueryRecord flushQueryRecord = new FlushQueryRecord(cellule, sIBUuid12, sIBUuid8, l);
            this.flushMap.put(sIBUuid122, flushQueryRecord);
            this.upControl.sendRequestFlushMessage(cellule, sIBUuid12, sIBUuid8, l, sIBUuid122, bl);
            flushQueryRecord.resend = this.am.create(10000L, this, sIBUuid122);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flush", (Object)new Object[]{sIBUuid12});
        }
        StreamSet streamSet = null;
        Object object = this.streamSets;
        synchronized (object) {
            this.sourceMap.remove(sIBUuid12);
            streamSet = (StreamSet)this.streamSets.remove(sIBUuid12);
        }
        if (streamSet != null) {
            Object object2;
            streamSet.dereferenceControlAdapter();
            object = streamSet.iterator();
            while (object.hasNext()) {
                object2 = (TargetStream)object.next();
                object2.flush();
            }
            object2 = this.flushedStreamSets;
            synchronized (object2) {
                this.flushedStreamSets.add(streamSet);
            }
            this.deliverer.forceTargetBatchCompletion(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotFlushedMessage(ControlNotFlushed controlNotFlushed) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNotFlushedMessage", (Object)new Object[]{controlNotFlushed});
        }
        SIBUuid12 sIBUuid12 = controlNotFlushed.getGuaranteedStreamUUID();
        HashMap hashMap = this.flushMap;
        synchronized (hashMap) {
            FlushQueryRecord flushQueryRecord = (FlushQueryRecord)this.flushMap.get(sIBUuid12);
            long l = controlNotFlushed.getRequestID();
            if (flushQueryRecord != null && flushQueryRecord.requestID == l) {
                this.flushMap.remove(sIBUuid12);
                flushQueryRecord.resend.cancel();
                StreamSet streamSet = null;
                Object object = this.streamSets;
                synchronized (object) {
                    streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
                }
                if (streamSet == null) {
                    Object object2;
                    Object object3;
                    Object object4;
                    object = new MessagingEngine(controlNotFlushed.getGuaranteedSourceMessagingEngineUUID());
                    if (this.sourceMap.containsValue(object)) {
                        object4 = this.sourceMap.keySet().iterator();
                        while (object4.hasNext()) {
                            object3 = (SIBUuid12)object4.next();
                            object2 = (Cellule)this.sourceMap.get(object3);
                            if (!((Cellule)object).equals(object2)) continue;
                            this.flush((SIBUuid12)object3);
                            break;
                        }
                    }
                    if ((object4 = controlNotFlushed.getGuaranteedCrossBusSourceBusUUID()) == null) {
                        object4 = this.messageProcessor.getMessagingEngineBusUuid();
                    }
                    streamSet = this.addNewStreamSet(sIBUuid12, (Cellule)object, controlNotFlushed.getGuaranteedTargetDestinationDefinitionUUID(), (SIBUuid8)object4);
                    object3 = controlNotFlushed.getCompletedPrefixTicks();
                    object2 = controlNotFlushed.getCompletedPrefixPriority();
                    int[] nArray = controlNotFlushed.getCompletedPrefixQOS();
                    for (int i = 0; i < ((SIBUuid12)object3).length; ++i) {
                        streamSet.setPersistentData((int)object2[i], Reliability.getReliability((int)nArray[i]), (long)object3[i]);
                    }
                }
                for (int i = 0; i < flushQueryRecord.cacheIndex; ++i) {
                    this.handleMessage(flushQueryRecord.cache[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNotFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAckExpectedMessage(ControlAckExpected controlAckExpected) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleAckExpectedMessage", (Object)new Object[]{controlAckExpected});
        }
        int n = controlAckExpected.getPriority();
        Reliability reliability = controlAckExpected.getReliability();
        SIBUuid12 sIBUuid12 = controlAckExpected.getGuaranteedStreamUUID();
        StreamSet streamSet = null;
        Object object = this.streamSets;
        synchronized (object) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
        }
        if (streamSet == null) {
            this.handleNewStreamID((ControlMessage)controlAckExpected);
        } else {
            object = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                object = (TargetStream)streamSet.getStream(n, reliability);
                if (object == null) {
                    object = this.createStream(streamSet, n, reliability, streamSet.getPersistentData(n, reliability));
                }
            }
            long l = controlAckExpected.getTick();
            object.processAckExpected(l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleAckExpectedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSilenceMessage(ControlSilence controlSilence) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleSilenceMessage", (Object)new Object[]{controlSilence});
        }
        int n = controlSilence.getPriority();
        Reliability reliability = controlSilence.getReliability();
        SIBUuid12 sIBUuid12 = controlSilence.getGuaranteedStreamUUID();
        StreamSet streamSet = null;
        Object object = this.streamSets;
        synchronized (object) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
        }
        if (streamSet == null) {
            this.handleNewStreamID((ControlMessage)controlSilence);
        } else {
            object = null;
            StreamSet streamSet2 = streamSet;
            synchronized (streamSet2) {
                object = (TargetStream)streamSet.getStream(n, reliability);
                if (object == null) {
                    object = this.createStream(streamSet, n, reliability, streamSet.getPersistentData(n, reliability));
                }
            }
            object.writeSilence(controlSilence);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleSilenceMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteStreamSet(StreamSet streamSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteStreamSet", (Object)streamSet);
        }
        Index index = this.streamSets;
        synchronized (index) {
            this.streamSets.put(streamSet.getStreamID(), streamSet);
            this.sourceMap.put(streamSet.getStreamID(), streamSet.getCellule());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteStreamSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        SIBUuid12 sIBUuid12 = (SIBUuid12)object;
        HashMap hashMap = this.flushMap;
        synchronized (hashMap) {
            block12: {
                FlushQueryRecord flushQueryRecord = (FlushQueryRecord)this.flushMap.get(sIBUuid12);
                if (flushQueryRecord != null) {
                    --flushQueryRecord.attempts;
                    if (flushQueryRecord.attempts > 0) {
                        try {
                            if (flushQueryRecord.cache == null) {
                                this.upControl.sendRequestFlushMessage(flushQueryRecord.source, flushQueryRecord.destId, flushQueryRecord.busId, flushQueryRecord.requestID, sIBUuid12, false);
                                break block12;
                            }
                            this.upControl.sendAreYouFlushedMessage(flushQueryRecord.source, flushQueryRecord.destId, flushQueryRecord.busId, flushQueryRecord.requestID, sIBUuid12);
                        }
                        catch (SIResourceException sIResourceException) {
                            this.flushMap.remove(sIBUuid12);
                            if (tc.isEventEnabled()) {
                                SibTr.event((TraceComponent)tc, (String)("Flush query failed for stream: " + sIBUuid12));
                            }
                            break block12;
                        }
                    }
                    this.flushMap.remove(sIBUuid12);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)("Flush query expired for stream: " + sIBUuid12));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty");
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Boolean(this.streamSets.isEmpty()));
        }
        return this.streamSets.isEmpty() && this.flushedStreamSets.isEmpty();
    }

    public SIMPIterator getTargetStreamSetControlIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetStreamSetControlIterator");
        }
        TargetStreamSetControllableIterator targetStreamSetControllableIterator = new TargetStreamSetControllableIterator(this.streamSets.iterator(), this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetStreamSetControlIterator", (Object)targetStreamSetControllableIterator);
        }
        return targetStreamSetControllableIterator;
    }

    public void batchPrecommit(Transaction transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchCommitted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"batchCommitted");
        }
        List list = this.flushedStreamSets;
        synchronized (list) {
            Iterator iterator = this.flushedStreamSets.iterator();
            while (iterator.hasNext()) {
                StreamSet streamSet = (StreamSet)iterator.next();
                try {
                    streamSet.remove();
                    iterator.remove();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.TargetStreamManager.batchCommitted", (String)"1:1210:1.50", (Object)this);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"batchCommitted", (Object)"SIErrorException");
                    }
                    throw new SIErrorException((Throwable)sIException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchCommitted");
        }
    }

    public void batchRolledBack() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryUnflushedStreams() throws SIResourceException {
        Index index = this.streamSets;
        synchronized (index) {
            SIMPIterator sIMPIterator = this.streamSets.iterator();
            while (sIMPIterator.hasNext()) {
                StreamSet streamSet = (StreamSet)sIMPIterator.next();
                this.upControl.sendAreYouFlushedMessage(streamSet.getCellule(), streamSet.getDestUuid(), streamSet.getBusUuid(), -1L, streamSet.getStreamID());
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/TargetStreamManager.java, SIB.processor, WAS602.SIB, o0610.11 1.50");
        }
    }

    protected class FlushQueryRecord {
        public Cellule source;
        public SIBUuid12 destId;
        public SIBUuid8 busId;
        public MessageItem[] cache;
        public int cacheIndex;
        public Alarm resend;
        public int attempts;
        public long requestID;

        public FlushQueryRecord(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"FlushQueryRecord", (Object)new Object[]{cellule, sIBUuid12, sIBUuid8, new Long(l)});
            }
            this.source = cellule;
            this.destId = sIBUuid12;
            this.busId = sIBUuid8;
            this.requestID = l;
            this.cache = null;
            this.attempts = 10;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"FlushQueryRecord", (Object)this);
            }
        }

        public FlushQueryRecord(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, MessageItem messageItem, long l) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"FlushQueryRecord", (Object)new Object[]{cellule, sIBUuid12, sIBUuid8, messageItem, new Long(l)});
            }
            this.source = cellule;
            this.destId = sIBUuid12;
            this.busId = sIBUuid8;
            this.cache = new MessageItem[10];
            this.cacheIndex = 0;
            this.requestID = l;
            this.attempts = 3;
            if (messageItem != null) {
                this.append(messageItem);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"FlushQueryRecord", (Object)this);
            }
        }

        public synchronized void append(MessageItem messageItem) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"append", (Object)new Object[]{messageItem});
            }
            if (this.cacheIndex < this.cache.length && messageItem != null) {
                this.cache[this.cacheIndex++] = messageItem;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"append");
            }
        }
    }
}

