/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl;
import com.ibm.ws.sib.processor.runtime.SourceStreamSetControl;
import com.ibm.ws.sib.processor.runtime.TargetStreamSetControl;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class StreamSet
extends SIMPItem
implements ControllableResource {
    private Type type;
    private ControlAdapter controlAdapter = null;
    private long initialData = -1L;
    private boolean persistent = false;
    private static final int maxReliabilityIndex = Reliability.MAX_INDEX;
    private SIMPTransactionManager txManager = null;
    private ProtocolItemStream itemStream = null;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Cellule cellule = null;
    private SIBUuid12 streamID = null;
    private SIBUuid12 destID = null;
    private SIBUuid8 busID = null;
    private static TraceComponent tc = SibTr.register((Class)StreamSet.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long[] subsetIDs;
    private ReliabilitySubset[] subsets;
    static /* synthetic */ Class class$com$ibm$ws$sib$processor$gd$StreamSet$ReliabilitySubset;

    public StreamSet() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"StreamSet");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StreamSet", (Object)this);
        }
    }

    public StreamSet(SIBUuid12 sIBUuid12, long l, Type type) {
        this(sIBUuid12, null, l, type);
    }

    public StreamSet(SIBUuid12 sIBUuid12, Cellule cellule, long l, Type type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"StreamSet", (Object)new Object[]{sIBUuid12, cellule, new Long(l), type});
        }
        this.streamID = sIBUuid12;
        this.cellule = cellule;
        this.initialData = l;
        this.type = type;
        this.initialize();
        this.createNonPersistentSubsets();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StreamSet", (Object)this);
        }
    }

    public StreamSet(SIBUuid12 sIBUuid12, Cellule cellule, SIBUuid12 sIBUuid122, SIBUuid8 sIBUuid8, ProtocolItemStream protocolItemStream, SIMPTransactionManager sIMPTransactionManager, long l, Type type, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"StreamSet", (Object)new Object[]{sIBUuid12, cellule, sIBUuid122, sIBUuid8, protocolItemStream, sIMPTransactionManager, new Long(l), type, transaction});
        }
        this.streamID = sIBUuid12;
        this.cellule = cellule;
        this.destID = sIBUuid122;
        this.busID = sIBUuid8;
        this.itemStream = protocolItemStream;
        this.txManager = sIMPTransactionManager;
        this.initialData = l;
        this.type = type;
        this.initialize();
        this.persistent = true;
        this.createPersistentSubsets(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"StreamSet", (Object)this);
        }
    }

    private void initialize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.subsets = new ReliabilitySubset[maxReliabilityIndex + 1];
        this.subsetIDs = new long[maxReliabilityIndex + 1];
        for (int i = 0; i < this.subsetIDs.length; ++i) {
            this.subsetIDs[i] = -1L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public Type getType() {
        return this.type;
    }

    protected void setStream(int n, Reliability reliability, Stream stream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStream", (Object)new Object[]{new Integer(n), reliability, stream});
        }
        ReliabilitySubset reliabilitySubset = this.getSubset(reliability);
        reliabilitySubset.setStream(n, stream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStream");
        }
    }

    public void updateCellule(Cellule cellule) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateCellule", (Object)cellule);
        }
        this.cellule = cellule;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateCellule");
        }
    }

    private int getIndex(Reliability reliability) {
        return reliability.getIndex();
    }

    private Reliability getReliability(int n) {
        return Reliability.getReliabilityByIndex((int)n);
    }

    private void createPersistentSubsets(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPersistentSubsets", (Object)transaction);
        }
        for (int i = 0; i < this.subsets.length; ++i) {
            this.createPersistentSubset(this.getReliability(i), transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistentSubsets");
        }
    }

    private ReliabilitySubset createPersistentSubset(Reliability reliability, Transaction transaction) {
        ReliabilitySubset reliabilitySubset;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPersistentSubset", (Object)new Object[]{reliability});
        }
        this.subsets[this.getIndex((Reliability)reliability)] = reliabilitySubset = new ReliabilitySubset(reliability, this.initialData);
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            try {
                this.itemStream.addItem(reliabilitySubset, transaction);
                this.subsetIDs[this.getIndex((Reliability)reliability)] = reliabilitySubset.getID();
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.StreamSet.createPersistentSubset", (String)"1:414:1.56", (Object)this);
                this.subsetIDs[this.getIndex((Reliability)reliability)] = -1L;
                if (tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.exit((TraceComponent)tc, (String)"createPersistentSubset", (Object)((Object)messageStoreException));
                }
            }
        } else {
            this.subsetIDs[this.getIndex((Reliability)reliability)] = -1L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistentSubset", (Object)reliabilitySubset);
        }
        return reliabilitySubset;
    }

    private void createNonPersistentSubsets() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNonPersistentSubsets");
        }
        for (int i = 0; i < this.subsets.length; ++i) {
            this.createNonPersistentSubset(this.getReliability(i));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNonPersistentSubsets");
        }
    }

    private ReliabilitySubset createNonPersistentSubset(Reliability reliability) {
        ReliabilitySubset reliabilitySubset;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNonPersistentSubset", (Object)new Object[]{reliability});
        }
        this.subsets[this.getIndex((Reliability)reliability)] = reliabilitySubset = new ReliabilitySubset(reliability, this.initialData);
        this.subsetIDs[this.getIndex((Reliability)reliability)] = -1L;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNonPersistentSubset", (Object)reliabilitySubset);
        }
        return reliabilitySubset;
    }

    public Stream getStream(int n, Reliability reliability) {
        return this.getSubset(reliability).getStream(n);
    }

    private ReliabilitySubset getSubset(Reliability reliability) {
        ReliabilitySubset reliabilitySubset;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubset", (Object)reliability);
        }
        if ((reliabilitySubset = this.subsets[this.getIndex(reliability)]) == null && this.persistent) {
            reliabilitySubset = this.createPersistentSubset(reliability, this.txManager.createAutoCommitTransaction());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubset");
        }
        return reliabilitySubset;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            byte[] byArray = this.cellule.getBytes();
            int n = byArray.length;
            byte[] byArray2 = this.streamID.toByteArray();
            int n2 = byArray2.length;
            byte[] byArray3 = this.destID.toByteArray();
            int n3 = byArray3.length;
            byte[] byArray4 = this.busID.toByteArray();
            int n4 = byArray4.length;
            byte[] byArray5 = new byte[n + n2 + n3 + n4];
            System.arraycopy(byArray, 0, byArray5, 0, n);
            System.arraycopy(byArray2, 0, byArray5, n, n2);
            System.arraycopy(byArray3, 0, byArray5, n + n2, n3);
            System.arraycopy(byArray4, 0, byArray5, n + n2 + n3, n4);
            objectOutputStream.write(byArray5);
            objectOutputStream.writeLong(this.initialData);
            objectOutputStream.writeInt(this.type.toInt());
            objectOutputStream.writeInt(this.subsets.length);
            for (int i = 0; i < this.subsets.length; ++i) {
                objectOutputStream.writeLong(this.subsetIDs[i]);
                objectOutputStream.writeInt(this.subsets[i].getReliability().toInt());
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.gd.StreamSet.getPersistentData", (String)"1:559:1.56", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:566:1.56", iOException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:576:1.56", iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.itemStream = (ProtocolItemStream)this.getItemStream();
        this.persistent = true;
        try {
            Reliability reliability;
            int n2;
            byte[] byArray = new byte[9];
            objectInputStream.read(byArray, 0, 9);
            this.cellule = new MessagingEngine(byArray);
            byte[] byArray2 = new byte[12];
            objectInputStream.read(byArray2, 0, 12);
            this.streamID = new SIBUuid12(byArray2);
            byte[] byArray3 = new byte[12];
            objectInputStream.read(byArray3, 0, 12);
            this.destID = new SIBUuid12(byArray3);
            byte[] byArray4 = new byte[8];
            objectInputStream.read(byArray4, 0, 8);
            this.busID = new SIBUuid8(byArray4);
            this.initialData = objectInputStream.readLong();
            this.type = Type.getType(objectInputStream.readInt());
            int n3 = objectInputStream.readInt();
            ReliabilitySubset[] reliabilitySubsetArray = new ReliabilitySubset[n3];
            long[] lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                long l = objectInputStream.readLong();
                reliability = Reliability.getReliability((int)objectInputStream.readInt());
                if (l != -1L) {
                    ReliabilitySubset reliabilitySubset = (ReliabilitySubset)this.getItemStream().findById(l);
                    if (reliabilitySubset != null) {
                        reliabilitySubset.setReliability(reliability);
                        reliabilitySubsetArray[this.getIndex((Reliability)reliability)] = reliabilitySubset;
                    } else {
                        l = -1L;
                    }
                }
                lArray[n2] = l;
            }
            for (n2 = 0; n2 < n3 && lArray[n2] == -1L; ++n2) {
            }
            for (int i = 0; i < maxReliabilityIndex + 1; ++i) {
                ReliabilitySubset reliabilitySubset = null;
                reliability = null;
                if (n2 < n3) {
                    reliabilitySubset = reliabilitySubsetArray[n2];
                    reliability = reliabilitySubset.getReliability();
                }
                if (reliability != this.getReliability(i)) continue;
                this.subsets[i] = reliabilitySubset;
                this.subsetIDs[i] = lArray[n2++];
                while (n2 < n3 && lArray[n2] == -1L) {
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.gd.StreamSet.restore", (String)"1:694:1.56", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:701:1.56", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet", "1:711:1.56", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public Cellule getCellule() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCellule");
            SibTr.exit((TraceComponent)tc, (String)"getCellule", (Object)this.cellule);
        }
        return this.cellule;
    }

    public SIBUuid12 getDestUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"getDestUuid", (Object)this.destID);
        }
        return this.destID;
    }

    public SIBUuid8 getBusUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusUuid");
            SibTr.exit((TraceComponent)tc, (String)"getBusUuid", (Object)this.busID);
        }
        return this.busID;
    }

    public byte[] getSpillData() {
        return this.getPersistentData();
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        int n = 4;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(n));
        }
        return n;
    }

    public SIBUuid12 getStreamID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)this.streamID);
        }
        return this.streamID;
    }

    public void setStreamID(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStreamID");
            SibTr.exit((TraceComponent)tc, (String)"setStreamID", (Object)sIBUuid12);
        }
        this.streamID = sIBUuid12;
    }

    protected void setPersistentData(int n, Reliability reliability, long l) {
        this.getSubset(reliability).setPersistentData(n, l);
    }

    protected long getPersistentData(int n, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)new Object[]{new Integer(n), reliability});
        }
        long l = this.getSubset(reliability).getPersistentData(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)new Long(l));
        }
        return l;
    }

    public void unspill(byte[] byArray) {
        this.restore(byArray);
    }

    public Iterator iterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"iterator", (Object)new Object[0]);
        }
        ArrayList<Stream> arrayList = new ArrayList<Stream>();
        for (int i = 0; i < maxReliabilityIndex + 1; ++i) {
            ReliabilitySubset reliabilitySubset = this.getSubset(this.getReliability(i));
            if (reliabilitySubset == null) continue;
            for (int j = 0; j < 10; ++j) {
                Stream stream = reliabilitySubset.getStream(j);
                if (stream == null) continue;
                arrayList.add(stream);
            }
        }
        Iterator iterator = arrayList.iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator", iterator);
        }
        return iterator;
    }

    public void requestUpdate(Reliability reliability, Transaction transaction) throws SIResourceException {
        ReliabilitySubset reliabilitySubset;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestUpdate", (Object)new Object[]{reliability, transaction});
        }
        if (!(reliabilitySubset = this.getSubset(reliability)).isUpdating()) {
            if (transaction == null) {
                transaction = this.txManager.createAutoCommitTransaction();
            }
            try {
                reliabilitySubset.requestUpdate(transaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.StreamSet.requestUpdate", (String)"1:927:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"requestUpdate", (Object)"SIStoreException");
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestUpdate");
        }
    }

    public void remove() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
        try {
            for (int i = 0; i < this.subsets.length; ++i) {
                if (this.subsets[i] == null || !this.subsets[i].isInStore()) continue;
                this.subsets[i].remove(externalLocalTransaction, this.subsets[i].getLockID());
            }
            this.remove(externalLocalTransaction, this.getLockID());
            externalLocalTransaction.commit();
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)sIIncorrectCallException);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.StreamSet.remove", (String)"1:1247:1.56", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public void initializeNonPersistent(SIMPTransactionManager sIMPTransactionManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)sIMPTransactionManager);
        }
        this.txManager = sIMPTransactionManager;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public ControlAdapter getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    public String getRemoteEngineUUID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUUID");
        }
        String string = null;
        SIBUuid8 sIBUuid8 = null;
        if (this.cellule != null) {
            sIBUuid8 = ((MessagingEngine)this.cellule).getUuid();
            string = sIBUuid8.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUUID", string);
        }
        return string;
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        String string = this.getRemoteEngineUUID();
        if (this.type == Type.SOURCE) {
            this.controlAdapter = new SourceStreamSetControl(string, this);
        } else if (this.type == Type.TARGET) {
            this.controlAdapter = new TargetStreamSetControl(this);
        } else if (this.type == Type.INTERNAL_OUTPUT) {
            this.controlAdapter = new InternalOutputStreamSetControl(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void dereferenceControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        if (this.controlAdapter != null) {
            this.controlAdapter.dereferenceControllable();
            this.controlAdapter = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/StreamSet.java, SIB.processor, WAS602.SIB, o0610.11 1.56");
        }
    }

    public static class ReliabilitySubset
    extends SIMPItem {
        private long initialData;
        private Reliability reliability;
        private long[] persistentData;
        private Stream[] streams;
        private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
        private static TraceComponent tc = SibTr.register((Class)(class$com$ibm$ws$sib$processor$gd$StreamSet$ReliabilitySubset == null ? (class$com$ibm$ws$sib$processor$gd$StreamSet$ReliabilitySubset = StreamSet.class$("com.ibm.ws.sib.processor.gd.StreamSet$ReliabilitySubset")) : class$com$ibm$ws$sib$processor$gd$StreamSet$ReliabilitySubset), (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

        public ReliabilitySubset() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ReliabilitySubset");
            }
            this.initialize(-1L);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReliabilitySubset", (Object)this);
            }
        }

        public void setReliability(Reliability reliability) {
            this.reliability = reliability;
        }

        public ReliabilitySubset(Reliability reliability, long l) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ReliabilitySubset", (Object)new Object[]{reliability, new Long(l)});
            }
            this.reliability = reliability;
            this.initialData = l;
            this.initialize(l);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReliabilitySubset", (Object)this);
            }
        }

        private void initialize(long l) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"initialize");
            }
            this.streams = new Stream[10];
            this.persistentData = new long[10];
            for (int i = 0; i < 10; ++i) {
                this.persistentData[i] = l;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initialize");
            }
        }

        public Reliability getReliability() {
            return this.reliability;
        }

        public Stream getStream(int n) {
            return this.streams[n];
        }

        public void setStream(int n, Stream stream) {
            this.streams[n] = stream;
        }

        public long getCompletedPrefix(int n) {
            return this.streams[n].getCompletedPrefix();
        }

        public void setPersistentData(long[] lArray) {
            this.persistentData = lArray;
        }

        public void setPersistentData(int n, long l) {
            this.persistentData[n] = l;
        }

        public long getPersistentData(int n) {
            return this.persistentData[n];
        }

        public void getPersistentData(ObjectOutputStream objectOutputStream) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
            }
            try {
                for (int i = 0; i < this.streams.length; ++i) {
                    Stream stream = this.streams[i];
                    if (stream == null) {
                        objectOutputStream.writeLong(this.initialData);
                        continue;
                    }
                    objectOutputStream.writeLong(this.persistentData[i]);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset.getPersistentData", (String)"1:1104:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)iOException);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ReliabilitySubset", "1:1111:1.56", iOException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.ReliabilitySubset", "1:1121:1.56", iOException}, null), (Throwable)iOException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
            }
        }

        public void restore(ObjectInputStream objectInputStream, int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
            }
            try {
                for (int i = 0; i < this.streams.length; ++i) {
                    long l = objectInputStream.readLong();
                    this.setPersistentData(i, l);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset.restore", (String)"1:1155:1.56", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset", "1:1162:1.56", exception});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.StreamSet.ReliabilitySubset", "1:1171:1.56", exception}, null), (Throwable)exception);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore");
            }
        }

        public int getStorageStrategy() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
            }
            int n = this.reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) <= 0 ? 1 : (this.reliability.compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0 ? 2 : (this.reliability.compareTo((Object)Reliability.RELIABLE_PERSISTENT) <= 0 ? 3 : 4));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(n));
            }
            return n;
        }

        static {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/StreamSet.java, SIB.processor, WAS602.SIB, o0610.11 1.56");
            }
        }
    }

    public static class Type {
        public static final Type SOURCE = new Type(0, "SOURCE");
        public static final Type TARGET = new Type(1, "TARGET");
        public static final Type INTERNAL_OUTPUT = new Type(2, "INTERNAL_OUTPUT");
        public static final Type INTERNAL_INPUT = new Type(3, "INTERNAL_INPUT");
        private final int value;
        private final String name;
        private static final Type[] set = new Type[]{SOURCE, TARGET, INTERNAL_OUTPUT, INTERNAL_INPUT};

        private Type(int n, String string) {
            this.value = n;
            this.name = string;
        }

        public int toInt() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(int n) {
            return set[n];
        }
    }
}

