/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.processor.gd.ARangeList;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.utils.BlockVector;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class StateStream {
    private static TraceComponent tc = SibTr.register((Class)StateStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private static byte Unknown;
    private static byte Requested;
    private static byte Uncommitted;
    private static byte Value;
    private static byte Discarded;
    private static byte Accepted;
    private static byte Rejected;
    private static byte Completed;
    private static byte Error;
    private static byte[][] nextState;
    private long completedPrefix;
    private ARangeList list;
    private Object mark = null;

    public void init() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init");
        }
        TickRange tickRange = new TickRange(0, 0L, Long.MAX_VALUE);
        this.list = new ARangeList();
        this.list.init(tickRange);
        tickRange = new TickRange(7, 0L, 0L);
        this.list.setCursor(0L);
        this.list.replacePrefix(tickRange);
        this.completedPrefix = 0L;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public boolean writeRange(TickRange tickRange) {
        TickRange tickRange2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeRange", (Object)tickRange);
        }
        boolean bl = false;
        byte by = tickRange.type;
        this.list.setCursor(tickRange.startstamp);
        TickRange tickRange3 = (TickRange)this.list.getCurr();
        do {
            tickRange2 = tickRange3;
            by = this.changeState(tickRange.type, tickRange2.type);
            if (by != tickRange2.type) {
                if (tickRange2.startstamp < tickRange.startstamp) {
                    this.list.splitStart(tickRange.startstamp);
                    tickRange2 = tickRange3 = (TickRange)this.list.getCurr();
                }
                if (tickRange2.endstamp > tickRange.endstamp) {
                    this.list.splitEnd(tickRange.endstamp);
                    tickRange2 = tickRange3 = (TickRange)this.list.getCurr();
                }
                tickRange2.type = by;
                tickRange2.value = tickRange.value;
                tickRange2.valuestamp = tickRange.valuestamp;
                tickRange2.itemStreamIndex = tickRange.itemStreamIndex;
                bl = true;
            }
            if (tickRange2.type == 7 && tickRange2.startstamp <= this.completedPrefix + 1L) {
                this.setCompletedPrefix(tickRange2.endstamp);
            }
            this.list.getNext();
            tickRange3 = (TickRange)this.list.getCurr();
        } while (tickRange3.startstamp <= tickRange.endstamp && tickRange2 != tickRange3);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeRange", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean containsRequested(TickRange tickRange) {
        return this.containsState(tickRange, (byte)1);
    }

    public boolean containsState(TickRange tickRange, byte by) {
        TickRange tickRange2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsState", (Object)new Object[]{tickRange, new Byte(by)});
        }
        boolean bl = false;
        this.list.setCursor(tickRange.startstamp);
        TickRange tickRange3 = (TickRange)this.list.getNext();
        do {
            if (tickRange3.type != by) continue;
            bl = true;
            break;
        } while ((tickRange2 = tickRange3) != (tickRange3 = (TickRange)this.list.getNext()) && tickRange3.endstamp < tickRange.endstamp);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsState", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isRequested(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRequested", (Object)new Long(l));
        }
        boolean bl = false;
        this.list.setCursor(l);
        TickRange tickRange = (TickRange)this.list.getNext();
        if (tickRange.type == 1) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRequested", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean writeCombinedRange(TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeCombinedRange", (Object)tickRange);
        }
        boolean bl = false;
        TickRange tickRange2 = null;
        if (tickRange.endstamp <= this.completedPrefix && tickRange.valuestamp <= this.completedPrefix) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCombinedRange", (Object)new Boolean(bl));
            }
            return bl;
        }
        long l = StateStream.max(this.completedPrefix + 1L, tickRange.startstamp);
        if (l < tickRange.valuestamp) {
            tickRange2 = new TickRange(7, l, tickRange.valuestamp - 1L);
            this.writeCompletedRange(tickRange2);
        }
        tickRange2 = new TickRange(tickRange.type, tickRange.valuestamp, tickRange.valuestamp);
        tickRange2.itemStreamIndex = tickRange.itemStreamIndex;
        tickRange2.value = tickRange.value;
        tickRange2.valuestamp = tickRange.valuestamp;
        bl = this.writeRange(tickRange2);
        if (tickRange.endstamp > tickRange.valuestamp) {
            tickRange2 = new TickRange(7, tickRange.valuestamp + 1L, tickRange.endstamp);
            this.writeCompletedRange(tickRange2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCombinedRange", (Object)new Boolean(bl));
        }
        return bl;
    }

    public TickRange findCompletedRange(TickRange tickRange) {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findCompletedRange", (Object)tickRange);
        }
        long l2 = l = tickRange.valuestamp;
        long l3 = l;
        this.list.setCursor(l);
        this.mark = this.list.getMark(this.mark);
        TickRange tickRange2 = (TickRange)this.list.getNext();
        l3 = this.discoverNextCompleted(l3, tickRange2);
        this.list.setCursor(this.mark);
        tickRange2 = (TickRange)this.list.getPrev();
        tickRange.startstamp = l2 = this.discoverPrevCompleted(l2, tickRange2);
        tickRange.endstamp = l3;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findCompletedRange", (Object)tickRange);
        }
        return tickRange;
    }

    private long discoverNextCompleted(long l, TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverNextCompleted", (Object)new Object[]{new Long(l), tickRange});
        }
        TickRange tickRange2 = tickRange;
        if (tickRange2.endstamp == l) {
            tickRange2 = (TickRange)this.list.getNext();
        }
        while (tickRange2.type == 7) {
            l = tickRange2.endstamp;
            TickRange tickRange3 = tickRange2;
            if (tickRange3 != (tickRange2 = (TickRange)this.list.getNext())) continue;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverNextCompleted", (Object)new Long(l));
        }
        return l;
    }

    private long discoverPrevCompleted(long l, TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Object[]{new Long(l), tickRange});
        }
        TickRange tickRange2 = tickRange;
        if (tickRange2.startstamp == l) {
            tickRange2 = (TickRange)this.list.getPrev();
        }
        while (tickRange2.type == 7) {
            l = tickRange2.startstamp;
            TickRange tickRange3 = tickRange2;
            if (tickRange3 != (tickRange2 = (TickRange)this.list.getPrev())) continue;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Long(l));
        }
        return l;
    }

    public long discoverPrevCompleted(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Object[]{new Long(l)});
        }
        long l2 = l;
        this.list.setCursor(l);
        TickRange tickRange = (TickRange)this.list.getPrev();
        l2 = this.discoverPrevCompleted(l, tickRange);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Long(l2));
        }
        return l2;
    }

    public TickRange writeCompleted(TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeCompleted", (Object)new Object[]{tickRange});
        }
        long l = tickRange.startstamp;
        long l2 = tickRange.startstamp;
        if (tickRange.endstamp <= this.completedPrefix && tickRange.valuestamp <= this.completedPrefix) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCompleted", (Object)tickRange);
            }
            return tickRange;
        }
        this.list.setCursor(tickRange.startstamp);
        TickRange tickRange2 = (TickRange)this.list.getCurr();
        byte by = this.changeState(tickRange.type, tickRange2.type);
        if (by != tickRange2.type) {
            TickRange tickRange3;
            if (by == 7) {
                if (l == tickRange2.startstamp) {
                    this.list.getPrev();
                    tickRange3 = (TickRange)this.list.getNext();
                    if (tickRange3.type == 7) {
                        l = tickRange3.startstamp;
                    }
                }
                if (l2 == tickRange2.endstamp) {
                    this.list.getNext();
                    tickRange3 = (TickRange)this.list.getCurr();
                    if (tickRange3.type == 7) {
                        l2 = tickRange3.endstamp;
                    }
                }
                tickRange.startstamp = l;
                tickRange.endstamp = l2;
                if (l <= this.completedPrefix + 1L) {
                    this.completedPrefix = l2;
                }
            }
            tickRange3 = new TickRange(by, l, l2);
            BlockVector blockVector = new BlockVector();
            blockVector.add(tickRange3);
            this.list.replace(blockVector);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompleted", (Object)tickRange);
        }
        return tickRange;
    }

    public TickRange writeCompletedRange(TickRange tickRange) {
        TickRange tickRange2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeCompletedRange", (Object)new Object[]{tickRange});
        }
        if (tickRange.endstamp <= this.completedPrefix && tickRange.valuestamp <= this.completedPrefix) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCompletedRange", (Object)tickRange);
            }
            return tickRange;
        }
        boolean bl = false;
        long l = tickRange.startstamp;
        long l2 = tickRange.endstamp;
        this.list.setCursor(tickRange.startstamp);
        this.mark = this.list.getMark(this.mark);
        TickRange tickRange3 = (TickRange)this.list.getNext();
        do {
            tickRange2 = tickRange3;
            int n = 7;
            n = this.changeState(tickRange.type, tickRange2.type);
            if (n != 7) {
                bl = true;
                break;
            }
            tickRange3 = (TickRange)this.list.getNext();
        } while (tickRange3.startstamp <= tickRange.endstamp && tickRange2 != tickRange3);
        if (!bl) {
            if (tickRange2.type == 7 && tickRange2.endstamp > tickRange.endstamp) {
                l2 = tickRange2.endstamp;
            }
            if (tickRange2.endstamp == tickRange.endstamp && tickRange3.type == 7) {
                l2 = tickRange3.endstamp;
            }
            this.list.setCursor(this.mark);
            tickRange2 = (TickRange)this.list.getPrev();
            if (tickRange2.type == 7 && tickRange2.startstamp < tickRange.startstamp) {
                l = tickRange2.startstamp;
            }
            if (tickRange2.startstamp == tickRange.startstamp) {
                tickRange3 = (TickRange)this.list.getPrev();
                if (tickRange3.type == 7) {
                    l = tickRange3.startstamp;
                }
            }
            if (l <= this.completedPrefix + 1L) {
                this.completedPrefix = l2;
            }
            TickRange tickRange4 = new TickRange(7, l, l2);
            BlockVector blockVector = new BlockVector();
            blockVector.add(tickRange4);
            this.list.replace(blockVector);
            tickRange.startstamp = l;
            tickRange.endstamp = l2;
        } else {
            this.writeRange(tickRange);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompletedRange", (Object)tickRange);
        }
        return tickRange;
    }

    public TickRange writeCompletedRangeForced(TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeCompletedRangeForced", (Object)new Object[]{tickRange});
        }
        if (tickRange.endstamp <= this.completedPrefix && tickRange.valuestamp <= this.completedPrefix) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeCompletedRangeForced", (Object)tickRange);
            }
            return tickRange;
        }
        long l = tickRange.startstamp;
        long l2 = tickRange.endstamp;
        this.list.setCursor(tickRange.startstamp);
        TickRange tickRange2 = (TickRange)this.list.getPrev();
        if (tickRange2.type == 7 && tickRange2.startstamp < tickRange.startstamp) {
            l = tickRange2.startstamp;
        }
        if (tickRange2.startstamp == tickRange.startstamp) {
            tickRange2 = (TickRange)this.list.getPrev();
            if (tickRange2.type == 7) {
                l = tickRange2.startstamp;
            }
        }
        this.list.setCursor(tickRange.endstamp);
        tickRange2 = (TickRange)this.list.getNext();
        if (tickRange2.type == 7 && tickRange2.endstamp > tickRange.endstamp) {
            l2 = tickRange2.endstamp;
        }
        if (tickRange2.endstamp == tickRange.endstamp) {
            tickRange2 = (TickRange)this.list.getNext();
            if (tickRange2.type == 7) {
                l2 = tickRange2.endstamp;
            }
        }
        if (l <= this.completedPrefix + 1L) {
            this.completedPrefix = l2;
        }
        TickRange tickRange3 = new TickRange(7, l, l2);
        BlockVector blockVector = new BlockVector();
        blockVector.add(tickRange3);
        this.list.replace(blockVector);
        tickRange.startstamp = l;
        tickRange.endstamp = l2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompletedRangeForced", (Object)tickRange);
        }
        return tickRange;
    }

    private byte changeState(byte by, byte by2) {
        byte by3 = nextState[by][by2];
        if (by3 == Error) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0008", new Object[]{"com.ibm.ws.sib.processor.gd.StateStream", "1:890:1.48", new Byte(by2), new Byte(by)}, null));
        }
        return by3;
    }

    private static final long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    public final void lookup(long l, long l2, BlockVector blockVector) {
        this.list.get(l, l2, blockVector);
    }

    public final void setCursor(long l) {
        this.list.setCursor(l);
    }

    public final TickRange getNext() {
        return (TickRange)this.list.getNext();
    }

    public final TickRange getPrev() {
        return (TickRange)this.list.getPrev();
    }

    public final long getCompletedPrefix() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)new Long(this.completedPrefix));
        }
        return this.completedPrefix;
    }

    public final boolean setCompletedPrefix(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCompletedPrefix", (Object)new Long(l));
        }
        boolean bl = false;
        if (l > this.completedPrefix) {
            TickRange tickRange;
            this.completedPrefix = l;
            if (this.completedPrefix < Long.MAX_VALUE) {
                this.list.setCursor(this.completedPrefix + 1L);
                tickRange = (TickRange)this.list.getCurr();
                if (tickRange.type == 7) {
                    this.completedPrefix = tickRange.endstamp;
                }
            }
            tickRange = new TickRange(7, 0L, this.completedPrefix);
            this.list.setCursor(0L);
            this.list.replacePrefix(tickRange);
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCompletedPrefix", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String stateString(String string) {
        TickRange tickRange;
        String string2 = "Elements in stream " + string + ": Completedpre=" + this.completedPrefix + ":\n";
        this.setCursor(0L);
        TickRange tickRange2 = this.getNext();
        do {
            string2 = string2 + tickRange2.toString() + "\n";
            tickRange = tickRange2;
        } while ((tickRange2 = this.getNext()) != tickRange);
        return string2;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/StateStream.java, SIB.processor, WAS602.SIB, o0610.11 1.48");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
        Unknown = 0;
        Requested = 1;
        Uncommitted = (byte)2;
        Value = (byte)3;
        Discarded = (byte)4;
        Accepted = (byte)5;
        Rejected = (byte)6;
        Completed = (byte)7;
        Error = (byte)8;
        nextState = new byte[][]{{Unknown, Unknown, Error, Error, Error, Error, Error, Error, Error}, {Requested, Requested, Error, Error, Error, Error, Error, Error, Error}, {Uncommitted, Uncommitted, Error, Error, Error, Error, Error, Error, Error}, {Value, Value, Value, Value, Error, Error, Error, Completed, Error}, {Discarded, Discarded, Discarded, Error, Error, Error, Error, Error, Error}, {Accepted, Accepted, Error, Accepted, Error, Error, Error, Error, Error}, {Rejected, Rejected, Error, Rejected, Error, Error, Error, Error, Error}, {Completed, Completed, Completed, Completed, Completed, Completed, Completed, Completed, Error}, {Error, Error, Error, Error, Error, Error, Error, Error, Error}};
    }
}

