/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.FlushAlreadyInProgressException;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.Reallocator;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.SourceStreamSetControl;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SourceStreamManager {
    private boolean pointTopoint = false;
    private SIMPTransactionManager txManager;
    private ProtocolItemStream protocolItemStream = null;
    private Cellule targetCellule = null;
    private DestinationHandler destinationHandler;
    private MessageProcessor messageProcessor;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)SourceStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DownstreamControl downControl;
    private StreamSet streamSet;
    private Reallocator reallocator = null;
    protected FlushComplete flushInProgress = null;

    public SourceStreamManager(MessageProcessor messageProcessor, DownstreamControl downstreamControl, DestinationHandler destinationHandler, ProtocolItemStream protocolItemStream, Cellule cellule, Reallocator reallocator) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SourceStreamManager", (Object)new Object[]{messageProcessor, downstreamControl, destinationHandler, protocolItemStream, cellule, reallocator});
        }
        this.messageProcessor = messageProcessor;
        this.downControl = downstreamControl;
        this.destinationHandler = destinationHandler;
        this.protocolItemStream = protocolItemStream;
        this.txManager = messageProcessor.getTXManager();
        this.targetCellule = cellule;
        this.reallocator = reallocator;
        if (reallocator != null) {
            this.pointTopoint = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SourceStreamManager", (Object)this);
        }
    }

    public synchronized StreamSet getStreamSet() throws SIResourceException {
        if (this.streamSet == null) {
            this.createNewPersistentStreamSet(null);
        }
        return this.streamSet;
    }

    public ControlAdapter getStreamSetRuntimeControl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSetRuntimeControl");
        }
        ControlAdapter controlAdapter = null;
        if (this.streamSet != null) {
            controlAdapter = this.streamSet.getControlAdapter();
            ((SourceStreamSetControl)controlAdapter).setSourceStreamManager(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSetRuntimeControl", (Object)controlAdapter);
        }
        return controlAdapter;
    }

    private synchronized StreamSet getStreamSet(SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSet", (Object)sIBUuid12);
        }
        if (this.streamSet == null) {
            this.createNewPersistentStreamSet(sIBUuid12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSet", (Object)this.streamSet);
        }
        return this.streamSet;
    }

    private void createNewPersistentStreamSet(SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)sIBUuid12);
        }
        if (sIBUuid12 == null) {
            sIBUuid12 = new SIBUuid12();
        }
        try {
            ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
            this.streamSet = new StreamSet(sIBUuid12, this.targetCellule, this.destinationHandler.getUuid(), this.messageProcessor.getMessagingEngineBusUuid(), this.protocolItemStream, this.txManager, Long.MAX_VALUE, StreamSet.Type.SOURCE, externalLocalTransaction);
            this.protocolItemStream.addItem(this.streamSet, externalLocalTransaction);
            externalLocalTransaction.commit();
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIConnectionLostException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)sIConnectionLostException);
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)sIIncorrectCallException);
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.createNewPersistentStreamSet", (String)"1:311:1.79", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewPersistentStreamSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessage(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMessage", (Object)new Object[]{sIMPMessage});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        StreamSet streamSet = this.getStreamSet();
        sIMPMessage.setGuaranteedStreamUuid(streamSet.getStreamID());
        int n = sIMPMessage.getPriority();
        Reliability reliability = sIMPMessage.getReliability();
        SourceStream sourceStream = null;
        Object object = streamSet;
        synchronized (object) {
            sourceStream = (SourceStream)streamSet.getStream(n, reliability);
            if (sourceStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                sourceStream = this.createStream(streamSet, n, reliability, streamSet.getPersistentData(n, reliability), false);
            }
        }
        object = this;
        synchronized (object) {
            long l = this.messageProcessor.nextTick();
            if (sIMPMessage.getRequiresNewId() || jsMessage.getSystemMessageId() == null) {
                jsMessage.setSystemMessageSourceUuid(this.messageProcessor.getMessagingEngineUuid());
                jsMessage.setSystemMessageValue(l);
                sIMPMessage.setRequiresNewId(false);
            }
            jsMessage.setGuaranteedValueEndTick(l);
            jsMessage.setGuaranteedValueValueTick(l);
            jsMessage.setGuaranteedValueRequestedOnly(false);
            if (sourceStream != null) {
                jsMessage.setGuaranteedValueStartTick(sourceStream.getLastMsgAdded() + 1L);
                jsMessage.setGuaranteedValueCompletedPrefix(sourceStream.getCompletedPrefix());
                sourceStream.writeUncommitted(sIMPMessage);
            } else {
                jsMessage.setGuaranteedValueStartTick(-1L);
                jsMessage.setGuaranteedValueCompletedPrefix(-1L);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMessage", (Object)(sourceStream != null ? 1 : 0));
        }
        return sourceStream != null;
    }

    public void removeMessage(SIMPMessage sIMPMessage) throws SIResourceException {
        Reliability reliability;
        int n;
        StreamSet streamSet;
        SourceStream sourceStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{sIMPMessage});
        }
        if ((sourceStream = (SourceStream)(streamSet = this.getStreamSet()).getStream(n = sIMPMessage.getPriority(), reliability = sIMPMessage.getReliability())) != null) {
            sourceStream.writeSilenceForced(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreMessage(SIMPMessage sIMPMessage, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreMessage", (Object)new Object[]{sIMPMessage});
        }
        int n = sIMPMessage.getPriority();
        Reliability reliability = sIMPMessage.getReliability();
        SIBUuid12 sIBUuid12 = sIMPMessage.getGuaranteedStreamUuid();
        StreamSet streamSet = this.getStreamSet(sIBUuid12);
        SourceStream sourceStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            sourceStream = (SourceStream)streamSet.getStream(n, reliability);
            if (sourceStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                sourceStream = this.createStream(streamSet, n, reliability, streamSet.getPersistentData(n, reliability), true);
            }
        }
        if (sourceStream != null) {
            if (!bl) {
                sourceStream.restoreUncommitted(sIMPMessage);
            } else {
                sourceStream.restoreValue(sIMPMessage);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreMessage");
        }
    }

    public void reallocate(boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocate");
        }
        if (this.pointTopoint) {
            this.reallocator.reallocateMsgs(this.destinationHandler, bl, true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocate");
        }
    }

    public List processAck(ControlAck controlAck) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{controlAck});
        }
        long l = controlAck.getAckPrefix();
        List list = this.processAck(controlAck, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)list);
        }
        return list;
    }

    public List processAck(ControlAck controlAck, long l) throws SIRollbackException, SIConnectionLostException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{controlAck, new Long(l)});
        }
        List list = null;
        if (!this.hasStream(controlAck.getGuaranteedStreamUUID())) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)new Object[]{"unknown stream ID - returning null array list(message ignored)"});
            }
            return list;
        }
        int n = controlAck.getPriority();
        Reliability reliability = controlAck.getReliability();
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            StreamSet streamSet = this.getStreamSet();
            SourceStream sourceStream = (SourceStream)streamSet.getStream(n, reliability);
            if (sourceStream == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)new Object[]{"unknown priority - returning null array list(message ignored)"});
                }
                return list;
            }
            long l2 = sourceStream.getAckPrefix();
            if (l > l2) {
                list = sourceStream.writeAckPrefix(l);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unexpected Ack message for BEST_EFFORT_NONPERSISTENT message ");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", list);
        }
        return list;
    }

    public void processNack(ControlNack controlNack) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)controlNack);
        }
        if (!this.hasStream(controlNack.getGuaranteedStreamUUID())) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)"unknown stream ID - message ignored");
            }
            return;
        }
        int n = controlNack.getPriority();
        Reliability reliability = controlNack.getReliability();
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            StreamSet streamSet = this.getStreamSet();
            SourceStream sourceStream = (SourceStream)streamSet.getStream(n, reliability);
            if (sourceStream == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)"unknown priority - message ignored");
                }
                return;
            }
            sourceStream.processNack(controlNack);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unexpected Nack message for BEST_EFFORT_NONPERSISTENT message ");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    public boolean isFlushed(SIBUuid12 sIBUuid12) {
        if (this.streamSet == null) {
            return true;
        }
        return !sIBUuid12.equals((Object)this.streamSet.getStreamID());
    }

    public boolean isReallocationRequired(SIMPMessage sIMPMessage) throws SIResourceException {
        TickRange tickRange;
        Reliability reliability;
        StreamSet streamSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReallocationRequired", (Object)new Object[]{sIMPMessage});
        }
        boolean bl = false;
        JsMessage jsMessage = sIMPMessage.getMessage();
        SIBUuid12 sIBUuid12 = sIMPMessage.getGuaranteedStreamUuid();
        if (!sIBUuid12.equals((Object)(streamSet = this.getStreamSet()).getStreamID())) {
            SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:700:1.79"}, null));
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.isReallocationRequired", (String)"1:707:1.79", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:714:1.79"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        int n = sIMPMessage.getPriority();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(n, reliability = sIMPMessage.getReliability());
        if (sourceStream != null && (tickRange = sourceStream.getTickRange(jsMessage.getGuaranteedValueValueTick())).isReallocationRequired()) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired", (Object)bl);
        }
        return bl;
    }

    public boolean hasStream(SIBUuid12 sIBUuid12) {
        if (this.streamSet == null) {
            return false;
        }
        return sIBUuid12.equals((Object)this.streamSet.getStreamID());
    }

    private SourceStream createStream(StreamSet streamSet, int n, Reliability reliability, long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, new Integer(n), reliability, new Long(l), bl});
        }
        SourceStream sourceStream = this.createStream(streamSet, n, reliability);
        if (this.pointTopoint) {
            sourceStream.initialiseSendWindow(l, this.messageProcessor.getDefinedSendWindow());
            if (bl && this.destinationHandler.isLink() && !this.destinationHandler.isMQLink()) {
                sourceStream.guessesInStream();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", (Object)sourceStream);
        }
        return sourceStream;
    }

    private SourceStream createStream(StreamSet streamSet, int n, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{streamSet, new Integer(n), reliability});
        }
        SourceStream sourceStream = null;
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            sourceStream = new SourceStream(n, reliability, this.downControl, new ArrayList(), streamSet, this.messageProcessor.getAlarmManager());
        }
        streamSet.setStream(n, reliability, sourceStream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", sourceStream);
        }
        return sourceStream;
    }

    public void reconstituteStreamSet(StreamSet streamSet) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteStreamSet", (Object)this.streamSet);
        }
        if (this.streamSet != null) {
            this.streamSet.remove();
        }
        this.streamSet = streamSet;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteStreamSet");
        }
    }

    public ControlNotFlushed stampNotFlushed(ControlNotFlushed controlNotFlushed) throws SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stampNotFlushed", (Object)new Object[]{controlNotFlushed});
        }
        int n = 0;
        int n2 = 10 * (Reliability.MAX_INDEX + 1);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        long[] lArray = new long[n2];
        StreamSet streamSet = this.getStreamSet();
        Iterator iterator = streamSet.iterator();
        while (iterator.hasNext()) {
            object = (SourceStream)iterator.next();
            nArray[n] = ((SourceStream)object).getPriority();
            nArray2[n] = ((SourceStream)object).getReliability().toInt();
            lArray[n] = ((SourceStream)object).getCompletedPrefix();
            ++n;
        }
        object = new int[n];
        int[] nArray3 = new int[n];
        long[] lArray2 = new long[n];
        System.arraycopy(nArray, 0, object, 0, n);
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        System.arraycopy(lArray, 0, lArray2, 0, n);
        controlNotFlushed.setCompletedPrefixPriority((int[])object);
        controlNotFlushed.setCompletedPrefixQOS(nArray3);
        controlNotFlushed.setCompletedPrefixTicks(lArray2);
        controlNotFlushed.setDuplicatePrefixPriority((int[])object);
        controlNotFlushed.setDuplicatePrefixQOS(nArray3);
        controlNotFlushed.setDuplicatePrefixTicks(lArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stampNotFlushed", (Object)controlNotFlushed);
        }
        return controlNotFlushed;
    }

    public List consolidateStreams(int n) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consolidateStreams");
        }
        ArrayList arrayList = new ArrayList();
        StreamSet streamSet = this.getStreamSet();
        Iterator iterator = streamSet.iterator();
        List list = null;
        while (iterator.hasNext()) {
            SourceStream sourceStream = (SourceStream)iterator.next();
            list = sourceStream.restoreStream(n);
            if (list != null) {
                arrayList.addAll(list);
            }
            if (!this.pointTopoint) continue;
            sourceStream.setDefinedSendWindow(this.messageProcessor.getDefinedSendWindow());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consolidateStreams", arrayList);
        }
        return arrayList;
    }

    public boolean flushable() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushable");
        }
        if (this.streamSet == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushable", (Object)Boolean.TRUE);
            }
            return true;
        }
        StreamSet streamSet = this.getStreamSet();
        Iterator iterator = streamSet.iterator();
        while (iterator.hasNext()) {
            SourceStream sourceStream = (SourceStream)iterator.next();
            if (sourceStream.flushable()) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushable", (Object)Boolean.FALSE);
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushable", (Object)Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFlush(FlushComplete flushComplete) throws FlushAlreadyInProgressException, SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startFlush", (Object)new Object[]{flushComplete});
        }
        SourceStreamManager sourceStreamManager = this;
        synchronized (sourceStreamManager) {
            if (this.flushInProgress != null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"startFlush", (Object)"FlushAlreadyInProgressException");
                }
                throw new FlushAlreadyInProgressException();
            }
            this.flushInProgress = flushComplete;
        }
        this.attemptFlush();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startFlush");
        }
    }

    public void attemptFlushIfNecessary() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (this.flushInProgress != null) {
            this.attemptFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptFlush() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attemptFlush");
        }
        FlushComplete flushComplete = null;
        StreamSet streamSet = null;
        SourceStreamManager sourceStreamManager = this;
        synchronized (sourceStreamManager) {
            if (this.flushInProgress == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attemptFlush");
                }
                return;
            }
            if (!this.flushable()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attemptFlush");
                }
                return;
            }
            flushComplete = this.flushInProgress;
            this.flushInProgress = null;
            streamSet = this.streamSet;
            this.streamSet = null;
            if (streamSet != null) {
                streamSet.remove();
            }
        }
        try {
            if (streamSet != null) {
                this.downControl.sendFlushedMessage(null, streamSet.getStreamID());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.attemptFlush", (String)"1:1135:1.79", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"attemptFlush", (Object)exception);
            }
            return;
        }
        finally {
            flushComplete.flushComplete(this.destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attemptFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlush() throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlush");
        }
        SourceStreamManager sourceStreamManager = this;
        synchronized (sourceStreamManager) {
            this.streamSet.remove();
            this.streamSet.dereferenceControlAdapter();
        }
        try {
            this.downControl.sendFlushedMessage(null, this.streamSet.getStreamID());
            this.streamSet = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.forceFlush", (String)"1:1186:1.79", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceFlush", (Object)exception);
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlush");
        }
    }

    public boolean updateSourceStream(SIMPMessage sIMPMessage, boolean bl) throws SIResourceException {
        Reliability reliability;
        StreamSet streamSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateSourceStream", (Object)new Object[]{sIMPMessage});
        }
        boolean bl2 = false;
        SIBUuid12 sIBUuid12 = sIMPMessage.getGuaranteedStreamUuid();
        if (!sIBUuid12.equals((Object)(streamSet = this.getStreamSet()).getStreamID())) {
            SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:1218:1.79"}, null));
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.updateSourceStream", (String)"1:1225:1.79", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.SourceStreamManager", "1:1232:1.79"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"updateSourceStream", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        int n = sIMPMessage.getPriority();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(n, reliability = sIMPMessage.getReliability());
        bl2 = sourceStream != null ? (bl ? sourceStream.writeSilence(sIMPMessage) : sourceStream.writeValue(sIMPMessage)) : true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateSourceStream", (Object)bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlushQuery(ControlAreYouFlushed controlAreYouFlushed) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushQuery", (Object)new Object[]{controlAreYouFlushed});
        }
        SIBUuid12 sIBUuid12 = controlAreYouFlushed.getGuaranteedStreamUUID();
        try {
            SourceStreamManager sourceStreamManager = this;
            synchronized (sourceStreamManager) {
                MessagingEngine messagingEngine = new MessagingEngine(controlAreYouFlushed.getGuaranteedSourceMessagingEngineUUID());
                if (this.isFlushed(sIBUuid12)) {
                    this.downControl.sendFlushedMessage(messagingEngine, sIBUuid12);
                } else {
                    this.downControl.sendNotFlushedMessage(messagingEngine, sIBUuid12, controlAreYouFlushed.getRequestID());
                }
            }
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.processFlushQuery", (String)"1:1307:1.79", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processFlushQuery", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushQuery");
        }
    }

    public synchronized void updateTargetCellule(Cellule cellule) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateTargetCellule", (Object)cellule);
        }
        if (this.pointTopoint) {
            this.targetCellule = cellule;
            StreamSet streamSet = this.getStreamSet();
            if (streamSet != null) {
                streamSet.updateCellule(cellule);
                ExternalAutoCommitTransaction externalAutoCommitTransaction = this.txManager.createAutoCommitTransaction();
                try {
                    streamSet.requestUpdate(externalAutoCommitTransaction);
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.SourceStreamManager.updateTargetCellule", (String)"1:1358:1.79", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"updateTargetCellule", (Object)((Object)messageStoreException));
                    }
                    throw new SIResourceException((Throwable)((Object)messageStoreException));
                }
                Iterator iterator = streamSet.iterator();
                while (iterator.hasNext()) {
                    SourceStream sourceStream = (SourceStream)iterator.next();
                    sourceStream.noGuessesInStream();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateTargetCellule");
        }
    }

    public SourceStream getBatchListener(ControlAck controlAck) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchListener", (Object)new Object[]{controlAck});
        }
        int n = controlAck.getPriority();
        Reliability reliability = controlAck.getReliability();
        StreamSet streamSet = this.getStreamSet();
        SourceStream sourceStream = (SourceStream)streamSet.getStream(n, reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchListener", (Object)sourceStream);
        }
        return sourceStream;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/SourceStreamManager.java, SIB.processor, WAS602.SIB, o0610.11 1.79");
        }
    }
}

