/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.processor.gd.InternalOutputStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.InternalOutputStreamSetControl;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InternalOutputStreamManager {
    private UpstreamControl upControl;
    private Cellule targetCellule;
    private static final TraceComponent tc = SibTr.register((Class)InternalOutputStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DownstreamControl downControl;
    private Map streamSets;
    static /* synthetic */ Class class$com$ibm$ws$sib$processor$gd$InternalOutputStreamManager$InternalOutputStreamSetIterator;

    public InternalOutputStreamManager(DownstreamControl downstreamControl, UpstreamControl upstreamControl, Cellule cellule) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStreamManager", (Object)new Object[]{downstreamControl, upstreamControl, cellule});
        }
        this.downControl = downstreamControl;
        this.upControl = upstreamControl;
        this.targetCellule = cellule;
        this.streamSets = Collections.synchronizedMap(new HashMap());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStreamManager", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSet getStreamSet(SIBUuid12 sIBUuid12, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSet", (Object)new Object[]{sIBUuid12, new Boolean(bl)});
        }
        StreamSet streamSet = null;
        Map map = this.streamSets;
        synchronized (map) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
            if (streamSet == null && bl) {
                streamSet = new StreamSet(sIBUuid12, this.targetCellule, 0L, StreamSet.Type.INTERNAL_OUTPUT);
                this.streamSets.put(sIBUuid12, streamSet);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSet", (Object)streamSet);
        }
        return streamSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SIMPMessage sIMPMessage, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMessage", (Object)new Object[]{sIMPMessage, new Boolean(bl)});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        int n = jsMessage.getPriority();
        Reliability reliability = jsMessage.getReliability();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, true);
        long l = jsMessage.getGuaranteedValueStartTick() - 1L;
        InternalOutputStream internalOutputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
            if (internalOutputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalOutputStream = this.createStream(streamSet, n, reliability, l);
            }
        }
        if (!sIMPMessage.isFromRemoteME() && internalOutputStream != null) {
            if (bl) {
                internalOutputStream.writeValue(sIMPMessage);
            } else {
                internalOutputStream.writeUncommitted(sIMPMessage);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSilence(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSilence", (Object)sIMPMessage);
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        int n = jsMessage.getPriority();
        Reliability reliability = jsMessage.getReliability();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, true);
        long l = jsMessage.getGuaranteedValueStartTick() - 1L;
        InternalOutputStream internalOutputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
            if (internalOutputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalOutputStream = this.createStream(streamSet, n, reliability, l);
            }
        }
        if (internalOutputStream != null) {
            internalOutputStream.writeSilence(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSilence");
        }
    }

    public void processAckExpected(long l, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        StreamSet streamSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{new Long(l), new Integer(n), reliability, sIBUuid12});
        }
        if ((streamSet = this.getStreamSet(sIBUuid12, false)) != null) {
            InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
            if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                if (internalOutputStream != null) {
                    internalOutputStream.processAckExpected(l);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unexpected AckExpected message for streamID " + sIBUuid12 + " Reliability " + reliability + " priority " + n));
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("AckExpected message for unknown streamID " + sIBUuid12));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    public void processAck(ControlAck controlAck) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{controlAck});
        }
        long l = controlAck.getAckPrefix();
        this.processAck(controlAck, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck");
        }
    }

    public void processAck(ControlAck controlAck, long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{controlAck});
        }
        int n = controlAck.getPriority();
        Reliability reliability = controlAck.getReliability();
        SIBUuid12 sIBUuid12 = controlAck.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, false);
        if (streamSet != null) {
            InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
            if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                if (internalOutputStream != null) {
                    long l2 = internalOutputStream.getAckPrefix();
                    if (l > l2) {
                        internalOutputStream.writeAckPrefix(l);
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unexpected Ack message for streamID " + sIBUuid12 + " Reliability " + reliability + " priority " + n));
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Ack message for unknown streamID " + sIBUuid12));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck");
        }
    }

    public void processNack(ControlNack controlNack) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)controlNack);
        }
        int n = controlNack.getPriority();
        Reliability reliability = controlNack.getReliability();
        SIBUuid12 sIBUuid12 = controlNack.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, false);
        if (streamSet != null) {
            InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
            if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                if (internalOutputStream != null) {
                    internalOutputStream.processNack(controlNack);
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unexpected Nack message for streamID " + sIBUuid12 + " Reliability " + reliability + " priority " + n));
                }
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Nack message for unknown streamID " + sIBUuid12));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFlushQuery(ControlAreYouFlushed controlAreYouFlushed) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushQuery", (Object)new Object[]{controlAreYouFlushed});
        }
        SIBUuid12 sIBUuid12 = controlAreYouFlushed.getGuaranteedStreamUUID();
        try {
            InternalOutputStreamManager internalOutputStreamManager = this;
            synchronized (internalOutputStreamManager) {
                MessagingEngine messagingEngine = new MessagingEngine(controlAreYouFlushed.getGuaranteedSourceMessagingEngineUUID());
                if (this.isFlushed(sIBUuid12)) {
                    this.downControl.sendFlushedMessage(messagingEngine, sIBUuid12);
                } else {
                    this.downControl.sendNotFlushedMessage(messagingEngine, sIBUuid12, controlAreYouFlushed.getRequestID());
                }
            }
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStreamManager.processFlushQuery", (String)"1:438:1.34", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processFlushQuery", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushQuery");
        }
    }

    private InternalOutputStream createStream(StreamSet streamSet, int n, Reliability reliability, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{new Integer(n), reliability});
        }
        InternalOutputStream internalOutputStream = null;
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            internalOutputStream = new InternalOutputStream(n, reliability, l, this.downControl, this.upControl, null, streamSet.getStreamID(), streamSet);
        }
        streamSet.setStream(n, reliability, internalOutputStream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", internalOutputStream);
        }
        return internalOutputStream;
    }

    public boolean commitInsert(SIMPMessage sIMPMessage) {
        Reliability reliability;
        int n;
        InternalOutputStream internalOutputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInsert", (Object)new Object[]{sIMPMessage});
        }
        boolean bl = false;
        JsMessage jsMessage = sIMPMessage.getMessage();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, false);
        if (streamSet == null && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Tried to commit a message on an unknown streamID " + sIBUuid12));
        }
        if ((internalOutputStream = (InternalOutputStream)streamSet.getStream(n = jsMessage.getPriority().intValue(), reliability = jsMessage.getReliability())) != null) {
            bl = internalOutputStream.writeValue(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInsert");
        }
        return bl;
    }

    public boolean rollbackInsert(MessageItem messageItem) throws SIResourceException {
        Reliability reliability;
        int n;
        InternalOutputStream internalOutputStream;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackInsert", (Object)messageItem);
        }
        boolean bl = false;
        JsMessage jsMessage = messageItem.getMessage();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, false);
        if (streamSet == null && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Tried to rollback a message on an unknown streamID " + sIBUuid12));
        }
        if ((internalOutputStream = (InternalOutputStream)streamSet.getStream(n = jsMessage.getPriority().intValue(), reliability = jsMessage.getReliability())) != null) {
            bl = internalOutputStream.writeSilence(messageItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackInsert");
        }
        return bl;
    }

    public long checkAck(ControlAck controlAck, long l) {
        long l2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkAck", (Object)new Object[]{controlAck, new Long(l)});
        }
        int n = controlAck.getPriority();
        Reliability reliability = controlAck.getReliability();
        SIBUuid12 sIBUuid12 = controlAck.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, false);
        if (streamSet == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkAck", (Object)new Long(l));
            }
            return l;
        }
        InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
        if (internalOutputStream != null && (l2 = internalOutputStream.getAckPrefix()) < l) {
            l = l2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkAck", (Object)new Long(l));
        }
        return l;
    }

    public void remove(SIBUuid12 sIBUuid12) {
        this.streamSets.remove(sIBUuid12);
    }

    private boolean isFlushed(SIBUuid12 sIBUuid12) {
        return this.getStreamSet(sIBUuid12, false) == null;
    }

    public ControlNotFlushed stampNotFlushed(ControlNotFlushed controlNotFlushed, SIBUuid12 sIBUuid12) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stampNotFlushed", (Object)new Object[]{controlNotFlushed});
        }
        int n = 0;
        int n2 = 10 * (Reliability.MAX_INDEX + 1);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        long[] lArray = new long[n2];
        StreamSet streamSet = this.getStreamSet(sIBUuid12, false);
        Iterator iterator = streamSet.iterator();
        while (iterator.hasNext()) {
            object = (InternalOutputStream)iterator.next();
            nArray[n] = ((InternalOutputStream)object).getPriority();
            nArray2[n] = ((InternalOutputStream)object).getReliability().toInt();
            lArray[n] = ((InternalOutputStream)object).getCompletedPrefix();
            ++n;
        }
        object = new int[n];
        int[] nArray3 = new int[n];
        long[] lArray2 = new long[n];
        System.arraycopy(nArray, 0, object, 0, n);
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        System.arraycopy(lArray, 0, lArray2, 0, n);
        controlNotFlushed.setCompletedPrefixPriority((int[])object);
        controlNotFlushed.setCompletedPrefixQOS(nArray3);
        controlNotFlushed.setCompletedPrefixTicks(lArray2);
        controlNotFlushed.setDuplicatePrefixPriority((int[])object);
        controlNotFlushed.setDuplicatePrefixQOS(nArray3);
        controlNotFlushed.setDuplicatePrefixTicks(lArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stampNotFlushed", (Object)controlNotFlushed);
        }
        return controlNotFlushed;
    }

    public SIMPIterator getStreamSetIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSetIterator");
        }
        InternalOutputStreamSetIterator internalOutputStreamSetIterator = new InternalOutputStreamSetIterator(this.streamSets.values().iterator());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSetIterator", (Object)internalOutputStreamSetIterator);
        }
        return internalOutputStreamSetIterator;
    }

    public void removeMessage(StreamSet streamSet, SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{streamSet, sIMPMessage});
        }
        int n = sIMPMessage.getPriority();
        Reliability reliability = sIMPMessage.getReliability();
        InternalOutputStream internalOutputStream = (InternalOutputStream)streamSet.getStream(n, reliability);
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueStartTick();
        long l2 = jsMessage.getGuaranteedValueEndTick();
        TickRange tickRange = new TickRange(7, l, l2);
        if (internalOutputStream != null) {
            internalOutputStream.writeSilenceForced(tickRange);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/InternalOutputStreamManager.java, SIB.processor, WAS602.SIB, o0610.11 1.34");
        }
    }

    private class InternalOutputStreamSetIterator
    extends BasicSIMPIterator {
        private final TraceComponent innerTC;

        InternalOutputStreamSetIterator(Iterator iterator) {
            super(iterator);
            this.innerTC = SibTr.register((Class)(class$com$ibm$ws$sib$processor$gd$InternalOutputStreamManager$InternalOutputStreamSetIterator == null ? (class$com$ibm$ws$sib$processor$gd$InternalOutputStreamManager$InternalOutputStreamSetIterator = InternalOutputStreamManager.class$("com.ibm.ws.sib.processor.gd.InternalOutputStreamManager$InternalOutputStreamSetIterator")) : class$com$ibm$ws$sib$processor$gd$InternalOutputStreamManager$InternalOutputStreamSetIterator), (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
        }

        public Object next() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)this.innerTC, (String)"next");
            }
            StreamSet streamSet = (StreamSet)super.next();
            InternalOutputStreamSetControl internalOutputStreamSetControl = null;
            if (streamSet != null) {
                internalOutputStreamSetControl = (InternalOutputStreamSetControl)streamSet.getControlAdapter();
                internalOutputStreamSetControl.setInternalOutputStreamManager(InternalOutputStreamManager.this);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)this.innerTC, (String)"next", (Object)internalOutputStreamSetControl);
            }
            return internalOutputStreamSetControl;
        }
    }
}

