/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.InternalOutputStreamControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class InternalOutputStream
extends ControllableStream {
    private UpstreamControl upControl;
    private static TraceComponent tc = SibTr.register((Class)InternalOutputStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int priority;
    private Reliability reliability;
    private DownstreamControl downControl;
    private long totalMessagesSent = 0L;
    private SIBUuid12 streamID;
    private StateStream oststream;
    private long oack = 0L;
    private long ack = 0L;
    private long lastSent = 0L;
    private SourceStream.SourceStreamState internalOutputState = SourceStream.SourceStreamState.ACTIVE;
    private StreamSet streamSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalOutputStream(int n, Reliability reliability, long l, DownstreamControl downstreamControl, UpstreamControl upstreamControl, List list, SIBUuid12 sIBUuid12, StreamSet streamSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalOutputStream", (Object)new Object[]{new Integer(n), reliability, new Long(l), downstreamControl, upstreamControl, list, sIBUuid12, streamSet});
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.streamSet = streamSet;
            this.priority = n;
            this.reliability = reliability;
            this.downControl = downstreamControl;
            this.upControl = upstreamControl;
            this.streamID = sIBUuid12;
            this.oststream = new StateStream();
            this.oststream.init();
            this.oststream.setCompletedPrefix(l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalOutputStream", (Object)this);
        }
    }

    public long getCompletedPrefix() {
        long l = this.oststream.getCompletedPrefix();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)new Long(l));
        }
        return l;
    }

    public int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    public Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    public long getAckPrefix() {
        return this.oack;
    }

    public void setLastSent(long l) {
        if (l > this.lastSent) {
            this.lastSent = l;
        }
    }

    public void sendSilence(long l, long l2) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSilence", (Object)new Long(l));
        }
        if (this.ack < l - 1L) {
            long l3 = this.oststream.discoverPrevCompleted(l);
            if (l3 < this.ack + 1L) {
                l3 = this.ack + 1L;
            }
            if (l3 < l) {
                try {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("send Silence from: " + l3 + " to " + (l - 1L) + " on Stream " + this.streamID));
                    }
                    this.downControl.sendSilenceMessage(l3, l - 1L, l2, false, this.priority, this.reliability, this.streamID);
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.sendSilence", (String)"1:284:1.73", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendSilence", (Object)((Object)sIResourceException));
                    }
                    throw sIResourceException;
                }
                this.setLastSent(l - 1L);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSilence");
        }
    }

    public StateStream getStateStream() {
        return this.oststream;
    }

    public synchronized long getTotalMessagesSent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalMessagesSent");
            SibTr.exit((TraceComponent)tc, (String)"getTotalMessagesSent", (Object)new Long(this.totalMessagesSent));
        }
        return this.totalMessagesSent;
    }

    public InternalOutputStreamControl getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        InternalOutputStreamControl internalOutputStreamControl = new InternalOutputStreamControl(this.streamSet.getRemoteEngineUUID(), this, this.streamSet);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)internalOutputStreamControl);
        }
        return internalOutputStreamControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValue(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeValue", (Object)new Object[]{sIMPMessage});
        }
        TickRange tickRange = null;
        long l = -1L;
        if (sIMPMessage.isInStore()) {
            l = sIMPMessage.getID();
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l2 = jsMessage.getGuaranteedValueValueTick();
        boolean bl = true;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeValue at: " + l2 + " on Stream " + this.streamID));
        }
        ++this.totalMessagesSent;
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            if (l2 > this.oststream.getCompletedPrefix()) {
                if (jsMessage.getGuaranteedValueRequestedOnly() && !this.oststream.isRequested(l2)) {
                    bl = false;
                }
                tickRange = TickRange.newValueTick(l2, null, l);
                this.oststream.writeRange(tickRange);
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.setLastSent(jsMessage.getGuaranteedValueEndTick());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUncommitted(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeUncommitted", (Object)new Object[]{sIMPMessage});
        }
        TickRange tickRange = null;
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        long l2 = jsMessage.getGuaranteedValueStartTick();
        long l3 = jsMessage.getGuaranteedValueEndTick();
        tickRange = TickRange.newUncommittedTick(l);
        tickRange.startstamp = l2;
        tickRange.endstamp = l3;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeUncommitted at: " + l + " with Silence from: " + l2 + " to " + l3 + " on Stream " + this.streamID));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.oststream.writeCombinedRange(tickRange);
            long l4 = this.oststream.getCompletedPrefix();
            this.sendSilence(l2, l4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeUncommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSilence(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{sIMPMessage});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        long l2 = jsMessage.getGuaranteedValueStartTick();
        long l3 = jsMessage.getGuaranteedValueEndTick();
        if (l3 < l) {
            l3 = l;
        }
        TickRange tickRange = new TickRange(7, l2, l3);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilence from: " + l2 + " to " + l3 + " on Stream " + this.streamID));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            tickRange = this.oststream.writeCompletedRange(tickRange);
            long l4 = this.oststream.getCompletedPrefix();
            if (l4 > this.oack) {
                this.oack = l4;
            }
            if (this.lastSent > l3) {
                this.sendSilence(l3 + 1L, l4);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
        this.setLastSent(jsMessage.getGuaranteedValueEndTick());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilence(ControlSilence controlSilence) throws SIResourceException {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{controlSilence});
        }
        boolean bl = false;
        long l2 = controlSilence.getStartTick();
        long l3 = controlSilence.getEndTick();
        boolean bl2 = controlSilence.getRequestedOnly();
        TickRange tickRange = new TickRange(7, l2, l3);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilence from: " + l2 + " to " + l3 + " on Stream " + this.streamID));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            if (bl2 && !this.oststream.containsRequested(tickRange)) {
                bl = false;
            }
            tickRange = this.oststream.writeCompletedRange(tickRange);
            if (this.oststream.getCompletedPrefix() > this.oack) {
                this.oack = this.oststream.getCompletedPrefix();
            }
            l = this.oststream.getCompletedPrefix();
        }
        if (bl) {
            try {
                this.downControl.sendSilenceMessage(tickRange.startstamp, tickRange.endstamp, l, bl2, this.priority, this.reliability, this.streamID);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.writeSilence", (String)"1:596:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"writeSilence", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
            this.setLastSent(tickRange.endstamp);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence", (Object)new Boolean(bl));
        }
    }

    public void processAckExpected(long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{new Long(l)});
        }
        if (this.oack < l) {
            try {
                this.downControl.sendAckExpectedMessage(l, this.priority, this.reliability, this.streamID);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processAckExpected", (String)"1:636:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAckPrefix(long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAckPrefix", (Object)new Long(l));
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            if (l > this.ack) {
                this.ack = l;
            }
            this.oststream.setCompletedPrefix(l);
            long l2 = this.oststream.getCompletedPrefix();
            if (l2 > this.oack) {
                this.oack = l2;
                this.upControl.sendAckMessage(null, null, null, l2, this.priority, this.reliability, this.streamID, false);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeAckPrefix");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List processNack(ControlNack controlNack) throws SIResourceException {
        TickRange tickRange;
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)new Object[]{controlNack, new Boolean(false)});
        }
        boolean bl = false;
        ArrayList<TickRange> arrayList = new ArrayList<TickRange>();
        boolean bl2 = false;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl3 = false;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = controlNack.getStartTick();
        long l7 = controlNack.getEndTick();
        TickRange tickRange2 = null;
        Object object = this;
        synchronized (object) {
            l = this.oststream.getCompletedPrefix();
            if (l6 <= l) {
                bl2 = true;
                l2 = l6;
                l3 = l;
                l6 = l + 1L;
            }
            if (l7 > l) {
                this.oststream.setCursor(l6);
                tickRange = this.oststream.getNext();
                TickRange tickRange3 = null;
                while (tickRange.startstamp <= l7 && tickRange != tickRange3) {
                    if (tickRange.type == 0 || tickRange.type == 1) {
                        long l8 = InternalOutputStream.max(tickRange.startstamp, l6);
                        long l9 = InternalOutputStream.min(l7, tickRange.endstamp);
                        TickRange tickRange4 = new TickRange(1, l8, l9);
                        if (tickRange.type == 0) {
                            this.oststream.writeRange(tickRange4);
                        }
                        this.upControl.sendNackMessage(null, null, null, l8, l9, this.priority, this.reliability, this.streamID);
                    } else if (tickRange.type == 3) {
                        if (bl) {
                            arrayList.add(tickRange2);
                        }
                        tickRange2 = (TickRange)tickRange.clone();
                        bl = true;
                    } else if (tickRange.type == 2 && bl) {
                        if (tickRange.valuestamp > tickRange2.valuestamp + 1L) {
                            tickRange2.endstamp = tickRange.valuestamp - 1L;
                        }
                        arrayList.add(tickRange2);
                        bl = false;
                    }
                    tickRange3 = tickRange;
                    tickRange = this.oststream.getNext();
                }
                if (tickRange3 != null && tickRange3.type == 7) {
                    if (bl) {
                        tickRange2.endstamp = tickRange3.endstamp;
                    } else {
                        bl3 = true;
                        l4 = tickRange3.startstamp;
                        l5 = tickRange3.endstamp;
                    }
                }
                if (bl) {
                    arrayList.add(tickRange2);
                }
            }
        }
        if (bl2) {
            try {
                this.downControl.sendSilenceMessage(l2, l3, l, true, controlNack.getPriority(), controlNack.getReliability(), this.streamID);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processNack", (String)"1:859:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (arrayList.size() != 0) {
            object = null;
            try {
                object = this.downControl.sendValueMessages(arrayList, this.getCompletedPrefix(), true, this.priority, this.reliability, this.streamID);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processNack", (String)"1:892:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
            if (object != null) {
                tickRange = null;
                for (int i = 0; i < object.size(); ++i) {
                    tickRange = (TickRange)object.get(i);
                    this.writeSilenceForced(tickRange);
                }
            }
        }
        if (bl3) {
            try {
                this.downControl.sendSilenceMessage(l4, l5, l, true, controlNack.getPriority(), controlNack.getReliability(), this.streamID);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.processNack", (String)"1:935:1.73", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseMemory");
        }
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.oststream = new StateStream();
            this.oststream.init();
            this.oststream.setCompletedPrefix(this.oack);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseMemory");
        }
    }

    protected static long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    protected static long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Object[]{tickRange});
        }
        long l = tickRange.startstamp;
        long l2 = tickRange.endstamp;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + l + " to " + l2 + " on Stream " + this.streamID));
        }
        TickRange tickRange2 = new TickRange(7, l, l2);
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            tickRange2 = this.oststream.writeCompletedRangeForced(tickRange2);
            try {
                if (tickRange2.startstamp == 0L) {
                    this.writeAckPrefix(tickRange2.endstamp);
                }
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalOutputStream.writeSilenceForced", (String)"1:1036:1.73", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Long(l));
        }
        TickRange tickRange = null;
        InternalOutputStream internalOutputStream = this;
        synchronized (internalOutputStream) {
            this.oststream.setCursor(l);
            tickRange = this.oststream.getNext();
            if (tickRange != null) {
                this.writeSilenceForced(tickRange);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    public synchronized List getAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList<Long> linkedList = new LinkedList<Long>();
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                linkedList.add(new Long(tickRange.itemStreamIndex));
            }
            if (tickRange.type == 2) {
                tickRange.reallocateOnCommit();
            }
            tickRange = this.oststream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        return Collections.unmodifiableList(linkedList);
    }

    public synchronized List getAllMessageItemsOnStream(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessageItemsOnStream", (Object)new Boolean(bl));
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                long l = tickRange.itemStreamIndex;
                MessageItem messageItem = this.downControl.getValueMessage(l);
                if (messageItem != null) {
                    linkedList.add(messageItem);
                }
            } else if (tickRange.type == 2 && bl && tickRange.value != null) {
                linkedList.add(tickRange.value);
            }
            tickRange = this.oststream.getNext();
        }
        List list = Collections.unmodifiableList(linkedList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessageItemsOnStream", list);
        }
        return list;
    }

    public synchronized long countAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long l = 0L;
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                ++l;
            }
            if (tickRange.type == 2) {
                tickRange.reallocateOnCommit();
            }
            tickRange = this.oststream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)new Long(l));
        }
        return l;
    }

    public SourceStream.SourceStreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.internalOutputState);
        }
        return this.internalOutputState;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/InternalOutputStream.java, SIB.processor, WAS602.SIB, o0610.11 1.73");
        }
    }
}

