/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.processor.gd.InternalInputStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalInputStreamManager {
    private static final TraceComponent tc = SibTr.register((Class)InternalInputStreamManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private UpstreamControl upControl;
    private MessageProcessor messageProcessor;
    private Map streamSets;
    protected FlushComplete flushInProgress = null;

    public InternalInputStreamManager(MessageProcessor messageProcessor, UpstreamControl upstreamControl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalInputStreamManager", (Object)new Object[]{messageProcessor, upstreamControl});
        }
        this.upControl = upstreamControl;
        this.messageProcessor = messageProcessor;
        this.streamSets = Collections.synchronizedMap(new HashMap());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalInputStreamManager", (Object)this);
        }
    }

    public boolean hasStream(SIBUuid12 sIBUuid12, int n, Reliability reliability) {
        StreamSet streamSet;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasStream", (Object)new Object[]{sIBUuid12, new Integer(n), reliability});
        }
        if ((streamSet = (StreamSet)this.streamSets.get(sIBUuid12)) != null && streamSet.getStream(n, reliability) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"hasStream", (Object)Boolean.TRUE);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasStream", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMessage", (Object)new Object[]{jsMessage});
        }
        int n = jsMessage.getPriority();
        Reliability reliability = jsMessage.getReliability();
        SIBUuid12 sIBUuid12 = jsMessage.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(n, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, n, reliability);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAckExpected(ControlAckExpected controlAckExpected) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpectedMessage", (Object)new Object[]{controlAckExpected});
        }
        int n = controlAckExpected.getPriority();
        Reliability reliability = controlAckExpected.getReliability();
        SIBUuid12 sIBUuid12 = controlAckExpected.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(n, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, n, reliability);
            }
        }
        internalInputStream.processAckExpected(controlAckExpected.getTick());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpectedMessage");
        }
    }

    public List processAck(ControlAck controlAck) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{controlAck});
        }
        long l = controlAck.getAckPrefix();
        List list = this.processAck(controlAck, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List processAck(ControlAck controlAck, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{controlAck, new Long(l)});
        }
        int n = controlAck.getPriority();
        Reliability reliability = controlAck.getReliability();
        List list = null;
        SIBUuid12 sIBUuid12 = controlAck.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(n, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, n, reliability);
            }
        }
        long l2 = internalInputStream.getAckPrefix();
        if (l > l2) {
            list = internalInputStream.writeAckPrefix(l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNack(ControlNack controlNack) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)controlNack);
        }
        int n = controlNack.getPriority();
        Reliability reliability = controlNack.getReliability();
        SIBUuid12 sIBUuid12 = controlNack.getGuaranteedStreamUUID();
        StreamSet streamSet = this.getStreamSet(sIBUuid12, true);
        InternalInputStream internalInputStream = null;
        StreamSet streamSet2 = streamSet;
        synchronized (streamSet2) {
            internalInputStream = (InternalInputStream)streamSet.getStream(n, reliability);
            if (internalInputStream == null && reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
                internalInputStream = this.createStream(streamSet, n, reliability);
            }
        }
        internalInputStream.processNack(controlNack);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSet getStreamSet(SIBUuid12 sIBUuid12, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamSet", (Object)new Object[]{sIBUuid12, new Boolean(bl)});
        }
        StreamSet streamSet = null;
        Map map = this.streamSets;
        synchronized (map) {
            streamSet = (StreamSet)this.streamSets.get(sIBUuid12);
            if (streamSet == null && bl) {
                streamSet = new StreamSet(sIBUuid12, null, 0L, StreamSet.Type.INTERNAL_INPUT);
                this.streamSets.put(sIBUuid12, streamSet);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamSet", (Object)streamSet);
        }
        return streamSet;
    }

    private InternalInputStream createStream(StreamSet streamSet, int n, Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStream", (Object)new Object[]{new Integer(n), reliability});
        }
        InternalInputStream internalInputStream = null;
        if (reliability.compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0) {
            internalInputStream = new InternalInputStream(n, reliability, this.upControl, streamSet.getStreamID(), null, this.messageProcessor.getAlarmManager());
        }
        streamSet.setStream(n, reliability, internalInputStream);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStream", internalInputStream);
        }
        return internalInputStream;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/InternalInputStreamManager.java, SIB.processor, WAS602.SIB, o0610.11 1.21");
        }
    }
}

