/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.RangeObject;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.TargetStreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class GuaranteedTargetStream
extends ControllableStream
implements TargetStream,
BatchListener {
    private MPAlarmManager am;
    private static TraceComponent tc = SibTr.register((Class)GuaranteedTargetStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int priority;
    private Reliability reliability;
    private MessageDeliverer deliverer;
    private UpstreamControl upControl;
    private StateStream oststream;
    private volatile long doubtHorizon;
    private long unknownHorizon;
    private long nextCompletedPrefix = 0L;
    private boolean isStreamFull = false;
    private long valueHorizon = 0L;
    protected static Hashtable pendingAlarms;
    private GuaranteedTargetStreamState streamState = GuaranteedTargetStreamState.ACTIVE;
    private int messagesInBatch = 0;
    private long numberOfMessagesReceived = 0L;
    protected StreamSet streamSet;
    private String remoteEngineUUID;
    private static final TraceNLS nls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuaranteedTargetStream(MessageDeliverer messageDeliverer, UpstreamControl upstreamControl, MPAlarmManager mPAlarmManager, StreamSet streamSet, int n, Reliability reliability, List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"GuaranteedTargetStream", (Object)new Object[]{messageDeliverer, upstreamControl, mPAlarmManager, streamSet, new Integer(n), reliability, list});
        }
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            this.remoteEngineUUID = streamSet.getRemoteEngineUUID();
            this.am = mPAlarmManager;
            this.priority = n;
            this.reliability = reliability;
            this.unknownHorizon = 0L;
            this.doubtHorizon = 1L;
            this.oststream = new StateStream();
            this.oststream.init();
            this.deliverer = messageDeliverer;
            this.upControl = upstreamControl;
            this.streamSet = streamSet;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"GuaranteedTargetStream", (Object)this);
        }
    }

    public long reconstituteCompletedPrefix(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteCompletedPrefix", (Object)new Long(l));
        }
        long l2 = this.oststream.setCompletedPrefix(l) ? l : this.oststream.getCompletedPrefix();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteCompletedPrefix", (Object)new Long(l2));
        }
        return l2;
    }

    private void persistCompletedPrefix(Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistCompletedPrefix", (Object)transaction);
        }
        this.streamSet.setPersistentData(this.priority, this.reliability, this.getNextCompletedPrefix());
        this.streamSet.requestUpdate(this.reliability, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompletedPrefix(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCompletedPrefix", (Object)new Long(l));
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            if (this.oststream.setCompletedPrefix(l)) {
                this.doubtHorizon = l + 1L;
                this.unknownHorizon = l;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompletedPrefix() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateCompletedPrefix");
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.oststream.setCompletedPrefix(this.nextCompletedPrefix);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateCompletedPrefix");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDoubtHorizon() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDoubtHorizon");
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.resetDoubtHorizon(this.oststream.getCompletedPrefix() + 1L);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDoubtHorizon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDoubtHorizon(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDoubtHorizon", (Object)new Long(l));
        }
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.doubtHorizon = l;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDoubtHorizon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDoubtHorizon() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDoubtHorizon");
        }
        long l = 0L;
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            l = this.doubtHorizon;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDoubtHorizon");
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeValue", (Object)new Object[]{messageItem});
        }
        TickRange tickRange = null;
        List<MessageItem> list = null;
        JsMessage jsMessage = messageItem.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            StateStream stateStream = this.oststream;
            synchronized (stateStream) {
                boolean bl = false;
                try {
                    bl = this.streamCanAcceptNewMessage(messageItem);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.writeValue", (String)"1:421:1.77", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)((Object)sIException));
                    }
                    return;
                }
                if (bl) {
                    long l2 = this.oststream.getCompletedPrefix();
                    if (l > l2) {
                        tickRange = TickRange.newValueTick(l, messageItem, -1L);
                        tickRange.startstamp = jsMessage.getGuaranteedValueStartTick();
                        tickRange.endstamp = jsMessage.getGuaranteedValueEndTick();
                        boolean bl2 = false;
                        bl2 = this.oststream.writeCombinedRange(tickRange);
                        if (bl2) {
                            if (tickRange.valuestamp > this.valueHorizon) {
                                this.valueHorizon = tickRange.valuestamp;
                            }
                            boolean bl3 = false;
                            tickRange = this.oststream.findCompletedRange(tickRange);
                            if (tickRange.endstamp > this.unknownHorizon) {
                                if (tickRange.startstamp > this.unknownHorizon + 1L) {
                                    if (tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)("created gap [" + (this.unknownHorizon + 1L) + ", " + (tickRange.startstamp - 1L) + "]"));
                                    }
                                    bl3 = true;
                                    this.handleNewGap(this.unknownHorizon + 1L, tickRange.startstamp - 1L);
                                }
                                this.unknownHorizon = tickRange.endstamp;
                            }
                            if (!bl3) {
                                if (tickRange.startstamp <= this.doubtHorizon) {
                                    if (list == null) {
                                        list = new ArrayList<MessageItem>();
                                    }
                                    list.add(messageItem);
                                    this.doubtHorizon = tickRange.endstamp + 1L;
                                    list = this.advanceDoubtHorizon(list);
                                } else {
                                    list = this.advanceDoubtHorizon(list);
                                }
                            }
                        } else if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Repeated V tick value - not yet acked " + l + " : " + l2));
                        }
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Repeated V tick value - already acked " + l + " : " + l2));
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The stream is full: msg discarded for resend.");
                }
            }
            if (list != null) {
                try {
                    this.messagesInBatch += list.size();
                    this.deliverer.deliverOrderedMessages(list, this, this.priority, this.reliability);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.writeValue", (String)"1:568:1.77", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:575:1.77", sIException});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)"GDException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:585:1.77", sIException}, null), (Throwable)sIException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue");
        }
    }

    public void writeSilence(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{messageItem});
        }
        JsMessage jsMessage = messageItem.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        long l2 = jsMessage.getGuaranteedValueEndTick();
        if (l2 < l) {
            l2 = l;
        }
        TickRange tickRange = new TickRange(7, jsMessage.getGuaranteedValueStartTick(), l2);
        this.writeSilenceInternal(tickRange, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
    }

    public void writeSilence(ControlSilence controlSilence) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{controlSilence});
        }
        TickRange tickRange = new TickRange(7, controlSilence.getStartTick(), controlSilence.getEndTick());
        this.writeSilenceInternal(tickRange, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Long(l));
        }
        TickRange tickRange = null;
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            this.oststream.setCursor(l);
            tickRange = this.oststream.getNext();
        }
        this.writeSilenceInternal(tickRange, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSilenceInternal(TickRange tickRange, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceInternal", (Object)new Object[]{tickRange, new Boolean(bl)});
        }
        List list = null;
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            if (!bl || tickRange.valuestamp > this.nextCompletedPrefix) {
                StateStream stateStream = this.oststream;
                synchronized (stateStream) {
                    long l = this.oststream.getCompletedPrefix();
                    if (tickRange.endstamp > l) {
                        if (!bl) {
                            this.oststream.writeRange(tickRange);
                        } else {
                            this.oststream.writeCompletedRangeForced(tickRange);
                        }
                        l = this.oststream.getCompletedPrefix();
                    }
                    if (l + 1L > this.doubtHorizon) {
                        this.doubtHorizon = l + 1L;
                        list = this.advanceDoubtHorizon(null);
                    }
                    if (this.doubtHorizon - 1L > this.unknownHorizon) {
                        this.unknownHorizon = this.doubtHorizon - 1L;
                    }
                    if (tickRange.endstamp > this.unknownHorizon) {
                        if (tickRange.startstamp > this.unknownHorizon + 1L) {
                            this.handleNewGap(this.unknownHorizon + 1L, tickRange.startstamp - 1L);
                        }
                        this.unknownHorizon = tickRange.endstamp;
                    }
                }
                if (list != null) {
                    try {
                        this.deliverer.deliverOrderedMessages(list, this, this.priority, this.reliability);
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.writeSilenceInternal", (String)"1:784:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:791:1.77", sIException});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"writeSilenceInternal", (Object)"GDException");
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:801:1.77", sIException}, null), (Throwable)sIException);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAckExpected(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{new Long(l)});
        }
        ArrayList<TickRange> arrayList = null;
        boolean bl = true;
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            long l2 = this.oststream.getCompletedPrefix();
            this.sendAck();
            if (this.getStreamIsFull()) {
                bl = false;
                if (this.deliverer.isDestinationNotFull()) {
                    this.setStreamIsFull(false);
                    bl = true;
                }
            }
            if (bl) {
                if (l <= l2) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
                    }
                    return;
                }
                arrayList = new ArrayList<TickRange>();
                long l3 = l2 + 1L;
                long l4 = l;
                this.oststream.setCursor(l3);
                TickRange tickRange = null;
                TickRange tickRange2 = this.oststream.getNext();
                do {
                    if (tickRange2.type == 0 || tickRange2.type == 1) {
                        long l5 = tickRange2.startstamp > l3 ? tickRange2.startstamp : l3;
                        long l6 = l4 > tickRange2.endstamp ? tickRange2.endstamp : l4;
                        TickRange tickRange3 = new TickRange(1, l5, l6);
                        if (tickRange2.type == 0) {
                            this.oststream.writeRange(tickRange3);
                        }
                        arrayList.add(tickRange3);
                    }
                    tickRange = tickRange2;
                    tickRange2 = this.oststream.getNext();
                } while (tickRange2.startstamp <= l4 && tickRange2 != tickRange);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"did not process AckExpected message for nacks.");
            }
        }
        for (int i = 0; bl && i < arrayList.size(); ++i) {
            TickRange tickRange = (TickRange)arrayList.get(i);
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("processAckExpected sending Nack from: " + tickRange.startstamp + " to " + tickRange.endstamp));
                }
                this.upControl.sendNackMessage(this.streamSet.getCellule(), this.streamSet.getDestUuid(), this.streamSet.getBusUuid(), tickRange.startstamp, tickRange.endstamp, this.priority, this.reliability, this.streamSet.getStreamID());
                continue;
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.processAckExpected", (String)"1:935:1.77", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:942:1.77", sIResourceException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)((Object)sIResourceException));
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:953:1.77", sIResourceException}, null), (Throwable)sIResourceException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    private void handleNewGap(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNewGap", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        TickRange tickRange = new TickRange(1, l, l2);
        this.oststream.writeRange(tickRange);
        NRTExpiryHandle nRTExpiryHandle = new NRTExpiryHandle(tickRange, this);
        nRTExpiryHandle.timer = this.am.create(GDConfig.GD_GAP_CURIOSITY_THRESHOLD, nRTExpiryHandle);
        GuaranteedTargetStream.addAlarm(this, nRTExpiryHandle);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNewGap");
        }
    }

    private List advanceDoubtHorizon(List arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"advanceDoubtHorizon");
        }
        boolean bl = false;
        this.oststream.setCursor(this.doubtHorizon);
        TickRange tickRange = null;
        ArrayList<MessageItem> arrayList2 = null;
        if (arrayList != null) {
            arrayList2 = arrayList;
        }
        while (true) {
            tickRange = this.oststream.getNext();
            if (tickRange.type == 7) continue;
            if (tickRange.type != 3) break;
            try {
                MessageItem messageItem = (MessageItem)tickRange.value;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<MessageItem>();
                }
                arrayList2.add(messageItem);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.advanceDoubtHorizon", (String)"1:1043:1.77", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"advanceDoubtHorizon", (Object)"GDException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1050:1.77", exception});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream", "1:1058:1.77", exception}, null), (Throwable)exception);
            }
        }
        if (tickRange.startstamp > this.doubtHorizon) {
            this.doubtHorizon = tickRange.startstamp;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"advanceDoubtHorizon", (Object)new Boolean(bl));
        }
        return arrayList2;
    }

    protected void releaseMemory() {
    }

    public StateStream getStateStream() {
        return this.oststream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flush");
        }
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            Iterator iterator = GuaranteedTargetStream.getAlarms(this);
            while (iterator.hasNext()) {
                NRTExpiryHandle nRTExpiryHandle = (NRTExpiryHandle)iterator.next();
                nRTExpiryHandle.timer.cancel();
                iterator.remove();
            }
        }
        if (this.oststream.containsState(new TickRange(0, 0L, Long.MAX_VALUE), (byte)3) || this.oststream.containsState(new TickRange(0, 0L, Long.MAX_VALUE), (byte)2)) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addAlarm(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addAlarm", (Object)new Object[]{object, object2});
        }
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            Set<Object> set = null;
            if (pendingAlarms.containsKey(object)) {
                set = (Set)pendingAlarms.get(object);
            } else {
                set = new HashSet();
                pendingAlarms.put(object, set);
            }
            set.add(object2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeAlarm(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAlarm", (Object)new Object[]{object, object2});
        }
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            if (pendingAlarms.containsKey(object)) {
                ((Set)pendingAlarms.get(object)).remove(object2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Iterator getAlarms(Object object) {
        Hashtable hashtable = pendingAlarms;
        synchronized (hashtable) {
            if (pendingAlarms.containsKey(object)) {
                return ((Set)pendingAlarms.get(object)).iterator();
            }
            return new GTSIterator();
        }
    }

    public void batchPrecommit(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"batchPrecommit", (Object)transaction);
        }
        try {
            this.persistCompletedPrefix(transaction);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.batchPrecommit", (String)"1:1531:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchPrecommit");
        }
    }

    public void batchCommitted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"batchCommitted");
        }
        this.numberOfMessagesReceived += (long)this.messagesInBatch;
        this.messagesInBatch = 0;
        this.updateCompletedPrefix();
        this.sendAck();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchCommitted");
        }
    }

    public void batchRolledBack() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"batchRolledBack");
        }
        this.resetDoubtHorizon();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchRolledBack");
        }
    }

    public long getCompletedPrefix() {
        return this.oststream.getCompletedPrefix();
    }

    public void setNextCompletedPrefix(long l) {
        this.nextCompletedPrefix = l;
    }

    public long getNextCompletedPrefix() {
        return this.nextCompletedPrefix;
    }

    private void sendAck() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAck");
        }
        long l = this.oststream.getCompletedPrefix();
        try {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("sendAck up to: " + l));
            }
            this.upControl.sendAckMessage(this.streamSet.getCellule(), this.streamSet.getDestUuid(), this.streamSet.getBusUuid(), l, this.priority, this.reliability, this.streamSet.getStreamID(), true);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.sendAck", (String)"1:1629:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String streamToString(String string) {
        GuaranteedTargetStream guaranteedTargetStream = this;
        synchronized (guaranteedTargetStream) {
            return this.getStateStream().stateString(string);
        }
    }

    public long getLastKnownTick() {
        return this.unknownHorizon;
    }

    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    protected Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    private void setStreamIsFull(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStreamIsFull", (Object)new Boolean(bl));
        }
        this.isStreamFull = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStreamIsFull");
        }
    }

    private boolean getStreamIsFull() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamIsFull");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamIsFull", (Object)new Boolean(this.isStreamFull));
        }
        return this.isStreamFull;
    }

    public TargetStream.TargetStreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.streamState);
        }
        return this.streamState;
    }

    private boolean streamCanAcceptNewMessage(MessageItem messageItem) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"streamCanAcceptNewMessage", (Object)messageItem);
        }
        boolean bl = false;
        if (this.getStreamIsFull()) {
            long l = messageItem.getMessage().getGuaranteedValueValueTick();
            if (l <= this.valueHorizon) {
                bl = true;
            }
        } else {
            JsMessage jsMessage = messageItem.getMessage();
            if (this.deliverer.isDestinationFull(jsMessage.getRoutingDestination())) {
                this.setStreamIsFull(true);
                long l = messageItem.getMessage().getGuaranteedValueValueTick();
                if (l <= this.valueHorizon) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"streamCanAcceptNewMessage", (Object)new Boolean(bl));
        }
        return bl;
    }

    public TargetStreamControl getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        TargetStreamControl targetStreamControl = new TargetStreamControl(this.remoteEngineUUID, this, this.streamSet.getStreamID(), this.getReliability(), this.getPriority());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)targetStreamControl);
        }
        return targetStreamControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        StateStream stateStream = this.oststream;
        synchronized (stateStream) {
            this.oststream.setCursor(0L);
            TickRange tickRange = this.oststream.getNext();
            while (tickRange.endstamp < Long.MAX_VALUE) {
                if (tickRange.type == 3) {
                    linkedList.add(tickRange.value);
                }
                tickRange = this.oststream.getNext();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        return Collections.unmodifiableList(linkedList);
    }

    public long getNumberOfMessagesReceived() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesReceived");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)new Long(this.numberOfMessagesReceived));
        }
        return this.numberOfMessagesReceived;
    }

    public synchronized long countAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long l = 0L;
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                ++l;
            }
            if (tickRange.type == 2) {
                tickRange.reallocateOnCommit();
            }
            tickRange = this.oststream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)new Long(l));
        }
        return l;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/GuaranteedTargetStream.java, SIB.processor, WAS602.SIB, o0610.11 1.77");
        }
        pendingAlarms = new Hashtable();
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    private static class GTSIterator
    implements Iterator {
        private GTSIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
        }
    }

    class NRTExpiryHandle
    implements AlarmListener {
        RangeObject nackRange;
        int ecount;
        int repeatCount;
        int nrtIteration;
        int numOfTimesNackSent = 0;
        Alarm timer;
        Object parent;

        NRTExpiryHandle(RangeObject rangeObject, Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"NRTExpiryHandle", (Object)new Object[]{rangeObject, object});
            }
            this.nackRange = rangeObject;
            this.ecount = 0;
            this.repeatCount = 1;
            this.nrtIteration = 0;
            this.parent = object;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"NRTExpiryHandle", (Object)this);
            }
        }

        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            GuaranteedTargetStream.removeAlarm(this.parent, this);
            boolean bl = false;
            long l = 0L;
            ++this.ecount;
            ++this.nrtIteration;
            if (this.nrtIteration == this.repeatCount) {
                l = this.checkCuriosityAndNack();
                if (l > 0L) {
                    bl = true;
                }
                ++this.numOfTimesNackSent;
                this.nrtIteration = 0;
                this.repeatCount = 2 * this.repeatCount;
                if (bl && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("repeatCount=" + this.repeatCount));
                }
            } else {
                bl = this.checkCuriosity();
            }
            if (bl) {
                this.timer = GuaranteedTargetStream.this.am.create(GDConfig.GD_NACK_REPETITION_THRESHOLD, this);
                GuaranteedTargetStream.addAlarm(this.parent, this);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)(" Gap filled from " + this.nackRange.startstamp + "," + this.nackRange.endstamp + "doubtHorizon=" + GuaranteedTargetStream.this.getDoubtHorizon()));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long checkCuriosityAndNack() {
            TickRange tickRange;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkCuriosityAndNack");
            }
            boolean bl = false;
            long l = 0L;
            ArrayList<Object> arrayList = null;
            GuaranteedTargetStream guaranteedTargetStream = GuaranteedTargetStream.this;
            synchronized (guaranteedTargetStream) {
                GuaranteedTargetStream.this.oststream.setCursor(this.nackRange.startstamp);
                TickRange tickRange2 = GuaranteedTargetStream.this.oststream.getNext();
                do {
                    if (tickRange2.type == 1) {
                        if (!bl) {
                            bl = true;
                            if (tickRange2.startstamp > this.nackRange.startstamp) {
                                this.nackRange.startstamp = tickRange2.startstamp;
                            }
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>();
                        }
                        arrayList.add(tickRange2.clone());
                    }
                    tickRange = tickRange2;
                    tickRange2 = GuaranteedTargetStream.this.oststream.getNext();
                } while (tickRange2.startstamp <= this.nackRange.endstamp && tickRange2 != tickRange);
            }
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    tickRange = (TickRange)arrayList.get(i);
                    long l2 = tickRange.startstamp;
                    long l3 = tickRange.endstamp;
                    if (l2 < this.nackRange.startstamp) {
                        l2 = this.nackRange.startstamp;
                    }
                    if (l3 > this.nackRange.endstamp) {
                        l3 = this.nackRange.endstamp;
                    }
                    if (l2 > l3) continue;
                    l += l3 - l2;
                    try {
                        GuaranteedTargetStream.this.upControl.sendNackMessage(GuaranteedTargetStream.this.streamSet.getCellule(), GuaranteedTargetStream.this.streamSet.getDestUuid(), GuaranteedTargetStream.this.streamSet.getBusUuid(), l2, l3, GuaranteedTargetStream.this.priority, GuaranteedTargetStream.this.reliability, GuaranteedTargetStream.this.streamSet.getStreamID());
                        continue;
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.GuaranteedTargetStream.NRTExpiryHandle.checkCuriosityAndNack", (String)"1:1298:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.NRTExpiryHandle", "1:1305:1.77", sIException});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"checkCuriosityAndNack", (Object)((Object)sIException));
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.NRTExpiryHandle", "1:1316:1.77", sIException}, null), (Throwable)sIException);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkCuriosityAndNack", (Object)new Long(l));
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkCuriosity() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkCuriosity");
            }
            boolean bl = false;
            GuaranteedTargetStream guaranteedTargetStream = GuaranteedTargetStream.this;
            synchronized (guaranteedTargetStream) {
                TickRange tickRange;
                GuaranteedTargetStream.this.oststream.setCursor(this.nackRange.startstamp);
                TickRange tickRange2 = GuaranteedTargetStream.this.oststream.getNext();
                do {
                    if (tickRange2.type == 1 && !bl) {
                        bl = true;
                        if (tickRange2.startstamp <= this.nackRange.startstamp) break;
                        this.nackRange.startstamp = tickRange2.startstamp;
                        break;
                    }
                    tickRange = tickRange2;
                    tickRange2 = GuaranteedTargetStream.this.oststream.getNext();
                } while (tickRange2.startstamp <= this.nackRange.endstamp && tickRange2 != tickRange);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkCuriosity", (Object)new Boolean(bl));
            }
            return bl;
        }
    }

    public static class GuaranteedTargetStreamState
    extends TargetStream.TargetStreamState {
        public static final GuaranteedTargetStreamState ACTIVE = new GuaranteedTargetStreamState("Active", 1);

        private GuaranteedTargetStreamState(String string, int n) {
            super(string, n);
        }
    }
}

