/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.gd.RangeList;
import com.ibm.ws.sib.processor.gd.RangeObject;
import com.ibm.ws.sib.processor.utils.BlockVector;
import com.ibm.ws.sib.utils.ras.SibTr;

public class ARangeList
implements RangeList {
    private static TraceComponent tc = SibTr.register((Class)ARangeList.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private BlockVector blockVector;
    private int cursor;
    private static final TraceNLS nls;

    public void init(RangeObject rangeObject) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init", (Object)rangeObject);
        }
        this.blockVector = new BlockVector();
        rangeObject.startstamp = 0L;
        rangeObject.endstamp = Long.MAX_VALUE;
        this.blockVector.add(rangeObject);
        this.cursor = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void setCursor(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCursor", (Object)new Long(l));
        }
        this.cursor = l == 0L ? 0 : this.getIndex(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCursor", (Object)new Object[]{new Long(this.cursor), new Integer(this.blockVector.size())});
        }
    }

    public Object getMark(Object object) {
        Marker marker;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMark", (Object)object);
        }
        if ((marker = (Marker)object) == null) {
            marker = new Marker(this.cursor);
        } else {
            marker.position = this.cursor;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMark", (Object)marker);
        }
        return marker;
    }

    public void setCursor(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCursor", (Object)object);
        }
        this.cursor = ((Marker)object).position;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCursor", (Object)new Object[]{new Integer(this.cursor), new Integer(this.blockVector.size())});
        }
    }

    public RangeObject getNext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNext");
        }
        int n = this.cursor;
        int n2 = this.cursor = this.cursor < this.blockVector.size() - 1 ? this.cursor + 1 : this.cursor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNext", this.blockVector.get(n));
        }
        return (RangeObject)this.blockVector.get(n);
    }

    public RangeObject getPrev() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPrev");
        }
        int n = this.cursor;
        int n2 = this.cursor = this.cursor > 0 ? this.cursor - 1 : this.cursor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPrev", this.blockVector.get(n));
        }
        return (RangeObject)this.blockVector.get(n);
    }

    public RangeObject getCurr() {
        return (RangeObject)this.blockVector.get(this.cursor);
    }

    public void get(RangeObject rangeObject, BlockVector blockVector) {
        this.get(rangeObject.startstamp, rangeObject.endstamp, blockVector);
    }

    public void get(long l, long l2, BlockVector blockVector) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{new Long(l), new Long(l2), blockVector});
        }
        int n = this.getIndex(l);
        int n2 = this.blockVector.size();
        for (int i = n; i < n2; ++i) {
            RangeObject rangeObject = (RangeObject)this.blockVector.get(i);
            if (rangeObject.startstamp > l2) break;
            blockVector.add(rangeObject);
        }
        this.cursor = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get");
        }
    }

    public void replace(BlockVector blockVector) {
        int n;
        int n2;
        RangeObject rangeObject;
        RangeObject rangeObject2;
        int n3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"replace", (Object)blockVector);
        }
        boolean bl = false;
        int n4 = blockVector.size();
        long l = ((RangeObject)blockVector.get((int)0)).startstamp;
        long l2 = ((RangeObject)blockVector.get((int)(n4 - 1))).endstamp;
        int n5 = n3 = this.linearSearch(l, 0, this.blockVector.size() - 1);
        while (true) {
            rangeObject2 = (RangeObject)this.blockVector.get(n5);
            if (l2 <= rangeObject2.endstamp && l2 >= rangeObject2.startstamp) break;
            ++n5;
        }
        if (n3 == n5) {
            if (l > rangeObject2.startstamp && l2 < rangeObject2.endstamp) {
                rangeObject = (RangeObject)rangeObject2.clone();
                rangeObject.startstamp = l2 + 1L;
                blockVector.add(rangeObject);
                bl = true;
                rangeObject2.endstamp = l - 1L;
                n2 = n3 + 1;
                n = ++n4;
            } else if (l > rangeObject2.startstamp) {
                rangeObject2.endstamp = l - 1L;
                n2 = n3 + 1;
                n = n4;
            } else if (l2 < rangeObject2.endstamp) {
                rangeObject2.startstamp = l2 + 1L;
                n2 = n3;
                n = n4;
            } else {
                n2 = n3;
                n = n4 - 1;
            }
        } else {
            n = n4 - (n5 - n3 + 1);
            n2 = n3;
            rangeObject = (RangeObject)this.blockVector.get(n3);
            if (l > rangeObject.startstamp) {
                rangeObject.endstamp = l - 1L;
                ++n2;
                ++n;
            }
            if (l2 < rangeObject2.endstamp) {
                rangeObject2.startstamp = l2 + 1L;
                ++n;
            }
        }
        if (n > 0) {
            this.blockVector.insertNullElementsAt(n2, n);
        } else if (n < 0) {
            n = -n;
            this.blockVector.removeElementsAt(n2, n);
        }
        for (int i = 0; i < blockVector.size(); ++i) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Setting " + blockVector.get(i) + " at index " + (i + n2)));
            }
            this.blockVector.set(i + n2, blockVector.get(i));
            if (this.blockVector.get(i + n2) != null) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"replace", (Object)("SIErrorException: null range at index " + (i + n2)));
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ARangeList", "1:338:1.23", "Null range at index " + (i + n2)}, null));
        }
        if (bl) {
            blockVector.remove(blockVector.size() - 1);
        }
        this.cursor = n2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replace");
        }
    }

    public void replacePrefix(RangeObject rangeObject) {
        RangeObject rangeObject2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"replacePrefix", (Object)rangeObject);
        }
        long l = rangeObject.endstamp;
        int n = 0;
        while (true) {
            rangeObject2 = (RangeObject)this.blockVector.get(n);
            if (l <= rangeObject2.endstamp && l >= rangeObject2.startstamp) break;
            ++n;
        }
        if (l < rangeObject2.endstamp) {
            rangeObject2.startstamp = l + 1L;
            if (n == 0) {
                this.blockVector.insertNullElementsAt(0, 1);
            } else if (n - 1 > 0) {
                this.blockVector.removeElementsAt(0, n - 1);
            }
        } else if (n > 0) {
            this.blockVector.removeElementsAt(0, n);
        }
        this.blockVector.set(0, rangeObject);
        this.cursor = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"replacePrefix");
        }
    }

    public void splitStart(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"splitStart", (Object)new Long(l));
        }
        RangeObject rangeObject = (RangeObject)this.blockVector.get(this.cursor);
        if (rangeObject.startstamp == l) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitStart");
            }
            return;
        }
        if (l > rangeObject.endstamp) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitStart", (Object)new Object[]{"A", new Long(l), new Long(rangeObject.endstamp)});
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:436:1.23"}, null));
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:445:1.23"});
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitStart", (String)"1:451:1.23", (Object)this);
            throw sIErrorException;
        }
        if (l < rangeObject.startstamp) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitStart", (Object)new Object[]{"B", new Long(l), new Long(rangeObject.startstamp)});
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:470:1.23"}, null));
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:478:1.23"});
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitStart", (String)"1:484:1.23", (Object)this);
            throw sIErrorException;
        }
        RangeObject rangeObject2 = (RangeObject)rangeObject.clone();
        rangeObject2.endstamp = l - 1L;
        rangeObject.startstamp = l;
        this.blockVector.insertNullElementsAt(this.cursor, 1);
        this.blockVector.set(this.cursor, rangeObject2);
        ++this.cursor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"splitStart");
        }
    }

    public void splitEnd(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"splitEnd", (Object)new Long(l));
        }
        RangeObject rangeObject = (RangeObject)this.blockVector.get(this.cursor);
        if (l == rangeObject.endstamp) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitEnd");
            }
            return;
        }
        if (l > rangeObject.endstamp) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitEnd", (Object)new Object[]{"A", new Long(l), new Long(rangeObject.endstamp)});
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:535:1.23"}, null));
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:543:1.23"});
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitEnd", (String)"1:549:1.23", (Object)this);
            throw sIErrorException;
        }
        if (l < rangeObject.startstamp) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"splitEnd", (Object)new Object[]{"B", new Long(l), new Long(rangeObject.startstamp)});
            }
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:568:1.23"}, null));
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.ARangeList", "1:577:1.23"});
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.ARangeList.splitEnd", (String)"1:583:1.23", (Object)this);
            throw sIErrorException;
        }
        RangeObject rangeObject2 = (RangeObject)rangeObject.clone();
        rangeObject2.endstamp = l;
        rangeObject.startstamp = l + 1L;
        this.blockVector.insertNullElementsAt(this.cursor, 1);
        this.blockVector.set(this.cursor, rangeObject2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"splitEnd");
        }
    }

    protected final int getIndex(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIndex");
        }
        int n = 0;
        int n2 = this.blockVector.size();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getIndex", (Object)new Long(l));
        }
        return this.linearSearch(l, n, n2 - 1);
    }

    protected final int linearSearch(long l, int n, int n2) {
        int n3;
        RangeObject rangeObject;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"linearSearch", (Object)new Object[]{new Long(l), new Integer(n), new Integer(n2), new Integer(this.cursor)});
        }
        if ((rangeObject = (RangeObject)this.blockVector.get(n3 = this.cursor)) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"linearSearch", (Object)("SIErrorException: Null range under cursor at index " + n3));
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ARangeList", "1:638:1.23", "Null range at index " + n3}, null));
        }
        if (l >= rangeObject.startstamp && l <= rangeObject.endstamp) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"linearSearch - index matched", (Object)new Integer(n3));
            }
            return n3;
        }
        if (l > rangeObject.endstamp) {
            n = n3 + 1;
        } else if (l < rangeObject.startstamp) {
            n2 = n3 - 1;
        }
        for (n3 = n2; n3 >= n; --n3) {
            rangeObject = (RangeObject)this.blockVector.get(n3);
            if (rangeObject == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"linearSearch", (Object)("SIErrorException: Null range at index " + n3));
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ARangeList", "1:671:1.23", "Null range at index " + n3}, null));
            }
            if (l >= rangeObject.startstamp && l <= rangeObject.endstamp) break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"linearSearch", (Object)new Integer(n3));
        }
        return n3;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/ARangeList.java, SIB.processor, WAS602.SIB, o0610.11 1.23");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    class Marker {
        int position;

        public Marker(int n) {
            this.position = n;
        }
    }
}

