/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.AIRequestedTick;
import com.ibm.ws.sib.processor.gd.AIValueTick;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.items.AICompletedPrefixItem;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.RemoteQueuePoint;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryReceiverControllable;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.AbstractBatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AIStream
extends ControllableStream {
    private static final TraceComponent tc = SibTr.register((Class)AIStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private static final int INDEX_KFACTOR = 2;
    private static final int INDEX_NODE_WIDTH = 12;
    private static final int NUM_OF_BUCKETS = 4;
    private final SIBUuid12 _streamId;
    private AIProtocolItemStream _itemStream;
    private GBSTree _itemStreamIndex;
    private AnycastInputHandler _parent;
    private AsyncUpdateThread _msUpdateThread;
    private StateStream _targetStream;
    private AICompletedPrefixItem _completedPrefix;
    private boolean _completedPrefixNeedsToBeScheduled;
    private int _countOfOutstandingCPUpdates;
    private long _latestTick;
    private long _latestDMEVersion;
    private BatchedTimeoutManager _eagerGetTOM;
    private TraversableBatchedTimeoutManager _slowedGetTOM;
    private BatchedTimeoutManager _initialAcceptedTOM;
    private BatchedTimeoutManager _acceptedTOM;
    private BatchedTimeoutManager _rejectedTOM;
    private boolean _stopped = false;
    private MessageProcessor _mp;
    private AIStreamState _streamState = AIStreamState.ACTIVE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIStream(SIBUuid12 sIBUuid12, AIProtocolItemStream aIProtocolItemStream, AnycastInputHandler anycastInputHandler, AsyncUpdateThread asyncUpdateThread, long l, AICompletedPrefixItem aICompletedPrefixItem, boolean bl, MessageProcessor messageProcessor) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIStream", (Object)new Object[]{sIBUuid12, aIProtocolItemStream, anycastInputHandler, asyncUpdateThread, new Long(l), aICompletedPrefixItem, new Boolean(bl), messageProcessor});
        }
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._itemStream = aIProtocolItemStream;
            ProtocolItemComparator protocolItemComparator = new ProtocolItemComparator();
            this._itemStreamIndex = new GBSTree(2, 12, protocolItemComparator, protocolItemComparator);
            this._parent = anycastInputHandler;
            this._msUpdateThread = asyncUpdateThread;
            this._targetStream = new StateStream();
            this._targetStream.init();
            this._latestTick = l;
            this._latestDMEVersion = -1L;
            this._mp = messageProcessor;
            CreateTOMs createTOMs = null;
            if (bl) {
                this._streamId = aIProtocolItemStream.getStreamId();
                try {
                    createTOMs = this.recoverFromPersistentState(aIProtocolItemStream);
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.AIStream.AIStream", (String)"1:244:1.97", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"AIStream", (Object)((Object)messageStoreException));
                    }
                    throw messageStoreException;
                }
            } else {
                this._streamId = sIBUuid12;
                this._completedPrefix = aICompletedPrefixItem;
                long l2 = aICompletedPrefixItem.getTick();
                this._targetStream.setCompletedPrefix(l2);
                ArrayList<AIRejectedRange> arrayList = null;
                if (l2 < l) {
                    arrayList = new ArrayList<AIRejectedRange>();
                    AIRejectedRange aIRejectedRange = this.writeRejectedNoTimeout(l2 + 1L, l, false);
                    arrayList.add(aIRejectedRange);
                }
                createTOMs = new CreateTOMs(null, arrayList);
            }
            this._completedPrefixNeedsToBeScheduled = true;
            this._countOfOutstandingCPUpdates = 0;
            createTOMs.create();
            if (!anycastInputHandler.getBaseDestinationHandler().isPubSub()) {
                RemoteQueuePoint remoteQueuePoint = anycastInputHandler.getBaseDestinationHandler().getRemoteQueuePointControl(anycastInputHandler.getLocalisationME().getUuid(), true);
                remoteQueuePoint.registerControlAdapterAsMBean();
            }
            this.start();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIStream", (Object)this);
        }
    }

    public AIStreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this._streamState);
        }
        return this._streamState;
    }

    public SIBUuid12 getStreamId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamId");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamId", (Object)this._streamId);
        }
        return this._streamId;
    }

    public long insertRequest(long l, SelectionCriteria[] selectionCriteriaArray, long l2, RemoteDispatchableKey remoteDispatchableKey, long l3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insertRequest", (Object)new Object[]{new Long(l), selectionCriteriaArray, new Long(l2), remoteDispatchableKey, new Long(l3)});
        }
        long l4 = this._latestTick + 1L;
        AIRequestedTick aIRequestedTick = null;
        if (l4 < l) {
            this.writeRejected(l4, l - 1L, false);
        } else {
            l4 = l;
        }
        TickRange tickRange = new TickRange(1, l, l);
        aIRequestedTick = new AIRequestedTick(l, selectionCriteriaArray, remoteDispatchableKey, l2, false, l3);
        tickRange.value = aIRequestedTick;
        tickRange.valuestamp = l;
        this._targetStream.writeRange(tickRange);
        if (l2 > 0L || l2 == SIMPConstants.INFINITE_TIMEOUT) {
            this._eagerGetTOM.addTimeoutEntry(aIRequestedTick);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insertRequest", (Object)new Long(l4));
        }
        return l4;
    }

    public long countAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long l = 0L;
        this._targetStream.setCursor(0L);
        TickRange tickRange = this._targetStream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                ++l;
            }
            tickRange = this._targetStream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)new Long(l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDeliverAssuredInOrder(long l, long l2, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"canDeliverAssuredInOrder", (Object)new Object[]{new Long(l), new Long(l2), new Integer(n)});
        }
        boolean bl = false;
        AIStream aIStream = this;
        synchronized (aIStream) {
            if (l2 == SIMPConstants.UNKNOWN_PREV_TICK) {
                bl = true;
                long l3 = this._targetStream.getCompletedPrefix() + 1L;
                long l4 = l - 1L;
                this._targetStream.setCursor(l3);
                TickRange tickRange = null;
                TickRange tickRange2 = this._targetStream.getNext();
                do {
                    if (tickRange2.type == 0 || tickRange2.type == 1) {
                        bl = false;
                        break;
                    }
                    if (tickRange2.type == 3) {
                        boolean bl2;
                        AIValueTick aIValueTick = (AIValueTick)tickRange2.value;
                        boolean bl3 = aIValueTick.isDelivered();
                        Reliability reliability = aIValueTick.getMsgReliability();
                        boolean bl4 = reliability.compareTo((Object)Reliability.RELIABLE_PERSISTENT) >= 0;
                        boolean bl5 = bl2 = aIValueTick.getMsgPriority() == n;
                        if (bl4 && bl2 && !bl3) {
                            bl = false;
                            break;
                        }
                    }
                    tickRange = tickRange2;
                    tickRange2 = this._targetStream.getNext();
                } while (tickRange2.startstamp <= l4 && tickRange2 != tickRange);
            } else {
                this._targetStream.setCursor(l2);
                TickRange tickRange = this._targetStream.getNext();
                bl = tickRange.type == 7 || tickRange.type == 5 ? true : (tickRange.type == 3 ? ((AIValueTick)tickRange.value).isDelivered() : false);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"canDeliverAssuredInOrder", (Object)new Boolean(bl));
        }
        return bl;
    }

    public AIRequestedTick updateRequestToValue(long l, AIMessageItem aIMessageItem, boolean bl, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateRequestToValue", (Object)new Object[]{new Long(l), aIMessageItem, new Boolean(bl)});
        }
        AIRequestedTick aIRequestedTick = null;
        this._targetStream.setCursor(l);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type == 1) {
            aIRequestedTick = (AIRequestedTick)tickRange.value;
            RemoteDispatchableKey remoteDispatchableKey = aIRequestedTick.getRemoteDispatchableKey();
            AIValueTick aIValueTick = new AIValueTick(l, aIMessageItem, bl, remoteDispatchableKey, aIRequestedTick.getOriginalTimeout(), aIRequestedTick.getIssueTime(), aIMessageItem.getMessage().getRedeliveredCount());
            TickRange tickRange2 = new TickRange(3, l, l);
            tickRange2.value = aIValueTick;
            tickRange2.valuestamp = l;
            this._targetStream.writeRange(tickRange2);
            if (aIRequestedTick.getTimeout() > 0L || aIRequestedTick.getTimeout() == SIMPConstants.INFINITE_TIMEOUT) {
                if (aIRequestedTick.isSlowed()) {
                    this._slowedGetTOM.removeTimeoutEntry(aIRequestedTick);
                } else {
                    this._eagerGetTOM.removeTimeoutEntry(aIRequestedTick);
                }
            }
        } else if (tickRange.type == 5) {
            long[] lArray = new long[]{l};
            sendDispatcher.sendAccept(lArray);
        } else if (tickRange.type == 6) {
            long[] lArray = new long[]{l};
            boolean bl2 = ((AIRejectedRange)tickRange.value).recovery;
            sendDispatcher.sendReject(lArray, lArray, bl2);
        } else if (tickRange.type == 7) {
            long[] lArray = new long[]{l};
            sendDispatcher.sendCompleted(lArray, lArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRequestToValue", (Object)aIRequestedTick);
        }
        return aIRequestedTick;
    }

    public final int getRedeliveredCount(long l) {
        AIValueTick aIValueTick;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRedeliveredCount", (Object)new Long(l));
        }
        this._targetStream.setCursor(l);
        TickRange tickRange = this._targetStream.getNext();
        int n = tickRange.type == 3 ? ((aIValueTick = (AIValueTick)tickRange.value) != null ? aIValueTick.getRedeliveredCount() : -1) : -1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRedeliveredCount", (Object)new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public List findUndeliveredList(long l, JsMessage jsMessage) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findUndeliveredList", (Object)new Object[]{new Long(l), jsMessage});
        }
        int n2 = jsMessage.getPriority();
        this._targetStream.setCursor(this._latestTick);
        TickRange tickRange = null;
        TickRange tickRange2 = this._targetStream.getNext();
        ArrayList<Object> arrayList = null;
        boolean bl = true;
        do {
            if (tickRange2.type == 3) {
                object = (AIValueTick)tickRange2.value;
                boolean n = ((AIValueTick)object).isDelivered();
                int n3 = ((AIValueTick)object).getMsgPriority();
                if (!n && n3 == n2) {
                    long l2 = ((AIValueTick)object).getMsg().getMessage().getGuaranteedRemoteGetPrevTick();
                    if (bl) {
                        arrayList = new ArrayList<Object>(10);
                        bl = false;
                    }
                    arrayList.add(object);
                    this._targetStream.setCursor(l2);
                    tickRange = tickRange2;
                    tickRange2 = this._targetStream.getNext();
                    continue;
                }
            }
            bl = true;
            tickRange = tickRange2;
            tickRange2 = this._targetStream.getPrev();
        } while (tickRange2.endstamp > l && tickRange2 != tickRange);
        object = null;
        if (arrayList != null) {
            void var10_11;
            object = new ArrayList(arrayList.size());
            int n = arrayList.size() - 1;
            while (var10_11 >= 0) {
                ((ArrayList)object).add(arrayList.get((int)var10_11));
                --var10_11;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findUndeliveredList", (Object)object);
        }
        return object;
    }

    public void markListDelivered(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markListDelivered", (Object)list);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AIValueTick aIValueTick = (AIValueTick)list.get(i);
            aIValueTick.setDelivered(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markListDelivered");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIProtocolItem processAccepted(long l, Transaction transaction) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAccepted", (Object)new Object[]{new Long(l), transaction});
        }
        AIProtocolItem aIProtocolItem = null;
        boolean bl = false;
        Reliability reliability = null;
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._targetStream.setCursor(l);
            object = this._targetStream.getNext();
            if (object.type != 3) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:769:1.97"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:776:1.97", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:785:1.97"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAccepted", null);
                }
                throw sIErrorException;
            }
            AIValueTick aIValueTick = (AIValueTick)object.value;
            reliability = aIValueTick.getMsgReliability();
            boolean bl2 = bl = reliability.compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0;
            if (transaction == null) {
                if (bl) {
                    this.updateToAccepted(l, null);
                } else {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:812:1.97"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:819:1.97", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:827:1.97"});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processAccepted", null);
                    }
                    throw sIErrorException;
                }
            }
        }
        if (!bl && transaction != null) {
            aIProtocolItem = new AIProtocolItem(l, 5, reliability, this._parent);
            try {
                this._itemStream.addItem(aIProtocolItem, transaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.gd.AIStream.processAccepted", (String)"1:857:1.97", (Object)this);
                aIProtocolItem = null;
                object = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:869:1.97", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                SibTr.exception((TraceComponent)tc, (Exception)object);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:878:1.97", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAccepted", (Object)aIProtocolItem);
                }
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAccepted", aIProtocolItem);
        }
        return aIProtocolItem;
    }

    public void updateToAccepted(long l, AIProtocolItem aIProtocolItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateToAccepted", (Object)new Object[]{new Long(l), aIProtocolItem});
        }
        this._targetStream.setCursor(l);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type == 1 || tickRange.type == 3) {
            long l2;
            if (aIProtocolItem != null) {
                l2 = aIProtocolItem.getID();
                this._itemStreamIndex.insert(aIProtocolItem);
            } else {
                l2 = -1L;
            }
            this.writeAccepted(l, l2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateToAccepted");
        }
    }

    public void updateToRejected(long l, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateToRejected", (Object)new Long(l));
        }
        this._targetStream.setCursor(l);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type != 1 && tickRange.type != 3) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:967:1.97"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.AIStream.updateToRejected", (String)"1:974:1.97", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:983:1.97"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"updateToRejected", null);
            }
            throw sIErrorException;
        }
        boolean bl = false;
        this.writeRejected(l, l, bl);
        long[] lArray = new long[]{l};
        sendDispatcher.sendReject(lArray, lArray, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateToRejected");
        }
    }

    public void updateAllToRejected(AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateAllToRejected");
        }
        boolean bl = false;
        long l = this._targetStream.getCompletedPrefix() + 1L;
        long l2 = this._latestTick;
        boolean bl2 = false;
        this._targetStream.setCursor(l);
        TickRange tickRange = null;
        TickRange tickRange2 = this._targetStream.getNext();
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(10);
        do {
            if (tickRange2.type == 1 || tickRange2.type == 3) {
                long l3 = tickRange2.startstamp;
                long l4 = tickRange2.endstamp;
                TickRange tickRange3 = new TickRange(6, l3, l4);
                AIRejectedRange aIRejectedRange = new AIRejectedRange(l3, l4, bl);
                tickRange3.value = aIRejectedRange;
                arrayList.add(new Long(l3));
                arrayList2.add(new Long(l4));
                this._targetStream.writeRange(tickRange3);
                this._rejectedTOM.addTimeoutEntry(aIRejectedRange);
                bl2 = true;
            }
            tickRange = tickRange2;
            tickRange2 = this._targetStream.getNext();
        } while (tickRange2.startstamp <= l2 && tickRange2 != tickRange);
        if (bl2) {
            int n = arrayList.size();
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = (Long)arrayList.get(i);
                lArray2[i] = (Long)arrayList2.get(i);
            }
            sendDispatcher.sendReject(lArray, lArray2, bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateAllToRejected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateToCompleted(long l, long l2) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateToCompleted", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        boolean bl = false;
        this._targetStream.setCursor(l);
        TickRange tickRange = this._targetStream.getNext();
        TickRange tickRange2 = null;
        do {
            AIStreamKey aIStreamKey;
            int n;
            boolean bl2;
            boolean bl3;
            block23: {
                Object object;
                bl3 = true;
                bl2 = false;
                n = 0;
                aIStreamKey = null;
                if (tickRange.type == 5) {
                    object = (AIAcceptedTick)tickRange.value;
                    this._acceptedTOM.removeTimeoutEntry((BatchedTimeoutEntry)object);
                } else if (tickRange.type == 6) {
                    object = (AIRejectedRange)tickRange.value;
                    this._rejectedTOM.removeTimeoutEntry((BatchedTimeoutEntry)object);
                } else if (tickRange.type == 1) {
                    n = 1;
                    object = (AIRequestedTick)tickRange.value;
                    aIStreamKey = new AIStreamKey(tickRange.startstamp, ((AIRequestedTick)object).getRemoteDispatchableKey(), ((AIRequestedTick)object).getOriginalTimeout(), ((AIRequestedTick)object).getIssueTime());
                    bl2 = true;
                    if (((AIRequestedTick)object).getTimeout() > 0L) {
                        if (((AIRequestedTick)object).isSlowed()) {
                            this._slowedGetTOM.removeTimeoutEntry((BatchedTimeoutEntry)object);
                        } else {
                            this._eagerGetTOM.removeTimeoutEntry((BatchedTimeoutEntry)object);
                        }
                    }
                } else {
                    if (tickRange.type == 3) {
                        object = (AIValueTick)tickRange.value;
                        if (!((AIValueTick)object).isDelivered()) {
                            n = 1;
                            aIStreamKey = new AIStreamKey(tickRange.startstamp, ((AIValueTick)object).getRemoteDispatchableKey(), ((AIValueTick)object).getOriginalTimeout(), ((AIValueTick)object).getIssueTime());
                            bl2 = true;
                            break block23;
                        } else {
                            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1148:1.97"}, null));
                            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.AIStream.updateToCompleted", (String)"1:1155:1.97", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1164:1.97"});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"updateToCompleted", null);
                            }
                            throw sIErrorException;
                        }
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                this.writeCompletedRange(tickRange.startstamp, tickRange.endstamp);
                bl = true;
            }
            if (bl2) {
                this._parent.resolve(n, aIStreamKey);
            }
            tickRange2 = tickRange;
            tickRange = this._targetStream.getNext();
        } while (tickRange.startstamp <= l2 && tickRange != tickRange2);
        if (bl) {
            AICompletedPrefixItem aICompletedPrefixItem = this._completedPrefix;
            synchronized (aICompletedPrefixItem) {
                if (this._targetStream.getCompletedPrefix() > this._completedPrefix.getTick()) {
                    this._completedPrefix.setTick(this._targetStream.getCompletedPrefix());
                    if (this._completedPrefixNeedsToBeScheduled) {
                        this.doEnqueueWork(new CompletedPrefixAsyncUpdate());
                        this._completedPrefixNeedsToBeScheduled = false;
                        ++this._countOfOutstandingCPUpdates;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateToCompleted");
        }
    }

    public void updateAllToCompleted() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateAllToCompleted");
        }
        long l = this._targetStream.getCompletedPrefix() + 1L;
        long l2 = this._latestTick;
        this.updateToCompleted(l, l2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateAllToCompleted");
        }
    }

    public void processDecisionExpected(long l, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDecisionExpected", (Object)new Long(l));
        }
        this._targetStream.setCursor(l);
        TickRange tickRange = this._targetStream.getNext();
        if (tickRange.type != 0) {
            if (tickRange.type == 1) {
                AIRequestedTick aIRequestedTick = (AIRequestedTick)tickRange.value;
                long[] lArray = new long[]{aIRequestedTick.getTick()};
                long[] lArray2 = new long[]{aIRequestedTick.getTick()};
                long[] lArray3 = new long[]{aIRequestedTick.getTimeout()};
                sendDispatcher.sendRequest(lArray, lArray2, aIRequestedTick.getCriterias(), lArray3);
            } else if (tickRange.type != 3) {
                if (tickRange.type == 5) {
                    long[] lArray = new long[]{l};
                    sendDispatcher.sendAccept(lArray);
                } else if (tickRange.type == 6) {
                    AIRejectedRange aIRejectedRange = (AIRejectedRange)tickRange.value;
                    long[] lArray = new long[]{aIRejectedRange.startTick};
                    long[] lArray4 = new long[]{aIRejectedRange.endTick};
                    boolean bl = aIRejectedRange.recovery;
                    sendDispatcher.sendReject(lArray, lArray4, bl);
                } else if (tickRange.type == 7) {
                    long[] lArray = new long[]{tickRange.startstamp};
                    long[] lArray5 = new long[]{tickRange.endstamp};
                    sendDispatcher.sendCompleted(lArray, lArray5);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDecisionExpected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestAck(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestAck", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        if (l2 >= this._latestDMEVersion) {
            this._targetStream.setCursor(l);
            TickRange tickRange = this._targetStream.getNext();
            if (tickRange.type == 1) {
                AIRequestedTick aIRequestedTick;
                AIRequestedTick aIRequestedTick2 = aIRequestedTick = (AIRequestedTick)tickRange.value;
                synchronized (aIRequestedTick2) {
                    if (!aIRequestedTick.isSlowed()) {
                        this._eagerGetTOM.removeTimeoutEntry(aIRequestedTick);
                        aIRequestedTick.setSlowed(true);
                        aIRequestedTick.setAckingDMEVersion(l2);
                        long l3 = aIRequestedTick.getTimeout();
                        if (l3 > 0L || l3 == SIMPConstants.INFINITE_TIMEOUT) {
                            this._slowedGetTOM.addTimeoutEntry(aIRequestedTick);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestAck");
        }
    }

    public void processResetRequestAck(long l, AnycastInputHandler.SendDispatcher sendDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processResetRequestAck", (Object)new Long(l));
        }
        if (l >= this._latestDMEVersion) {
            if (l > this._latestDMEVersion) {
                this._latestDMEVersion = l;
            }
            this._slowedGetTOM.applyToEachEntry(new AddToEagerTOM(this._slowedGetTOM, l));
            sendDispatcher.sendResetRequestAckAck(l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processResetRequestAck");
        }
    }

    public synchronized long getLatestTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLatestTick");
            SibTr.exit((TraceComponent)tc, (String)"getLatestTick", (Object)new Long(this._latestTick));
        }
        return this._latestTick;
    }

    public AnycastInputHandler getAnycastInputHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)this._parent);
        }
        return this._parent;
    }

    public synchronized void setLatestTick(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLatestTick", (Object)new Long(l));
        }
        this._latestTick = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLatestTick");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletedPrefix(Transaction transaction, long l) throws MessageStoreException, InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeCompletedPrefix", (Object)new Object[]{transaction, new Long(l), new Integer(this._countOfOutstandingCPUpdates)});
        }
        boolean bl = false;
        AICompletedPrefixItem aICompletedPrefixItem = this._completedPrefix;
        synchronized (aICompletedPrefixItem) {
            if (this._countOfOutstandingCPUpdates > 0) {
                this._completedPrefix.wait();
            }
            this._completedPrefix.lockItemIfAvailable(l);
            this._completedPrefix.remove(transaction, l);
            this._completedPrefix = null;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeCompletedPrefix", (Object)new Boolean(bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._stopped = false;
        }
        this._eagerGetTOM.startTimer();
        this._slowedGetTOM.startTimer();
        this._initialAcceptedTOM.startTimer();
        this._acceptedTOM.startTimer();
        this._rejectedTOM.startTimer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        AIStream aIStream = this;
        synchronized (aIStream) {
            this._stopped = true;
        }
        this._eagerGetTOM.stopTimer();
        this._slowedGetTOM.stopTimer();
        this._initialAcceptedTOM.stopTimer();
        this._acceptedTOM.stopTimer();
        this._rejectedTOM.stopTimer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    private void writeAccepted(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAccepted", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        AIAcceptedTick aIAcceptedTick = this.writeAcceptedNoTimeout(l, l2);
        this._initialAcceptedTOM.addTimeoutEntry(aIAcceptedTick);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeAccepted");
        }
    }

    private AIAcceptedTick writeAcceptedNoTimeout(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAcceptedNoTimeout", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        AIAcceptedTick aIAcceptedTick = new AIAcceptedTick(l, l2);
        TickRange tickRange = new TickRange(5, l, l);
        tickRange.value = aIAcceptedTick;
        this._targetStream.writeRange(tickRange);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeAcceptedNoTimeout", (Object)aIAcceptedTick);
        }
        return aIAcceptedTick;
    }

    private void writeRejected(long l, long l2, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeRejected", (Object)new Object[]{new Long(l), new Long(l2), new Boolean(bl)});
        }
        AIRejectedRange aIRejectedRange = this.writeRejectedNoTimeout(l, l2, bl);
        this._rejectedTOM.addTimeoutEntry(aIRejectedRange);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeRejected");
        }
    }

    private AIRejectedRange writeRejectedNoTimeout(long l, long l2, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeRejectedNoTimeout", (Object)new Object[]{new Long(l), new Long(l2), new Boolean(bl)});
        }
        AIRejectedRange aIRejectedRange = new AIRejectedRange(l, l2, bl);
        TickRange tickRange = new TickRange(6, l, l2);
        tickRange.value = aIRejectedRange;
        this._targetStream.writeRange(tickRange);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeRejectedNoTimeout", (Object)aIRejectedRange);
        }
        return aIRejectedRange;
    }

    private TickRange writeCompletedRange(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeCompletedRange", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        TickRange tickRange = new TickRange(7, l, l2);
        TickRange tickRange2 = null;
        tickRange2 = this._targetStream.writeCompletedRange(tickRange);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeCompletedRange", (Object)tickRange2);
        }
        return tickRange2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateTOMs recoverFromPersistentState(AIProtocolItemStream aIProtocolItemStream) throws MessageStoreException {
        TickRange tickRange;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverFromPersistentState", (Object)aIProtocolItemStream);
        }
        NonLockingCursor nonLockingCursor = null;
        AbstractItem abstractItem = null;
        ArrayList<AIAcceptedTick> arrayList = null;
        ArrayList<AIRejectedRange> arrayList2 = null;
        try {
            nonLockingCursor = aIProtocolItemStream.newNonLockingItemCursor(null);
            nonLockingCursor.allowUnavailableItems();
            while ((abstractItem = nonLockingCursor.next()) != null) {
                if (abstractItem instanceof AIProtocolItem) {
                    AIProtocolItem aIProtocolItem = (AIProtocolItem)abstractItem;
                    byte by = aIProtocolItem.getProtocolState();
                    if (by != 5) continue;
                    aIProtocolItem.setAIHCallbackTarget(this._parent);
                    if (aIProtocolItem.isAvailable()) {
                        AIAcceptedTick aIAcceptedTick = null;
                        try {
                            aIAcceptedTick = this.writeAcceptedNoTimeout(aIProtocolItem.getTick(), aIProtocolItem.getID());
                        }
                        catch (SIErrorException sIErrorException) {
                            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.gd.AIStream.recoverFromPersistentState", (String)"1:1617:1.97", (Object[])new Object[]{new Long(this.getCompletedPrefix()), new Long(aIProtocolItem.getTick()), aIProtocolItem, aIProtocolItemStream, this._targetStream, this});
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"recoverFromPersistentState", (Object)((Object)sIErrorException));
                            }
                            throw sIErrorException;
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList<AIAcceptedTick>();
                        }
                        arrayList.add(aIAcceptedTick);
                        this._itemStreamIndex.insert(aIProtocolItem);
                        continue;
                    }
                    long l = aIProtocolItem.getTick();
                    object = new AIValueTick(l, Reliability.ASSURED_PERSISTENT);
                    tickRange = new TickRange(3, l, l);
                    tickRange.value = object;
                    tickRange.valuestamp = l;
                    this._targetStream.writeRange(tickRange);
                    aIProtocolItem.setUnavailableAfterRecovery(true);
                    continue;
                }
                if (!(abstractItem instanceof AICompletedPrefixItem)) continue;
                this._completedPrefix = (AICompletedPrefixItem)abstractItem;
                long l = 0L;
                long l2 = this._completedPrefix.getTick();
                this.writeCompletedRange(l, l2);
                this._targetStream.setCompletedPrefix(l2);
            }
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        long l = this._targetStream.getCompletedPrefix() + 1L;
        long l3 = this._latestTick;
        this._targetStream.setCursor(l);
        object = null;
        tickRange = this._targetStream.getNext();
        while (tickRange.startstamp <= l3 && tickRange != object) {
            if (tickRange.type == 0) {
                long l4 = tickRange.startstamp;
                long l5 = tickRange.endstamp > l3 ? l3 : tickRange.endstamp;
                AIRejectedRange aIRejectedRange = this.writeRejectedNoTimeout(l4, l5, true);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<AIRejectedRange>();
                }
                arrayList2.add(aIRejectedRange);
            } else if (tickRange.type == 3 || tickRange.type == 5) {
                // empty if block
            }
            object = tickRange;
            tickRange = this._targetStream.getNext();
        }
        CreateTOMs createTOMs = new CreateTOMs(arrayList, arrayList2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverFromPersistentState", (Object)createTOMs);
        }
        return createTOMs;
    }

    private void doEnqueueWork(AsyncUpdate asyncUpdate) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doEnqueueWork", (Object)asyncUpdate);
        }
        try {
            this._msUpdateThread.enqueueWork(asyncUpdate);
        }
        catch (ClosedException closedException) {
            FFDCFilter.processException((Throwable)closedException, (String)"com.ibm.ws.sib.processor.gd.AIStream.doEnqueueWork", (String)"1:1732:1.97", (Object)this);
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1740:1.97", closedException}, null), (Throwable)closedException);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.AIStream", "1:1748:1.97", SIMPUtils.getStackTrace(closedException)});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork");
        }
    }

    private void sendRequest(long l, long l2, SelectionCriteria[] selectionCriteriaArray, long l3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequest", (Object)new Object[]{new Long(l), new Long(l2), selectionCriteriaArray, new Long(l3)});
        }
        long[] lArray = new long[]{l};
        long[] lArray2 = new long[]{l2};
        long[] lArray3 = new long[]{l3};
        this._parent.sendRequest(lArray, lArray2, selectionCriteriaArray, lArray3);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequest");
        }
    }

    public AIProtocolItemStream getAIProtocolItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIProtocolItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getAIProtocolItemStream", (Object)this._itemStream);
        }
        return this._itemStream;
    }

    public long getCompletedPrefix() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)new Long(this._targetStream.getCompletedPrefix()));
        }
        return this._targetStream.getCompletedPrefix();
    }

    public String getID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getID");
        }
        String string = this._streamId.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getID", (Object)string);
        }
        return string;
    }

    protected int getPriority() {
        return 0;
    }

    protected Reliability getReliability() {
        return null;
    }

    public StateStream getStateStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateStream");
            SibTr.exit((TraceComponent)tc, (String)"getStateStream", (Object)this._targetStream);
        }
        return this._targetStream;
    }

    public void writeSilenceForced(long l) {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/AIStream.java, SIB.processor, WAS602.SIB, o0610.11 1.97");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    class ProtocolItemComparator
    implements Comparator {
        ProtocolItemComparator() {
        }

        public int compare(Object object, Object object2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"compare", (Object)new Object[]{object, object2});
            }
            if (object instanceof AIProtocolItem && object2 instanceof AIProtocolItem) {
                AIProtocolItem aIProtocolItem = (AIProtocolItem)object;
                AIProtocolItem aIProtocolItem2 = (AIProtocolItem)object2;
                int n = aIProtocolItem.getTick() < aIProtocolItem2.getTick() ? -1 : (aIProtocolItem.getTick() > aIProtocolItem2.getTick() ? 1 : 0);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"compare", (Object)new Integer(n));
                }
                return n;
            }
            ClassCastException classCastException = new ClassCastException();
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.sib.processor.gd.AIStream.ProtocolItemComparator.compare", (String)"1:2479:1.97", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)classCastException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"compare", (Object)new Integer(0));
            }
            throw classCastException;
        }
    }

    class CompletedPrefixAsyncUpdate
    extends AsyncUpdate {
        CompletedPrefixAsyncUpdate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            AICompletedPrefixItem aICompletedPrefixItem = AIStream.this._completedPrefix;
            synchronized (aICompletedPrefixItem) {
                AIStream.this._completedPrefix.requestUpdate(transaction);
                GBSTree.Iterator iterator = AIStream.this._itemStreamIndex.iterator();
                AIProtocolItem aIProtocolItem = (AIProtocolItem)iterator.next();
                while (aIProtocolItem != null && aIProtocolItem.getTick() <= AIStream.this._completedPrefix.getTick()) {
                    long l = AIStream.this._parent.getUniqueLockID(1);
                    aIProtocolItem.lockItemIfAvailable(l);
                    aIProtocolItem.remove(transaction, l);
                    boolean bl = iterator.remove();
                    if (!bl) {
                        // empty if block
                    }
                    aIProtocolItem = (AIProtocolItem)iterator.next();
                }
                AIStream.this._completedPrefixNeedsToBeScheduled = true;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            AICompletedPrefixItem aICompletedPrefixItem = AIStream.this._completedPrefix;
            synchronized (aICompletedPrefixItem) {
                AIStream.this._countOfOutstandingCPUpdates--;
                if (AIStream.this._countOfOutstandingCPUpdates == 0) {
                    AIStream.this._completedPrefix.notify();
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed", (Object)new Integer(AIStream.this._countOfOutstandingCPUpdates));
            }
        }

        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            AIStream.this.doEnqueueWork(this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    class CreateTOMs {
        private List acceptedTicks;
        private List rejectedTicks;

        public CreateTOMs() {
            this.acceptedTicks = null;
            this.rejectedTicks = null;
        }

        public CreateTOMs(List list, List list2) {
            this.acceptedTicks = list;
            this.rejectedTicks = list2;
        }

        public void create() {
            AIStream.this._eagerGetTOM = new BatchedTimeoutManager(4, SIMPConstants.EAGER_GET_REQUEST_INTERVAL, null, new EagerGetTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._slowedGetTOM = new TraversableBatchedTimeoutManager(4, SIMPConstants.SLOWED_GET_REQUEST_INTERVAL, null, new SlowedGetTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._initialAcceptedTOM = new BatchedTimeoutManager(4, SIMPConstants.ACCEPT_INITIAL_THRESHOLD, this.acceptedTicks, new InitialAcceptedTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._acceptedTOM = new BatchedTimeoutManager(4, SIMPConstants.ACCEPT_REPETITION_INTERVAL, this.acceptedTicks, new AcceptedTimeoutProcessor(), AIStream.this._mp);
            AIStream.this._rejectedTOM = new BatchedTimeoutManager(4, SIMPConstants.REJECT_REPETITION_INTERVAL, this.rejectedTicks, new RejectedTimeoutProcessor(), AIStream.this._mp);
        }
    }

    public static class AIStreamState
    implements SIMPDeliveryReceiverControllable.StreamState {
        public static final AIStreamState ACTIVE = new AIStreamState("Active", 1);
        private String name;
        private int id;

        private AIStreamState(String string, int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIStreamState", (Object)new Object[]{string, new Integer(n)});
            }
            this.name = string;
            this.id = n;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIStreamState", (Object)this);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getValue");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getValue", (Object)new Integer(this.id));
            }
            return this.id;
        }
    }

    class RejectedTimeoutProcessor
    implements BatchedTimeoutProcessor {
        RejectedTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimedoutEntries(List list) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AIRejectedRange aIRejectedRange = (AIRejectedRange)list.get(i);
                long[] lArray = new long[]{aIRejectedRange.startTick};
                long[] lArray2 = new long[]{aIRejectedRange.endTick};
                AIStream.this._parent.sendReject(lArray, lArray2, aIRejectedRange.recovery);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
            }
        }
    }

    class AcceptedTimeoutProcessor
    implements BatchedTimeoutProcessor {
        protected boolean initialSend = false;

        AcceptedTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimedoutEntries(List list) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{list, new Boolean(this.initialSend)});
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int n = list.size();
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                AIAcceptedTick aIAcceptedTick = (AIAcceptedTick)list.get(i);
                lArray[i] = aIAcceptedTick.tick;
                if (!this.initialSend) continue;
                AIStream.this._initialAcceptedTOM.removeTimeoutEntry(aIAcceptedTick);
                AIStream.this._acceptedTOM.addTimeoutEntry(aIAcceptedTick);
            }
            AIStream.this._parent.sendAccept(lArray);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
            }
        }
    }

    class InitialAcceptedTimeoutProcessor
    extends AcceptedTimeoutProcessor {
        public InitialAcceptedTimeoutProcessor() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"InitialAcceptedTimeoutProcessor");
            }
            this.initialSend = true;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"InitialAcceptedTimeoutProcessor", (Object)this);
            }
        }
    }

    class AIRejectedRange
    extends AbstractBatchedTimeoutEntry {
        public long startTick;
        public long endTick;
        public boolean recovery;

        public AIRejectedRange(long l, long l2, boolean bl) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIRejectedRange", (Object)new Object[]{new Long(l), new Long(l2), new Boolean(bl)});
            }
            this.startTick = l;
            this.endTick = l2;
            this.recovery = bl;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIRejectedRange", (Object)this);
            }
        }
    }

    class AIAcceptedTick
    extends AbstractBatchedTimeoutEntry {
        public long tick;
        public long acceptedItemId;

        public AIAcceptedTick(long l, long l2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIAcceptedTick", (Object)new Object[]{new Long(l), new Long(l2)});
            }
            this.tick = l;
            this.acceptedItemId = l2;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIAcceptedTick", (Object)this);
            }
        }
    }

    class AddToEagerTOM
    implements EntryAction {
        private TraversableBatchedTimeoutManager timeoutManager;
        private long dmeVersion;

        public AddToEagerTOM(TraversableBatchedTimeoutManager traversableBatchedTimeoutManager, long l) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AddToEagerTOM", (Object)new Object[]{traversableBatchedTimeoutManager, new Long(l)});
            }
            this.timeoutManager = traversableBatchedTimeoutManager;
            this.dmeVersion = l;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AddToEagerTOM", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void theAction(BatchedTimeoutEntry batchedTimeoutEntry) {
            AIRequestedTick aIRequestedTick;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"theAction", (Object)batchedTimeoutEntry);
            }
            if ((aIRequestedTick = (AIRequestedTick)batchedTimeoutEntry).getAckingDMEVersion() < this.dmeVersion) {
                this.timeoutManager.removeTimeoutEntry(aIRequestedTick);
                AIRequestedTick aIRequestedTick2 = aIRequestedTick;
                synchronized (aIRequestedTick2) {
                    long l = aIRequestedTick.getTimeout();
                    if (l != SIMPConstants.INFINITE_TIMEOUT) {
                        l -= SIMPConstants.SLOWED_GET_REQUEST_INTERVAL;
                    }
                    if (l > 0L || l == SIMPConstants.INFINITE_TIMEOUT) {
                        AIStream.this._eagerGetTOM.addTimeoutEntry(aIRequestedTick);
                        aIRequestedTick.setSlowed(false);
                        long l2 = aIRequestedTick.getTick();
                        AIStream.this.sendRequest(l2, aIRequestedTick.getTick(), aIRequestedTick.getCriterias(), l);
                    } else {
                        try {
                            AnycastInputHandler.SendDispatcher sendDispatcher = AIStream.this._parent.new AnycastInputHandler.SendDispatcher();
                            AIStream.this.updateToRejected(aIRequestedTick.getTick(), sendDispatcher);
                            sendDispatcher.dispatch();
                        }
                        catch (SIErrorException sIErrorException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"theAction");
            }
        }
    }

    static interface EntryAction {
        public void theAction(BatchedTimeoutEntry var1);
    }

    class TraversableBatchedTimeoutManager
    extends BatchedTimeoutManager {
        public TraversableBatchedTimeoutManager(int n, long l, List list, BatchedTimeoutProcessor batchedTimeoutProcessor, MessageProcessor messageProcessor) {
            super(n, l, list, batchedTimeoutProcessor, messageProcessor);
        }

        public synchronized void applyToEachEntry(EntryAction entryAction) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"applyToEachEntry", (Object)entryAction);
            }
            BatchedTimeoutManager.LinkedListEntry linkedListEntry = (BatchedTimeoutManager.LinkedListEntry)this.activeEntries.getFirst();
            while (linkedListEntry != null) {
                entryAction.theAction(linkedListEntry.bte);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"applyToEachEntry");
            }
        }
    }

    class SlowedGetTimeoutProcessor
    implements BatchedTimeoutProcessor {
        SlowedGetTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimedoutEntries(List list) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AIRequestedTick aIRequestedTick = (AIRequestedTick)list.get(i);
                boolean bl = false;
                AIRequestedTick aIRequestedTick2 = aIRequestedTick;
                synchronized (aIRequestedTick2) {
                    long l = aIRequestedTick.getTimeout();
                    if (l != SIMPConstants.INFINITE_TIMEOUT) {
                        aIRequestedTick.resetTimeout(l -= SIMPConstants.SLOWED_GET_REQUEST_INTERVAL);
                    }
                    if (l > 0L || l == SIMPConstants.INFINITE_TIMEOUT) {
                        AIStream.this._slowedGetTOM.removeTimeoutEntry(aIRequestedTick);
                        aIRequestedTick.setSlowed(false);
                        AIStream.this._eagerGetTOM.addTimeoutEntry(aIRequestedTick);
                        long l2 = aIRequestedTick.getTick();
                        AIStream.this.sendRequest(l2, aIRequestedTick.getTick(), aIRequestedTick.getCriterias(), l);
                    } else {
                        AIStream.this._slowedGetTOM.removeTimeoutEntry(aIRequestedTick);
                        bl = true;
                    }
                }
                if (!bl) continue;
                AIStream.this._parent.reject(aIRequestedTick.getTick());
            }
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
            }
        }
    }

    class EagerGetTimeoutProcessor
    implements BatchedTimeoutProcessor {
        EagerGetTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTimedoutEntries(List list) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
            }
            AIStream aIStream = AIStream.this;
            synchronized (aIStream) {
                if (AIStream.this._stopped) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries", (Object)this);
                    }
                    return;
                }
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AIRequestedTick aIRequestedTick = (AIRequestedTick)list.get(i);
                boolean bl = false;
                AIRequestedTick aIRequestedTick2 = aIRequestedTick;
                synchronized (aIRequestedTick2) {
                    long l = aIRequestedTick.getTimeout();
                    if (l != SIMPConstants.INFINITE_TIMEOUT) {
                        aIRequestedTick.resetTimeout(l -= SIMPConstants.EAGER_GET_REQUEST_INTERVAL);
                    }
                    if (l > 0L || l == SIMPConstants.INFINITE_TIMEOUT) {
                        long l2 = aIRequestedTick.getTick();
                        AIStream.this.sendRequest(l2, aIRequestedTick.getTick(), aIRequestedTick.getCriterias(), l);
                    } else {
                        AIStream.this._eagerGetTOM.removeTimeoutEntry(aIRequestedTick);
                        bl = true;
                    }
                }
                if (!bl) continue;
                AIStream.this._parent.reject(aIRequestedTick.getTick());
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
            }
        }
    }
}

