/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.msgstore.transactions.TransactionParticipant;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.WorkList;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;

public class XidParticipant
implements TransactionParticipant {
    private static TraceComponent tc = SibTr.register((Class)XidParticipant.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _state = 10;
    private boolean _rollbackChanges = false;
    private boolean _indoubt = false;
    private boolean _loggingIndoubtAsynchronously = false;
    private PersistentTranId _ptid;
    private WorkList _workList;
    private final ArrayList _callbacks = new ArrayList(5);
    private MessageStoreImpl _ms;
    private PersistenceManager _persistence;
    private int _maxSize;
    private int _size = 0;
    private BatchingContext _bc;

    public XidParticipant(MessageStoreImpl messageStoreImpl, PersistentTranId persistentTranId, PersistenceManager persistenceManager, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"XidParticpant", (Object)("MessageStore=" + messageStoreImpl + ", PersistentTranId=" + persistentTranId + ", Persistence=" + persistenceManager + ", MaxSize=" + n));
        }
        this._ms = messageStoreImpl;
        this._ptid = persistentTranId;
        this._persistence = persistenceManager;
        this._maxSize = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"XidParticpant");
        }
    }

    public XidParticipant(MessageStoreImpl messageStoreImpl, PersistentTranId persistentTranId, PersistenceManager persistenceManager, int n, int n2) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("MessageStore=");
            stringBuffer.append(messageStoreImpl);
            stringBuffer.append(", PersistentTranId=");
            stringBuffer.append(persistentTranId);
            stringBuffer.append(", Persistence=");
            stringBuffer.append(persistenceManager);
            stringBuffer.append(", State=");
            switch (n2) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.entry((TraceComponent)tc, (String)"XidParticpant", (Object)stringBuffer.toString());
        }
        this._ms = messageStoreImpl;
        this._ptid = persistentTranId;
        this._persistence = persistenceManager;
        this._state = n2;
        this._maxSize = n;
        if (this._state == 12) {
            this._rollbackChanges = true;
            this._indoubt = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"XidParticpant");
        }
    }

    public synchronized void addWork(WorkItem workItem) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + workItem));
        }
        if (this._state != 10 && !this._indoubt) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot add work to transaction. Transaction is complete or completing!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addWork");
            }
            throw protocolException;
        }
        if (this._workList == null) {
            this._workList = new TaskList();
        }
        if (workItem == null) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot add null work item to transaction!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addWork");
            }
            throw protocolException;
        }
        this._workList.addWork(workItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    public WorkList getWorkList() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWorkList");
            SibTr.exit((TraceComponent)tc, (String)"getWorkList", (Object)("return=" + this._workList));
        }
        return this._workList;
    }

    public void registerCallback(TransactionCallback transactionCallback) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + transactionCallback));
        }
        this._callbacks.add(transactionCallback);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    public boolean isAutoCommit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((TraceComponent)tc, (String)"isAutoCommit", (Object)"return=false");
        }
        return false;
    }

    public PersistentTranId getPersistentTranId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentTranId");
            SibTr.exit((TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._ptid));
        }
        return this._ptid;
    }

    public void incrementCurrentSize() throws TransactionMaxSizeExceededException {
        if (++this._size > this._maxSize) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
            }
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Maximum transaction size reached, throwing exception!");
            }
            throw new TransactionMaxSizeExceededException();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
        }
    }

    public boolean isAlive() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlive");
        }
        boolean bl2 = bl = this._state == 10 || this._indoubt;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAlive", (Object)("return=" + bl));
        }
        return bl;
    }

    public int prepare() throws ProtocolException, RollbackException, SeverePersistenceException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepare");
        }
        if (this._state != 10) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot prepare Transaction. Transaction is complete or completing!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw protocolException;
        }
        for (n = 0; n < this._callbacks.size(); ++n) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(n);
            transactionCallback.beforeCompletion(this);
        }
        n = 0;
        if (this._workList != null) {
            try {
                this._workList.preCommit(this);
            }
            catch (Throwable throwable) {
                block23: {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.prepare", (String)"314");
                    try {
                        this.rollback();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.prepare", (String)"329");
                        if (!tc.isEventEnabled()) break block23;
                        SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)exception);
                    }
                }
                this._state = 17;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in preCommit!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"prepare");
                }
                throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, throwable);
            }
            this._state = 11;
            try {
                this._persistence.prepare(this);
                this._state = 12;
                this._rollbackChanges = true;
            }
            catch (SeverePersistenceException severePersistenceException) {
                FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.prepare", (String)"352", (Object)this);
                if (this._ms != null) {
                    this._ms.reportLocalError();
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unrecoverable persistence exception caught during prepare phase of transaction!", (Object)((Object)severePersistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"prepare");
                }
                throw severePersistenceException;
            }
            catch (PersistenceException persistenceException) {
                block24: {
                    FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.prepare", (String)"359", (Object)this);
                    try {
                        this.rollback();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.prepare", (String)"372");
                        if (!tc.isEventEnabled()) break block24;
                        SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)exception);
                    }
                }
                this._state = 17;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in prepare!", (Object)((Object)persistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"prepare");
                }
                throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{persistenceException}, (Throwable)((Object)persistenceException));
            }
        }
        this._state = 12;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepare", (Object)("return=" + n));
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(boolean bl) throws ProtocolException, RollbackException, SeverePersistenceException, TransactionException, PersistenceException {
        boolean bl2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit", (Object)("onePhase=" + bl));
        }
        if (this._state == 15 || this._state == 17) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot commit Transaction. Transaction is already complete!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw protocolException;
        }
        if (!bl && this._state != 12) {
            ProtocolException protocolException = new ProtocolException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot commit Transaction. Transaction has not been prepared!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw protocolException;
        }
        if (bl) {
            for (int i = 0; i < this._callbacks.size(); ++i) {
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.beforeCompletion(this);
            }
            if (this._workList != null) {
                try {
                    this._workList.preCommit(this);
                }
                catch (Throwable throwable) {
                    block44: {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.commit", (String)"446");
                        try {
                            this.rollback();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.prepare", (String)"461");
                            if (!tc.isEventEnabled()) break block44;
                            SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)exception);
                        }
                    }
                    this._state = 17;
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in preCommit!", (Object)throwable);
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"commit");
                    }
                    throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, throwable);
                }
            }
            this._state = 13;
        } else {
            this._state = 14;
        }
        try {
            try {
                if (this._workList != null) {
                    this._persistence.commit(this, bl);
                    this._workList.commit(this);
                }
                if (this._indoubt && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Indoubt transaction completed successfully. TranId=" + this._ptid));
                }
                this._state = 15;
            }
            catch (SeverePersistenceException severePersistenceException) {
                FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"501", (Object)this);
                if (this._ms != null) {
                    this._ms.reportLocalError();
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unrecoverable persistence exception caught during commit phase of transaction!", (Object)((Object)severePersistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw severePersistenceException;
            }
            catch (PersistenceException persistenceException) {
                FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"508", (Object)this);
                if (bl) {
                    block45: {
                        try {
                            if (this._workList != null) {
                                this._workList.rollback(this);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.commit", (String)"532");
                            if (!tc.isEventEnabled()) break block45;
                            SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back WorkList after commit failure!", (Object)exception);
                        }
                    }
                    this._state = 17;
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to exception in commit!", (Object)((Object)persistenceException));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"commit");
                    }
                    throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{persistenceException}, (Throwable)((Object)persistenceException));
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Persistence exception caught during commit phase of transaction!", (Object)((Object)persistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw persistenceException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"544", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught during commit phase of transaction!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, throwable);
            }
            Object var5_12 = null;
            bl2 = this._state == 15;
        }
        catch (Throwable throwable) {
            boolean bl4;
            Object var5_13 = null;
            boolean bl3 = bl4 = this._state == 15;
            if (this._workList != null) {
                this._workList.postComplete(this, bl4);
            }
            int i = 0;
            while (true) {
                if (i >= this._callbacks.size()) {
                    throw throwable;
                }
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.afterCompletion(this, bl4);
                ++i;
            }
        }
        boolean bl22 = bl2;
        if (this._workList != null) {
            this._workList.postComplete(this, bl22);
        }
        for (int i = 0; i < this._callbacks.size(); ++i) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
            transactionCallback.afterCompletion(this, bl22);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws ProtocolException, SeverePersistenceException, TransactionException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback");
        }
        if (this._state == 15 || this._state == 17) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot rollback Transaction. Transaction is already complete!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw protocolException;
        }
        this._state = 16;
        try {
            try {
                if (this._workList != null) {
                    if (this._rollbackChanges) {
                        this._persistence.rollback(this);
                    }
                    this._workList.rollback(this);
                }
                if (this._indoubt && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Indoubt transaction completed successfully. TranId=" + this._ptid));
                }
                this._state = 17;
            }
            catch (SeverePersistenceException severePersistenceException) {
                FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.rollback", (String)"613", (Object)this);
                if (this._ms != null) {
                    this._ms.reportLocalError();
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unrecoverable persistence exception caught during rollback phase of transaction!", (Object)((Object)severePersistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rollback");
                }
                throw severePersistenceException;
            }
            catch (PersistenceException persistenceException) {
                FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.rollback", (String)"620", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Persistence exception caught during rollback phase of transaction!", (Object)((Object)persistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rollback");
                }
                throw persistenceException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.rollback", (String)"627", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught during rollback phase of transaction!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rollback");
                }
                throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, throwable);
            }
            Object var3_5 = null;
            if (this._workList != null) {
                this._workList.postComplete(this, false);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (this._workList != null) {
                this._workList.postComplete(this, false);
            }
            int i = 0;
            while (true) {
                if (i >= this._callbacks.size()) {
                    throw throwable;
                }
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.afterCompletion(this, false);
                ++i;
            }
        }
        for (int i = 0; i < this._callbacks.size(); ++i) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
            transactionCallback.afterCompletion(this, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public String toXmlString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<transaction>\n");
        stringBuffer.append("<type>GLOBAL</type>\n");
        stringBuffer.append("<xid>");
        stringBuffer.append(this._ptid);
        stringBuffer.append("</xid>\n");
        stringBuffer.append("<state>");
        switch (this._state) {
            case 10: {
                stringBuffer.append("STATE_ACTIVE");
                break;
            }
            case 11: {
                stringBuffer.append("STATE_PREPARING");
                break;
            }
            case 12: {
                stringBuffer.append("STATE_PREPARED");
                break;
            }
            case 13: {
                stringBuffer.append("STATE_COMMITTING_1PC");
                break;
            }
            case 14: {
                stringBuffer.append("STATE_COMMITTING_2PC");
                break;
            }
            case 15: {
                stringBuffer.append("STATE_COMMITTED");
                break;
            }
            case 16: {
                stringBuffer.append("STATE_ROLLINGBACK");
                break;
            }
            case 17: {
                stringBuffer.append("STATE_ROLLEDBACK");
            }
        }
        stringBuffer.append("</state>\n");
        stringBuffer.append("<size>");
        stringBuffer.append(this._size);
        stringBuffer.append("</size>\n");
        stringBuffer.append("<max-size>");
        stringBuffer.append(this._maxSize);
        stringBuffer.append("</max-size>\n");
        if (this._workList != null) {
            stringBuffer.append(this._workList.toXmlString());
        }
        stringBuffer.append("</transaction>\n");
        return stringBuffer.toString();
    }

    public final int getTransactionType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_GLOBAL");
        }
        return 2;
    }

    public void setTransactionState(int n) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("State=");
            switch (n) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.entry((TraceComponent)tc, (String)"setTransactionState", (Object)stringBuffer.toString());
        }
        this._state = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionState");
        }
    }

    public int getTransactionState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionState");
            StringBuffer stringBuffer = new StringBuffer("return=");
            switch (this._state) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.exit((TraceComponent)tc, (String)"getTransactionState", (Object)stringBuffer.toString());
        }
        return this._state;
    }

    public BatchingContext getBatchingContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    public void setBatchingContext(BatchingContext batchingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + batchingContext));
        }
        this._bc = batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBatchingContext");
        }
    }
}

