/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.XidAlreadyKnownException;
import com.ibm.ws.sib.msgstore.XidStillAssociatedException;
import com.ibm.ws.sib.msgstore.XidUnknownException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionParticipant;
import com.ibm.ws.sib.msgstore.transactions.XidParticipant;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;
import javax.transaction.xa.Xid;

public class XidManager {
    private static TraceComponent tc = SibTr.register((Class)XidManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Vector _indoubtXids = new Vector();
    private Hashtable _associatedTrans = new Hashtable();
    private Hashtable _unassociatedTrans = new Hashtable();
    private MessageStoreImpl _ms;
    private PersistenceManager _persistence;
    private int _localTranIdCounter = 0;

    public XidManager(MessageStoreImpl messageStoreImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"XidManager", (Object)("MessageStore=" + messageStoreImpl));
        }
        this._ms = messageStoreImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"XidManager");
        }
    }

    public void start(PersistentTranId persistentTranId, TransactionParticipant transactionParticipant) throws XidAlreadyKnownException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)("Participant=" + transactionParticipant + ", PersistentTranId=" + persistentTranId));
        }
        if (this._associatedTrans.containsKey(persistentTranId)) {
            XidAlreadyKnownException xidAlreadyKnownException = new XidAlreadyKnownException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot start new association with this Xid. It is already known!", (Object)((Object)xidAlreadyKnownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start");
            }
            throw xidAlreadyKnownException;
        }
        this._associatedTrans.put(persistentTranId, transactionParticipant);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void end(PersistentTranId persistentTranId) throws XidUnknownException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"end", (Object)("PersistentTranId=" + persistentTranId));
        }
        if (!this._associatedTrans.containsKey(persistentTranId)) {
            XidUnknownException xidUnknownException = new XidUnknownException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot disassociate from this Xid. It is not currently associated!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"end");
            }
            throw xidUnknownException;
        }
        Object v = this._associatedTrans.remove(persistentTranId);
        this._unassociatedTrans.put(persistentTranId, v);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"end");
        }
    }

    public int prepare(PersistentTranId persistentTranId) throws XidUnknownException, XidStillAssociatedException, ProtocolException, RollbackException, SeverePersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepare", (Object)("PersistentTranId=" + persistentTranId));
        }
        if (this._associatedTrans.containsKey(persistentTranId)) {
            XidStillAssociatedException xidStillAssociatedException = new XidStillAssociatedException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Xid is still associated. Needs to be disassociated before completion!", (Object)((Object)xidStillAssociatedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw xidStillAssociatedException;
        }
        int n = 0;
        if (this._unassociatedTrans.containsKey(persistentTranId)) {
            TransactionParticipant transactionParticipant = (TransactionParticipant)this._unassociatedTrans.get(persistentTranId);
            try {
                n = transactionParticipant.prepare();
                this._indoubtXids.add(persistentTranId);
            }
            catch (RollbackException rollbackException) {
                FFDCFilter.processException((Throwable)((Object)rollbackException), (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.prepare", (String)"121");
                transactionParticipant = (TransactionParticipant)this._unassociatedTrans.remove(persistentTranId);
                if (tc.isEventEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Participant removed from XidManager due to RollbackException: " + transactionParticipant));
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"RollbackException caught during prepare phase of transaction!", (Object)((Object)rollbackException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"prepare");
                }
                throw rollbackException;
            }
        } else {
            XidUnknownException xidUnknownException = new XidUnknownException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot prepare transaction branch, Xid is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw xidUnknownException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepare", (Object)("return=" + n));
        }
        return n;
    }

    public void commit(PersistentTranId persistentTranId, boolean bl) throws XidUnknownException, XidStillAssociatedException, ProtocolException, RollbackException, SeverePersistenceException, PersistenceException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit", (Object)("onePhase=" + bl + ", PersistentTranId=" + persistentTranId));
        }
        if (this._associatedTrans.containsKey(persistentTranId)) {
            XidStillAssociatedException xidStillAssociatedException = new XidStillAssociatedException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Xid is still associated. Needs to be disassociated before completion!", (Object)((Object)xidStillAssociatedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw xidStillAssociatedException;
        }
        if (this._unassociatedTrans.containsKey(persistentTranId)) {
            TransactionParticipant transactionParticipant = (TransactionParticipant)this._unassociatedTrans.remove(persistentTranId);
            transactionParticipant.commit(bl);
            if (this._indoubtXids.contains(persistentTranId)) {
                this._indoubtXids.remove(persistentTranId);
            }
        } else {
            XidUnknownException xidUnknownException = new XidUnknownException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot commit transaction branch, Xid is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw xidUnknownException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public void rollback(PersistentTranId persistentTranId) throws XidUnknownException, XidStillAssociatedException, ProtocolException, SeverePersistenceException, PersistenceException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback", (Object)("PersistentTranId=" + persistentTranId));
        }
        if (this._associatedTrans.containsKey(persistentTranId)) {
            XidStillAssociatedException xidStillAssociatedException = new XidStillAssociatedException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Xid is still associated. Needs to be disassociated before completion!", (Object)((Object)xidStillAssociatedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw xidStillAssociatedException;
        }
        if (this._unassociatedTrans.containsKey(persistentTranId)) {
            TransactionParticipant transactionParticipant = (TransactionParticipant)this._unassociatedTrans.remove(persistentTranId);
            transactionParticipant.rollback();
            if (this._indoubtXids.contains(persistentTranId)) {
                this._indoubtXids.remove(persistentTranId);
            }
        } else {
            XidUnknownException xidUnknownException = new XidUnknownException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot rollback transaction branch, Xid is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw xidUnknownException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public void restart(PersistentMessageStore persistentMessageStore) throws TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restart", (Object)("PersistenceManager=" + persistentMessageStore));
        }
        if (persistentMessageStore != null) {
            if (!(persistentMessageStore instanceof PersistenceManager)) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"No PersistenceManager provided at startup. MessageStore cannot continue!");
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"restart");
                }
                throw new MessageStoreRuntimeException("UNRECOVERABLE_ERROR_SIMS1499", new Object[0]);
            }
            this._persistence = (PersistenceManager)((Object)persistentMessageStore);
            try {
                List list = persistentMessageStore.readIndoubtXIDs();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PersistentTranId persistentTranId = (PersistentTranId)iterator.next();
                    this._indoubtXids.add(persistentTranId);
                    this._unassociatedTrans.put(persistentTranId, new XidParticipant(this._ms, persistentTranId, this._persistence, 0, 12));
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Indoubt Transaction Re-instated from database: " + persistentTranId));
                }
            }
            catch (PersistenceException persistenceException) {
                FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.restart", (String)"223");
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Persistence exception caught reading indoubt transactions from database!", (Object)((Object)persistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"restart");
                }
                throw new TransactionException("UNEXPECTED_EXCEPTION_SIMS1099", new Object[]{persistenceException}, (Throwable)((Object)persistenceException));
            }
        } else {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"PersistenceManager is null. MessageStore cannot continue!");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restart");
            }
            throw new MessageStoreRuntimeException("UNRECOVERABLE_ERROR_SIMS1499", new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restart");
        }
    }

    public Xid[] recover() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recover");
        }
        Xid[] xidArray = new Xid[this._indoubtXids.size()];
        this._indoubtXids.toArray(xidArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recover", (Object)("return=" + xidArray + ", size=" + xidArray.length));
        }
        return xidArray;
    }

    public Transaction getTransactionFromTranId(PersistentTranId persistentTranId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionFromTranId", (Object)("TranId=" + persistentTranId));
        }
        Transaction transaction = null;
        if (this._unassociatedTrans.containsKey(persistentTranId)) {
            transaction = (Transaction)this._unassociatedTrans.get(persistentTranId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionFromTranId", (Object)("return=" + transaction));
        }
        return transaction;
    }

    public boolean isTranIdKnown(PersistentTranId persistentTranId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTranIdKnown", (Object)("PersistentTranId=" + persistentTranId));
        }
        boolean bl = false;
        if (this._associatedTrans.containsKey(persistentTranId) || this._unassociatedTrans.containsKey(persistentTranId)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTranIdKnown", (Object)("return=" + bl));
        }
        return bl;
    }

    public Xid[] listRemoteInDoubts() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listRemoteInDoubts");
        }
        Vector vector = (Vector)this._indoubtXids.clone();
        Xid[] xidArray = null;
        if (vector.size() > 0) {
            ObjectName objectName;
            AdminService adminService;
            Iterator iterator;
            String[] stringArray;
            Object[] objectArray;
            String string;
            block23: {
                string = "listOfTransactions";
                objectArray = null;
                stringArray = null;
                iterator = null;
                adminService = null;
                try {
                    adminService = AdminServiceFactory.getAdminService();
                    objectName = new ObjectName("WebSphere:type=TransactionService,*");
                    iterator = adminService.queryNames(objectName, null).iterator();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.listRemoteInDoubts", (String)"406");
                    if (!tc.isEventEnabled()) break block23;
                    SibTr.event((TraceComponent)tc, (String)"Exception caught looking up TransactionService!", (Object)exception);
                }
            }
            if (iterator != null && iterator.hasNext()) {
                String[] stringArray2;
                block24: {
                    objectName = (ObjectName)iterator.next();
                    stringArray2 = null;
                    try {
                        stringArray2 = (String[])adminService.invoke(objectName, string, objectArray, stringArray);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.listRemoteInDoubts", (String)"424");
                        if (!tc.isEventEnabled()) break block24;
                        SibTr.event((TraceComponent)tc, (String)"Exception caught invoking listTransactions!", (Object)exception);
                    }
                }
                if (stringArray2 != null && stringArray2.length > 0) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"TM Transaction List:");
                    }
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string2 = stringArray2[i];
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Transaction " + i + ": " + string2));
                        }
                        String string3 = string2.split(", ")[2];
                        Iterator iterator2 = vector.iterator();
                        while (iterator2.hasNext()) {
                            PersistentTranId persistentTranId = (PersistentTranId)iterator2.next();
                            String string4 = persistentTranId.toTMString().substring(0, string3.length());
                            if (!string3.equalsIgnoreCase(string4)) continue;
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"TM transaction matches ME transaction. Removing from list.");
                            }
                            try {
                                iterator2.remove();
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.XidManager.listRemoteInDoubts", (String)"469");
                                if (!tc.isEventEnabled()) continue;
                                SibTr.event((TraceComponent)tc, (String)"Exception caught removing Xid from ME list!", (Object)exception);
                            }
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"No Transactions found in TM. Returning complete ME list.");
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"TransactionService not found. Returning complete ME list.");
            }
            if (vector.size() > 0) {
                xidArray = new Xid[vector.size()];
                vector.toArray(xidArray);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"There are currently no in-doubt transaction branches within the ME.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listRemoteInDoubts", (Object)("return=" + xidArray));
        }
        return xidArray;
    }

    public String toXmlString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<transaction-management>\n");
        stringBuffer.append("<associated-transactions>\n");
        Iterator<Object> iterator = this._associatedTrans.values().iterator();
        while (iterator.hasNext()) {
            object = (TransactionParticipant)iterator.next();
            stringBuffer.append(object.toXmlString());
        }
        stringBuffer.append("</associated-transactions>\n");
        stringBuffer.append("<unassociated-transactions>\n");
        iterator = this._unassociatedTrans.values().iterator();
        while (iterator.hasNext()) {
            object = (TransactionParticipant)iterator.next();
            stringBuffer.append(object.toXmlString());
        }
        stringBuffer.append("</unassociated-transactions>\n");
        stringBuffer.append("<indoubt-transaction-ids>\n");
        iterator = this._indoubtXids.iterator();
        while (iterator.hasNext()) {
            object = (PersistentTranId)iterator.next();
            stringBuffer.append("<xid>");
            stringBuffer.append(((PersistentTranId)object).toString());
            stringBuffer.append("</xid>\n");
        }
        stringBuffer.append("</indoubt-transaction-ids>\n");
        stringBuffer.append("</transaction-management>\n");
        return stringBuffer.toString();
    }

    public synchronized int generateLocalTranId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateLocalTranId");
        }
        int n = this._localTranIdCounter++;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateLocalTranId", (Object)("return=" + n));
        }
        return n;
    }
}

