/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.XidParsingException;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.transaction.xa.Xid;

public class PersistentTranId
implements Xid {
    private static TraceComponent tc = SibTr.register((Class)PersistentTranId.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _hashCode = -1;
    private int _formatId;
    private byte[] _gtrid;
    private byte[] _bqual;

    public PersistentTranId(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PersistentTranId", (Object)("TranId=" + n));
        }
        this._formatId = n;
        this._hashCode = n;
        this._gtrid = this.intToBytes(n);
        this._bqual = this.intToBytes(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PersistentTranId");
        }
    }

    public PersistentTranId(int n, byte[] byArray, byte[] byArray2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PersistentTranId", (Object)("FormatId=" + n + ", GTRID=" + this.toHexString(byArray) + ", BQUAL=" + this.toHexString(byArray2)));
        }
        this._formatId = n;
        this._gtrid = byArray;
        this._bqual = byArray2;
        if (this._bqual.length > 3) {
            this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PersistentTranId");
        }
    }

    public PersistentTranId(Xid xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PersistentTranId", (Object)("Xid=" + xid));
        }
        this._formatId = xid.getFormatId();
        this._gtrid = xid.getGlobalTransactionId();
        this._bqual = xid.getBranchQualifier();
        if (this._bqual.length > 3) {
            this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PersistentTranId");
        }
    }

    public PersistentTranId(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PersistentTranId", (Object)("Byte Data=" + this.toHexString(byArray)));
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        this._formatId = this.bytesToInt(byArray2);
        if (byArray.length > 4) {
            System.arraycopy(byArray, 4, byArray2, 0, 4);
            int n = this.bytesToInt(byArray2);
            this._gtrid = new byte[n];
            System.arraycopy(byArray, 8, this._gtrid, 0, n);
            System.arraycopy(byArray, 8 + n, byArray2, 0, 4);
            int n2 = this.bytesToInt(byArray2);
            this._bqual = new byte[n2];
            System.arraycopy(byArray, 12 + n, this._bqual, 0, n2);
            if (this._bqual.length > 3) {
                this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PersistentTranId");
        }
    }

    public PersistentTranId(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PersistentTranId", (Object)("String Data=" + string));
        }
        byte[] byArray = this.fromHexString(string);
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        this._formatId = this.bytesToInt(byArray2);
        if (byArray.length > 4) {
            System.arraycopy(byArray, 4, byArray2, 0, 4);
            int n = this.bytesToInt(byArray2);
            this._gtrid = new byte[n];
            System.arraycopy(byArray, 8, this._gtrid, 0, n);
            System.arraycopy(byArray, 8 + n, byArray2, 0, 4);
            int n2 = this.bytesToInt(byArray2);
            this._bqual = new byte[n2];
            System.arraycopy(byArray, 12 + n, this._bqual, 0, n2);
            if (this._bqual.length > 3) {
                this._hashCode = ((this._bqual[this._bqual.length - 4] & 0xFF) << 24) + ((this._bqual[this._bqual.length - 3] & 0xFF) << 16) + ((this._bqual[this._bqual.length - 2] & 0xFF) << 8) + (this._bqual[this._bqual.length - 1] & 0xFF);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PersistentTranId");
        }
    }

    public int getFormatId() {
        return this._formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this._gtrid;
    }

    public byte[] getBranchQualifier() {
        return this._bqual;
    }

    public String getPersistentData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        String string = this.toHexString(this.toByteArray());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)("return=" + string));
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PersistentTranId)) {
            return false;
        }
        PersistentTranId persistentTranId = (PersistentTranId)object;
        int n = persistentTranId.getFormatId();
        byte[] byArray = persistentTranId.getGlobalTransactionId();
        byte[] byArray2 = persistentTranId.getBranchQualifier();
        if (this._formatId != n || this._gtrid.length != byArray.length || this._bqual.length != byArray2.length) {
            return false;
        }
        int n2 = this._bqual.length;
        while (--n2 >= 0) {
            if (this._bqual[n2] == byArray2[n2]) continue;
            return false;
        }
        n2 = this._gtrid.length;
        while (--n2 >= 0) {
            if (this._gtrid[n2] == byArray[n2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return this.toHexString(this.toByteArray());
    }

    public String toTMString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toHexString(this._gtrid));
        stringBuffer.append(this.toHexString(this._bqual));
        return stringBuffer.toString();
    }

    private byte[] toByteArray() {
        byte[] byArray = new byte[12 + this._gtrid.length + this._bqual.length];
        byte[] byArray2 = new byte[4];
        byArray2 = this.intToBytes(this._formatId);
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        if (this._gtrid != null) {
            byArray2 = this.intToBytes(this._gtrid.length);
            System.arraycopy(byArray2, 0, byArray, 4, 4);
            System.arraycopy(this._gtrid, 0, byArray, 8, this._gtrid.length);
            byArray2 = this.intToBytes(this._bqual.length);
            System.arraycopy(byArray2, 0, byArray, 8 + this._gtrid.length, 4);
            System.arraycopy(this._bqual, 0, byArray, 12 + this._gtrid.length, this._bqual.length);
        }
        return byArray;
    }

    private int bytesToInt(byte[] byArray) {
        int n = -1;
        if (byArray.length >= 4) {
            n = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        }
        return n;
    }

    private byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    private String toHexString(byte[] byArray) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(string.charAt(byArray[i] >> 4 & 0xF));
            stringBuffer.append(string.charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    private byte[] fromHexString(String string) {
        String string2 = "0123456789abcdef";
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); i += 2) {
            int n2 = string2.indexOf(string.charAt(i));
            int n3 = string2.indexOf(string.charAt(i + 1));
            if (n2 < 0 || n2 > 15 || n3 < 0 || n3 > 15) {
                if (tc.isEntryEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Invalid values found restoring Xid from String data. HO=" + n2 + ", LO=" + n3));
                }
                throw new XidParsingException("UNRECOVERABLE_ERROR_SIMS1499");
            }
            byArray[n] = new Integer(n2 << 4 | n3).byteValue();
            ++n;
        }
        return byArray;
    }
}

