/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.WorkList;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;

public final class AutoCommitTransaction
implements ExternalAutoCommitTransaction,
PersistentTransaction {
    private static TraceComponent tc = SibTr.register((Class)AutoCommitTransaction.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private MessageStoreImpl _ms;
    private MSInstrumentation _pmi;
    private PersistenceManager _persistence;
    private XidManager _xidManager;
    private int _state = 10;
    private PersistentTranId _ptid;
    private WorkList _workList;
    private ArrayList _callbacks = new ArrayList(5);
    private int _maxSize;
    private int _size = 0;
    private BatchingContext _bc;

    public AutoCommitTransaction(MessageStoreImpl messageStoreImpl, PersistenceManager persistenceManager, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AutoCommitTransaction", (Object)("MessageStore=" + messageStoreImpl + ", Persistence=" + persistenceManager + ", MaxSize=" + n));
        }
        this._ms = messageStoreImpl;
        this._persistence = persistenceManager;
        this._maxSize = n;
        if (this._ms != null) {
            this._pmi = this._ms._getInstrumentation();
            this._xidManager = this._ms.getXidManager();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AutoCommitTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void addWork(WorkItem workItem) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + workItem));
        }
        if (this._state != 10) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot add work to transaction. Transaction is complete or completing!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addWork");
            }
            throw protocolException;
        }
        if (workItem != null) {
            this._state = 13;
            this._workList = new TaskList();
            this._workList.addWork(workItem);
            for (int i = 0; i < this._callbacks.size(); ++i) {
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.beforeCompletion(this);
            }
            try {
                this._workList.preCommit(this);
            }
            catch (Throwable throwable) {
                block39: {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.setWorkList", (String)"105", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught during work list preCommit!", (Object)throwable);
                    }
                    try {
                        this._state = 16;
                        this._workList.rollback(this);
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.setWorkList", (String)"211");
                        if (!tc.isEventEnabled()) break block39;
                        SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)throwable2);
                    }
                }
                this._state = 17;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in preCommit!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addWork");
                }
                throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, throwable);
            }
            this._persistence.commit(this, true);
            this._workList.commit(this);
            this._state = 15;
            Object var5_13 = null;
            try {
                boolean bl;
                boolean bl2 = bl = this._state == 15;
                if (this._workList != null) {
                    this._workList.postComplete(this, bl);
                }
                for (int i = 0; i < this._callbacks.size(); ++i) {
                    TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                    transactionCallback.afterCompletion(this, bl);
                }
                Object var10_21 = null;
                this._callbacks.clear();
                this._workList = null;
                this._state = 10;
                this._ptid = null;
            }
            catch (Throwable throwable) {
                Object var10_22 = null;
                this._callbacks.clear();
                this._workList = null;
                this._state = 10;
                this._ptid = null;
                throw throwable;
            }
            {
                catch (RollbackException rollbackException) {
                    throw rollbackException;
                }
                catch (SeverePersistenceException severePersistenceException) {
                    FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.setWorkList", (String)"158");
                    if (this._ms != null) {
                        this._ms.reportLocalError();
                    }
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Unrecoverable persistence exception caught during commit phase of transaction!", (Object)((Object)severePersistenceException));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"addWork");
                    }
                    throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{severePersistenceException}, (Throwable)((Object)severePersistenceException));
                }
                catch (PersistenceException persistenceException) {
                    block40: {
                        FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.setWorkList", (String)"165");
                        try {
                            this._workList.rollback(this);
                            this._state = 17;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.commit", (String)"181");
                            if (!tc.isEventEnabled()) break block40;
                            SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back WorkList after Commit failure!", (Object)throwable);
                        }
                    }
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in Commit!", (Object)((Object)persistenceException));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"addWork");
                    }
                    throw new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{persistenceException}, (Throwable)((Object)persistenceException));
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.AutoCommitTransaction.setWorkList", (String)"191");
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught during commit phase of transaction!", (Object)throwable);
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"addWork");
                    }
                    throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, throwable);
                }
            }
            catch (Throwable throwable) {
                Object var5_14 = null;
                try {
                    boolean bl;
                    boolean bl3 = bl = this._state == 15;
                    if (this._workList != null) {
                        this._workList.postComplete(this, bl);
                    }
                    for (int i = 0; i < this._callbacks.size(); ++i) {
                        TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                        transactionCallback.afterCompletion(this, bl);
                    }
                    Object var10_23 = null;
                    this._callbacks.clear();
                    this._workList = null;
                    this._state = 10;
                    this._ptid = null;
                }
                catch (Throwable throwable3) {
                    Object var10_24 = null;
                    this._callbacks.clear();
                    this._workList = null;
                    this._state = 10;
                    this._ptid = null;
                    throw throwable3;
                }
                throw throwable;
            }
        }
        this._state = 10;
        ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
        if (tc.isEventEnabled()) {
            SibTr.event((TraceComponent)tc, (String)"Cannot add null work item to transaction!", (Object)((Object)protocolException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
        throw protocolException;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    public WorkList getWorkList() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWorkList");
            SibTr.exit((TraceComponent)tc, (String)"getWorkList", (Object)("return=" + this._workList));
        }
        return this._workList;
    }

    public void registerCallback(TransactionCallback transactionCallback) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + transactionCallback));
        }
        this._callbacks.add(transactionCallback);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    public boolean isAutoCommit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((TraceComponent)tc, (String)"isAutoCommit", (Object)"return=true");
        }
        return true;
    }

    public synchronized PersistentTranId getPersistentTranId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentTranId");
        }
        if (this._ptid == null) {
            this._ptid = this._xidManager != null ? new PersistentTranId(this._xidManager.generateLocalTranId()) : new PersistentTranId(this.hashCode());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._ptid));
        }
        return this._ptid;
    }

    public void incrementCurrentSize() throws TransactionMaxSizeExceededException {
        if (++this._size > this._maxSize) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
            }
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Maximum transaction size reached, throwing exception!");
            }
            throw new TransactionMaxSizeExceededException();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
        }
    }

    public boolean isAlive() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlive");
        }
        boolean bl2 = bl = this._state == 10;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAlive", (Object)("return=" + bl));
        }
        return bl;
    }

    public final int getTransactionType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_AUTO_COMMIT");
        }
        return 0;
    }

    public void setTransactionState(int n) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("State=");
            switch (n) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.entry((TraceComponent)tc, (String)"setTransactionState", (Object)stringBuffer.toString());
        }
        this._state = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionState");
        }
    }

    public int getTransactionState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionState");
            StringBuffer stringBuffer = new StringBuffer("return=");
            switch (this._state) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.exit((TraceComponent)tc, (String)"getTransactionState", (Object)stringBuffer.toString());
        }
        return this._state;
    }

    public BatchingContext getBatchingContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    public void setBatchingContext(BatchingContext batchingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + batchingContext));
        }
        this._bc = batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBatchingContext");
        }
    }
}

