/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.FormatBuffer;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.task.TaskListException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.WorkList;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public final class TaskList
implements WorkList {
    private static final String STATE_BEGIN_ABORT = "Aborting";
    private static final String STATE_BEGIN_COMMIT = "Committing";
    private static final String STATE_BEGIN_POSTABORT = "PostAborting";
    private static final String STATE_BEGIN_POSTCOMMIT = "PostCommitting";
    private static final String STATE_BEGIN_PRECOMMIT = "Precommitting";
    private static final String STATE_END_ABORT = "Aborted";
    private static final String STATE_END_COMMIT = "Committed";
    private static final String STATE_END_POSTABORT = "PostAborted";
    private static final String STATE_END_POSTCOMMIT = "PostCommitted";
    private static final String STATE_END_PRECOMMIT = "Precommitted";
    private static final String STATE_UNTOUCHED = "Untouched";
    private static TraceComponent tc = SibTr.register((Class)TaskList.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Task _firstTask;
    private boolean _hasStoreAlways = false;
    private boolean _hasStoreEventually = false;
    private boolean _hasStoreMaybe = false;
    private boolean _hasStoreNever = false;
    private Task _lastTask;
    private boolean _requiresPersistence = false;
    private String _state = "Untouched";
    private int _taskCount = 0;

    public final void addWork(WorkItem workItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + workItem));
        }
        Task task = (Task)workItem;
        int n = task.getStorageStrategy();
        switch (n) {
            case 4: {
                this._hasStoreAlways = true;
                break;
            }
            case 3: {
                this._hasStoreEventually = true;
                break;
            }
            case 2: {
                this._hasStoreMaybe = true;
                break;
            }
            case 1: {
                this._hasStoreNever = true;
            }
        }
        if (null == this._firstTask || null == this._lastTask) {
            this._firstTask = task;
            this._lastTask = task;
            task._nextTask = null;
        } else {
            this._lastTask._nextTask = task;
            this._lastTask = task;
            this._lastTask._nextTask = null;
        }
        ++this._taskCount;
        Persistable persistable = task.getPersistable();
        if (null != persistable) {
            this._requiresPersistence |= persistable.requiresPersistence();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    public final void commit(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit", (Object)("Transaction=" + transaction));
        }
        if (STATE_END_PRECOMMIT != this._state) {
            throw new TaskListException(this._state);
        }
        this._state = STATE_BEGIN_COMMIT;
        Task task = this._firstTask;
        while (null != task) {
            task.commitInternal(transaction);
            task = task._nextTask;
        }
        task = this._firstTask;
        while (null != task) {
            task.commitExternal(transaction);
            task = task._nextTask;
        }
        this._state = STATE_END_COMMIT;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public final int countLinks() {
        return this._taskCount;
    }

    public final int countRemovingItems(LinkOwner linkOwner) {
        int n = 0;
        Task task = this._firstTask;
        while (null != task) {
            if (task.isRemoveFromList(linkOwner)) {
                ++n;
            }
            task = task._nextTask;
        }
        return n;
    }

    public final void declareAlreadyPrecommitted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"declareAlreadyPrecommitted");
        }
        if (STATE_UNTOUCHED == this._state) {
            this._state = STATE_END_PRECOMMIT;
        } else if (STATE_END_PRECOMMIT != this._state) {
            throw new TaskListException(this._state);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"declareAlreadyPrecommitted");
        }
    }

    public final boolean hasStoreAlways() {
        return this._hasStoreAlways;
    }

    public final boolean hasStoreEventually() {
        return this._hasStoreEventually;
    }

    public final boolean hasStoreMaybe() {
        return this._hasStoreMaybe;
    }

    public final boolean hasStoreNever() {
        return this._hasStoreNever;
    }

    public final java.util.Iterator iterator() {
        return new Iterator();
    }

    public final java.util.Iterator iterator(int n) {
        return new FilteredIterator(n);
    }

    public final void postComplete(Transaction transaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postComplete", (Object)("Transaction=" + transaction + ", Committed=" + bl));
        }
        if (bl) {
            if (STATE_END_COMMIT != this._state) {
                throw new TaskListException(this._state);
            }
            this._state = STATE_BEGIN_POSTCOMMIT;
        } else {
            if (STATE_BEGIN_ABORT != this._state && STATE_END_ABORT != this._state && STATE_END_PRECOMMIT != this._state) {
                throw new TaskListException(this._state);
            }
            this._state = STATE_BEGIN_POSTABORT;
        }
        if (bl) {
            Task task = this._firstTask;
            while (null != task) {
                task.postCommit(transaction);
                task = task._nextTask;
            }
        } else {
            Task task = this._firstTask;
            while (null != task) {
                task.postAbort(transaction);
                task = task._nextTask;
            }
        }
        this._state = bl ? STATE_END_POSTCOMMIT : STATE_END_POSTABORT;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postComplete");
        }
    }

    public final void preCommit(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"preCommit", (Object)("Transaction=" + transaction));
        }
        if (STATE_UNTOUCHED != this._state) {
            throw new TaskListException(this._state);
        }
        this._state = STATE_BEGIN_PRECOMMIT;
        Task task = this._firstTask;
        while (null != task) {
            task.preCommit(transaction);
            task = task._nextTask;
        }
        this._state = STATE_END_PRECOMMIT;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"preCommit");
        }
    }

    public final void printOn(FormatBuffer formatBuffer) {
        formatBuffer.append("TaskList (");
        formatBuffer.append(this._state);
        formatBuffer.append(" ");
        int n = this._taskCount;
        formatBuffer.append(Integer.toString(n));
        if (1 == n) {
            formatBuffer.append(" link) {");
        } else {
            formatBuffer.append(" links) {");
        }
        if (0 != n) {
            formatBuffer.indent();
            Task task = this._firstTask;
            while (null != task) {
                formatBuffer.newline();
                task.printOn(formatBuffer);
                task = task._nextTask;
            }
            formatBuffer.outdent();
            formatBuffer.newline();
        }
        formatBuffer.append(")");
    }

    public final boolean requiresPersistence() {
        return this._requiresPersistence;
    }

    public final void rollback(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback", (Object)("Transaction=" + transaction));
        }
        if (STATE_UNTOUCHED != this._state && STATE_END_PRECOMMIT != this._state && STATE_BEGIN_PRECOMMIT != this._state) {
            new TaskListException(this._state).printStackTrace();
        }
        this._state = STATE_BEGIN_ABORT;
        Task task = this._firstTask;
        while (null != task) {
            task.abort(transaction);
            task = task._nextTask;
        }
        this._state = STATE_END_ABORT;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public final String toString() {
        FormatBuffer formatBuffer = new FormatBuffer();
        this.printOn(formatBuffer);
        return formatBuffer.toString();
    }

    public String toXmlString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<work-list>\n");
        Task task = this._firstTask;
        while (null != task) {
            stringBuffer.append("<work-item>");
            stringBuffer.append(task);
            stringBuffer.append("</work-item>\n");
            task = task._nextTask;
        }
        stringBuffer.append("</work-list>\n");
        return stringBuffer.toString();
    }

    private final class Iterator
    implements java.util.Iterator {
        private Task _nextTask;

        private Iterator() {
            this._nextTask = TaskList.this._firstTask;
        }

        public final boolean hasNext() {
            return null != this._nextTask;
        }

        public final Object next() {
            if (null == this._nextTask) {
                throw new NoSuchElementException();
            }
            Task task = this._nextTask;
            this._nextTask = this._nextTask._nextTask;
            return task;
        }

        public final void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private final class FilteredIterator
    implements java.util.Iterator {
        private Task _nextTask;
        private final int _storageStrategy;

        FilteredIterator(int n) {
            this._nextTask = TaskList.this._firstTask;
            this._storageStrategy = n;
            while (null != this._nextTask && this._storageStrategy != this._nextTask.getStorageStrategy()) {
                this._nextTask = this._nextTask._nextTask;
            }
        }

        public final boolean hasNext() {
            return null != this._nextTask;
        }

        public final Object next() {
            if (null == this._nextTask) {
                throw new NoSuchElementException();
            }
            Task task = this._nextTask;
            if (null != this._nextTask) {
                this._nextTask = this._nextTask._nextTask;
            }
            while (null != this._nextTask && this._storageStrategy != this._nextTask.getStorageStrategy()) {
                this._nextTask = this._nextTask._nextTask;
            }
            return task;
        }

        public final void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

