/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.FormatBuffer;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class AbstractRemoveTask
extends Task {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)AbstractRemoveTask.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public AbstractRemoveTask(AbstractItemLink abstractItemLink) {
        super(abstractItemLink);
    }

    public final void abort(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"abort", (Object)transaction);
        }
        this.getLink().abortRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"abort");
        }
    }

    public final void commitExternal(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitExternal", (Object)transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitExternal");
        }
    }

    public final void commitInternal(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInternal", (Object)transaction);
        }
        this.getLink().commitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInternal");
        }
    }

    public final int getPersistableSizeApproximation(int n) {
        int n2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistableSizeApproximation", (Object)new Integer(n));
        }
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 500;
                break;
            }
            default: {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{new Integer(n)}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistableSizeApproximation", (Object)new Integer(n2));
        }
        return n2;
    }

    public Task.Type getTaskType() {
        return Task.Type.REMOVE;
    }

    public boolean isDeleteOfPersistentRepresentation() {
        return true;
    }

    public final boolean isRemoveFromList(LinkOwner linkOwner) {
        LinkOwner linkOwner2;
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRemoveFromList");
        }
        boolean bl2 = bl = (linkOwner2 = this.getLink().getOwningStreamLink()) == linkOwner;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isRemoveFromList", (Object)new Boolean(bl));
        }
        return bl;
    }

    public final void persist(BatchingContext batchingContext, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, new Integer(n)});
        }
        switch (n) {
            case 13: 
            case 14: 
            case 15: {
                batchingContext.delete(this.getPersistable());
                break;
            }
            case 11: 
            case 12: {
                Persistable persistable = this.getPersistable();
                persistable.setLogicallyDeleted(true);
                batchingContext.updateLogicalDeleteAndXID(persistable);
                break;
            }
            case 16: 
            case 17: {
                Persistable persistable = this.getPersistable();
                persistable.setLogicallyDeleted(false);
                batchingContext.updateLogicalDeleteAndXID(persistable);
                break;
            }
            default: {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{new Integer(n)}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persist");
        }
    }

    public final void postAbort(Transaction transaction) {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postAbort", (Object)transaction);
        }
        if (null == (abstractItem = this.getItem())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            abstractItem.eventPostRollbackRemove(transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postAbort");
        }
    }

    public final void postCommit(Transaction transaction) {
        AbstractItem abstractItem;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postCommit", (Object)transaction);
        }
        if (null == (abstractItem = this.getItem())) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            abstractItem.eventPostCommitRemove(transaction);
        }
        this.getLink().postCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postCommit");
        }
    }

    public final void preCommit(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"preCommit", (Object)transaction);
        }
        this.getItem();
        this.getLink().preCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"preCommit");
        }
    }

    public void printOn(FormatBuffer formatBuffer) {
        formatBuffer.append("RemoveTask; link=");
        formatBuffer.append(Long.toString(this.getLink().getID()));
    }
}

