/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.pmi;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentor;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import javax.management.ObjectName;

public class MSInstrumentation
implements StatisticActionListener {
    private static TraceComponent tc = SibTr.register((Class)MSInstrumentation.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.pmi.MessageStoreStats");
    public static final int CACHE_ADD = 1;
    public static final int CACHE_ADD_NS = 2;
    public static final int CACHE_UPDATE = 3;
    public static final int CACHE_UPDATE_NS = 4;
    public static final int CACHE_REMOVE = 5;
    public static final int CACHE_REMOVE_NS = 6;
    public static final int CACHE_RESTORE = 7;
    public static final int CACHE_CURR_COUNT = 8;
    public static final int CACHE_CURR_COUNT_NS = 9;
    public static final int CACHE_CURR_SIZE = 10;
    public static final int CACHE_CURR_SIZE_NS = 11;
    public static final int CACHE_TOTAL_COUNT = 12;
    public static final int CACHE_TOTAL_COUNT_NS = 13;
    public static final int CACHE_TOTAL_SIZE = 14;
    public static final int CACHE_TOTAL_SIZE_NS = 15;
    public static final int CACHE_DISCARD_COUNT = 16;
    public static final int CACHE_DISCARD_COUNT_NS = 17;
    public static final int CACHE_DISCARD_SIZE = 18;
    public static final int CACHE_DISCARD_SIZE_NS = 19;
    public static final int CACHE_REFUSAL_COUNT = 20;
    public static final int CACHE_REFUSAL_COUNT_NS = 21;
    public static final int CACHE_STREAMS_SPILLING = 22;
    public static final int SPILL_REQUEST_SIZE = 23;
    public static final int SPILL_BATCH_SIZE = 24;
    public static final int SPILL_AVOIDANCE_ITEMS = 25;
    public static final int SPILL_AVOIDANCE_SIZE = 26;
    public static final int DISPATCHER_REQUEST_SIZE = 27;
    public static final int DISPATCHER_BATCH_SIZE = 28;
    public static final int DISPATCHER_CANCELLATIONS = 29;
    public static final int DISPATCHER_AVOIDANCE_ITEMS = 30;
    public static final int DISPATCHER_AVOIDANCE_SIZE = 31;
    public static final int EXPIRY_INDEX_SIZE = 32;
    public static final int TRAN_LOCAL_START = 33;
    public static final int TRAN_LOCAL_ABORT = 34;
    public static final int TRAN_LOCAL_COMMIT = 35;
    public static final int TRAN_GLOBAL_START = 36;
    public static final int TRAN_GLOBAL_IN_DOUBT = 37;
    public static final int TRAN_GLOBAL_ABORT = 38;
    public static final int TRAN_GLOBAL_COMMIT = 39;
    public static final int JDBC_CONN_OPEN = 40;
    public static final int JDBC_TRAN_COMPLETE = 41;
    public static final int JDBC_TRAN_ABORT = 42;
    public static final int JDBC_TRAN_TIME = 43;
    public static final int JDBC_OP_ITEM_INSERT = 44;
    public static final int JDBC_OP_ITEM_DELETE = 45;
    public static final int JDBC_OP_ITEM_UPDATE = 46;
    public static final int JDBC_OP_ITEM_INSERT_BATCHES = 47;
    public static final int JDBC_OP_ITEM_DELETE_BATCHES = 48;
    public static final int JDBC_OP_ITEM_UPDATE_BATCHES = 49;
    public static final int JDBC_OP_TRAN_INSERT = 50;
    public static final int JDBC_OP_TRAN_DELETE = 51;
    public static final int JDBC_OP_TRAN_UPDATE = 52;
    public static final int JDBC_OP_TRAN_INSERT_BATCHES = 53;
    public static final int JDBC_OP_TRAN_DELETE_BATCHES = 54;
    public static final int JDBC_OP_TRAN_UPDATE_BATCHES = 55;
    private static final int MAX_STATISTICS = 55;
    private static final String xmlTemplatePath = "/com/ibm/ws/sib/msgstore/pmi/static/";
    private static final String groupFilename = "MessageStore.xml";
    private static final String cacheFilename = "MessageStoreCache.xml";
    private static final String expiryFilename = "MessageStoreExpiry.xml";
    private static final String dataStoreFilename = "MessageStoreDataStore.xml";
    private static final String transactionsFilename = "MessageStoreTransactions.xml";
    protected SPIStatistic[] spiStat;
    protected MSInstrumentor[] instrumentor;
    private boolean isRunningInWas;
    private StatsGroup statsGroup;
    private StatsInstance cacheStats;
    private StatsInstance expiryStats;
    private StatsInstance dataStoreStats;
    private StatsInstance transactionStats;

    public MSInstrumentation() {
        this(null);
    }

    /*
     * Unable to fully structure code
     */
    public MSInstrumentation(JsMessagingEngine var1_1) {
        block19: {
            block17: {
                block18: {
                    super();
                    this.spiStat = new SPIStatistic[56];
                    this.instrumentor = new MSInstrumentor[56];
                    this.isRunningInWas = false;
                    this.statsGroup = null;
                    this.cacheStats = null;
                    this.expiryStats = null;
                    this.dataStoreStats = null;
                    this.transactionStats = null;
                    if (MSInstrumentation.tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)MSInstrumentation.tc, (String)"<init>", (Object)("ME=" + var1_1));
                    }
                    var2_2 = null;
                    var3_3 = "default";
                    if (var1_1 != null) {
                        var2_2 = var1_1.getStatsGroup();
                        var3_3 = var1_1.getName();
                    }
                    for (var4_4 = 0; var4_4 <= 55; ++var4_4) {
                        this.spiStat[var4_4] = null;
                    }
                    var4_5 = JsAdminService.getInstance();
                    if (var4_5 != null) {
                        this.isRunningInWas = var4_5.isInitialized();
                    }
                    if (!this.isRunningInWas) break block17;
                    if (!StatsFactory.isPMIEnabled()) break block18;
                    try {
                        this.statsGroup = var2_2 != null ? StatsFactory.createStatsGroup((String)MSInstrumentation.nls.getString("MessageStoreStats.group"), (String)"/com/ibm/ws/sib/msgstore/pmi/static/MessageStore.xml", (StatsGroup)var2_2, (ObjectName)null) : StatsFactory.createStatsGroup((String)(MSInstrumentation.nls.getString("MessageStoreStats.group") + " " + var3_3), (String)"/com/ibm/ws/sib/msgstore/pmi/static/MessageStore.xml", (ObjectName)null);
                        if (MSInstrumentation.tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)("PMI enabled. Stats group created OK for ME=" + var3_3));
                        }
                        this.cacheStats = StatsFactory.createStatsInstance((String)MSInstrumentation.nls.getString("MessageStoreStats.cache"), (String)"/com/ibm/ws/sib/msgstore/pmi/static/MessageStoreCache.xml", (StatsGroup)this.statsGroup, (ObjectName)null, (StatisticActionListener)this);
                        if (MSInstrumentation.tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)"PMI enabled. Stats instance (Cache) created successfully.");
                        }
                        this.expiryStats = StatsFactory.createStatsInstance((String)MSInstrumentation.nls.getString("MessageStoreStats.expiry"), (String)"/com/ibm/ws/sib/msgstore/pmi/static/MessageStoreExpiry.xml", (StatsGroup)this.statsGroup, (ObjectName)null, (StatisticActionListener)this);
                        if (MSInstrumentation.tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)"PMI enabled. Stats instance (Expiry) created successfully.");
                        }
                        this.dataStoreStats = StatsFactory.createStatsInstance((String)MSInstrumentation.nls.getString("MessageStoreStats.datastore"), (String)"/com/ibm/ws/sib/msgstore/pmi/static/MessageStoreDataStore.xml", (StatsGroup)this.statsGroup, (ObjectName)null, (StatisticActionListener)this);
                        if (MSInstrumentation.tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)"PMI enabled. Stats instance (DataStore) created successfully.");
                        }
                        this.transactionStats = StatsFactory.createStatsInstance((String)MSInstrumentation.nls.getString("MessageStoreStats.transactions"), (String)"/com/ibm/ws/sib/msgstore/pmi/static/MessageStoreTransactions.xml", (StatsGroup)this.statsGroup, (ObjectName)null, (StatisticActionListener)this);
                        if (!MSInstrumentation.tc.isDebugEnabled()) ** GOTO lbl64
                        SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)"PMI enabled. Stats instance (Transactions) created successfully.");
                    }
                    catch (StatsFactoryException var5_6) {
                        FFDCFilter.processException((Throwable)var5_6, (String)"MSInstrumentation.MSInstrumentation", (String)"001", (Object)this);
                        SibTr.exception((TraceComponent)MSInstrumentation.tc, (Exception)var5_6);
                        throw new MessageStoreRuntimeException(var5_6);
                    }
                }
                if (!MSInstrumentation.tc.isDebugEnabled()) break block19;
                SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)"PMI not enabled in WAS. No stats instance created.");
                break block19;
            }
            if (MSInstrumentation.tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)MSInstrumentation.tc, (String)"Not running in WAS. Simulating stats instance.");
            }
            block7: for (var5_7 = 1; var5_7 <= 55; ++var5_7) {
                switch (var5_7) {
                    case 43: {
                        this.statisticCreated((SPIStatistic)new TimeStatisticImpl(var5_7));
                        continue block7;
                    }
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 30: 
                    case 31: {
                        this.statisticCreated((SPIStatistic)new AverageStatisticImpl(var5_7));
                        continue block7;
                    }
                    default: {
                        this.statisticCreated((SPIStatistic)new CountStatisticImpl(var5_7));
                    }
                }
            }
        }
        if (MSInstrumentation.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)MSInstrumentation.tc, (String)"<init>");
        }
    }

    public void terminate() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"terminate");
        }
        if (this.isRunningInWas && StatsFactory.isPMIEnabled()) {
            try {
                if (this.cacheStats != null) {
                    StatsFactory.removeStatsInstance((StatsInstance)this.cacheStats);
                }
                if (this.expiryStats != null) {
                    StatsFactory.removeStatsInstance((StatsInstance)this.expiryStats);
                }
                if (this.dataStoreStats != null) {
                    StatsFactory.removeStatsInstance((StatsInstance)this.dataStoreStats);
                }
                if (this.transactionStats != null) {
                    StatsFactory.removeStatsInstance((StatsInstance)this.transactionStats);
                }
                if (this.statsGroup != null) {
                    StatsFactory.removeStatsGroup((StatsGroup)this.statsGroup);
                }
            }
            catch (StatsFactoryException statsFactoryException) {
                FFDCFilter.processException((Throwable)statsFactoryException, (String)"MSInstrumentation.terminate", (String)"001", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)statsFactoryException));
                throw new MessageStoreRuntimeException(statsFactoryException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    public void add(int n, long l) {
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            sPIAverageStatistic.add(l);
        }
    }

    public void add(int n, long l, long l2) {
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            sPIAverageStatistic.add(l, l2);
        }
    }

    public void set(int n, long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            sPIAverageStatistic.set(l, l2, l3, l4, (double)l5, l6, l7);
        }
    }

    public void decrement(int n) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.decrement();
        }
    }

    public void decrement(int n, long l) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.decrement(l);
        }
    }

    public void decrement(int n, long l, long l2) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.decrement(l, l2);
        }
    }

    public long getCount(int n) {
        long l = 0L;
        SPIStatistic sPIStatistic = this.getStatistic(n);
        if (sPIStatistic != null) {
            if (sPIStatistic instanceof SPIAverageStatistic) {
                SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)sPIStatistic;
                l = sPIAverageStatistic.getCount();
            } else if (sPIStatistic instanceof SPICountStatistic) {
                SPICountStatistic sPICountStatistic = (SPICountStatistic)sPIStatistic;
                l = sPICountStatistic.getCount();
            }
        }
        return l;
    }

    public long getTotal(int n) {
        long l = 0L;
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            l = sPIAverageStatistic.getTotal();
        }
        return l;
    }

    public long getMin(int n) {
        long l = 0L;
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            l = sPIAverageStatistic.getMin();
        }
        return l;
    }

    public long getMax(int n) {
        long l = 0L;
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            l = sPIAverageStatistic.getMax();
        }
        return l;
    }

    public double getMean(int n) {
        double d = 0.0;
        SPIAverageStatistic sPIAverageStatistic = (SPIAverageStatistic)this.getStatistic(n);
        if (sPIAverageStatistic != null) {
            d = sPIAverageStatistic.getMean();
        }
        return d;
    }

    private SPIStatistic getStatistic(int n) {
        SPIStatistic sPIStatistic = null;
        if (n > 0 && n <= 55) {
            sPIStatistic = this.spiStat[n];
        }
        return sPIStatistic;
    }

    public void increment(int n) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.increment();
        }
    }

    public void increment(int n, long l) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.increment(l);
        }
    }

    public void increment(int n, long l, long l2) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.increment(l, l2);
        }
    }

    public boolean isEnabled(int n) {
        boolean bl = false;
        if (n > 0 && n <= 55) {
            bl = this.spiStat[n] != null;
        }
        return bl;
    }

    public boolean registerInstrumentor(MSInstrumentor mSInstrumentor, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerInstrumentor", (Object)("id=" + n + " instr=" + mSInstrumentor));
        }
        boolean bl = false;
        if (n >= 0 && n <= 55) {
            this.instrumentor[n] = mSInstrumentor;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerInstrumentor", (Object)("reply=" + bl));
        }
        return bl;
    }

    public void setCount(int n, long l) {
        SPICountStatistic sPICountStatistic = (SPICountStatistic)this.getStatistic(n);
        if (sPICountStatistic != null) {
            sPICountStatistic.setCount(l);
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"statisticCreated", (Object)(sPIStatistic == null ? "null" : "id=" + sPIStatistic.getId()));
        }
        if (sPIStatistic != null) {
            int n = sPIStatistic.getId();
            this.spiStat[n] = sPIStatistic;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"statisticCreated");
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (n > 0 && n <= 55 && this.instrumentor[n] != null) {
            this.instrumentor[n].requestStatUpdate(n);
        }
    }

    public void dump() {
        System.out.println("---------- Statistics for MessageStore -----------");
        for (int i = 1; i <= 55; ++i) {
            this.updateStatisticOnRequest(i);
            System.out.println(this.getStatistic(i).toString());
        }
        System.out.println("--------------- End of Statistics ----------------");
    }
}

