/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.lock;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.MEOwnerTable;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockOwner;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockTimeouts;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockingDatasource;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.SQLException;
import java.util.List;

public class DBLockingThread
extends Thread {
    private static TraceComponent tc = SibTr.register((Class)DBLockingThread.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final DBLockingDatasource _datasource;
    private final MEOwnerTable _meTable;
    private final DBLockOwner _lockOwner;
    private final DBLockTimeouts _timeouts;
    private final JsMessagingEngine _me;
    private final boolean _retryThread;
    private boolean _checkedDataStore = false;
    private boolean _lockAquired = false;
    private boolean _keepTrying = true;
    private ConnectionWrapper _conn;

    public DBLockingThread(JsMessagingEngine jsMessagingEngine, DBLockingDatasource dBLockingDatasource, MEOwnerTable mEOwnerTable, DBLockTimeouts dBLockTimeouts, DBLockOwner dBLockOwner, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DBLockingThread", (Object)("ME=" + jsMessagingEngine + ", Datasource=" + dBLockingDatasource + ", METable=" + mEOwnerTable + ", LockOwner=" + dBLockOwner + ", RetryThread=" + bl));
        }
        this._me = jsMessagingEngine;
        this._datasource = dBLockingDatasource;
        this._meTable = mEOwnerTable;
        this._timeouts = dBLockTimeouts;
        this._lockOwner = dBLockOwner;
        this._retryThread = bl;
        this.setName("sib.LockThread");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DBLockingThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block17: {
            if (this._me != null) {
                SibTr.push((Object)this._me);
            }
            if (DBLockingThread.tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)DBLockingThread.tc, (String)"run");
            }
            this._keepTrying = this.lockAndUpdateTable();
            if (!this._keepTrying) break block17;
            try {
                this._conn = this._datasource.getLockConnection(false, false);
                if (this._conn != null && (var1_1 = this.aquireAndNotifyLock())) {
                    while (this._keepTrying) {
                        this._keepTrying = this.waitAndRefreshLock();
                    }
                }
                var3_4 = null;
                if (this._conn == null) break block17;
                ** GOTO lbl47
            }
            catch (SQLException var1_2) {
                FFDCFilter.processException((Throwable)var1_2, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.run", (String)"1:140:1.4.2.1", (Object)this);
                if (DBLockingThread.tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)DBLockingThread.tc, (String)"Unexpected exception caught getting table lock!", (Object)var1_2);
                }
                SibTr.error((TraceComponent)DBLockingThread.tc, (String)"STARTUP_EXCEPTION_SIMS0002", (Object)new Object[]{var1_2});
                var3_5 = null;
                if (this._conn == null) break block17;
                try {
                    this._conn.setTransactionRollbackOnly();
                    this._conn.close();
                }
                catch (SQLException var4_8) {
                    FFDCFilter.processException((Throwable)var4_8, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.run", (String)"1:160:1.4.2.1", (Object)this);
                    if (DBLockingThread.tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)DBLockingThread.tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)var4_8);
                    }
                    break block17;
                }
            }
            {
                catch (Throwable var2_10) {
                    var3_6 = null;
                    if (this._conn == null) throw var2_10;
                    ** try [egrp 2[TRYBLOCK] [4 : 165->182)] { 
lbl39:
                    // 1 sources

                    this._conn.setTransactionRollbackOnly();
                    this._conn.close();
                    throw var2_10;
lbl42:
                    // 1 sources

                    catch (SQLException var4_9) {
                        FFDCFilter.processException((Throwable)var4_9, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.run", (String)"1:160:1.4.2.1", (Object)this);
                        if (DBLockingThread.tc.isEventEnabled() == false) throw var2_10;
                        SibTr.event((TraceComponent)DBLockingThread.tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)var4_9);
                    }
                    throw var2_10;
                }
lbl47:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 165->182)] { 
lbl48:
                // 1 sources

                this._conn.setTransactionRollbackOnly();
                this._conn.close();
lbl51:
                // 1 sources

                catch (SQLException var4_7) {}
                FFDCFilter.processException((Throwable)var4_7, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.run", (String)"1:160:1.4.2.1", (Object)this);
                if (!DBLockingThread.tc.isEventEnabled()) break block17;
                SibTr.event((TraceComponent)DBLockingThread.tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)var4_7);
            }
        }
        var1_3 = this;
        synchronized (var1_3) {
            this.notify();
            ** if (!DBLockingThread.tc.isEntryEnabled()) goto lbl61
        }
lbl-1000:
        // 1 sources

        {
            SibTr.exit((TraceComponent)DBLockingThread.tc, (String)"run");
        }
lbl61:
        // 2 sources

        if (this._me == null) return;
        SibTr.pop();
    }

    public synchronized boolean hasCheckedDataStore() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasCheckedDataStore");
            SibTr.exit((TraceComponent)tc, (String)"hasCheckedDataStore", (Object)("return=" + this._checkedDataStore));
        }
        return this._checkedDataStore;
    }

    public synchronized boolean isLockAquired() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLockAquired");
            SibTr.exit((TraceComponent)tc, (String)"isLockAquired", (Object)("return=" + this._lockAquired));
        }
        return this._lockAquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTrying() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopTrying");
        }
        this._keepTrying = false;
        DBLockingThread dBLockingThread = this;
        synchronized (dBLockingThread) {
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopTrying");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean lockAndUpdateTable() {
        boolean bl;
        block63: {
            block62: {
                Object object;
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"lockAndUpdateTable");
                }
                bl = false;
                boolean bl2 = false;
                do {
                    this._conn = null;
                    try {
                        this._conn = this._datasource.getLockConnection(false, false);
                        if (this._conn == null) continue;
                        this._meTable.lockTable(this._conn);
                        bl2 = false;
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:271:1.4.2.1", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"SQLException caught getting initial lock! Retrying.", (Object)sQLException);
                        }
                        bl2 = true;
                        if (this._conn != null) continue;
                        try {
                            object = this;
                            synchronized (object) {
                                this.wait(this._timeouts.getLockWaitTimeout());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (bl2 && this._keepTrying);
                if (this._conn == null || !this._keepTrying) break block62;
                List list = this._meTable.readOwningME(this._conn);
                if (list == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"No rows found in DB before lock.");
                    }
                    SibTr.info((TraceComponent)tc, (String)"DBLOCK_NO_OWNER_SIMS1543");
                    this._meTable.insertOwningME(this._conn, this._lockOwner);
                    bl = true;
                    break block62;
                }
                if (list.size() > 1) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"More than one row found in DB before lock.");
                    }
                    SibTr.error((TraceComponent)tc, (String)"DBLOCK_MULTIPLE_OWNERS_SIMS1544");
                    object = this;
                    synchronized (object) {
                        this._checkedDataStore = true;
                    }
                    bl = false;
                    break block62;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"One row found in DB before lock.");
                }
                object = (DBLockOwner)list.get(0);
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_ONE_OWNER_SIMS1545", (Object)new Object[]{((DBLockOwner)object).getMeUUID(), ((DBLockOwner)object).getIncUUID()});
                if (this._lockOwner.getMeUUID().equals(((DBLockOwner)object).getMeUUID())) {
                    if (this._retryThread && !this._lockOwner.getIncUUID().equals(((DBLockOwner)object).getIncUUID())) {
                        SibTr.info((TraceComponent)tc, (String)"DBLOCK_MEUUID_DOESNT_MATCH_SIMS1535", (Object)new Object[]{this._lockOwner.getMeUUID() + ", INC_UUID=" + this._lockOwner.getIncUUID(), ((DBLockOwner)object).getMeUUID() + ", INC_UUID(DB)=" + ((DBLockOwner)object).getIncUUID()});
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Different ME incarnation id found in lock table during lock refresh!", (Object)("INC_UUID=" + this._lockOwner.getIncUUID() + ", INC_UUID(DB)=" + ((DBLockOwner)object).getIncUUID()));
                        }
                        DBLockingThread dBLockingThread = this;
                        synchronized (dBLockingThread) {
                            this._checkedDataStore = true;
                        }
                        bl = false;
                        break block62;
                    }
                    if (((DBLockOwner)object).getVersion() == this._lockOwner.getVersion()) {
                        if (!this._retryThread) {
                            this._meTable.updateOwningME(this._conn, this._lockOwner);
                        }
                        bl = true;
                        break block62;
                    }
                    SibTr.info((TraceComponent)tc, (String)"DBLOCK_VERSION_DOESNT_MATCH_SIMS1536", (Object)new Object[]{new Integer(this._lockOwner.getVersion()), new Integer(((DBLockOwner)object).getVersion())});
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Different ME version found in lock table!", (Object)("ME Version=" + this._lockOwner.getVersion() + ", ME Version(DB)=" + ((DBLockOwner)object).getVersion()));
                    }
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._checkedDataStore = true;
                    }
                    bl = false;
                    break block62;
                }
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_MEUUID_DOESNT_MATCH_SIMS1535", (Object)new Object[]{this._lockOwner.getMeUUID(), ((DBLockOwner)object).getMeUUID()});
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Different ME unique id found in lock table!", (Object)("ME_UUID=" + this._lockOwner.getMeUUID() + ", ME_UUID(DB)=" + ((DBLockOwner)object).getMeUUID()));
                }
                DBLockingThread dBLockingThread = this;
                synchronized (dBLockingThread) {
                    this._checkedDataStore = true;
                }
                bl = false;
            }
            Object var13_19 = null;
            if (this._conn == null) break block63;
            try {
                if (this._keepTrying && bl) {
                    this._conn.close();
                    break block63;
                }
                this._conn.setTransactionRollbackOnly();
                this._conn.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:463:1.4.2.1", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)sQLException);
                }
                break block63;
            }
            {
                catch (StaleConnectionException staleConnectionException) {
                    FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:414:1.4.2.1", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"StaleConnectionException caught getting table lock!", (Object)((Object)staleConnectionException));
                    }
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._checkedDataStore = false;
                    }
                    bl = false;
                    Object var13_20 = null;
                    if (this._conn == null) break block63;
                    try {
                        if (this._keepTrying && bl) {
                            this._conn.close();
                            break block63;
                        }
                        this._conn.setTransactionRollbackOnly();
                        this._conn.close();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:463:1.4.2.1", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)sQLException);
                        }
                        break block63;
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:428:1.4.2.1", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"SQLException caught inspecting lock table!", (Object)sQLException);
                    }
                    SibTr.error((TraceComponent)tc, (String)"STARTUP_EXCEPTION_SIMS0002", (Object)new Object[]{sQLException});
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._checkedDataStore = true;
                    }
                    bl = false;
                    Object var13_21 = null;
                    if (this._conn == null) break block63;
                    try {
                        if (this._keepTrying && bl) {
                            this._conn.close();
                            break block63;
                        }
                        this._conn.setTransactionRollbackOnly();
                        this._conn.close();
                    }
                    catch (SQLException sQLException2) {
                        FFDCFilter.processException((Throwable)sQLException2, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:463:1.4.2.1", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)sQLException2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block64: {
                    Object var13_22 = null;
                    if (this._conn != null) {
                        try {
                            if (this._keepTrying && bl) {
                                this._conn.close();
                            } else {
                                this._conn.setTransactionRollbackOnly();
                                this._conn.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.lockAndUpdateTable", (String)"1:463:1.4.2.1", (Object)this);
                            if (!tc.isEventEnabled()) break block64;
                            SibTr.event((TraceComponent)tc, (String)"Unexpected SQLException caught closing lock connection!", (Object)sQLException);
                        }
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lockAndUpdateTable", (Object)("return=" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean aquireAndNotifyLock() {
        boolean bl;
        Object object;
        block43: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"aquireAndNotifyLock");
            }
            try {
                this._meTable.lockTable(this._conn);
                List list = this._meTable.readOwningME(this._conn);
                if (list == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"No rows found in DB after lock.");
                    }
                    object = this;
                    synchronized (object) {
                        this._checkedDataStore = true;
                        this._lockAquired = false;
                        break block43;
                    }
                }
                if (list.size() > 1) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"More than one row found in DB after lock.");
                    }
                    object = this;
                    synchronized (object) {
                        this._checkedDataStore = true;
                        this._lockAquired = false;
                        break block43;
                    }
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"One row found in DB after lock.");
                }
                object = (DBLockOwner)list.get(0);
                if (this._lockOwner.getMeUUID().equals(((DBLockOwner)object).getMeUUID())) {
                    if (this._lockOwner.getIncUUID().equals(((DBLockOwner)object).getIncUUID())) {
                        DBLockingThread dBLockingThread = this;
                        synchronized (dBLockingThread) {
                            this._checkedDataStore = true;
                            this._lockAquired = true;
                            break block43;
                        }
                    }
                    SibTr.info((TraceComponent)tc, (String)"DBLOCK_MEUUID_DOESNT_MATCH_SIMS1535", (Object)new Object[]{this._lockOwner.getMeUUID() + ", INC_UUID=" + this._lockOwner.getIncUUID(), ((DBLockOwner)object).getMeUUID() + ", INC_UUID(DB)=" + ((DBLockOwner)object).getIncUUID()});
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Different ME incarnation id found in lock table after attempted lock!", (Object)("INC_UUID=" + this._lockOwner.getIncUUID() + ", INC_UUID(DB)=" + ((DBLockOwner)object).getIncUUID()));
                    }
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._checkedDataStore = true;
                        this._lockAquired = false;
                        break block43;
                    }
                }
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_MEUUID_DOESNT_MATCH_SIMS1535", (Object)new Object[]{this._lockOwner.getMeUUID(), ((DBLockOwner)object).getMeUUID()});
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Different ME unique id found in lock table after attempted lock!", (Object)("ME_UUID=" + this._lockOwner.getMeUUID() + ", ME_UUID(DB)=" + ((DBLockOwner)object).getMeUUID()));
                }
                DBLockingThread dBLockingThread = this;
                synchronized (dBLockingThread) {
                    this._checkedDataStore = true;
                    this._lockAquired = false;
                }
            }
            catch (StaleConnectionException staleConnectionException) {
                FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.aquireAndNotifyLock", (String)"1:571:1.4.2.1", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"StaleConnectionException caught getting table lock!", (Object)((Object)staleConnectionException));
                }
                object = this;
                synchronized (object) {
                    this._checkedDataStore = false;
                    this._lockAquired = false;
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.aquireAndNotifyLock", (String)"1:585:1.4.2.1", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"SQLException caught getting table lock!", (Object)sQLException);
                }
                SibTr.error((TraceComponent)tc, (String)"STARTUP_EXCEPTION_SIMS0002", (Object)new Object[]{sQLException});
                object = this;
                synchronized (object) {
                    this._checkedDataStore = true;
                    this._lockAquired = false;
                }
            }
        }
        boolean bl2 = bl = this._lockAquired && this._keepTrying;
        if (bl) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"DB Lock is being released due to failure or system request.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"aquireAndNotifyLock", (Object)("return=" + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitAndRefreshLock() {
        boolean bl;
        block42: {
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"waitAndRefreshLock");
            }
            try {
                object = this;
                synchronized (object) {
                    this.wait(this._timeouts.getKeepAliveWait());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this._keepTrying) {
                try {
                    object = null;
                    if (this._conn != null) {
                        object = this._meTable.readOwningME(this._conn);
                    }
                    if (object != null) {
                        if (object.size() > 1) {
                            DBLockingThread dBLockingThread = this;
                            synchronized (dBLockingThread) {
                                this._lockAquired = false;
                                break block42;
                            }
                        }
                        DBLockOwner dBLockOwner = (DBLockOwner)object.get(0);
                        if (this._lockOwner.getMeUUID().equals(dBLockOwner.getMeUUID())) {
                            if (this._lockOwner.getIncUUID().equals(dBLockOwner.getIncUUID())) {
                                DBLockingThread dBLockingThread = this;
                                synchronized (dBLockingThread) {
                                    this._lockAquired = true;
                                    break block42;
                                }
                            }
                            SibTr.info((TraceComponent)tc, (String)"DBLOCK_MEUUID_DOESNT_MATCH_SIMS1535", (Object)new Object[]{this._lockOwner.getMeUUID() + ", INC_UUID=" + this._lockOwner.getIncUUID(), dBLockOwner.getMeUUID() + ", INC_UUID(DB)=" + dBLockOwner.getIncUUID()});
                            if (tc.isEventEnabled()) {
                                SibTr.event((TraceComponent)tc, (String)"Different ME incarnation id found in lock table during lock refresh!", (Object)("INC_UUID=" + this._lockOwner.getIncUUID() + ", INC_UUID(DB)=" + dBLockOwner.getIncUUID()));
                            }
                            DBLockingThread dBLockingThread = this;
                            synchronized (dBLockingThread) {
                                this._lockAquired = false;
                                break block42;
                            }
                        }
                        SibTr.info((TraceComponent)tc, (String)"DBLOCK_MEUUID_DOESNT_MATCH_SIMS1535", (Object)new Object[]{this._lockOwner.getMeUUID(), dBLockOwner.getMeUUID()});
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Different ME unique id found in lock table during lock refresh!", (Object)("ME_UUID=" + this._lockOwner.getMeUUID() + ", ME_UUID(DB)=" + dBLockOwner.getMeUUID()));
                        }
                        DBLockingThread dBLockingThread = this;
                        synchronized (dBLockingThread) {
                            this._lockAquired = false;
                            break block42;
                        }
                    }
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._lockAquired = false;
                    }
                }
                catch (StaleConnectionException staleConnectionException) {
                    FFDCFilter.processException((Throwable)staleConnectionException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.waitAndRefreshLock", (String)"1:714:1.4.2.1", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"StaleConnectionException caught keeping lock active!", (Object)((Object)staleConnectionException));
                    }
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._checkedDataStore = false;
                        this._lockAquired = false;
                    }
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread.waitAndRefreshLock", (String)"1:728:1.4.2.1", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Unexpected SQLException caught keeping lock active!", (Object)sQLException);
                    }
                    SibTr.error((TraceComponent)tc, (String)"STARTUP_EXCEPTION_SIMS0002", (Object)new Object[]{sQLException});
                    DBLockingThread dBLockingThread = this;
                    synchronized (dBLockingThread) {
                        this._lockAquired = false;
                    }
                }
            }
        }
        boolean bl2 = bl = this._lockAquired && this._keepTrying;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitAndRefreshLock", (Object)("return=" + bl));
        }
        return bl;
    }
}

