/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.lock;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.MEOwnerTable;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockManagerThread;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockTimeouts;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockingDatasource;
import com.ibm.ws.sib.utils.ras.SibTr;

public class DBLockManager {
    private static TraceComponent tc = SibTr.register((Class)DBLockManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private DBLockManagerThread _lockManagerThread;
    private DBLockTimeouts _timeouts;
    private DBLockingDatasource _datasource;
    private MEOwnerTable _meTable;
    private MessageStoreImpl _ms;
    private boolean _enabled;

    public DBLockManager(MessageStoreImpl messageStoreImpl, DatasourceWrapper datasourceWrapper, MEOwnerTable mEOwnerTable) {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DBLockManager", (Object)("MS=" + messageStoreImpl + ", Datasource=" + datasourceWrapper + ", METable=" + mEOwnerTable));
        }
        boolean bl = this._enabled = Boolean.valueOf(string = messageStoreImpl.getProperty("jdbcDisableDataStoreLock", "false")) == false;
        if (this._enabled) {
            this._ms = messageStoreImpl;
            this._meTable = mEOwnerTable;
            this._timeouts = new DBLockTimeouts(this._ms);
            if (datasourceWrapper instanceof DBLockingDatasource) {
                this._datasource = (DBLockingDatasource)((Object)datasourceWrapper);
                this._datasource.disable();
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"DBLockManager has been disabled through use of jdbcDisableDataStoreLock Property.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DBLockManager");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        if (this._enabled) {
            this._lockManagerThread = new DBLockManagerThread(this._ms, this._datasource, this._meTable, this._timeouts);
            this._lockManagerThread.start();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this._enabled && this._lockManagerThread != null) {
            this._lockManagerThread.stopTrying();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }
}

