/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ce.cm.ConnectionWaitTimeoutException;
import com.ibm.websphere.rsadapter.WSCallHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.WASConfiguration;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.ConnectionUnavailableException;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapper;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapperStateException;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.CustomComponentMetaData;
import com.ibm.ws.sib.msgstore.persistence.impl.DatabaseMetaDataExtensions;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockingDatasource;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.rsadapter.WSOptimizedDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public final class WASConnectionManagerWrapper
implements DatasourceWrapper,
DBLockingDatasource {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)WASConnectionManagerWrapper.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int STOPPED = 0;
    private static final int STARTED = 1;
    private static final int DISABLED = 2;
    private final String datasourceJndiName;
    private final String authAlias;
    private final MessageStoreImpl msi;
    private final MSInstrumentation instrument;
    private final WSOptimizedDataSource enlistedDataSource;
    private final WSOptimizedDataSource unenlistedDataSource;
    private int staleConnectionRetryCount;
    private long staleConnectionRetryDelay;
    private long disabledDatasourceWaitTimeout;
    private volatile int _state = 0;

    public WASConnectionManagerWrapper(MessageStoreImpl messageStoreImpl, WASConfiguration wASConfiguration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{messageStoreImpl, wASConfiguration});
        }
        if (wASConfiguration.getDatasourceJndiName() == null) {
            throw new IllegalArgumentException(nls.getString("JNDI_NAME_NOT_SPECIFIED_SIMS1514"));
        }
        this.datasourceJndiName = wASConfiguration.getDatasourceJndiName();
        this.authAlias = wASConfiguration.getAuthenticationAlias();
        this.msi = messageStoreImpl;
        this.instrument = messageStoreImpl._getInstrumentation();
        String string = messageStoreImpl.getProperty("jdbcDisabledDatasourceWaitTimeout", "200");
        this.disabledDatasourceWaitTimeout = Long.parseLong(string);
        String string2 = messageStoreImpl.getProperty("jdbcResAuthForConnections", "Container");
        int n = 0;
        if (string2.equals("Application")) {
            n = 1;
        }
        this.unenlistedDataSource = (WSOptimizedDataSource)this.getDataSource("Websphere Platform Messaging Unsharable Connection Factory", "SIBUnshareableConnectionFactory", n, 1);
        this.enlistedDataSource = (WSOptimizedDataSource)this.getDataSource("Websphere Platform Messaging Sharable Connection Factory", "SIBShareableConnectionFactory", n, 0);
        this.getStaleConnectionConfig();
        this._state = 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnection(boolean bl) throws SQLException, DatasourceWrapperStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnection", (Object)("autoCommit=" + bl));
        }
        if (this._state == 2) {
            object = this;
            synchronized (object) {
                if (this._state == 2) {
                    try {
                        this.wait(this.disabledDatasourceWaitTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._state == 2) {
                        ConnectionUnavailableException connectionUnavailableException = new ConnectionUnavailableException("Connection cannot be provided as Datasource has been disabled!");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been disabled!", (Object)connectionUnavailableException);
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw connectionUnavailableException;
                    }
                    if (this._state == 0) {
                        DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw datasourceWrapperStateException;
                    }
                }
            }
        }
        object = this.getLockConnection(bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection", (Object)("return=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnection(boolean bl, long l) throws SQLException, DatasourceWrapperStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnection", (Object)("autoCommit=" + bl + ", timeOut=" + l));
        }
        if (this._state == 2) {
            object = this;
            synchronized (object) {
                if (this._state == 2) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._state == 2) {
                        ConnectionUnavailableException connectionUnavailableException = new ConnectionUnavailableException("Connection cannot be provided as Datasource has been disabled!");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been disabled!", (Object)connectionUnavailableException);
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw connectionUnavailableException;
                    }
                    if (this._state == 0) {
                        DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw datasourceWrapperStateException;
                    }
                }
            }
        }
        object = this.getLockConnection(bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection", (Object)("return=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnection(boolean bl, boolean bl2) throws SQLException, DatasourceWrapperStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnection", (Object)("autoCommit=" + bl + ", useEnlistedConnections=" + bl2));
        }
        if (this._state == 2) {
            object = this;
            synchronized (object) {
                if (this._state == 2) {
                    try {
                        this.wait(this.disabledDatasourceWaitTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._state == 2) {
                        ConnectionUnavailableException connectionUnavailableException = new ConnectionUnavailableException("Connection cannot be provided as Datasource has been disabled!");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been disabled!", (Object)connectionUnavailableException);
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw connectionUnavailableException;
                    }
                    if (this._state == 0) {
                        DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw datasourceWrapperStateException;
                    }
                }
            }
        }
        object = this.getLockConnection(bl, bl2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection", (Object)("return=" + object));
        }
        return object;
    }

    public ConnectionWrapper getLockConnection(boolean bl, boolean bl2) throws SQLException, DatasourceWrapperStateException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLockConnection", (Object)("autoCommit=" + bl + ", useEnlistedConnections=" + bl2));
        }
        Connection connection = null;
        if (this._state == 0) {
            DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLockConnection");
            }
            throw datasourceWrapperStateException;
        }
        try {
            connection = bl2 ? this.enlistedDataSource.getConnection(262144L, bl2) : this.unenlistedDataSource.getConnection(262144L, bl2);
        }
        catch (ConnectionWaitTimeoutException connectionWaitTimeoutException) {
            SibTr.error((TraceComponent)tc, (String)"CONNECTION_WAIT_TIMEOUT_SIMS1522");
            throw connectionWaitTimeoutException;
        }
        connection.setAutoCommit(bl);
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(this.instrument, connection, bl, bl2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLockConnection", (Object)("return=" + connectionWrapper));
        }
        return connectionWrapper;
    }

    public int getStaleConnectionRetryCount() {
        return this.staleConnectionRetryCount;
    }

    public long getStaleConnectionRetryDelay() {
        return this.staleConnectionRetryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void stop(int n) {
        block20: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"stop", (Object)new Object[]{new Integer(n)});
            }
            ConnectionWrapper connectionWrapper = null;
            Statement statement = null;
            if (this._state == 0) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"stop");
                }
                return;
            }
            connectionWrapper = this.getLockConnection(true, false);
            DatabaseMetaDataExtensions databaseMetaDataExtensions = connectionWrapper.getMetaDataExtensions();
            String string = databaseMetaDataExtensions.getDBMS();
            if (string == "db2j" || string == "Derby") {
                statement = connectionWrapper.createStatement();
                statement.executeUpdate(TableHelper.getCheckpointSql(string));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Purge the connection pool");
            }
            WSCallHelper.setConnectionError((Object)connectionWrapper);
            Object var7_7 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connectionWrapper != null) {
                    connectionWrapper.close();
                }
                break block20;
            }
            catch (Exception exception) {}
            break block20;
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connectionWrapper != null) {
                            connectionWrapper.close();
                        }
                        break block20;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connectionWrapper != null) {
                        connectionWrapper.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this._state = 0;
        this.notifyAll();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void enable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"enable");
        }
        if (this._state == 2) {
            this._state = 1;
            this.notifyAll();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Datasource re-enabled for use by MessageStore.");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Datasource not enabled as it is not in a suitable state, " + this._state));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"enable");
        }
    }

    public synchronized void disable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"disable");
        }
        if (this._state == 1) {
            this._state = 2;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Datasource disabled for use by MessageStore.");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Datasource not disabled as it is not in a suitable state, " + this._state));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"disable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource(String string, String string2, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDataSource", (Object)new Object[]{string, string2, new Integer(n), new Integer(n2)});
        }
        DataSource dataSource = null;
        boolean bl = false;
        ComponentMetaDataAccessorImpl componentMetaDataAccessorImpl = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        try {
            CustomComponentMetaData customComponentMetaData = new CustomComponentMetaData(string, string2, this.datasourceJndiName, "javax.resource.cci.ConnectionFactory", n, n2, 2, this.authAlias);
            componentMetaDataAccessorImpl.beginContext((ComponentMetaData)customComponentMetaData);
            bl = true;
            try {
                dataSource = (DataSource)new InitialContext().lookup(this.datasourceJndiName);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.WASConnectionManagerWrapper.getDataSource", (String)"187", (Object)this);
                throw new MessageStoreRuntimeException("DATASOURCE_NOT_FOUND_EXCEPTION_SIMS1524", new Object[]{this.datasourceJndiName}, namingException);
            }
        }
        finally {
            if (bl) {
                componentMetaDataAccessorImpl.endContext();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDataSource", (Object)dataSource);
        }
        return dataSource;
    }

    private void getStaleConnectionConfig() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStaleConnectionConfig");
        }
        try {
            this.staleConnectionRetryDelay = Long.parseLong(this.msi.getProperty("jdbcStaleConnectionRetryDelay", "2000"));
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.WASConnectionManagerWrapper.getStaleConnectionConfig", (String)"1", (Object)this);
            this.staleConnectionRetryDelay = Long.parseLong("2000");
        }
        if (this.staleConnectionRetryDelay <= 0L) {
            this.staleConnectionRetryDelay = 1L;
        }
        try {
            this.staleConnectionRetryCount = Integer.parseInt(this.msi.getProperty("jdbcStaleConnectionRetryCount", "5"));
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.WASConnectionManagerWrapper.getStaleConnectionConfig", (String)"2", (Object)this);
            this.staleConnectionRetryCount = Integer.parseInt("5");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStaleConnectionConfig");
        }
    }
}

