/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import java.util.IdentityHashMap;
import java.util.Map;

public class UniqueKeyGeneratorTableHelper {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String KEYGENID = "ID";
    public static final String LASTKEY = "LAST_KEY";
    private static final Map DEFAULT = new IdentityHashMap();
    private static final Map OTHER = new IdentityHashMap();
    private static final Map INFORMIX = new IdentityHashMap();
    private static final Map SYSTEMS = new IdentityHashMap();

    private UniqueKeyGeneratorTableHelper() {
    }

    public static Map getReferenceInfo(String string) {
        return (Map)SYSTEMS.get(string);
    }

    public static String[] getCreateTableSql(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string6 == "db2j" || string6 == "Derby") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " VARCHAR(50) NOT NULL, " + LASTKEY + " BIGINT NOT NULL, PRIMARY KEY(" + KEYGENID + ") )"};
        }
        if (string6 == "DB2" || string6 == "DB2iSeries") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " VARCHAR(50) NOT NULL, " + LASTKEY + " BIGINT NOT NULL, PRIMARY KEY(" + KEYGENID + ") )"};
        }
        if (string6 == "Oracle" || string6 == "Oracle8i") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " VARCHAR2(50) NOT NULL, " + LASTKEY + " NUMBER(19) NOT NULL, PRIMARY KEY(" + KEYGENID + ") )"};
        }
        if (string6 == "MS SQL Server") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " NVARCHAR(50) NOT NULL, " + LASTKEY + " BIGINT NOT NULL, PRIMARY KEY(" + KEYGENID + ") )"};
        }
        if (string6 == "Informix") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " VARCHAR(50) NOT NULL, " + LASTKEY + " INT8 NOT NULL, PRIMARY KEY(" + KEYGENID + ") ) LOCK MODE ROW"};
        }
        if (string6 == "Informix_73") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " VARCHAR(50) NOT NULL, " + LASTKEY + " DECIMAL(19,0) NOT NULL, PRIMARY KEY(" + KEYGENID + ") ) LOCK MODE ROW"};
        }
        if (string6 == "Sybase") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " NVARCHAR(50) NOT NULL, " + LASTKEY + " DECIMAL(19) NOT NULL, PRIMARY KEY(" + KEYGENID + ") )"};
        }
        if (string6 == "DB2390") {
            return new String[]{"CREATE TABLESPACE KEYTS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 3200 SECQTY 320 ERASE NO PCTFREE 10 SEGSIZE 32 BUFFERPOOL " + string3 + " LOCKSIZE ANY CLOSE NO", "CREATE TABLE " + string4 + "." + string5 + " ( " + KEYGENID + " VARCHAR(50) NOT NULL, " + LASTKEY + " DECIMAL(19) NOT NULL, PRIMARY KEY(" + KEYGENID + ") ) IN " + string + ".KEYTS", "CREATE UNIQUE INDEX " + string4 + "." + string5 + " ON " + string4 + "." + string5 + "(" + KEYGENID + ") USING STOGROUP " + string2 + " PRIQTY 200 SECQTY 20"};
        }
        if (string6 == "Dummy") {
            return new String[0];
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string6}, null));
    }

    public static String[] getDropTableSql(String string, String string2, String string3, String string4) {
        if (string4 == "DB2390") {
            return new String[]{"DROP TABLE " + string2 + "." + string3, "DROP TABLESPACE " + string + ".KEYTS"};
        }
        return new String[]{"DROP TABLE " + string2 + "." + string3};
    }

    public static String getReadTableSql(String string, String string2) {
        return "SELECT ID,LAST_KEY FROM " + string + "." + string2;
    }

    public static String getInsertRowSql(String string, String string2) {
        return "INSERT INTO " + string + "." + string2 + " (" + KEYGENID + "," + LASTKEY + ") VALUES (?,?)";
    }

    public static String getUpdateRowSql(String string, String string2) {
        return "UPDATE " + string + "." + string2 + " SET " + LASTKEY + "=? WHERE " + KEYGENID + "=?";
    }

    public static String getGrantSql(String string, String string2, String string3) {
        return "GRANT SELECT,INSERT,UPDATE ON " + string + "." + string2 + " TO " + string3;
    }

    static {
        DEFAULT.put(KEYGENID, TableHelper.VARCHAR);
        DEFAULT.put(LASTKEY, TableHelper.BIGINT);
        OTHER.put(KEYGENID, TableHelper.VARCHAR);
        OTHER.put(LASTKEY, TableHelper.DECIMAL);
        INFORMIX.put(KEYGENID, TableHelper.VARCHAR);
        INFORMIX.put(LASTKEY, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        SYSTEMS.put("DB2", DEFAULT);
        SYSTEMS.put("DB2iSeries", DEFAULT);
        SYSTEMS.put("DB2390", OTHER);
        SYSTEMS.put("db2j", DEFAULT);
        SYSTEMS.put("Derby", DEFAULT);
        SYSTEMS.put("Oracle", OTHER);
        SYSTEMS.put("Oracle8i", OTHER);
        SYSTEMS.put("MS SQL Server", DEFAULT);
        SYSTEMS.put("Informix", INFORMIX);
        SYSTEMS.put("Informix_73", INFORMIX);
        SYSTEMS.put("Sybase", OTHER);
    }
}

