/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.persistence.RangeManager;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;

public class UniqueKeyGeneratorImpl
implements UniqueKeyGenerator {
    private static TraceComponent tc = SibTr.register((Class)UniqueKeyGeneratorImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final RangeManager manager;
    private final String generatorId;
    private final long range;
    private final long midrange;
    private final Object lock = new Object();
    private final Object perInstanceLock = new Object();
    private long perInstanceKey = -100L;
    private long finalKey;
    private long milestoneKey;
    private long currentKey;

    public UniqueKeyGeneratorImpl(RangeManager rangeManager, String string, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{rangeManager, string, new Long(l)});
        }
        this.manager = rangeManager;
        this.generatorId = string;
        this.range = l;
        this.midrange = l >> 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public String getName() {
        return this.generatorId;
    }

    public long getRange() {
        return this.range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize");
        }
        Object object = this.lock;
        synchronized (object) {
            this.currentKey = this.manager.entryExists(this) ? this.manager.updateEntry(this) : this.manager.addEntry(this);
            this.milestoneKey = this.currentKey + this.midrange;
            this.finalKey = this.currentKey + this.range;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUniqueValue() throws PersistenceException {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUniqueValue");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.currentKey == this.milestoneKey) {
                this.manager.scheduleUpdate(this);
            } else if (this.currentKey == this.finalKey) {
                this.manager.updateEntry(this);
                this.nextRangeMaximumAvailable();
            }
            l = this.currentKey++;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUniqueValue", (Object)new Long(l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPerInstanceUniqueValue() {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPerInstanceUniqueValue");
        }
        Object object = this.perInstanceLock;
        synchronized (object) {
            l = this.perInstanceKey--;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPerInstanceUniqueValue", (Object)new Long(l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextRangeMaximumAvailable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"nextRangeMaximumAvailable");
        }
        Object object = this.lock;
        synchronized (object) {
            this.milestoneKey = this.finalKey + this.midrange;
            this.finalKey += this.range;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"nextRangeMaximumAvailable");
        }
    }
}

