/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class Token
implements Tuple,
XmlConstants {
    public static final String $ssccid = "@(#) 1.35 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/persistence/impl/Token.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/05/11 09:52:37 [3/13/06 13:59:35]";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)Token.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int NOT_SET = -1;
    private final long uniqueID;
    private final long containingStreamID;
    private final TupleTypeEnum tupleType;
    private int storageStrategy = 1;
    private String classname;
    private int priority;
    private long sequence;
    private boolean canExpireSilently = true;
    private long lockID = -2L;
    private long referredID = -1L;
    private long expiryTime;
    private boolean logicallyDeleted;
    private int persistentSize = -1;
    private PersistentTranId xid;
    private Persistable containingStream;
    private int persistableOperationBegunCounter;
    private int persistableOperationCompletedCounter;
    private boolean wasSpillingAtAddition;
    private AbstractItemLink link;
    private int permanentTableId = -1;
    private int temporaryTableId = -1;
    private int itemClassId = -1;

    protected Token(long l, long l2, TupleTypeEnum tupleTypeEnum) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>(uniqueID, containingStreamID, tupleType)", (Object)new Object[]{new Long(l), new Long(l2), tupleTypeEnum});
        }
        this.uniqueID = l;
        this.containingStreamID = l2;
        this.tupleType = tupleTypeEnum;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    protected Token(long l, Token token, TupleTypeEnum tupleTypeEnum) {
        this(l, token.uniqueID, tupleTypeEnum);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{new Long(l), token, tupleTypeEnum});
        }
        this.containingStream = token;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public Persistable createPersistable(long l, TupleTypeEnum tupleTypeEnum) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPersistable", (Object)new Object[]{new Long(l), tupleTypeEnum});
        }
        if (this.tupleType == TupleTypeEnum.ITEM || this.tupleType == TupleTypeEnum.ITEM_REFERENCE) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_PERSISTABLE_OPERATION_SIMS1507", new Object[]{new Long(this.uniqueID), this.tupleType}, null));
        }
        Token token = new Token(l, this, tupleTypeEnum);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistable", (Object)token);
        }
        return token;
    }

    public void setContainingStream(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setContainingStream", (Object)new Object[]{persistable});
        }
        this.containingStream = persistable;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setContainingStream");
        }
    }

    public Persistable getContainingStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getContainingStream");
            SibTr.exit((TraceComponent)tc, (String)"getContainingStream", (Object)this.containingStream);
        }
        return this.containingStream;
    }

    public void setCanExpireSilently(boolean bl) {
        this.canExpireSilently = bl;
    }

    public boolean getCanExpireSilently() {
        return this.canExpireSilently;
    }

    public void setLockID(long l) {
        this.lockID = l;
    }

    public long getLockID() {
        return this.lockID;
    }

    public void setItemClassName(String string) {
        this.classname = string;
    }

    public String getItemClassName() {
        return this.classname;
    }

    public void setAbstractItemLink(AbstractItemLink abstractItemLink) {
        this.link = abstractItemLink;
    }

    public byte[] getData() throws PersistentDataEncodingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getData");
        }
        byte[] byArray = null;
        if (this.link != null) {
            byArray = this.link.getMemberData();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getData", (Object)byArray);
        }
        return byArray;
    }

    public void setPersistentSize(int n) {
        this.persistentSize = n;
    }

    public int getPersistentSize() {
        return this.persistentSize;
    }

    public long getUniqueId() {
        return this.uniqueID;
    }

    public long getContainingStreamId() {
        return this.containingStreamID;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setSequence(long l) {
        this.sequence = l;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setReferredID(long l) {
        this.referredID = l;
    }

    public long getReferredID() {
        return this.referredID;
    }

    public void setStorageStrategy(int n) {
        this.storageStrategy = n;
    }

    public int getStorageStrategy() {
        return this.storageStrategy;
    }

    public TupleTypeEnum getTupleType() {
        return this.tupleType;
    }

    public void setLogicallyDeleted(boolean bl) {
        this.logicallyDeleted = bl;
    }

    public boolean isLogicallyDeleted() {
        return this.logicallyDeleted;
    }

    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setWasSpillingAtAddition(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWasSpillingAtAddition", (Object)new Object[]{new Boolean(bl)});
        }
        this.wasSpillingAtAddition = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWasSpillingAtAddition");
        }
    }

    public void setPersistentTranId(PersistentTranId persistentTranId) {
        this.xid = persistentTranId;
    }

    public PersistentTranId getPersistentTranId() {
        return this.xid;
    }

    public void setPermanentTableId(int n) {
        this.permanentTableId = n;
    }

    public int getPermanentTableId() {
        return this.permanentTableId;
    }

    public void setTemporaryTableId(int n) {
        this.temporaryTableId = n;
    }

    public int getTemporaryTableId() {
        return this.temporaryTableId;
    }

    public void setItemClassId(int n) {
        this.itemClassId = n;
    }

    public int getItemClassId() {
        return this.itemClassId;
    }

    public synchronized void persistableOperationBegun() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistableOperationBegun");
        }
        ++this.persistableOperationBegunCounter;
        if (tc.isEventEnabled()) {
            SibTr.event((TraceComponent)tc, (String)("persistableOperationBegunCounter: " + this.persistableOperationBegunCounter));
        }
        if (this.link != null && this.persistableOperationBegunCounter - this.persistableOperationCompletedCounter == 1) {
            this.link.persistentRepresentationIsUnstable();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistableOperationBegun");
        }
    }

    public synchronized void persistableOperationCompleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistableOperationCompleted");
        }
        ++this.persistableOperationCompletedCounter;
        if (tc.isEventEnabled()) {
            SibTr.event((TraceComponent)tc, (String)("persistableOperationCompletedCounter: " + this.persistableOperationCompletedCounter));
        }
        if (this.link != null) {
            if (this.persistableOperationBegunCounter == this.persistableOperationCompletedCounter) {
                this.link.persistentRepresentationIsStable();
            } else if (this.persistableOperationBegunCounter < this.persistableOperationCompletedCounter) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_PERSISTABLE_STATE_SIMS1527", new Object[]{new Integer(this.persistableOperationBegunCounter), new Integer(this.persistableOperationCompletedCounter)}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistableOperationCompleted");
        }
    }

    public synchronized void persistableOperationCancelled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistableOperationCancelled");
        }
        --this.persistableOperationBegunCounter;
        if (tc.isEventEnabled()) {
            SibTr.event((TraceComponent)tc, (String)("persistableOperationBegunCounter: " + this.persistableOperationBegunCounter));
        }
        if (this.link != null) {
            if (this.persistableOperationBegunCounter == this.persistableOperationCompletedCounter) {
                this.link.persistentRepresentationIsStable();
            } else if (this.persistableOperationBegunCounter < this.persistableOperationCompletedCounter) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_PERSISTABLE_STATE_SIMS1527", new Object[]{new Integer(this.persistableOperationBegunCounter), new Integer(this.persistableOperationCompletedCounter)}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistableOperationCancelled");
        }
    }

    public synchronized boolean persistableRepresentationWasCreated() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistableRepresentationWasCreated");
        }
        boolean bl2 = bl = this.persistableOperationCompletedCounter > 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistableRepresentationWasCreated", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean requiresPersistence() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requiresPersistence");
        }
        boolean bl = false;
        if (4 == this.storageStrategy) {
            bl = true;
        } else if (3 == this.storageStrategy) {
            bl = true;
        } else if (2 == this.storageStrategy) {
            bl = this.wasSpillingAtAddition;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requiresPersistence", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String toString() {
        return "uniqueId: " + this.uniqueID + ", containingStreamId: " + this.containingStreamID + ", className: " + this.classname + ", classId: " + this.itemClassId + ", dataSize: " + this.persistentSize + ", permanentTableId: " + this.permanentTableId + ", temporaryTableId: " + this.temporaryTableId + ", storageStrategy: " + this.storageStrategy + ", tupleType: " + this.tupleType + ", priority: " + this.priority + ", sequence: " + this.sequence + ", canExpireSilently: " + this.canExpireSilently + ", lockId: " + this.lockID + ", referredId: " + this.referredID + ", expiryTime: " + this.expiryTime + ", logicallyDeleted: " + this.logicallyDeleted + ", xid: " + this.xid + LINE_SEPARATOR;
    }

    public void xmlWrite(FormattedWriter formattedWriter) throws IOException {
        long l;
        formattedWriter.taggedValue("class", (Object)this.getItemClassName());
        formattedWriter.newLine();
        formattedWriter.taggedValue("priority", (long)this.getPriority());
        if (this.isLogicallyDeleted()) {
            formattedWriter.newLine();
            formattedWriter.emptyTag("logicallyDeleted");
        }
        if (this.getCanExpireSilently()) {
            formattedWriter.newLine();
            formattedWriter.emptyTag("canExpireSilently");
        }
        formattedWriter.newLine();
        switch (this.getStorageStrategy()) {
            case 4: {
                formattedWriter.taggedValue("storageStrategy", (Object)"StoreAlways");
                break;
            }
            case 2: {
                formattedWriter.taggedValue("storageStrategy", (Object)"StoreMaybe");
                break;
            }
            case 3: {
                formattedWriter.taggedValue("storageStrategy", (Object)"StoreEventually");
                break;
            }
            case 1: {
                formattedWriter.taggedValue("storageStrategy", (Object)"StoreNever");
                break;
            }
            default: {
                formattedWriter.taggedValue("storageStrategy", (long)this.getStorageStrategy());
            }
        }
        formattedWriter.newLine();
        formattedWriter.taggedValue("expiryTime", this.getExpiryTime());
        formattedWriter.newLine();
        formattedWriter.taggedValue("sequence", this.getSequence());
        formattedWriter.newLine();
        formattedWriter.taggedValue("tranID", (Object)this.getPersistentTranId());
        long l2 = this.getLockID();
        if (-2L != this.lockID) {
            formattedWriter.newLine();
            formattedWriter.taggedValue("lockID", this.lockID);
        }
        if (-1L != (l = this.getReferredID())) {
            formattedWriter.newLine();
            formattedWriter.taggedValue("referredID", l);
        }
    }
}

