/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.InvalidConstructor;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapperStateException;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.impl.BatchingAction;
import com.ibm.ws.sib.msgstore.persistence.impl.ClassId;
import com.ibm.ws.sib.msgstore.persistence.impl.ClassmapTable;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.DatabaseMetaDataExtensions;
import com.ibm.ws.sib.msgstore.persistence.impl.DatasourceController;
import com.ibm.ws.sib.msgstore.persistence.impl.InterruptableAction;
import com.ibm.ws.sib.msgstore.persistence.impl.ItemTable;
import com.ibm.ws.sib.msgstore.persistence.impl.ListingTable;
import com.ibm.ws.sib.msgstore.persistence.impl.ListingTableEntry;
import com.ibm.ws.sib.msgstore.persistence.impl.MEOwnerTable;
import com.ibm.ws.sib.msgstore.persistence.impl.PersistenceMap;
import com.ibm.ws.sib.msgstore.persistence.impl.RetryableAction;
import com.ibm.ws.sib.msgstore.persistence.impl.TransactionsTable;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.persistence.impl.UniqueKeyGeneratorImpl;
import com.ibm.ws.sib.msgstore.persistence.impl.UniqueKeyGeneratorTable;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockManager;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class TableManager
implements Runnable {
    public static final String $ssccid = "@(#) 1.17.4.1 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/persistence/impl/TableManager.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/08/23 11:04:43 [3/13/06 13:59:35]";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)TableManager.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final byte[] BYTE_ARRAY = new byte[0];
    private static final Class[] CLASS_ARRAY = new Class[0];
    private static final Long INITIAL_VALUE = new Long(0L);
    private static final int MAX_NUMBER_OF_ITEM_TABLES = 32;
    private static final int MAX_NUMBER_OF_MAPPINGS = 100;
    private static final int DELETION_THRESHOLD = 64;
    private volatile boolean active;
    private final LinkedList queue = new LinkedList();
    private final Random numberGenerator = new Random();
    private final DatasourceController controller;
    private final Configuration configuration;
    private final MSInstrumentation instrument;
    private final int numberOfPermanentTables;
    private final int numberOfTemporaryTables;
    private MessageStoreImpl _messageStore;
    private XidManager _manager;
    private DBLockManager _lockManager;
    private HashMap classToId;
    private HashMap idToClass;
    private ClassId[] classIdCache;
    private Map rangeCache;
    private Thread rangeManager;
    private int[] keysForPermanentTables;
    private int[] keysForTemporaryTables;
    private int[] keysForStreamTables;
    private int numberOfKeysForPermanentTables;
    private int numberOfKeysForTemporaryTables;
    private int numberOfKeysForStreamTables;
    private int totalNumberOfItemTables;
    private int nextClassId;
    private ItemTable[] itemTables;
    private ListingTable listingTable;
    private ClassmapTable classmapTable;
    private TransactionsTable xactsTable;
    private UniqueKeyGeneratorTable generatorTable;
    private MEOwnerTable meTable;
    private boolean performColumnChecks;
    private int minimumDataSize = Integer.MAX_VALUE;

    public TableManager(MessageStoreImpl messageStoreImpl, DatasourceController datasourceController, Configuration configuration, XidManager xidManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{messageStoreImpl, datasourceController, configuration, xidManager});
        }
        this._messageStore = messageStoreImpl;
        this._manager = xidManager;
        this.controller = datasourceController;
        this.configuration = configuration;
        this.instrument = this._messageStore._getInstrumentation();
        String string = this._messageStore.getProperty("jdbcPerformColumnChecks", "true");
        this.performColumnChecks = Boolean.valueOf(string);
        String string2 = this._messageStore.getProperty("jdbcNumberOfPermanentTables", "1");
        this.numberOfPermanentTables = Integer.parseInt(string2);
        String string3 = this._messageStore.getProperty("jdbcNumberOfTemporaryTables", "1");
        this.numberOfTemporaryTables = Integer.parseInt(string3);
        int n = 1 + this.numberOfPermanentTables + this.numberOfTemporaryTables;
        if (n > 32) {
            throw new IllegalStateException(nls.getFormattedMessage("MAX_NUMBER_OF_TABLES_EXCEEDED_SIMS1541", new Object[]{new Integer(32)}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public void initialize() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.active = true;
        this.controller.performAction(new InterruptableAction(){

            public final Object run(ConnectionWrapper connectionWrapper) throws SQLException {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                }
                TableManager.this.meTable = new MEOwnerTable(TableManager.this.configuration.getDatabaseSchemaName(), "SIBOWNER");
                TableManager.this.meTable.initialize(connectionWrapper, TableManager.this.configuration.isCreateTablesAutomatically(), TableManager.this.configuration.isCleanPersistenceOnStart(), TableManager.this.performColumnChecks);
                TableManager.this._lockManager = new DBLockManager(TableManager.this._messageStore, TableManager.this.controller.getConnectionManager(), TableManager.this.meTable);
                TableManager.this._lockManager.start();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
                return null;
            }

            public final boolean isActive() {
                return TableManager.this.active;
            }
        });
        this.controller.performAction(new InterruptableAction(){

            public final Object run(ConnectionWrapper connectionWrapper) throws SQLException {
                Object object;
                Iterator<Object> iterator;
                Collection<Object> collection;
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                }
                int[] nArray = new int[32];
                int[] nArray2 = new int[32];
                int[] nArray3 = new int[32];
                ItemTable[] itemTableArray = new ItemTable[32];
                TableManager.this.numberOfKeysForPermanentTables = 0;
                TableManager.this.numberOfKeysForTemporaryTables = 0;
                TableManager.this.numberOfKeysForStreamTables = 0;
                TableManager.this.totalNumberOfItemTables = 0;
                TableManager.this.classmapTable = new ClassmapTable(TableManager.this.configuration.getDatabaseSchemaName(), "SIBCLASSMAP");
                TableManager.this.classmapTable.initialize(connectionWrapper, TableManager.this.configuration.isCreateTablesAutomatically(), TableManager.this.configuration.isCleanPersistenceOnStart(), TableManager.this.performColumnChecks);
                Map map = TableManager.this.classmapTable.readTable(connectionWrapper);
                TableManager.this.classToId = (HashMap)map.get("CLASS_TO_ID");
                TableManager.this.idToClass = (HashMap)map.get("ID_TO_CLASS");
                TableManager.access$1502(TableManager.this, new ClassId[100]);
                if (!TableManager.this.idToClass.isEmpty()) {
                    collection = TableManager.this.idToClass.keySet();
                    iterator = collection.iterator();
                    object = null;
                    while (iterator.hasNext()) {
                        object = (ClassId)iterator.next();
                        TableManager.this.assertValidConstructor((String)TableManager.this.idToClass.get(object));
                        ((TableManager)TableManager.this).classIdCache[((ClassId)object).getId()] = object;
                    }
                    object = (ClassId)Collections.max(collection);
                    TableManager.this.nextClassId = ((ClassId)object).getId() + 1;
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("The next class id is: " + TableManager.this.nextClassId));
                }
                TableManager.this.listingTable = new ListingTable(TableManager.this.configuration.getDatabaseSchemaName(), "SIBLISTING", 1, TableManager.this.numberOfPermanentTables, TableManager.this.numberOfTemporaryTables);
                TableManager.this.listingTable.initialize(connectionWrapper, TableManager.this.configuration.isCreateTablesAutomatically(), TableManager.this.configuration.isCleanPersistenceOnStart(), TableManager.this.performColumnChecks);
                collection = TableManager.this.listingTable.readTable(connectionWrapper);
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object = (ListingTableEntry)iterator.next();
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)("Listing table entry: (" + object + ")"));
                    }
                    String string = ((ListingTableEntry)object).getSchemaName() == null ? TableManager.this.configuration.getDatabaseSchemaName() : ((ListingTableEntry)object).getSchemaName();
                    String string2 = ((ListingTableEntry)object).getTableType();
                    ItemTable itemTable = new ItemTable(TableManager.this.instrument, TableManager.this._manager, string, ((ListingTableEntry)object).getTableName(), string2);
                    itemTable.initialize(connectionWrapper, TableManager.this.configuration.isCreateTablesAutomatically(), TableManager.this.configuration.isCleanPersistenceOnStart(), TableManager.this.performColumnChecks);
                    int n = ((ListingTableEntry)object).getId();
                    if (n < 0 || n >= 32) {
                        throw new IllegalStateException(nls.getFormattedMessage("TABLE_NUMBER_OUTSIDE_RANGE_SIMS1508", new Object[]{new Integer(n)}, null));
                    }
                    if (string2.equals("P")) {
                        nArray[((TableManager)TableManager.this).numberOfKeysForPermanentTables++] = n;
                    } else if (string2.equals("T")) {
                        nArray2[((TableManager)TableManager.this).numberOfKeysForTemporaryTables++] = n;
                    } else if (string2.equals("S")) {
                        nArray3[((TableManager)TableManager.this).numberOfKeysForStreamTables++] = n;
                    } else {
                        throw new IllegalStateException(nls.getFormattedMessage("INVALID_TABLE_TYPE_EXCEPTION_SIMS1525", new Object[]{string2}, null));
                    }
                    TableManager.this.minimumDataSize = Math.min(TableManager.this.minimumDataSize, itemTable.getMaximumDataSize());
                    itemTableArray[n] = itemTable;
                }
                TableManager.this.generatorTable = new UniqueKeyGeneratorTable(TableManager.this.configuration.getDatabaseSchemaName(), "SIBKEYS");
                TableManager.this.generatorTable.initialize(connectionWrapper, TableManager.this.configuration.isCreateTablesAutomatically(), TableManager.this.configuration.isCleanPersistenceOnStart(), TableManager.this.performColumnChecks);
                TableManager.this.rangeCache = TableManager.this.generatorTable.readTable(connectionWrapper);
                TableManager.this.rangeCache = Collections.synchronizedMap(TableManager.this.rangeCache);
                if (TableManager.this.numberOfKeysForStreamTables != 1) {
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_NUMBER_OF_STREAM_TABLES_SIMS1509", new Object[]{new Integer(TableManager.this.numberOfKeysForStreamTables)}, null));
                }
                if (TableManager.this.numberOfKeysForPermanentTables == 0) {
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_NUMBER_OF_PERMANENT_TABLES_SIMS1510", new Object[]{new Integer(TableManager.this.numberOfKeysForPermanentTables)}, null));
                }
                if (TableManager.this.numberOfKeysForTemporaryTables == 0) {
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_NUMBER_OF_TEMPORARY_TABLES_SIMS1511", new Object[]{new Integer(TableManager.this.numberOfKeysForTemporaryTables)}, null));
                }
                TableManager.access$2702(TableManager.this, new int[TableManager.this.numberOfKeysForStreamTables]);
                System.arraycopy(nArray3, 0, TableManager.this.keysForStreamTables, 0, TableManager.this.numberOfKeysForStreamTables);
                TableManager.access$2802(TableManager.this, new int[TableManager.this.numberOfKeysForPermanentTables]);
                System.arraycopy(nArray, 0, TableManager.this.keysForPermanentTables, 0, TableManager.this.numberOfKeysForPermanentTables);
                TableManager.access$2902(TableManager.this, new int[TableManager.this.numberOfKeysForTemporaryTables]);
                System.arraycopy(nArray2, 0, TableManager.this.keysForTemporaryTables, 0, TableManager.this.numberOfKeysForTemporaryTables);
                TableManager.this.totalNumberOfItemTables = TableManager.this.numberOfKeysForStreamTables + TableManager.this.numberOfKeysForPermanentTables + TableManager.this.numberOfKeysForTemporaryTables;
                TableManager.access$3002(TableManager.this, new ItemTable[TableManager.this.totalNumberOfItemTables]);
                System.arraycopy(itemTableArray, 0, TableManager.this.itemTables, 0, TableManager.this.totalNumberOfItemTables);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
                return null;
            }

            public final boolean isActive() {
                return TableManager.this.active;
            }
        });
        this.controller.performAction(new InterruptableAction(){

            public final Object run(ConnectionWrapper connectionWrapper) throws SQLException {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                }
                TableManager.this.xactsTable = new TransactionsTable(TableManager.this.instrument, TableManager.this.configuration.getDatabaseSchemaName(), "SIBXACTS");
                TableManager.this.xactsTable.initialize(connectionWrapper, TableManager.this.configuration.isCreateTablesAutomatically(), TableManager.this.configuration.isCleanPersistenceOnStart(), TableManager.this.performColumnChecks);
                List list = TableManager.this.xactsTable.readTransactionsByState(connectionWrapper, "C");
                List list2 = TableManager.this.xactsTable.readTransactionsByState(connectionWrapper, "R");
                if (!list.isEmpty()) {
                    TableManager.this.completeCommittedTransactions(connectionWrapper, list);
                }
                if (!list2.isEmpty()) {
                    TableManager.this.completeRolledbackTransactions(connectionWrapper, list2);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
                return null;
            }

            public final boolean isActive() {
                return TableManager.this.active;
            }
        });
        this.controller.performAction(new InterruptableAction(){

            public final Object run(ConnectionWrapper connectionWrapper) throws SQLException {
                DatabaseMetaDataExtensions databaseMetaDataExtensions;
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                }
                if ((databaseMetaDataExtensions = connectionWrapper.getMetaDataExtensions()).supportsTruncateTableSql()) {
                    for (int i = 0; i < TableManager.this.numberOfKeysForTemporaryTables; ++i) {
                        int n = TableManager.this.keysForTemporaryTables[i];
                        ItemTable itemTable = TableManager.this.itemTables[n];
                        itemTable.truncate(connectionWrapper);
                    }
                } else {
                    for (int i = 0; i < TableManager.this.numberOfKeysForTemporaryTables; ++i) {
                        int n = TableManager.this.keysForTemporaryTables[i];
                        ItemTable itemTable = TableManager.this.itemTables[n];
                        List list = itemTable.identifyAllItems(connectionWrapper);
                        try {
                            TableManager.this.deleteItems(itemTable, list);
                            continue;
                        }
                        catch (PersistenceException persistenceException) {
                            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.persistence.impl.TableManager.initialize", (String)"1:488:1.17.4.1", (Object)this);
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
                return null;
            }

            public final boolean isActive() {
                return TableManager.this.active;
            }
        });
        for (int i = 0; i < this.totalNumberOfItemTables; ++i) {
            ItemTable itemTable = this.itemTables[i];
            if (itemTable.getMaximumDataSize() == this.minimumDataSize) continue;
            itemTable.setMaximumDataSize(this.minimumDataSize);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Maximum data size is: " + this.minimumDataSize + " bytes"));
        }
        this.rangeManager = new Thread(this);
        this.rangeManager.setName("sib.RangeManagerThread");
        this.rangeManager.setDaemon(true);
        this.rangeManager.start();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public int nextKeyForStreamTable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextKeyForStreamTable");
        }
        int n = this.numberGenerator.nextInt() % this.numberOfKeysForStreamTables;
        int n2 = this.keysForStreamTables[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextKeyForStreamTable", (Object)new Integer(n2));
        }
        return n2;
    }

    public int nextKeyForPermanentTable(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextKeyForPermanentTable");
        }
        int n = this.getNextPermanentCount(string) % this.numberOfKeysForPermanentTables;
        int n2 = this.keysForPermanentTables[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextKeyForPermanentTable", (Object)new Integer(n2));
        }
        return n2;
    }

    public int nextKeyForTemporaryTable(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextKeyForTemporaryTable");
        }
        int n = this.getNextTemporaryCount(string) % this.numberOfKeysForTemporaryTables;
        int n2 = this.keysForTemporaryTables[n];
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextKeyForTemporaryTable", (Object)new Integer(n2));
        }
        return n2;
    }

    public int getNumberOfItemTables() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfItemTables");
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfItemTables", (Object)new Integer(this.totalNumberOfItemTables));
        }
        return this.totalNumberOfItemTables;
    }

    public void insert(ConnectionWrapper connectionWrapper, PersistenceMap persistenceMap) throws SQLException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insert", (Object)new Object[]{connectionWrapper, persistenceMap});
        }
        while (persistenceMap.hasNextKey()) {
            int n = persistenceMap.getNextKey();
            List list = persistenceMap.getList(n);
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Tuple tuple = (Tuple)list.get(i);
                if (tuple.getItemClassId() != -1) continue;
                int n3 = this.getClassmapKey(tuple.getItemClassName());
                tuple.setItemClassId(n3);
            }
            this.itemTables[n].insert(connectionWrapper, list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    public void delete(ConnectionWrapper connectionWrapper, PersistenceMap persistenceMap) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete", (Object)new Object[]{connectionWrapper, persistenceMap});
        }
        while (persistenceMap.hasNextKey()) {
            int n = persistenceMap.getNextKey();
            this.itemTables[n].delete(connectionWrapper, persistenceMap.getList(n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    public void updateLockIDOnly(ConnectionWrapper connectionWrapper, PersistenceMap persistenceMap) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLockIDOnly", (Object)new Object[]{connectionWrapper, persistenceMap});
        }
        while (persistenceMap.hasNextKey()) {
            int n = persistenceMap.getNextKey();
            this.itemTables[n].updateLockIDOnly(connectionWrapper, persistenceMap.getList(n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLockIDOnly");
        }
    }

    public void updateDataAndSize(ConnectionWrapper connectionWrapper, PersistenceMap persistenceMap) throws SQLException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDataAndSize", (Object)new Object[]{connectionWrapper, persistenceMap});
        }
        while (persistenceMap.hasNextKey()) {
            int n = persistenceMap.getNextKey();
            this.itemTables[n].updateDataAndSize(connectionWrapper, persistenceMap.getList(n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDataAndSize");
        }
    }

    public void updateLogicalDeleteAndXID(ConnectionWrapper connectionWrapper, PersistenceMap persistenceMap) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLogicalDeleteAndXID", (Object)new Object[]{connectionWrapper, persistenceMap});
        }
        while (persistenceMap.hasNextKey()) {
            int n = persistenceMap.getNextKey();
            this.itemTables[n].updateLogicalDeleteAndXID(connectionWrapper, persistenceMap.getList(n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLogicalDeleteAndXID");
        }
    }

    public byte[] readDataOnly(ConnectionWrapper connectionWrapper, Tuple tuple) throws SQLException, IOException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readDataOnly", (Object)new Object[]{connectionWrapper, tuple});
        }
        byte[] byArray = BYTE_ARRAY;
        int n = -1;
        if (tuple.getPersistentSize() > 0) {
            TupleTypeEnum tupleTypeEnum = tuple.getTupleType();
            if (tupleTypeEnum == TupleTypeEnum.ITEM || tupleTypeEnum == TupleTypeEnum.ITEM_REFERENCE) {
                Tuple tuple2 = (Tuple)tuple.getContainingStream();
                n = tuple.getStorageStrategy() == 2 ? tuple2.getTemporaryTableId() : tuple2.getPermanentTableId();
            } else {
                n = this.keysForStreamTables[0];
            }
            byArray = this.itemTables[n].readDataOnly(connectionWrapper, tuple);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readDataOnly", (Object)byArray);
        }
        return byArray;
    }

    public Tuple readRootPersistable(ConnectionWrapper connectionWrapper, long l, long l2) throws SQLException {
        int n;
        Tuple tuple;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readRootPersistable", (Object)new Object[]{connectionWrapper, new Long(l), new Long(l2)});
        }
        if ((tuple = this.itemTables[n = this.keysForStreamTables[0]].readRootPersistable(connectionWrapper, l, l2)) != null) {
            String string = this.getClassmapUri(tuple.getItemClassId());
            tuple.setItemClassName(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readRootPersistable", (Object)tuple);
        }
        return tuple;
    }

    public List readNonStreamItems(ConnectionWrapper connectionWrapper, Tuple tuple) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readNonStreamItems", (Object)new Object[]{connectionWrapper, tuple});
        }
        int n = tuple.getPermanentTableId();
        List list = this.itemTables[n].readNonStreamItems(connectionWrapper, tuple);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Tuple tuple2 = (Tuple)list.get(i);
            String string = this.getClassmapUri(tuple2.getItemClassId());
            tuple2.setItemClassName(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readNonStreamItems", (Object)list);
        }
        return list;
    }

    public List readAllStreams(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readAllStreams", (Object)new Object[]{connectionWrapper});
        }
        int n = this.keysForStreamTables[0];
        ItemTable itemTable = this.itemTables[n];
        List list = itemTable.readAllStreams(connectionWrapper);
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>(list.size());
        ArrayList<Tuple> arrayList2 = new ArrayList<Tuple>(list.size());
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Tuple tuple = (Tuple)list.get(i);
            if (tuple.getStorageStrategy() == 2) {
                arrayList.add(tuple);
                continue;
            }
            arrayList2.add(tuple);
            String string = this.getClassmapUri(tuple.getItemClassId());
            tuple.setItemClassName(string);
        }
        if (!arrayList.isEmpty()) {
            try {
                this.deleteItems(itemTable, arrayList);
            }
            catch (PersistenceException persistenceException) {
                FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.persistence.impl.TableManager.readAllStreams", (String)"1:900:1.17.4.1", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readAllStreams", arrayList2);
        }
        return arrayList2;
    }

    public Set identifyStreamsWithExpirableItems(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"identifyStreamsWithExpirableItems", (Object)new Object[]{connectionWrapper});
        }
        HashSet hashSet = new HashSet();
        int n = this.numberOfKeysForPermanentTables;
        for (int i = 0; i < n; ++i) {
            int n2 = this.keysForPermanentTables[i];
            List list = this.itemTables[n2].identifyStreamsWithExpirableItems(connectionWrapper);
            hashSet.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"identifyStreamsWithExpirableItems", hashSet);
        }
        return hashSet;
    }

    public Set identifyStreamsWithIndoubtItems(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems", (Object)new Object[]{connectionWrapper});
        }
        HashSet hashSet = new HashSet();
        int n = this.numberOfKeysForPermanentTables;
        for (int i = 0; i < n; ++i) {
            int n2 = this.keysForPermanentTables[i];
            List list = this.itemTables[n2].identifyStreamsWithIndoubtItems(connectionWrapper);
            hashSet.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems", hashSet);
        }
        return hashSet;
    }

    public void addTransaction(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTransaction", (Object)new Object[]{connectionWrapper, list});
        }
        this.xactsTable.addTransaction(connectionWrapper, list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTransaction");
        }
    }

    public void commitTransaction(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitTransaction", (Object)new Object[]{connectionWrapper, list});
        }
        this.xactsTable.commitTransaction(connectionWrapper, list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitTransaction");
        }
    }

    public void rollbackTransaction(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackTransaction", (Object)new Object[]{connectionWrapper, list});
        }
        this.xactsTable.rollbackTransaction(connectionWrapper, list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackTransaction");
        }
    }

    public void removeTransaction(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTransaction", (Object)new Object[]{connectionWrapper, list});
        }
        this.xactsTable.removeTransaction(connectionWrapper, list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTransaction");
        }
    }

    public List readAllIndoubts(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readAllIndoubts", (Object)new Object[]{connectionWrapper});
        }
        List list = this.xactsTable.readTransactionsByState(connectionWrapper, "I");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readAllIndoubts", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdate(UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"scheduleUpdate", (Object)new Object[]{uniqueKeyGeneratorImpl});
        }
        if (this.active) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.add(uniqueKeyGeneratorImpl);
                this.queue.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleUpdate");
        }
    }

    public boolean entryExists(UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"entryExists", (Object)new Object[]{uniqueKeyGeneratorImpl});
        }
        boolean bl = this.rangeCache.containsKey(uniqueKeyGeneratorImpl.getName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"entryExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addEntry(ConnectionWrapper connectionWrapper, UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addEntry", (Object)new Object[]{connectionWrapper, uniqueKeyGeneratorImpl});
        }
        String string = uniqueKeyGeneratorImpl.getName();
        long l = uniqueKeyGeneratorImpl.getRange();
        UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl2 = uniqueKeyGeneratorImpl;
        synchronized (uniqueKeyGeneratorImpl2) {
            this.generatorTable.insertRow(connectionWrapper, string, l);
            this.rangeCache.put(string, new Long(l));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addEntry", (Object)INITIAL_VALUE);
        }
        return INITIAL_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long updateEntry(ConnectionWrapper connectionWrapper, UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateEntry", (Object)new Object[]{connectionWrapper, uniqueKeyGeneratorImpl});
        }
        String string = uniqueKeyGeneratorImpl.getName();
        long l = uniqueKeyGeneratorImpl.getRange();
        Long l2 = null;
        UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl2 = uniqueKeyGeneratorImpl;
        synchronized (uniqueKeyGeneratorImpl2) {
            l2 = (Long)this.rangeCache.get(string);
            long l3 = l2 + l;
            this.generatorTable.updateRow(connectionWrapper, string, l3);
            this.rangeCache.put(string, new Long(l3));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateEntry", (Object)l2);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this._messageStore != null && this._messageStore._getMessagingEngine() != null) {
            SibTr.push((Object)this._messageStore._getMessagingEngine());
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"run");
        }
        UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl = null;
        while (true) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                while (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.active) continue;
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run");
                    }
                    if (this._messageStore != null && this._messageStore._getMessagingEngine() != null) {
                        SibTr.pop();
                    }
                    return;
                }
                uniqueKeyGeneratorImpl = (UniqueKeyGeneratorImpl)this.queue.removeFirst();
            }
            try {
                this.updateGenerator(uniqueKeyGeneratorImpl);
                continue;
            }
            catch (DatasourceWrapperStateException datasourceWrapperStateException) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
                if (this._messageStore != null && this._messageStore._getMessagingEngine() != null) {
                    SibTr.pop();
                }
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)new Object[]{new Integer(n)});
        }
        this.active = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notify();
        }
        if (this._lockManager != null) {
            this._lockManager.stop();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextPermanentCount(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNextPermanentCount", (Object)new Object[]{string});
        }
        ClassId classId = (ClassId)this.classToId.get(string);
        int n = 0;
        if (classId != null) {
            n = classId.getNextPermanentCount();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getNextPermanentCount", (Object)new Integer(n));
            }
            return n;
        }
        Object var4_4 = null;
        TableManager tableManager = this;
        synchronized (tableManager) {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Performing double-check for classmap key");
            }
            HashMap hashMap = null;
            String string2 = "CLASS_TO_ID";
            synchronized ("CLASS_TO_ID") {
                hashMap = this.classToId;
                // ** MonitorExit[var7_7] (shouldn't be in output)
                classId = (ClassId)hashMap.get(string);
                if (classId != null) {
                    n = classId.getNextPermanentCount();
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"getNextPermanentCount", (Object)new Integer(n));
                    }
                    return n;
                }
            }
        }
        {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Failed to locate classmap key");
            }
            n = Math.abs(this.numberGenerator.nextInt());
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getNextPermanentCount", (Object)new Integer(n));
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextTemporaryCount(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNextTemporaryCount", (Object)new Object[]{string});
        }
        ClassId classId = (ClassId)this.classToId.get(string);
        int n = 0;
        if (classId != null) {
            n = classId.getNextTemporaryCount();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getNextTemporaryCount", (Object)new Integer(n));
            }
            return n;
        }
        Object var4_4 = null;
        TableManager tableManager = this;
        synchronized (tableManager) {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Performing double-check for classmap key");
            }
            HashMap hashMap = null;
            String string2 = "CLASS_TO_ID";
            synchronized ("CLASS_TO_ID") {
                hashMap = this.classToId;
                // ** MonitorExit[var7_7] (shouldn't be in output)
                classId = (ClassId)hashMap.get(string);
                if (classId != null) {
                    n = classId.getNextTemporaryCount();
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"getNextTemporaryCount", (Object)new Integer(n));
                    }
                    return n;
                }
            }
        }
        {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Failed to locate classmap key");
            }
            n = Math.abs(this.numberGenerator.nextInt());
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getNextTemporaryCount", (Object)new Integer(n));
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClassmapKey(String string) throws SQLException {
        ClassId classId;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getClassmapKey", (Object)new Object[]{string});
        }
        if ((classId = (ClassId)this.classToId.get(string)) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getClassmapKey", (Object)classId);
            }
            return classId.getId();
        }
        ClassId classId2 = null;
        TableManager tableManager = this;
        synchronized (tableManager) {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Performing double-check for classmap key");
            }
            HashMap hashMap = null;
            String string2 = "CLASS_TO_ID";
            synchronized ("CLASS_TO_ID") {
                hashMap = this.classToId;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                classId = (ClassId)hashMap.get(string);
                if (classId != null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"getClassmapKey", (Object)classId);
                    }
                    return classId.getId();
                }
                this.assertValidConstructor(string);
                classId2 = new ClassId(this.nextClassId++);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Generating a new classmap key, ", (Object)classId2);
                }
                this.updateClassmapTable(classId2, string);
                this.updateClassmapCache(classId2, string);
            }
        }
        {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getClassmapKey", (Object)classId2);
            }
            return classId2.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassmapUri(int n) {
        ClassId classId;
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getClassmapUri", (Object)new Object[]{new Integer(n)});
        }
        if ((string = (String)this.idToClass.get(classId = this.classIdCache[n])) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getClassmapUri", (Object)string);
            }
            return string;
        }
        ClassId[] classIdArray = null;
        HashMap hashMap = null;
        String string2 = "ID_TO_CLASS";
        synchronized ("ID_TO_CLASS") {
            classIdArray = this.classIdCache;
            hashMap = this.idToClass;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            classId = classIdArray[n];
            string = (String)hashMap.get(classId);
            if (string == null) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_CLASSMAP_TABLE_REFERENCE_SIMS1534", new Object[]{classId}, null));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getClassmapUri", (Object)string);
            }
            return string;
        }
    }

    private void updateClassmapTable(final ClassId classId, final String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateClassmapTable", (Object)new Object[]{classId, string});
        }
        try {
            this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    TableManager.this.classmapTable.addClass(connectionWrapper, classId, string);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run");
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateClassmapTable");
        }
    }

    private void updateGenerator(final UniqueKeyGeneratorImpl uniqueKeyGeneratorImpl) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateGenerator", (Object)new Object[]{uniqueKeyGeneratorImpl});
        }
        try {
            this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    TableManager.this.updateEntry(connectionWrapper, uniqueKeyGeneratorImpl);
                    uniqueKeyGeneratorImpl.nextRangeMaximumAvailable();
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run");
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateGenerator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassmapCache(ClassId classId, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateClassmapCache", (Object)new Object[]{classId, string});
        }
        HashMap hashMap = null;
        hashMap = (HashMap)this.idToClass.clone();
        hashMap.put(classId, string);
        String string2 = "ID_TO_CLASS";
        synchronized ("ID_TO_CLASS") {
            int n = classId.getId();
            this.classIdCache[n] = classId;
            this.idToClass = hashMap;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            hashMap = (HashMap)this.classToId.clone();
            hashMap.put(string, classId);
            string2 = "CLASS_TO_ID";
            synchronized ("CLASS_TO_ID") {
                this.classToId = hashMap;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"updateClassmapCache");
                }
                return;
            }
        }
    }

    private void completeCommittedTransactions(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"completeCommittedTransactions", (Object)new Object[]{connectionWrapper, list});
        }
        int n2 = this.numberOfKeysForPermanentTables;
        for (n = 0; n < n2; ++n) {
            int n3 = this.keysForPermanentTables[n];
            this.itemTables[n3].removeCommittedDeletes(connectionWrapper, list);
        }
        n = this.keysForStreamTables[0];
        this.itemTables[n].removeCommittedDeletes(connectionWrapper, list);
        this.xactsTable.removeTransaction(connectionWrapper, list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"completeCommittedTransactions");
        }
    }

    private void completeRolledbackTransactions(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"completeRolledbackTransactions", (Object)new Object[]{connectionWrapper, list});
        }
        int n2 = this.numberOfKeysForPermanentTables;
        for (n = 0; n < n2; ++n) {
            int n3 = this.keysForPermanentTables[n];
            ItemTable itemTable = this.itemTables[n3];
            itemTable.removeRolledbackInserts(connectionWrapper, list);
            itemTable.undoRolledbackDeletes(connectionWrapper, list);
        }
        n = this.keysForStreamTables[0];
        ItemTable itemTable = this.itemTables[n];
        itemTable.removeRolledbackInserts(connectionWrapper, list);
        itemTable.undoRolledbackDeletes(connectionWrapper, list);
        this.xactsTable.removeTransaction(connectionWrapper, list);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"completeRolledbackTransactions");
        }
    }

    private void assertValidConstructor(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidConstructor", (Object)new Object[]{string});
        }
        if (string.equals("com.ibm.ws.sib.msgstore.cache.links.RootMembership")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidConstructor");
            }
            return;
        }
        try {
            Class.forName(string).getConstructor(CLASS_ARRAY);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.TableManager.assertValidConstructor", (String)"1:1697:1.17.4.1", (Object)this);
            throw new InvalidConstructor("INVALID_ITEM_CONSTRUCTOR_SIMS0001", exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidConstructor");
        }
    }

    private void deleteItems(final ItemTable itemTable, List list) throws SQLException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteItems", (Object)new Object[]{itemTable, list});
        }
        final ArrayList arrayList = new ArrayList(64);
        BatchingAction batchingAction = new BatchingAction(){

            public final void run(ConnectionWrapper connectionWrapper) throws SQLException {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                }
                itemTable.delete(connectionWrapper, arrayList);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
            }

            public final boolean useEnlistedConnections() {
                return false;
            }

            public final int getBatchCount() {
                return arrayList.size();
            }
        };
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(i));
            if (arrayList.size() < 64) continue;
            this.controller.performAction(batchingAction);
            arrayList.clear();
        }
        if (arrayList.size() > 0) {
            this.controller.performAction(batchingAction);
            arrayList.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteItems");
        }
    }

    static /* synthetic */ ClassId[] access$1502(TableManager tableManager, ClassId[] classIdArray) {
        tableManager.classIdCache = classIdArray;
        return classIdArray;
    }

    static /* synthetic */ int[] access$2702(TableManager tableManager, int[] nArray) {
        tableManager.keysForStreamTables = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$2802(TableManager tableManager, int[] nArray) {
        tableManager.keysForPermanentTables = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$2902(TableManager tableManager, int[] nArray) {
        tableManager.keysForTemporaryTables = nArray;
        return nArray;
    }

    static /* synthetic */ ItemTable[] access$3002(TableManager tableManager, ItemTable[] itemTableArray) {
        tableManager.itemTables = itemTableArray;
        return itemTableArray;
    }
}

