/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class PersistenceMap {
    private static TraceComponent tc = SibTr.register((Class)PersistenceMap.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final List[] array;
    private final int[] stack;
    private final BatchingContext batchingContext;
    private int pointer;
    private int counter;

    public PersistenceMap(int n, BatchingContext batchingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{new Integer(n), batchingContext});
        }
        this.array = new List[n];
        this.stack = new int[n];
        this.batchingContext = batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public void set(int n, Tuple tuple) {
        ArrayList<Tuple> arrayList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"set", (Object)new Object[]{new Integer(n), tuple});
        }
        if ((arrayList = this.array[n]) == null) {
            this.array[n] = arrayList = new ArrayList<Tuple>(this.batchingContext.getCapacity());
            this.stack[this.pointer++] = n;
        }
        arrayList.add(tuple);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"set");
        }
    }

    public List getList(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getList", (Object)new Object[]{new Integer(n)});
            SibTr.exit((TraceComponent)tc, (String)"getList", (Object)this.array[n]);
        }
        return this.array[n];
    }

    public int size() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"size");
            SibTr.exit((TraceComponent)tc, (String)"size", (Object)new Integer(this.pointer));
        }
        return this.pointer;
    }

    public boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty");
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Boolean(this.pointer == 0));
        }
        return this.pointer == 0;
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clear");
        }
        int n = this.pointer;
        for (int i = 0; i < n; ++i) {
            int n2 = this.stack[i];
            this.array[n2] = null;
        }
        this.counter = 0;
        this.pointer = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    public void resetPosition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetPosition");
            SibTr.exit((TraceComponent)tc, (String)"resetPosition");
        }
        this.counter = 0;
    }

    public boolean hasNextKey() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNextKey");
            SibTr.exit((TraceComponent)tc, (String)"hasNextKey", (Object)new Boolean(this.counter < this.pointer));
        }
        return this.counter < this.pointer;
    }

    public int getNextKey() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNextKey");
            SibTr.exit((TraceComponent)tc, (String)"getNextKey", (Object)new Integer(this.stack[this.counter]));
        }
        return this.stack[this.counter++];
    }
}

